/*==================================================================
 * wtbl_awefx.c - OSS AWE wavetable driver effects routines
 *
 * Smurf Sound Font Editor
 * Copyright (C) 1999-2001 Josh Green
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Smurf homepage: http://smurf.sourceforge.net
 *==================================================================*/
#include "config.h"

#ifdef AWE_SUPPORT

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/ioctl.h>

#if defined(HAVE_SYS_SOUNDCARD_H)
#include <sys/soundcard.h>
#elif defined(HAVE_MACHINE_SOUNDCARD_H)
#include <machine/soundcard.h>
#endif

#if defined(HAVE_AWE_VOICE_H)
#include <awe_voice.h>
#elif defined(HAVE_SYS_AWE_VOICE_H)
#include <sys/awe_voice.h>
#elif defined(HAVE_LINUX_AWE_VOICE_H)
#include <linux/awe_voice.h>
#endif

#include <glib.h>
#include "wtbl_awefx.h"
#include "wtbl_aweunits.h"
#include "sfont.h"
#include "util.h"

/* AWE conversion and real time effect table */
AweFXConvType awefxtbl[] = {
  {NULL, AWE_FX_SAMPLE_START, METH_EFFECT},    // Gen_StartAddrOfs
  {NULL, -1, METH_NONE},    // Gen_EndAddrOfs
  {NULL, AWE_FX_LOOP_START, METH_EFFECT},    // Gen_StartLoopAddrOfs
  {NULL, AWE_FX_LOOP_END, METH_EFFECT},    // Gen_EndLoopAddrOfs
  {NULL, AWE_FX_COARSE_SAMPLE_START, METH_EFFECT},    // Gen_StartAddrCoarseOfs
  {awe_calc_pitch_shift, AWE_FX_LFO1_PITCH, METH_EFFECT},    // Gen_ModLFO2Pitch
  {awe_calc_pitch_shift, AWE_FX_LFO2_PITCH, METH_EFFECT},    // Gen_VibLFO2Pitch
  {awe_calc_pitch_shift, AWE_FX_ENV1_PITCH, METH_EFFECT},    // Gen_ModEnv2Pitch
  {awe_calc_cutoff, AWE_FX_CUTOFF, METH_EFFECT},    // Gen_FilterFc
  {awe_calc_filterQ, AWE_FX_FILTERQ, METH_EFFECT},    // Gen_FilterQ
  {awe_calc_modlfo_cutoff, AWE_FX_LFO1_CUTOFF, METH_EFFECT},    // Gen_ModLFO2FilterFc
  {awe_calc_modenv_cutoff, AWE_FX_ENV1_CUTOFF, METH_EFFECT},    // Gen_ModEnv2FilterFc
  {NULL, -1, METH_NONE},    // Gen_EndAddrCoarseOfs
  {awe_calc_tremolo, AWE_FX_LFO1_VOLUME, METH_EFFECT},    // Gen_ModLFO2Vol
  {NULL, -1, METH_INVALID},    // Gen_Unused1
  {awe_calc_tenthpercent, AWE_FX_CHORUS, METH_EFFECT},    // Gen_ChorusSend
  {awe_calc_tenthpercent, AWE_FX_REVERB, METH_EFFECT},    // Gen_ReverbSend
  {awe_calc_pan, CTL_PAN, METH_SEQCTRL},    // Gen_Pan
  {NULL, -1, METH_INVALID},    // Gen_Unused2
  {NULL, -1, METH_INVALID},    // Gen_Unused3
  {NULL, -1, METH_INVALID},    // Gen_Unused4
  {awe_calc_delay, AWE_FX_LFO1_DELAY, METH_EFFECT},    // Gen_ModLFODelay
  {awe_calc_freq, AWE_FX_LFO1_FREQ, METH_EFFECT},    // Gen_ModLFOFreq
  {awe_calc_delay, AWE_FX_LFO2_DELAY, METH_EFFECT},    // Gen_VibLFODelay
  {awe_calc_freq, AWE_FX_LFO2_FREQ, METH_EFFECT},    // Gen_VibLFOFreq
  {awe_calc_delay, AWE_FX_ENV1_DELAY, METH_EFFECT},    // Gen_ModEnvDelay
  {awe_calc_attack, AWE_FX_ENV1_ATTACK, METH_EFFECT},    // Gen_ModEnvAttack
  {awe_calc_hold, AWE_FX_ENV1_HOLD, METH_EFFECT},    // Gen_ModEnvHold
  {awe_calc_decay, AWE_FX_ENV1_DECAY, METH_EFFECT},    // Gen_ModEnvDecay
  {awe_calc_mod_sustain, AWE_FX_ENV1_SUSTAIN, METH_EFFECT},    // Gen_ModEnvSustain
  {/*???*/NULL, AWE_FX_ENV1_RELEASE, METH_EFFECT},    // Gen_ModEnvRelease
  {NULL, -1, METH_NONE},    // Gen_Key2ModEnvHold
  {NULL, -1, METH_NONE},    // Gen_Key2ModEnvDecay
  {awe_calc_delay, AWE_FX_ENV2_DELAY, METH_EFFECT},    // Gen_VolEnvDelay
  {awe_calc_attack, AWE_FX_ENV2_ATTACK, METH_EFFECT},    // Gen_VolEnvAttack
  {awe_calc_hold, AWE_FX_ENV2_HOLD, METH_EFFECT},    // Gen_VolEnvHold
  {awe_calc_decay, AWE_FX_ENV2_DECAY, METH_EFFECT},    // Gen_VolEnvDecay
  {awe_calc_sustain, AWE_FX_ENV2_SUSTAIN, METH_EFFECT},    // Gen_VolEnvSustain
  {/*???*/NULL, AWE_FX_ENV2_RELEASE, METH_EFFECT},    // Gen_VolEnvRelease
  {NULL, -1, METH_NONE},    // Gen_Key2VolEnvHold
  {NULL, -1, METH_NONE},    // Gen_Key2VolEnvDecay
  {NULL, -1, METH_NONE},    // Gen_Instrument
  {NULL, -1, METH_INVALID},    // Gen_Reserved1
  {NULL, -1, METH_NONE},    // Gen_KeyRange
  {NULL, -1, METH_NONE},    // Gen_VelRange
  {NULL, AWE_FX_COARSE_LOOP_START, METH_EFFECT},    // Gen_StartLoopAddrCoarseOfs
  {NULL, -1, METH_NONE},    // Gen_Keynum
  {NULL, -1, METH_NONE},    // Gen_Velocity
  {/*???*/NULL, -1, METH_NONE},    // Gen_InitAttenuation
  {NULL, -1, METH_INVALID},    // Gen_Reserved2
  {NULL, AWE_FX_COARSE_LOOP_END, METH_EFFECT},    // Gen_EndLoopAddrCoarseOfs
  {/*???*/NULL, -1, METH_NONE},    // Gen_CourseTune
  {/*???*/NULL, -1, METH_NONE},    // Gen_FineTune
  {NULL, -1, METH_NONE},    // Gen_sampleId
  {NULL, -1, METH_NONE},    // Gen_SampleModes
  {NULL, -1, METH_INVALID},    // Gen_Reserved3
  {/*???*/NULL, -1, METH_NONE},    // Gen_ScaleTuning
  {NULL, -1, METH_NONE},    // Gen_ExclusiveClass
  {NULL, -1, METH_NONE}     // Gen_OverrideRootKey
};

#endif /* #ifdef AWE_SUPPORT */
