/***************************************************************************
    smb4kshare  -  This is a container that holds information about
    a mounted remote share.
                             -------------------
    begin                : Do Mär 4 2004
    copyright            : (C) 2004 by Franck Babin
                           (C) 2005 by Alexander Reinholdt
    email                : babinfranck@yahoo.ca
                           dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

// Qt includes
#include <qdir.h>

// KDE includes
#include <kdebug.h>

// system includes
#include <unistd.h>
#include <sys/types.h>

// application specific includes
#include "smb4kshare.h"


Smb4KShare::Smb4KShare( const QString &name, const QString &path, const QString &filesystem, const int uid, const int gid, bool broken ) :
m_name(name), m_path( path.local8Bit() ), m_filesystem( filesystem ), m_user( uid ), m_group( gid ), m_cifs_login( QString::null ), m_broken( broken ), m_total( 0 ), m_free( 0 )
{
  //FIXME should throw an exception if one of the param is empty

  if ( uid != (int)getuid() && gid != (int)getgid() )
  {
    m_foreign_mount = true;
  }
  else
  {
    m_foreign_mount = false;
  }
}


Smb4KShare::Smb4KShare( const QString &name, const QString &path, const QString &filesystem, const QString &username, bool foreign, bool broken ) :
m_name( name ), m_path( path.local8Bit() ), m_filesystem( filesystem ), m_user( (int)getuid() ), m_group( (int)getgid() ), m_cifs_login( username ), m_foreign_mount( foreign ), m_broken( broken ), m_total( 0 ), m_free( 0 )
{
}


Smb4KShare::Smb4KShare( const Smb4KShare &s ) :
m_name( s.name() ), m_path( s.path() ), m_filesystem( s.filesystem() ), m_user( s.uid() ), m_group( s.gid() ), m_cifs_login( s.cifsLogin() ), m_foreign_mount( s.isForeign() ), m_broken( s.isBroken() ), m_total( s.totalDiskSpace() ), m_free( s.freeDiskSpace() )
{
}


Smb4KShare::~Smb4KShare()
{
}



const QString &Smb4KShare::name() const
{
  return m_name;
}


const QCString &Smb4KShare::path() const
{
  return m_path;
}


const QCString Smb4KShare::canonicalPath() const
{
  return m_broken ? m_path : QDir( m_path ).canonicalPath().local8Bit();
}


int Smb4KShare::uid() const
{
  return (int)m_user.uid();
}


void Smb4KShare::setUID( int uid )
{
  m_user = KUser( uid );
}


int Smb4KShare::gid() const
{
  return (int)m_group.gid();
}


void Smb4KShare::setGID( int gid )
{
  m_group = KUserGroup( gid );
}


const QString Smb4KShare::user() const
{
  return m_user.loginName();
}


const QString Smb4KShare::group() const
{
  return m_group.name();
}


const QString &Smb4KShare::filesystem() const
{
  return m_filesystem;
}


const QString &Smb4KShare::cifsLogin() const
{
  return m_cifs_login;
}


bool Smb4KShare::isForeign() const
{
  return m_foreign_mount;
}


void Smb4KShare::setForeign( bool foreign )
{
  m_foreign_mount = foreign;
}


bool Smb4KShare::isBroken() const
{
  return m_broken;
}


void Smb4KShare::setBroken( bool broken )
{
  m_broken = broken;
}


void Smb4KShare::setTotalDiskSpace( double total )
{
  m_total = total;
}


void Smb4KShare::setFreeDiskSpace( double free )
{
  m_free = free;
}


double Smb4KShare::totalDiskSpace() const
{
  return m_total;
}


double Smb4KShare::freeDiskSpace() const
{
  return m_free;
}


double Smb4KShare::percentage() const
{
  return (m_total - m_free) / m_total * 100;
}


bool Smb4KShare::equals( const Smb4KShare &share )
{
  bool equal = false;

  if ( QString::compare( m_name, share.name() ) == 0 &&
       QString::compare( m_path, share.path() ) == 0 &&
       QString::compare( m_filesystem, share.filesystem() ) == 0 &&
       QString::compare( m_cifs_login, share.cifsLogin() ) == 0 &&
       (int)m_user.uid() == share.uid() &&
       (int)m_group.gid() == share.gid() &&
       m_broken == share.isBroken() &&
       m_foreign_mount == share.isForeign() &&
       m_total == share.totalDiskSpace() &&
       m_free == share.freeDiskSpace() )
  {
    equal = true;
  }

  return equal;
}
