/***************************************************************************
    smb4ksynchronizeoptions  -  description
                             -------------------
    begin                : So Nov 20 2005
    copyright            : (C) 2005 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

// Qt includes
#include <qlayout.h>
#include <qbuttongroup.h>
#include <qdir.h>

// KDE includes
#include <klocale.h>
#include <kmessagebox.h>

// application specific includes
#include "smb4krsyncoptions.h"

Smb4KRsyncOptions::Smb4KRsyncOptions( QWidget *parent, const char *name ) : QTabWidget( parent, name )
{
  setMargin( 10 );

  //
  // The Copying tab
  //
  QWidget *copying_tab = new QWidget( this, "RsyncCopying" );
  QGridLayout *copying_layout = new QGridLayout( copying_tab );
  copying_layout->setSpacing( 10 );

  QGroupBox *directory_box = new QGroupBox( 2, QGroupBox::Horizontal, i18n( "Default Destination" ), copying_tab, "RsyncDestinationBox" );
  m_rsync_prefix_label = new QLabel( i18n( "Rsync prefix:" ), directory_box );
  m_rsync_prefix = new KURLRequester( QString::null, directory_box );
  m_rsync_prefix->setMode( KFile::Directory );

  QButtonGroup *general_box = new QButtonGroup( 2, QButtonGroup::Horizontal, i18n( "General" ), copying_tab, "RsyncModeBox" );
  m_archive = new QCheckBox( i18n( "Archive mode" ), general_box );
  m_recursive = new QCheckBox( i18n( "Recurse into directories" ), general_box );
  m_update = new QCheckBox( i18n( "Skip files that are newer in target directory" ), general_box );
  m_inplace = new QCheckBox( i18n( "Update destination files in place" ), general_box );
  m_relative = new QCheckBox( i18n( "Use relative path names (-R)" ), general_box );
  m_no_implied_dirs = new QCheckBox( i18n( "Don't send implied directories with -R" ), general_box );
  m_dirs = new QCheckBox( i18n( "Transfer directories without recursing" ), general_box );
  m_compress = new QCheckBox( i18n( "Compress data during transfer" ), general_box );

  QButtonGroup *links_box = new QButtonGroup( 2, QButtonGroup::Horizontal, i18n( "Links" ), copying_tab, "RsyncModeBox" );
  m_links = new QCheckBox( i18n( "Preserve symlinks" ), links_box );
  m_copy_links = new QCheckBox( i18n( "Transform symlinks" ), links_box );
  m_copy_unsafe_links = new QCheckBox( i18n( "Only transform unsafe links" ), links_box );
  m_safe_links = new QCheckBox( i18n( "Ignore symlinks that point outside the tree" ), links_box );
  m_hard_links = new QCheckBox( i18n( "Preserve hard links" ), links_box );
  m_keep_dirlinks = new QCheckBox( i18n( "Keep directory symlinks" ), links_box );

  QButtonGroup *perm_box = new QButtonGroup( 2, QButtonGroup::Horizontal, i18n( "File Permissions, etc." ), copying_tab, "RsyncPreservationBox" );
  m_perms = new QCheckBox( i18n( "Preserve permissions" ), perm_box );
  m_group = new QCheckBox( i18n( "Preserve group" ), perm_box );
  m_owner = new QCheckBox( i18n( "Preserve owner (root only)" ), perm_box );
  m_devices = new QCheckBox( i18n( "Preserve devices (root only)" ), perm_box );
  m_times = new QCheckBox( i18n( "Preserve times" ), perm_box );
  m_omit_dir_times = new QCheckBox( i18n( "Omit directories when preserving times" ), perm_box );

  QSpacerItem *spacer1 = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );

  copying_layout->addWidget( directory_box, 0, 0, 0 );
  copying_layout->addWidget( general_box, 1, 0, 0 );
  copying_layout->addWidget( links_box, 2, 0, 0 );
  copying_layout->addWidget( perm_box, 3, 0, 0 );
  copying_layout->addItem( spacer1, 4, 0 );

  addTab( copying_tab, i18n( "Copying" ) );


  //
  // The File Deletion & Transfer tab
  //
  QWidget *deltrans_tab = new QWidget( this, "RsyncFileDeletion" );
  QGridLayout *deltrans_layout = new QGridLayout( deltrans_tab );
  deltrans_layout->setSpacing( 10 );

  QButtonGroup *delete_box = new QButtonGroup( 2, QButtonGroup::Horizontal, i18n( "File Deletion" ), deltrans_tab, "RsyncDeleteBox" );
  m_remove_sent_files = new QCheckBox( i18n( "Remove sent files/symlinks from source" ), delete_box );
  m_delete = new QCheckBox( i18n( "Delete files that don't exist in source" ), delete_box );
  m_delete_before = new QCheckBox( i18n( "Delete files on destination before transfer" ), delete_box );
  m_delete_after = new QCheckBox( i18n( "Delete files on destination after transfer" ), delete_box );
  m_delete_during = new QCheckBox( i18n( "Delete files on destination during transfer" ), delete_box );
  m_delete_excluded = new QCheckBox( i18n( "Also delete excluded files on destination" ), delete_box );
  m_ignore_errors = new QCheckBox( i18n( "Delete even if I/O errors occur" ), delete_box );
  m_force = new QCheckBox( i18n( "Force deletion of non-void directories" ), delete_box );

  QButtonGroup *delete_restrictions_box = new QButtonGroup( 2, QButtonGroup::Horizontal, i18n( "Restrictions" ), deltrans_tab, "RsyncDeleteRestrictionsBox" );
  m_max_delete = new QCheckBox( i18n( "Don't delete more than this many files:" ), delete_restrictions_box );
  m_max_delete_input = new KIntNumInput( 0, delete_restrictions_box );
  m_max_delete_input->setMinValue( 0 );

  QButtonGroup *transfer_box = new QButtonGroup( 2, QButtonGroup::Horizontal, i18n( "File Transfer" ), deltrans_tab, "RsyncFileTransferBox" );
  m_min_size = new QCheckBox( i18n( "Don't transfer any file smaller than" ), transfer_box );
  m_min_size_input = new KIntNumInput( 0, transfer_box );
  m_min_size_input->setSuffix( " kB" );
  m_min_size_input->setMinValue( 0 );
  m_max_size = new QCheckBox( i18n( "Don't transfer any file larger than" ), transfer_box );
  m_max_size_input = new KIntNumInput( 0, transfer_box );
  m_max_size_input->setSuffix( " kB" );
  m_max_size_input->setMinValue( 0 );
  m_partial = new QCheckBox( i18n( "Keep partially transferred files" ), transfer_box );
  transfer_box->addSpace( 0 );
  m_partial_dir = new QCheckBox( i18n( "Put a partially transferred file into" ), transfer_box );
  m_partial_dir_requester = new KURLRequester( QDir::homeDirPath(), transfer_box );

  QSpacerItem *spacer2 = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );

  deltrans_layout->addWidget( delete_box, 0, 0, 0 );
  deltrans_layout->addWidget( delete_restrictions_box, 1, 0, 0 );
  deltrans_layout->addWidget( transfer_box, 2, 0, 0 );
  deltrans_layout->addItem( spacer2, 3, 0 );

  addTab( deltrans_tab, i18n( "File Deletion && Transfer" ) );


  //
  // The Filter tab
  //
  QWidget *filter_tab = new QWidget( this, "RsyncFiltering" );
  QGridLayout *filter_layout = new QGridLayout( filter_tab );
  filter_layout->setSpacing( 10 );

  QButtonGroup *general_filter_box = new QButtonGroup( 2, QButtonGroup::Horizontal, i18n( "General" ), filter_tab, "RsyncGeneralFilterBox" );
  m_cvs_exclude = new QCheckBox( i18n( "Auto-ignore files in the same way CVS does" ), general_filter_box );
  general_filter_box->addSpace( 0 );
  m_exclude = new QCheckBox( i18n( "Exclude files matching this pattern:" ), general_filter_box );
  m_exclude_input = new KLineEdit( general_filter_box );
  m_exclude_from = new QCheckBox( i18n( "Read exclude patterns from" ), general_filter_box );
  m_exclude_from_input = new KURLRequester( QDir::homeDirPath()+"/exclude.txt", general_filter_box );
  m_exclude_from_input->setMode( KFile::File );
  m_include = new QCheckBox( i18n( "Don't exclude files matching this pattern:" ), general_filter_box );
  m_include_input = new KLineEdit( general_filter_box );
  m_include_from = new QCheckBox( i18n( "Read include patterns from" ), general_filter_box );
  m_include_from_input = new KURLRequester( QDir::homeDirPath()+"/include.txt", general_filter_box );

  QButtonGroup *filter_rules_box = new QButtonGroup( 1, QGroupBox::Horizontal, i18n( "Filter Rules" ), filter_tab, "RsyncFilterRulesBox" );
  m_filter_input = new KLineEdit( filter_rules_box );
  QLabel *filter_rules_label= new QLabel( i18n( "The rules defined above will be added to the <i>rsync</i> command as they are. Thus, you have to start with the '--filter=' argument. You should also read rsync's manual page first." ), filter_rules_box );
  filter_rules_label->setTextFormat( Qt::RichText );
  m_f_filter = new QCheckBox( i18n( "Use \"--filter=': /.rsync-filter'\" filter rule" ), filter_rules_box );
  m_ff_filter = new QCheckBox( i18n( "Use \"--filter='- .rsync-filter'\" filter rule" ), filter_rules_box );

  QSpacerItem *spacer3 = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );

  filter_layout->addWidget( general_filter_box, 0, 0, 0 );
  filter_layout->addWidget( filter_rules_box, 1, 0, 0 );
  filter_layout->addItem( spacer3, 2, 0 );

  addTab( filter_tab, i18n( "Filtering" ) );


  //
  // The Advanced tab
  //
  QWidget *advanced_tab = new QWidget( this, "RsyncAdvanced" );
  QGridLayout *advanced_layout = new QGridLayout( advanced_tab );
  advanced_layout->setSpacing( 10 );

  QButtonGroup *misc_box = new QButtonGroup( 2, QButtonGroup::Horizontal, i18n( "General" ), advanced_tab, "RsyncAdvancedMiscBox" );
  m_sparse = new QCheckBox( i18n( "Handle sparse files efficiently" ), misc_box );
  m_whole_file = new QCheckBox( i18n( "Copy files whole (no rsync algorithm)" ), misc_box );
  m_one_file_system = new QCheckBox( i18n( "Don't cross file system boundaries" ), misc_box );
  m_existing = new QCheckBox( i18n( "Only update files that already exist" ), misc_box );
  m_ignore_existing = new QCheckBox( i18n( "Ignore files that already exist" ), misc_box );
  m_delay_updates = new QCheckBox( i18n( "Put all updated files into place at end" ), misc_box );

  QButtonGroup *backup_box = new QButtonGroup( 2, QButtonGroup::Horizontal, i18n( "Backup" ), advanced_tab, "RsyncBackupBox" );
  m_backup = new QCheckBox( i18n( "Make backups" ), backup_box );
  backup_box->addSpace( 0 );
  m_suffix = new QCheckBox( i18n( "Backup suffix:" ), backup_box );
  m_suffix_line = new KLineEdit( "~", backup_box );
  m_backup_dir = new QCheckBox( i18n( "Backup directory:" ), backup_box );
  m_backup_dir_requester = new KURLRequester( QDir::homeDirPath(), backup_box );

  QButtonGroup *checksum_box = new QButtonGroup( 2, QButtonGroup::Horizontal, i18n( "Checksums" ), advanced_tab, "RsyncChecksumsBox" );
  m_block_size = new QCheckBox( i18n( "Force fixed checksum block size:" ), checksum_box );
  m_block_size_input = new KIntNumInput( 0, checksum_box );
  m_block_size_input->setMinValue( 0 );
  m_checksum_seed = new QCheckBox( i18n( "Set block/file checksum seed:" ), checksum_box );
  m_checksum_seed_input = new KIntNumInput( 0, checksum_box );
  m_checksum_seed_input->setMinValue( 0 );
  m_checksum = new QCheckBox( i18n( "Skip based on checksum" ), checksum_box );
  checksum_box->addSpace( 0 );

  QSpacerItem *spacer4 = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );

  advanced_layout->addWidget( misc_box, 0, 0, 0 );
  advanced_layout->addWidget( backup_box, 1, 0, 0 );
  advanced_layout->addWidget( checksum_box, 2, 0, 0 );
  advanced_layout->addItem( spacer4, 3, 0 );

  addTab( advanced_tab, i18n( "Advanced" ) );

  connect( m_archive,         SIGNAL( toggled( bool ) ),
           this,              SLOT( slotArchiveToggled( bool ) ) );
  connect( m_recursive,       SIGNAL( toggled( bool ) ),
           this,              SLOT( slotUncheckArchive( bool ) ) );
  connect( m_links,           SIGNAL( toggled( bool ) ),
           this,              SLOT( slotUncheckArchive( bool ) ) );
  connect( m_perms,           SIGNAL( toggled( bool ) ),
           this,              SLOT( slotUncheckArchive( bool ) ) );
  connect( m_times,           SIGNAL( toggled( bool ) ),
           this,              SLOT( slotUncheckArchive( bool ) ) );
  connect( m_group,           SIGNAL( toggled( bool ) ),
           this,              SLOT( slotUncheckArchive( bool ) ) );
  connect( m_owner,           SIGNAL( toggled( bool ) ),
           this,              SLOT( slotUncheckArchive( bool ) ) );
  connect( m_devices,         SIGNAL( toggled( bool ) ),
           this,              SLOT( slotUncheckArchive( bool ) ) );
  connect( m_existing,        SIGNAL( toggled( bool ) ),
           this,              SLOT( slotExistingToggled( bool ) ) );
  connect( m_ignore_existing, SIGNAL( toggled( bool ) ),
           this,              SLOT( slotIgnoreExistingToggled( bool ) ) );
  connect( m_backup,          SIGNAL( toggled( bool ) ),
           this,              SLOT( slotBackupToggled( bool ) ) );
  connect( m_f_filter,        SIGNAL( toggled( bool ) ),
           this,              SLOT( slotFShortcutToggled( bool ) ) );
  connect( m_ff_filter,       SIGNAL( toggled( bool ) ),
           this,              SLOT( slotFFShortcutToggled( bool ) ) );

  slotArchiveToggled( true );
  slotExistingToggled( false );
  slotIgnoreExistingToggled( false );
  slotBackupToggled( false );
}


Smb4KRsyncOptions::~Smb4KRsyncOptions()
{
}


/////////////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////

void Smb4KRsyncOptions::slotArchiveToggled( bool on )
{
  if ( on )
  {
    m_recursive->setChecked( on );
    m_links->setChecked( on );
    m_perms->setChecked( on );
    m_times->setChecked( on );
    m_group->setChecked( on );
    m_owner->setChecked( on );
    m_devices->setChecked( on );
  }
}


void Smb4KRsyncOptions::slotUncheckArchive( bool on )
{
  if ( !on )
  {
    m_archive->setChecked( on );
  }
}


void Smb4KRsyncOptions::slotExistingToggled( bool on )
{
  if ( on && m_ignore_existing->isChecked() )
  {
    m_ignore_existing->setChecked( !on );
  }
}


void Smb4KRsyncOptions::slotIgnoreExistingToggled( bool on )
{
  if ( on && m_existing->isChecked() )
  {
    m_existing->setChecked( !on );
  }
}


void Smb4KRsyncOptions::slotBackupToggled( bool on )
{
  m_backup_dir->setEnabled( on );
  m_backup_dir_requester->setEnabled( on );
  m_suffix->setEnabled( on );
  m_suffix_line->setEnabled( on );
}


void Smb4KRsyncOptions::slotFShortcutToggled( bool on )
{
  if ( on && m_ff_filter->isChecked() )
  {
    m_ff_filter->setChecked( false );
  }
}


void Smb4KRsyncOptions::slotFFShortcutToggled( bool on )
{
  if ( on && m_f_filter->isChecked() )
  {
    m_f_filter->setChecked( false );
  }
}

#include "smb4krsyncoptions.moc"
