% SLgtk: S-Lang language bindings for GTK+ widget set
%
% Copyright (C) 2007 Massachusetts Institute of Technology
% Copyright (C) 2002 Michael S. Noble <mnoble@space.mit.edu>
% 
% This library is free software; you can redistribute it and/or
% modify it under the terms of the GNU Library General Public
% License as published by the Free Software Foundation; either
% version 2 of the License, or (at your option) any later version.
% 
% This library is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% Library General Public License for more details.

#ifnexists toolbox_new

require("gtk");

typedef struct { % {{{
   widget,
   toolbar,
   buttons,
   funcs,
   defaultfocus,
   keepfocus,
   curr,			% index of currently selected button w/in tbox
   curr_widget,			% radio utton corresponding to curr selection
} ToolBox; % }}}

static define choose_tool(tb, which, data) % {{{
{
   if (tb.curr == which)
      return;

   variable prev = tb.curr;
   tb.curr = which;
   (@tb.funcs[which])(tb,data);
   if ( not (tb.keepfocus[which]) ) {
	gtk_toggle_button_set_active(tb.buttons[prev],TRUE);
	tb.curr = prev;
   }
} % }}}

public define toolbox_set_active(tb, id) % {{{
{
   g_signal_emit_by_name(tb.buttons[id],"clicked");
} % }}}

public define toolbox_set_focusable(tb, id, keepfocus) % {{{
{
   tb.keepfocus[id] = (keepfocus != FALSE);
} % }}}

public define toolbox_set_focus_default(tb, focusable_by_default) % {{{
{
   tb.defaultfocus = (focusable_by_default != FALSE);
} % }}}

public define toolbox_add_button() % {{{
{
   variable tb, icon, id, func, data, signal;
   switch (_NARGS)
	{ case 5: (tb, icon, id, func, data) = (); signal = "clicked";}
	{ case 6: (tb, icon, id, func, data, signal) = (); }

   !if (_is_callable(func))
      error(sprintf("toolbox_add_button: %S not a callable function",func));

   % Add radio button to same group as last button added (NULL if first rb)
   variable rb = gtk_radio_button_new_from_widget(tb.curr_widget);
   variable image;
   variable size = GTK_ICON_SIZE_LARGE_TOOLBAR;

   switch(_typeof(icon))
	{ case NULL: image = gtk_image_new_from_stock(GTK_STOCK_NEW,size); }
	{ case String_Type: image = gtk_image_new_from_stock(icon,size); }
	{ case GtkOpaque: image = icon;}

   gtk_toggle_button_set_mode (rb, FALSE);
   gtk_container_add(rb,image);

   % id is a text string which is used both to index the assoc arrays
   % of buttons/etc in this toolbox AND to provide tooltip popup help
   gtk_toolbar_append_widget(tb.toolbar, rb, id, );
   tb.buttons[id] = rb;
   tb.funcs[id] = func;
   tb.keepfocus[id] = tb.defaultfocus;

   % Note that the "clicked" signal will be emitted for both the tool being
   % chosen AND the tool previously chosen.   This is a Gtk implementation 
   % blemish (discussed in the mail archives) which for historical reasons
   % has not been corrected yet.  The caller should be mindful of this, and 
   % implement their callbacks (i.e. the elements of tb.funcs) accordingly.
   () = g_signal_connect_swapped(rb,signal,&choose_tool,tb,id,data);

   if (tb.curr_widget == NULL) {
	tb.curr = id;			% default: select first entry
	toolbox_set_active(tb,id);
   }
   tb.curr_widget = rb;
} % }}}

public define toolbox_new() % {{{
{
   variable orientation = GTK_ORIENTATION_VERTICAL;

   if (_NARGS == 1)
	orientation = ();

   variable tbox     = @ToolBox;
   tbox.buttons      = Assoc_Type[Any_Type, NULL];
   tbox.funcs        = Assoc_Type[Ref_Type];
   tbox.defaultfocus = TRUE;
   tbox.keepfocus    = Assoc_Type[Integer_Type];
   tbox.toolbar      = gtk_toolbar_new();
   tbox.widget       = tbox.toolbar;

   gtk_toolbar_set_orientation(tbox.toolbar,orientation);
   gtk_toolbar_append_space(tbox.toolbar);

   return tbox;
} % }}}

#endif

provide("toolbox");
