
% The rgbselect() guilet was written as a component of another guilet,
% evt2img, which will be bundled within John Davis's histogram module.
% It is also bundled with the slgtk-demo code, as yet another example
% of how the GtkPlot widget may be used.

static variable window = NULL;

require("rgbselect");

static define print_new_selection(r)
{
   vmessage("New color selection:\n"+
		"red   = (%S,%S),\n"+
		"green = (%S, %S)\n"+
		"blue  = (%S, %S) \n", r.r0, r.r1, r.g0 ,r.g1 ,r.b0 ,r.b1);
}

static define invoke_rgbselect(button,toplevel)
{
   variable x = [1:99:3];
   variable y = Double_Type[length(x)];
   y[0] = 1;
   y[1] = 3;
   y[2] = 7;
   y[[3:10]] = 2;
   y[[11:15]] = 4;
   y[[16:19]] = 5;
   y[[20:26]] = 8;
   y[[27:32]] = 2;

   variable r = @RGBLimits;

   r.r0 = 10.0;
   r.r1 = 22.0;
   r.g0 = 40.0;
   r.g1 = 55.0;
   r.b0 = 70.0;
   r.b1 = 88.0;

   if ( rgbselect(x, y, r, &print_new_selection))
	print_new_selection(r);
   else
	vmessage("No colors changed (i.e. since last 'Apply')");

}

define create_rgbtest(test)
{

   if (window == NULL) {

	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	() = g_signal_connect(window,"destroy",&gtk_widget_destroyed,&window);

	gtk_window_set_title (window, "RGB Color Selector (using GtkPlot)");
	gtk_window_set_default_size(window, 250, 150);
	variable vbox = gtk_vbox_new(FALSE,5);
	gtk_container_add ( window, vbox);

	variable button = gtk_button_new_with_label("Invoke rgbselect()");

	_gtk_window_destroy_with(window, gtk_widget_get_toplevel(test.raise));
	() = g_signal_connect(button,"clicked",&invoke_rgbselect,window);

	gtk_box_pack_start(vbox,button,TRUE,TRUE,0);
	test.lower = generic_close_button(vbox,window);
   }

   if (gtk_widget_visible (window))
	gtk_widget_destroy (window);
   else
	gtk_widget_show_all (window);
}
