
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License (Version 2) as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * In sfront distribution, see file COPYING for the GNU General Public License
 *
 *Automatically generated library file asys

 */

#include "tree.h"



void makeaif(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: aiff audio driver for sfront";
  z[lc++]="#    Copyright (C) 1999  Regents of the University of California";
  z[lc++]="#";
  z[lc++]="#    This program is free software; you can redistribute it and/or modify";
  z[lc++]="#    it under the terms of the GNU General Public License (Version 2) as";
  z[lc++]="#    published by the Free Software Foundation.";
  z[lc++]="#";
  z[lc++]="#    This program is distributed in the hope that it will be useful,";
  z[lc++]="#    but WITHOUT ANY WARRANTY; without even the implied warranty of";
  z[lc++]="#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the";
  z[lc++]="#    GNU General Public License for more details.";
  z[lc++]="#";
  z[lc++]="#    You should have received a copy of the GNU General Public License";
  z[lc++]="#    along with this program; if not, write to the Free Software";
  z[lc++]="#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             aif file audio driver for sfront                 */ ";
  z[lc++]="/*                  reads/writes AIFF files                     */";
  z[lc++]="/****************************************************************/";
  z[lc++]="        ";
  z[lc++]="#include <stdio.h>";
  z[lc++]="#include <string.h>";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/* default name for output audio file */";
  z[lc++]="#define ASYSO_DEFAULTNAME \"output.aif\"";
  z[lc++]="";
  z[lc++]="/* global variables, must start with asyso_ */";
  z[lc++]="";
  z[lc++]="FILE * asyso_fd;     /* output file pointer */";
  z[lc++]="char * asyso_name;   /* name of file  */        ";
  z[lc++]="long asyso_srate;    /* sampling rate */";
  z[lc++]="long asyso_channels; /* number of channels */";
  z[lc++]="long asyso_size;    /* number of samples in a buffer */";
  z[lc++]="long asyso_nsamp;    /* total number of shorts written */";
  z[lc++]="long asyso_doswap;   /* needs byteswap on write */";
  z[lc++]="short * asyso_buf;   /* location for output buffer */ ";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/* default name for input audio file */";
  z[lc++]="";
  z[lc++]="#define ASYSI_DEFAULTNAME \"input.aif\"";
  z[lc++]="";
  z[lc++]="/* only used for asysi_soundtypecheck */";
  z[lc++]="";
  z[lc++]="#define ASYSI_MATCH  0";
  z[lc++]="#define ASYSI_EOF 1";
  z[lc++]="#define ASYSI_NOMATCH 2";
  z[lc++]="";
  z[lc++]="/* global variables, must start with asysi_ */";
  z[lc++]="";
  z[lc++]="FILE * asysi_fd;     /* input file pointer */";
  z[lc++]="char * asysi_name;   /* name of file  */        ";
  z[lc++]="long asysi_srate;    /* sampling rate */";
  z[lc++]="long asysi_channels; /* number of channels */";
  z[lc++]="long asysi_size;    /* number of samples in a buffer */";
  z[lc++]="long asysi_nsamp;    /* total number of shorts read */";
  z[lc++]="long asysi_doswap;   /* needs byteswap on read */";
  z[lc++]="short * asysi_buf;   /* location for input buffer */ ";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/*********************************************************/";
  z[lc++]="/*            writes next block of AIFF bytes            */";
  z[lc++]="/*********************************************************/";
  z[lc++]="";
  z[lc++]="int asyso_putbytes(unsigned char * c, int numbytes)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (rwrite(c, sizeof(char), numbytes, asyso_fd) != numbytes)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*********************************************************/";
  z[lc++]="/*        writes unsigned long to a AIFF files            */";
  z[lc++]="/*********************************************************/";
  z[lc++]="";
  z[lc++]="int asyso_putlong(unsigned long val, int numbytes)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char c[4];";
  z[lc++]="";
  z[lc++]="  if (numbytes > 4)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  switch (numbytes) {";
  z[lc++]="  case 4:";
  z[lc++]="    c[3] = (unsigned char) (val&0x000000FF);";
  z[lc++]="    c[2] = (unsigned char)((val >> 8)&0x000000FF);";
  z[lc++]="    c[1] = (unsigned char)((val >> 16)&0x000000FF);";
  z[lc++]="    c[0] = (unsigned char)((val >> 24)&0x000000FF);";
  z[lc++]="    return asyso_putbytes(c, 4);";
  z[lc++]="  case 3:";
  z[lc++]="    c[2] = (unsigned char) (val&0x000000FF);";
  z[lc++]="    c[1] = (unsigned char)((val >> 8)&0x000000FF);";
  z[lc++]="    c[0] = (unsigned char)((val >> 16)&0x000000FF);";
  z[lc++]="    return asyso_putbytes(c, 3);";
  z[lc++]="  case 2:";
  z[lc++]="    c[1] = (unsigned char) (val&0x000000FF);";
  z[lc++]="    c[0] = (unsigned char)((val >> 8)&0x000000FF);";
  z[lc++]="    return asyso_putbytes(c, 2);";
  z[lc++]="  case 1:";
  z[lc++]="    c[0] = (unsigned char) (val&0x000000FF);";
  z[lc++]="    return asyso_putbytes(c,1);";
  z[lc++]="  default:";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        core routine for audio output setup                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asyso_setup(long srate, long ochannels, long osize, char * name)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  short swaptest = 0x0001;";
  z[lc++]="  int e;";
  z[lc++]="  unsigned long m;";
  z[lc++]="  unsigned char c[10];";
  z[lc++]="  char * val;";
  z[lc++]="";
  z[lc++]="  asyso_doswap = *((char *)&swaptest);";
  z[lc++]="  if (name == NULL)";
  z[lc++]="    val = ASYSO_DEFAULTNAME;";
  z[lc++]="  else";
  z[lc++]="    val = name;";
  z[lc++]="  asyso_name = strcpy((char *) calloc((strlen(val)+1),sizeof(char)), val);";
  z[lc++]="";
  z[lc++]="  asyso_fd = fopen(asyso_name,\"wb\");";
  z[lc++]="  if (asyso_fd == NULL)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  /* preamble for wav file */";
  z[lc++]="";
  z[lc++]="  asyso_putbytes((unsigned char *) \"FORM\",4);";
  z[lc++]="  asyso_putlong(0,4);       /* length, patched later */";
  z[lc++]="  asyso_putbytes((unsigned char *) \"AIFFCOMM\",8);";
  z[lc++]="  asyso_putlong(18,4);                 /* 18 bytes */";
  z[lc++]="  asyso_putlong(ochannels,2);          /* number of channels */";
  z[lc++]="  asyso_putlong(0,4);                  /* frames, patched later */";
  z[lc++]="  asyso_putlong(16,2);                 /* 16 bit data */";
  z[lc++]="  m = (unsigned long)floor(ldexp(frexp((double)srate, &e),32));";
  z[lc++]="  e += 16382;";
  z[lc++]="  c[0] = e >> 8;";
  z[lc++]="  c[1] = e;";
  z[lc++]="  c[2] = m >> 24;";
  z[lc++]="  c[3] = m >> 16;";
  z[lc++]="  c[4] = m >> 8;";
  z[lc++]="  c[5] = m;";
  z[lc++]="  c[6] = c[7] = c[8] = c[9] = 0;";
  z[lc++]="  asyso_putbytes((unsigned char *)&c[0],10); /* srate */";
  z[lc++]="  asyso_putbytes((unsigned char *) \"SSND\",4);";
  z[lc++]="  asyso_putlong(0,4);       /* length, patched later */";
  z[lc++]="  asyso_putlong(0,4);       /* offset = 0 */           ";
  z[lc++]="  asyso_putlong(0,4);       /* block size */           ";
  z[lc++]="";
  z[lc++]="  asyso_srate = srate;";
  z[lc++]="  asyso_channels = ochannels;";
  z[lc++]="  asyso_size = osize;";
  z[lc++]="  asyso_nsamp = 0;";
  z[lc++]="  asyso_buf = (short *)calloc(osize, sizeof(short));";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/*********************************************************/";
  z[lc++]="/*            gets next block of AIFF bytes               */";
  z[lc++]="/*********************************************************/";
  z[lc++]="";
  z[lc++]="int asysi_getbytes(unsigned char * c, int numbytes)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if ((int)rread(c, sizeof(char), numbytes, asysi_fd) != numbytes)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*********************************************************/";
  z[lc++]="/*        flushes next block of AIFF bytes                */";
  z[lc++]="/*********************************************************/";
  z[lc++]="";
  z[lc++]="int asysi_flushbytes(int numbytes)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char c;";
  z[lc++]="";
  z[lc++]="  while (numbytes > 0)";
  z[lc++]="    {";
  z[lc++]="      if (rread(&c, sizeof(char), 1, asysi_fd) != 1)";
  z[lc++]="	return ASYS_ERROR;";
  z[lc++]="      numbytes--;";
  z[lc++]="    }";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*********************************************************/";
  z[lc++]="/*     converts byte stream to an unsigned long          */";
  z[lc++]="/*********************************************************/";
  z[lc++]="";
  z[lc++]="long asysi_getlong(int numbytes,  unsigned long * ret)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char c[4];";
  z[lc++]="";
  z[lc++]="  if (numbytes > 4)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if (ASYS_DONE != asysi_getbytes(&c[0],numbytes))";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  switch (numbytes) {";
  z[lc++]="  case 4:";
  z[lc++]="    *ret  =  (unsigned long)c[3];";
  z[lc++]="    *ret |=  (unsigned long)c[2] << 8;";
  z[lc++]="    *ret |=  (unsigned long)c[1] << 16;";
  z[lc++]="    *ret |=  (unsigned long)c[0] << 24;";
  z[lc++]="    return ASYS_DONE;";
  z[lc++]="  case 3:";
  z[lc++]="    *ret  =  (unsigned long)c[2];";
  z[lc++]="    *ret |=  (unsigned long)c[1] << 8;";
  z[lc++]="    *ret |=  (unsigned long)c[0] << 16;";
  z[lc++]="    return ASYS_DONE;";
  z[lc++]="  case 2:";
  z[lc++]="    *ret  =  (unsigned long)c[1];";
  z[lc++]="    *ret |=  (unsigned long)c[0] << 8;";
  z[lc++]="    return ASYS_DONE;";
  z[lc++]="  case 1:";
  z[lc++]="    *ret = (unsigned long)c[0];";
  z[lc++]="    return ASYS_DONE;";
  z[lc++]="  default:";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="    ";
  z[lc++]="/*********************************************************/";
  z[lc++]="/*     converts byte stream to an long          */";
  z[lc++]="/*********************************************************/";
  z[lc++]="";
  z[lc++]="long asysi_getslong(int numbytes, long * ret)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char c[4];";
  z[lc++]="";
  z[lc++]="  if (numbytes > 4)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if (ASYS_DONE != asysi_getbytes(&c[0],numbytes))";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  switch (numbytes) {";
  z[lc++]="  case 4:";
  z[lc++]="    *ret  =  (long)c[3];";
  z[lc++]="    *ret |=  (long)c[2] << 8;";
  z[lc++]="    *ret |=  (long)c[1] << 16;";
  z[lc++]="    *ret |=  (long)c[0] << 24;";
  z[lc++]="    return ASYS_DONE;";
  z[lc++]="  case 3:";
  z[lc++]="    *ret  =  (long)c[2];";
  z[lc++]="    *ret |=  (long)c[1] << 8;";
  z[lc++]="    *ret |=  (long)c[0] << 16;";
  z[lc++]="    return ASYS_DONE;";
  z[lc++]="  case 2:";
  z[lc++]="    *ret  =  (long)c[1];";
  z[lc++]="    *ret |=  (long)c[0] << 8;";
  z[lc++]="    return ASYS_DONE;";
  z[lc++]="  case 1:";
  z[lc++]="    *ret = (long)c[0];";
  z[lc++]="    return ASYS_DONE;";
  z[lc++]="  default:";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="    ";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*  checks byte stream for AIFF cookie --                 */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="int asysi_soundtypecheck(char * d)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  char c[4];";
  z[lc++]="";
  z[lc++]="  if (rread(c, sizeof(char), 4, asysi_fd) != 4)";
  z[lc++]="    return ASYSI_EOF;";
  z[lc++]="  if (strncmp(c,d,4))";
  z[lc++]="    return ASYSI_NOMATCH;";
  z[lc++]="  return ASYSI_MATCH;";
  z[lc++]="}";
  z[lc++]="  ";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        core routine for audio input setup                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysi_setup(long srate, long ichannels, long isize, char * name)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  short swaptest = 0x0001;";
  z[lc++]="  unsigned long i, m;";
  z[lc++]="  long e, len;";
  z[lc++]="  unsigned char c[4];";
  z[lc++]="  char * val;";
  z[lc++]="";
  z[lc++]="  asysi_doswap = *((char *)&swaptest);";
  z[lc++]="  if (name == NULL)";
  z[lc++]="    val = ASYSI_DEFAULTNAME;";
  z[lc++]="  else";
  z[lc++]="    val = name;";
  z[lc++]="  asysi_name = strcpy((char *) calloc((strlen(val)+1),sizeof(char)), val);";
  z[lc++]="  asysi_fd = fopen(asysi_name,\"rb\");";
  z[lc++]="";
  z[lc++]="  if (asysi_fd == NULL)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if (asysi_soundtypecheck(\"FORM\")!= ASYSI_MATCH)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if (asysi_flushbytes(4)!= ASYS_DONE)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if (asysi_soundtypecheck(\"AIFF\")!= ASYSI_MATCH)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if (asysi_getbytes(&c[0],4)!= ASYS_DONE)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  while (strncmp((char *) c,\"SSND\",4))";
  z[lc++]="    {";
  z[lc++]="      if (strncmp((char *) c,\"COMM\",4))";
  z[lc++]="	{";
  z[lc++]="	  if (asysi_getlong(4, &i) != ASYS_DONE)";
  z[lc++]="	    return ASYS_ERROR;";
  z[lc++]="	  if (asysi_flushbytes(i)!= ASYS_DONE)";
  z[lc++]="	    return ASYS_ERROR;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  if (asysi_flushbytes(4)!= ASYS_DONE) /* length */";
  z[lc++]="	    return ASYS_ERROR;";
  z[lc++]="	  if (asysi_getlong(2, &i) != ASYS_DONE)";
  z[lc++]="	    return ASYS_ERROR;";
  z[lc++]="	  if (i != ichannels)";
  z[lc++]="	    {";
  z[lc++]="	      fprintf(stderr,\"Error: Inchannels doesn't match AIFF file\\n\");";
  z[lc++]="	      return ASYS_ERROR;";
  z[lc++]="	    }";
  z[lc++]="	  if (asysi_flushbytes(4)!= ASYS_DONE) /* frames */";
  z[lc++]="	    return ASYS_ERROR;";
  z[lc++]="	  if (asysi_getlong(2, &i) != ASYS_DONE)";
  z[lc++]="	    return ASYS_ERROR;";
  z[lc++]="	  if (i != 16)";
  z[lc++]="	    {";
  z[lc++]="	      fprintf(stderr,\"Error: Can't handle %i bit data\\n\",i);";
  z[lc++]="	      return ASYS_ERROR;";
  z[lc++]="	    }";
  z[lc++]="	  if (asysi_getslong(2, &e) != ASYS_DONE)";
  z[lc++]="	    return ASYS_ERROR;";
  z[lc++]="	  if (asysi_getlong(4, &m) != ASYS_DONE)";
  z[lc++]="	    return ASYS_ERROR;";
  z[lc++]="	  if (asysi_flushbytes(4)!= ASYS_DONE) /* unneeded precision */";
  z[lc++]="	    return ASYS_ERROR;";
  z[lc++]="	  i = (unsigned long)(0.5+(m*exp(log(2)*(e - 16414.0F))));";
  z[lc++]="	  if (srate != i)";
  z[lc++]="	    fprintf(stderr,\"Warning: SAOL srate %i mismatches AIFF file srate %i\\n\",";
  z[lc++]="		    srate, i);";
  z[lc++]="	    ";
  z[lc++]="	}";
  z[lc++]="      if (asysi_getbytes(&c[0],4)!= ASYS_DONE)";
  z[lc++]="	return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="  if (asysi_getlong(4, &i) != ASYS_DONE)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if (asysi_flushbytes(8)!= ASYS_DONE) ";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  asysi_nsamp = (i - 8)/2;";
  z[lc++]="  ";
  z[lc++]="  asysi_srate = srate;";
  z[lc++]="  asysi_channels = ichannels;";
  z[lc++]="  asysi_size = isize;";
  z[lc++]="  asysi_buf = (short *)malloc(sizeof(short)*isize);";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && !defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio output for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_osetup(long srate, long ochannels, long osample, ";
  z[lc++]="		char * oname, long toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  return asyso_setup(srate, ochannels, ASYS_OCHAN*ACYCLE, oname);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio input for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_isetup(long srate, long ichannels, long isample, ";
  z[lc++]="		char * iname, long toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  return asysi_setup(srate, ichannels, ASYS_ICHAN*ACYCLE, iname);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*   sets up audio input and output for a given srate/channels  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_iosetup(long srate, long ichannels, long ochannels,";
  z[lc++]="		 long isample, long osample, ";
  z[lc++]="		 char * iname, char * oname, long toption)";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  if (asysi_setup(srate, ichannels, ASYS_ICHAN*ACYCLE, iname) != ASYS_DONE)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  return asyso_setup(srate, ochannels, ASYS_OCHAN*ACYCLE, oname);";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             shuts down audio output system                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asyso_shutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  fseek(asyso_fd, 4, SEEK_SET);";
  z[lc++]="  asyso_putlong(2*asyso_nsamp+46,4);";
  z[lc++]="  fseek(asyso_fd,22,SEEK_SET); /* bugfix by Richard Dobson */";
  z[lc++]="  asyso_putlong(asyso_nsamp /asyso_channels,4);";
  z[lc++]="  fseek(asyso_fd, 16, SEEK_CUR);";
  z[lc++]="  asyso_putlong(8+2*asyso_nsamp,4);";
  z[lc++]="  fclose(asyso_fd);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               shuts down audio input system                  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asysi_shutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  fclose(asysi_fd);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(!defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                    shuts down audio output                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_oshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asyso_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input device                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ishutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysi_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input and output device        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ioshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysi_shutdown();";
  z[lc++]="  asyso_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        creates buffer, and generates starting silence        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_preamble(ASYS_OTYPE * asys_obuf[], long * osize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  *asys_obuf = asyso_buf;";
  z[lc++]="  *osize = asyso_size;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               sends one frame of audio to output             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_putbuf(ASYS_OTYPE * asys_obuf[], long * osize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char * buf;";
  z[lc++]="  unsigned char tmp;";
  z[lc++]="  long i = 0;";
  z[lc++]="";
  z[lc++]="  if (asyso_doswap)";
  z[lc++]="    {";
  z[lc++]="      buf = (unsigned char *)(*asys_obuf);";
  z[lc++]="      while (i < 2*(*osize))";
  z[lc++]="	{";
  z[lc++]="	  tmp = buf[i+1];";
  z[lc++]="	  buf[i+1] = buf[i];";
  z[lc++]="	  buf[i] = tmp;";
  z[lc++]="	  i += 2;";
  z[lc++]="	}";
  z[lc++]="      if (rwrite(buf, sizeof(char), 2*(*osize), asyso_fd) != 2*(*osize))";
  z[lc++]="	return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    if (rwrite(*asys_obuf, sizeof(short), *osize, asyso_fd) != *osize)";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="  asyso_nsamp += *osize;";
  z[lc++]="  *osize = asyso_size;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               sends one frame of audio to output             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_getbuf(ASYS_ITYPE * asys_ibuf[], long * isize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char * buf;";
  z[lc++]="  unsigned char tmp;";
  z[lc++]="  long i = 0;";
  z[lc++]="";
  z[lc++]="  if (*asys_ibuf == NULL)";
  z[lc++]="    *asys_ibuf = asysi_buf;";
  z[lc++]="  ";
  z[lc++]="  if (asysi_nsamp <= 0)";
  z[lc++]="    {";
  z[lc++]="      *isize = 0;";
  z[lc++]="      return ASYS_DONE;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  *isize = (long)rread(*asys_ibuf, sizeof(short), asysi_size, asysi_fd);";
  z[lc++]="  if (asysi_doswap)";
  z[lc++]="    {";
  z[lc++]="      buf = (unsigned char *)(*asys_ibuf);";
  z[lc++]="      while (i < 2*(*isize))";
  z[lc++]="	{";
  z[lc++]="	  tmp = buf[i+1];";
  z[lc++]="	  buf[i+1] = buf[i];";
  z[lc++]="	  buf[i] = tmp;";
  z[lc++]="	  i += 2;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  asysi_nsamp -= *isize;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  printlib(lc);
}


void makehpux(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: hpux audio driver for sfront";
  z[lc++]="#    Copyright (C) 1999  Regents of the University of California";
  z[lc++]="#";
  z[lc++]="#    This program is free software; you can redistribute it and/or modify";
  z[lc++]="#    it under the terms of the GNU General Public License (Version 2) as";
  z[lc++]="#    published by the Free Software Foundation.";
  z[lc++]="#";
  z[lc++]="#    This program is distributed in the hope that it will be useful,";
  z[lc++]="#    but WITHOUT ANY WARRANTY; without even the implied warranty of";
  z[lc++]="#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the";
  z[lc++]="#    GNU General Public License for more details.";
  z[lc++]="#";
  z[lc++]="#    You should have received a copy of the GNU General Public License";
  z[lc++]="#    along with this program; if not, write to the Free Software";
  z[lc++]="#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             HPUX/9.0 audio driver for sfront                 */ ";
  z[lc++]="/*                                                              */";
  z[lc++]="/****************************************************************/";
  z[lc++]="        ";
  z[lc++]="#include <fcntl.h>";
  z[lc++]="#include <sys/socket.h>";
  z[lc++]="#include <audio/Alib.h>";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/* global variables for HPUX audio output */";
  z[lc++]="";
  z[lc++]="Audio *asyso_a;                  /* audio ptr                     */";
  z[lc++]="ATransID asyso_x;                /* audio stream                  */";
  z[lc++]="long asyso_s;                    /* socket for audio stream       */";
  z[lc++]="long asyso_pflag;                /* flag for hardware head start  */";
  z[lc++]="long asyso_pidx;                 /* number of bytes of head start */";
  z[lc++]="long asyso_size;                 /* number of shorts in a buffer  */";
  z[lc++]="short * asyso_buf;               /* location for output buffer    */";
  z[lc++]=" ";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="Audio    *asysi_a;      /* audio ptr                     */";
  z[lc++]="ATransID asysi_x;       /* audio stream                  */";
  z[lc++]="long     asysi_s;       /* socket for audio stream       */";
  z[lc++]="long     asysi_size;    /* number of shorts in a buffer  */";
  z[lc++]="short    *asysi_buf;    /* location for output buffer    */";
  z[lc++]="fd_set   asysi_selFD;   /* select file descriptor        */";
  z[lc++]="fd_set   asysi_redFD;   /* ready file descriptor         */";
  z[lc++]="long     asysi_stdFD;   /* stdin file descriptor         */";
  z[lc++]="long     asysi_maxFD;   /* max-numbered file descriptor  */";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio system for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asyso_setup(long srate, long ochannels, long osize, char * oname,";
  z[lc++]="		long toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  AudioAttributes aa;";
  z[lc++]="  SSPlayParams sp;    ";
  z[lc++]="  SStream as; ";
  z[lc++]="  AGainEntry g[2];";
  z[lc++]="";
  z[lc++]="  asyso_size = osize;";
  z[lc++]="  asyso_buf = (short *)calloc(osize, sizeof(short));";
  z[lc++]="";
  z[lc++]="  asyso_a = AOpenAudio(\"\", NULL);";
  z[lc++]="  aa = *ABestAudioAttributes(asyso_a);";
  z[lc++]="";
  z[lc++]="  aa.attr.sampled_attr.data_format = ADFLin16;";
  z[lc++]="  aa.attr.sampled_attr.bits_per_sample = 16;";
  z[lc++]="  aa.attr.sampled_attr.sampling_rate = srate;";
  z[lc++]="  aa.attr.sampled_attr.channels = ochannels;";
  z[lc++]="  aa.attr.sampled_attr.interleave = 1;";
  z[lc++]="  aa.attr.sampled_attr.duration.type = ATTFullLength;";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="  if (ochannels > 2)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (ochannels == 1)";
  z[lc++]="    {";
  z[lc++]="      g[0].gain = AUnityGain;";
  z[lc++]="      g[0].u.o.out_ch = AOCTMono;";
  z[lc++]="      g[0].u.o.out_dst = AODTMonoJack;";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      g[0].gain = g[1].gain = AUnityGain;";
  z[lc++]="      g[0].u.o.out_ch = AOCTLeft;";
  z[lc++]="      g[1].u.o.out_ch = AOCTRight;";
  z[lc++]="      g[0].u.o.out_dst = AODTLeftLineOut;";
  z[lc++]="      g[1].u.o.out_dst = AODTRightLineOut;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  sp.gain_matrix.type = AGMTOutput;";
  z[lc++]="  sp.gain_matrix.num_entries = ochannels;";
  z[lc++]="  sp.gain_matrix.gain_entries = g;";
  z[lc++]="  sp.play_volume = AUnityGain;   ";
  z[lc++]="";
  z[lc++]="  if (toption == ASYS_RENDER)";
  z[lc++]="    sp.priority = APriorityHigh; ";
  z[lc++]="  else";
  z[lc++]="    sp.priority = APriorityUrgent; ";
  z[lc++]="";
  z[lc++]="  sp.event_mask = 0;             ";
  z[lc++]="";
  z[lc++]="  asyso_x = APlaySStream(asyso_a, ~0, &aa, &sp , &as, NULL);";
  z[lc++]="  if ((asyso_s = socket(AF_INET, SOCK_STREAM, 0)) < 0)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if (connect(asyso_s, (struct sockaddr *)&as.tcp_sockaddr,";
  z[lc++]="		   sizeof(struct sockaddr_in)) < 0)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (toption == ASYS_RENDER)";
  z[lc++]="    {";
  z[lc++]="      asyso_pidx = 3 * 2 * ochannels * srate;";
  z[lc++]="      asyso_pflag = 1;";
  z[lc++]="      APauseAudio(asyso_a, asyso_x, NULL, NULL);";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    asyso_pflag = asyso_pidx = 0;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              initializes audio input                         */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysi_setup(long srate, long ichannels, long isize, char * iname)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  AudioAttributes rr;";
  z[lc++]="  SStream sr;";
  z[lc++]="  SSRecordParams  asr;";
  z[lc++]="  AGainEntry g[2];";
  z[lc++]="";
  z[lc++]="  asysi_size = isize;";
  z[lc++]="  asysi_buf = (short *)malloc(sizeof(short)*isize);";
  z[lc++]="";
  z[lc++]="  asysi_a = AOpenAudio(\"\", NULL);";
  z[lc++]="  rr = *aBestAudioAttributes(asysi_a);   ";
  z[lc++]="";
  z[lc++]="  rr.attr.sampled_attr.data_format = ADFLin16;";
  z[lc++]="  rr.attr.sampled_attr.bits_per_sample = 16;";
  z[lc++]="  rr.attr.sampled_attr.sampling_rate = srate;";
  z[lc++]="  rr.attr.sampled_attr.channels = ichannels;";
  z[lc++]="  rr.attr.sampled_attr.interleave = 1;";
  z[lc++]="";
  z[lc++]="  if (ichannels > 2)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (ichannels == 1)";
  z[lc++]="    {";
  z[lc++]="      g[0].u.i.in_ch = AICTMono;";
  z[lc++]="      g[0].gain = AUnityGain;";
  z[lc++]="      g[0].u.i.in_src = AISTMonoAuxiliary;";
  z[lc++]="      g[0].u.i.in_src = AISTMonoMicrophone;";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      g[0].u.i.in_ch = AICTLeft;";
  z[lc++]="      g[0].gain = AUnityGain;";
  z[lc++]="      g[0].u.i.in_src = AISTLeftAuxiliary;";
  z[lc++]="      g[0].u.i.in_src = AISTLeftMicrophone;";
  z[lc++]="      g[1].u.i.in_ch = AICTRight;";
  z[lc++]="      g[1].gain = AUnityGain;";
  z[lc++]="      g[1].u.i.in_src = AISTRightAuxiliary;";
  z[lc++]="      g[1].u.i.in_src = AISTRightMicrophone;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  asr.gain_matrix.type = AGMTInput;";
  z[lc++]="  asr.gain_matrix.num_entries = ichannels;";
  z[lc++]="  asr.gain_matrix.gain_entries = g;";
  z[lc++]="  asr.record_gain = AUnityGain;  ";
  z[lc++]="  asr.event_mask = 0;";
  z[lc++]="";
  z[lc++]="  if ((asysi_s = socket( AF_INET, SOCK_STREAM, 0 )) < 0)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  asysi_x = ARecordSStream(asysi_a, ~0, &rr, &asr,";
  z[lc++]="			&sr, NULL );";
  z[lc++]="  if (connect(asysi_s,(struct sockaddr *)&sr.tcp_sockaddr,";
  z[lc++]="		   sizeof(struct sockaddr_in)) < 0)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  asysi_maxFD = asysi_stdFD = fileno(stdin);";
  z[lc++]="  if (asysi_s > asysi_maxFD)";
  z[lc++]="    asysi_maxFD = asysi_s;";
  z[lc++]="  FD_ZERO(&asysi_redFD);";
  z[lc++]="  FD_ZERO(&asysi_selFD);";
  z[lc++]="  FD_SET(asysi_stdFD, &asysi_selFD);";
  z[lc++]="  FD_SET(asysi_s, &asysi_selFD);";
  z[lc++]="  ";
  z[lc++]="  fprintf(stderr, \"Hit RETURN to stop recording\\n\" );";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              initializes audio input                         */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_isetup(long srate, long ichannels, long isample, ";
  z[lc++]="                char * iname, long toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  return asysi_setup(srate, ichannels, ASYS_ICHAN*ACYCLE, iname);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && !defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio system for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_osetup(long srate, long ochannels, long osample, ";
  z[lc++]="                char * oname, long toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  return asyso_setup(srate, ochannels, ASYS_OCHAN*ACYCLE, oname, toption);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif ";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        initializes bidirectional audio flows                 */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_iosetup(long srate, long ichannels, long ochannels,";
  z[lc++]="                 long isample, long osample, ";
  z[lc++]="                 char * iname, char * oname, long toption)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (asyso_setup(srate, ochannels, osize, ASYS_OCHAN*ACYCLE, ";
  z[lc++]="		  toption) != ASYS_DONE)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  return asysi_setup(srate, ichannels, ASYS_ICHAN*ACYCLE, iname);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              core routine -- shuts down audio input device   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asysi_shutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  close(asysi_s);";
  z[lc++]="  ACloseAudio(asysi_a, NULL);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*            core routine -- shuts down audio output           */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asyso_shutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (asyso_pflag) ";
  z[lc++]="    AResumeAudio(asyso_a, asyso_x, NULL, NULL);";
  z[lc++]="  close(asyso_s);";
  z[lc++]="  ASetCloseDownMode(asyso_a, AKeepTransactions, NULL);";
  z[lc++]="  ACloseAudio(asyso_a, NULL);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(!defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                    shuts down audio output                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_oshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asyso_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input device                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ishutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysi_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input and output device        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ioshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysi_shutdown();";
  z[lc++]="  asyso_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="  ";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        creates buffer, and generates starting silence        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_preamble(ASYS_OTYPE * asys_obuf[], long * osize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  *asys_obuf = asyso_buf;";
  z[lc++]="  *osize = asyso_size;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               sends one frame of audio to output             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_putbuf(ASYS_OTYPE * asys_obuf[], long * osize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int bsize, bwrite;";
  z[lc++]="  char * buf;";
  z[lc++]="";
  z[lc++]="  bsize = 2*(*osize);";
  z[lc++]="  buf = (char *)(asyso_buf);";
  z[lc++]="  while (bsize) ";
  z[lc++]="    {";
  z[lc++]="      if ((bwrite = write(asyso_s, buf, bsize )) < 0)";
  z[lc++]="	return ASYS_ERROR;";
  z[lc++]="      buf += bwrite;";
  z[lc++]="      bsize -= bwrite;";
  z[lc++]="      if ((asyso_pflag)&&(((asyso_pidx -= bwrite) <= 0)||(bwrite == 0)))";
  z[lc++]="	{";
  z[lc++]="	  AResumeAudio(asyso_a, asyso_x, NULL, NULL);";
  z[lc++]="	  asyso_pflag = 0;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               gets one frame of audio from input             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_getbuf(ASYS_ITYPE * asys_ibuf[], long * isize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  if (*asys_ibuf == NULL)";
  z[lc++]="    {";
  z[lc++]="      *asys_ibuf = asysi_buf;";
  z[lc++]="      *isize = asysi_size;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if ((*isize) == 0)";
  z[lc++]="    return ASYS_DONE;";
  z[lc++]="";
  z[lc++]="  while (1)";
  z[lc++]="    {";
  z[lc++]="      asysi_redFD = asysi_selFD;";
  z[lc++]="";
  z[lc++]="      if (select(asysi_maxFD + 1, (int *)&asysi_redFD, (int *)NULL,";
  z[lc++]="		      (int *)NULL, NULL) < 0)";
  z[lc++]="	return ASYS_ERROR;";
  z[lc++]="    ";
  z[lc++]="      if (FD_ISSET(asysi_s, &asysi_redFD))";
  z[lc++]="	{";
  z[lc++]="	  *isize = read(asysi_s, (char *) asysi_buf, 2*asysi_size);";
  z[lc++]="	  *isize = (*isize)/2;";
  z[lc++]="	  if (*isize < 0)";
  z[lc++]="	    return ASYS_ERROR;";
  z[lc++]="	  else";
  z[lc++]="	    return ASYS_DONE;";
  z[lc++]="	}";
  z[lc++]="    ";
  z[lc++]="      if (FD_ISSET(asysi_stdFD, &asysi_redFD)) ";
  z[lc++]="	{";
  z[lc++]="	  FD_CLR(asysi_stdFD, &asysi_selFD);";
  z[lc++]="	  AStopAudio(asysi_a, asysi_x, ASMThisTrans,";
  z[lc++]="		     (ATransStatus *)NULL, NULL);";
  z[lc++]="	  *isize = 0;";
  z[lc++]="	  return ASYS_DONE;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  printlib(lc);
}


void makeraw(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: raw audio driver for sfront";
  z[lc++]="#    Copyright (C) 1999  Regents of the University of California";
  z[lc++]="#";
  z[lc++]="#    This program is free software; you can redistribute it and/or modify";
  z[lc++]="#    it under the terms of the GNU General Public License (Version 2) as";
  z[lc++]="#    published by the Free Software Foundation.";
  z[lc++]="#";
  z[lc++]="#    This program is distributed in the hope that it will be useful,";
  z[lc++]="#    but WITHOUT ANY WARRANTY; without even the implied warranty of";
  z[lc++]="#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the";
  z[lc++]="#    GNU General Public License for more details.";
  z[lc++]="#";
  z[lc++]="#    You should have received a copy of the GNU General Public License";
  z[lc++]="#    along with this program; if not, write to the Free Software";
  z[lc++]="#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             raw file audio driver for sfront                 */ ";
  z[lc++]="/*       reads/writes 16-bit signed shorts in native format     */";
  z[lc++]="/****************************************************************/";
  z[lc++]="        ";
  z[lc++]="#include <stdio.h>";
  z[lc++]="#include <string.h>";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/* default name for output audio file */";
  z[lc++]="#define ASYSO_DEFAULTNAME \"output\"";
  z[lc++]="";
  z[lc++]="/* global variables, must start with asyso_ */";
  z[lc++]="";
  z[lc++]="FILE * asyso_fd;     /* output file pointer */";
  z[lc++]="char * asyso_name;   /* name of file  */        ";
  z[lc++]="long asyso_srate;    /* sampling rate */";
  z[lc++]="long asyso_channels; /* number of channels */";
  z[lc++]="long asyso_size;    /* number of samples in a buffer */";
  z[lc++]="long asyso_nsamp;    /* total number of samples written */";
  z[lc++]="short * asyso_buf;   /* location for output buffer */ ";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/* default name for output audio file */";
  z[lc++]="#define ASYSI_DEFAULTNAME \"input\"";
  z[lc++]="";
  z[lc++]="/* global variables, must start with asysi_ */";
  z[lc++]="";
  z[lc++]="FILE * asysi_fd;     /* input file pointer */";
  z[lc++]="char * asysi_name;   /* name of file  */        ";
  z[lc++]="long asysi_srate;    /* sampling rate */";
  z[lc++]="long asysi_channels; /* number of channels */";
  z[lc++]="long asysi_size;    /* number of samples in a buffer */";
  z[lc++]="long asysi_nsamp;    /* total number of samples written */";
  z[lc++]="short * asysi_buf;   /* location for input buffer */ ";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        core routine for audio output setup                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asyso_setup(long srate, long ochannels, long osize, char * name)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  char * val;";
  z[lc++]="";
  z[lc++]="  if (name == NULL)";
  z[lc++]="    val = ASYSO_DEFAULTNAME;";
  z[lc++]="  else";
  z[lc++]="    val = name;";
  z[lc++]="  asyso_name = strcpy((char *) calloc((strlen(val)+1),sizeof(char)), val);";
  z[lc++]="  asyso_fd = fopen(asyso_name,\"wb\");";
  z[lc++]="  if (asyso_fd == NULL)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  asyso_srate = srate;";
  z[lc++]="  asyso_channels = ochannels;";
  z[lc++]="  asyso_size = osize;";
  z[lc++]="  asyso_nsamp = 0;";
  z[lc++]="  asyso_buf = (short *)calloc(osize, sizeof(short));";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        core routine for audio input setup                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysi_setup(long srate, long ichannels, long isize, char * name)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  char * val;";
  z[lc++]="";
  z[lc++]="  if (name == NULL)";
  z[lc++]="    val = ASYSI_DEFAULTNAME;";
  z[lc++]="  else";
  z[lc++]="    val = name;";
  z[lc++]="  asysi_name = strcpy((char *) calloc((strlen(val)+1),sizeof(char)), val);";
  z[lc++]="  asysi_fd = fopen(asysi_name,\"rb\");";
  z[lc++]="  if (asysi_fd == NULL)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  asysi_srate = srate;";
  z[lc++]="  asysi_channels = ichannels;";
  z[lc++]="  asysi_size = isize;";
  z[lc++]="  asysi_nsamp = 0;";
  z[lc++]="  asysi_buf = (short *)malloc(sizeof(short)*isize);";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && !defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio output for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_osetup(long srate, long ochannels, long osample, ";
  z[lc++]="                char * oname, long toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  return asyso_setup(srate, ochannels, ASYS_OCHAN*ACYCLE, oname);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio input for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_isetup(long srate, long ichannels, long isample, ";
  z[lc++]="                char * iname, long toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  return asysi_setup(srate, ichannels, ASYS_ICHAN*ACYCLE, iname);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*   sets up audio input and output for a given srate/channels  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_iosetup(long srate, long ichannels, long ochannels,";
  z[lc++]="                 long isample, long osample, ";
  z[lc++]="                 char * iname, char * oname, long toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  if (asysi_setup(srate, ichannels, ASYS_ICHAN*ACYCLE, iname) != ASYS_DONE)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  return asyso_setup(srate, ochannels, ASYS_OCHAN*ACYCLE, oname);";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             shuts down audio output system                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asyso_shutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  char name[1024];";
  z[lc++]="";
  z[lc++]="  fclose(asyso_fd);";
  z[lc++]="  strcpy(name,asyso_name);";
  z[lc++]="  strcat(name,\".info\");";
  z[lc++]="  asyso_fd = fopen(name,\"w\");";
  z[lc++]="  fprintf(asyso_fd,\"%i\\n\",asyso_srate);";
  z[lc++]="  fprintf(asyso_fd,\"%i\\n\",asyso_channels);";
  z[lc++]="  fprintf(asyso_fd,\"%i\\n\",asyso_nsamp);";
  z[lc++]="  fclose(asyso_fd);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               shuts down audio input system                  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asysi_shutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  char name[1024];";
  z[lc++]="";
  z[lc++]="  fclose(asysi_fd);";
  z[lc++]="  strcpy(name, asysi_name);";
  z[lc++]="  strcat(name,\".info\");";
  z[lc++]="  asysi_fd = fopen(name,\"w\");";
  z[lc++]="  fprintf(asysi_fd,\"%i\\n\", asysi_srate);";
  z[lc++]="  fprintf(asysi_fd,\"%i\\n\", asysi_channels);";
  z[lc++]="  fprintf(asysi_fd,\"%i\\n\", asysi_nsamp);";
  z[lc++]="  fclose(asysi_fd);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(!defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                    shuts down audio output                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_oshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asyso_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input device                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ishutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysi_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input and output device        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ioshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysi_shutdown();";
  z[lc++]="  asyso_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="  ";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        creates buffer, and generates starting silence        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_preamble(ASYS_OTYPE * asys_obuf[], long * osize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  *asys_obuf = asyso_buf;";
  z[lc++]="  *osize = asyso_size;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               sends one frame of audio to output             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_putbuf(ASYS_OTYPE * asys_obuf[], long * osize)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (rwrite(*asys_obuf, sizeof(short), *osize, asyso_fd) != *osize)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  asyso_nsamp += *osize;";
  z[lc++]="  *osize = asyso_size;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               sends one frame of audio to output             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_getbuf(ASYS_ITYPE * asys_ibuf[], long * isize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (*asys_ibuf == NULL)";
  z[lc++]="    *asys_ibuf = asysi_buf;";
  z[lc++]="  *isize = (long)rread(*asys_ibuf, sizeof(short), asysi_size, asysi_fd);";
  z[lc++]="  asysi_nsamp += *isize;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  printlib(lc);
}


void makewav(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: WAV audio driver for sfront";
  z[lc++]="#    Copyright (C) 1999  Regents of the University of California";
  z[lc++]="#";
  z[lc++]="#    This program is free software; you can redistribute it and/or modify";
  z[lc++]="#    it under the terms of the GNU General Public License (Version 2) as";
  z[lc++]="#    published by the Free Software Foundation.";
  z[lc++]="#";
  z[lc++]="#    This program is distributed in the hope that it will be useful,";
  z[lc++]="#    but WITHOUT ANY WARRANTY; without even the implied warranty of";
  z[lc++]="#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the";
  z[lc++]="#    GNU General Public License for more details.";
  z[lc++]="#";
  z[lc++]="#    You should have received a copy of the GNU General Public License";
  z[lc++]="#    along with this program; if not, write to the Free Software";
  z[lc++]="#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             wav file audio driver for sfront                 */ ";
  z[lc++]="/****************************************************************/";
  z[lc++]="        ";
  z[lc++]="#include <stdio.h>";
  z[lc++]="#include <string.h>";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/* default name for output audio file */";
  z[lc++]="#define ASYSO_DEFAULTNAME \"output.wav\"";
  z[lc++]="";
  z[lc++]="/* global variables, must start with asyso_ */";
  z[lc++]="";
  z[lc++]="FILE * asyso_fd;     /* output file pointer */";
  z[lc++]="char * asyso_name;   /* name of file  */        ";
  z[lc++]="long asyso_srate;    /* sampling rate */";
  z[lc++]="long asyso_channels; /* number of channels */";
  z[lc++]="long asyso_size;    /* number of samples in a buffer */";
  z[lc++]="long asyso_nsamp;    /* total number of shorts written */";
  z[lc++]="long asyso_doswap;   /* needs byteswap on write */";
  z[lc++]="short * asyso_buf;   /* location for output buffer */ ";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/* default name for input audio file */";
  z[lc++]="";
  z[lc++]="#define ASYSI_DEFAULTNAME \"input.wav\"";
  z[lc++]="";
  z[lc++]="/* only used for asysi_soundtypecheck */";
  z[lc++]="";
  z[lc++]="#define ASYSI_MATCH  0";
  z[lc++]="#define ASYSI_EOF 1";
  z[lc++]="#define ASYSI_NOMATCH 2";
  z[lc++]="";
  z[lc++]="/* global variables, must start with asysi_ */";
  z[lc++]="";
  z[lc++]="FILE * asysi_fd;     /* input file pointer */";
  z[lc++]="char * asysi_name;   /* name of file  */        ";
  z[lc++]="long asysi_srate;    /* sampling rate */";
  z[lc++]="long asysi_channels; /* number of channels */";
  z[lc++]="long asysi_size;    /* number of samples in a buffer */";
  z[lc++]="long asysi_nsamp;    /* total number of shorts read */";
  z[lc++]="long asysi_doswap;   /* needs byteswap on read */";
  z[lc++]="short * asysi_buf;   /* location for input buffer */ ";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/*********************************************************/";
  z[lc++]="/*        writes next block of WAV/AIFF bytes            */";
  z[lc++]="/*********************************************************/";
  z[lc++]="";
  z[lc++]="int asyso_putbytes(unsigned char * c, int numbytes)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (rwrite(c, sizeof(char), numbytes, asyso_fd) != numbytes)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*********************************************************/";
  z[lc++]="/*        writes unsigned long to a WAV files            */";
  z[lc++]="/*********************************************************/";
  z[lc++]="";
  z[lc++]="int asyso_putlong(unsigned long val, int numbytes)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char c[4];";
  z[lc++]="";
  z[lc++]="  if (numbytes > 4)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  switch (numbytes) {";
  z[lc++]="  case 4:";
  z[lc++]="    c[0] = (unsigned char) (val&0x000000FF);";
  z[lc++]="    c[1] = (unsigned char)((val >> 8)&0x000000FF);";
  z[lc++]="    c[2] = (unsigned char)((val >> 16)&0x000000FF);";
  z[lc++]="    c[3] = (unsigned char)((val >> 24)&0x000000FF);";
  z[lc++]="    return asyso_putbytes(c, 4);";
  z[lc++]="  case 3:";
  z[lc++]="    c[0] = (unsigned char) (val&0x000000FF);";
  z[lc++]="    c[1] = (unsigned char)((val >> 8)&0x000000FF);";
  z[lc++]="    c[2] = (unsigned char)((val >> 16)&0x000000FF);";
  z[lc++]="    return asyso_putbytes(c, 3);";
  z[lc++]="  case 2:";
  z[lc++]="    c[0] = (unsigned char) (val&0x000000FF);";
  z[lc++]="    c[1] = (unsigned char)((val >> 8)&0x000000FF);";
  z[lc++]="    return asyso_putbytes(c, 2);";
  z[lc++]="  case 1:";
  z[lc++]="    c[0] = (unsigned char) (val&0x000000FF);";
  z[lc++]="    return asyso_putbytes(c,1);";
  z[lc++]="  default:";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        core routine for audio output setup                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asyso_setup(long srate, long ochannels, long osize, char * name)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  short swaptest = 0x0100;";
  z[lc++]="  char * val;";
  z[lc++]="";
  z[lc++]="  asyso_doswap = *((char *)&swaptest);";
  z[lc++]="  if (name == NULL)";
  z[lc++]="    val = ASYSO_DEFAULTNAME;";
  z[lc++]="  else";
  z[lc++]="    val = name;";
  z[lc++]="  asyso_name = strcpy((char *) calloc((strlen(val)+1),sizeof(char)), val);";
  z[lc++]="  asyso_fd = fopen(asyso_name,\"wb\");";
  z[lc++]="  if (asyso_fd == NULL)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  /* preamble for wav file */";
  z[lc++]="";
  z[lc++]="  asyso_putbytes((unsigned char *) \"RIFF\",4);";
  z[lc++]="  asyso_putlong(0,4);       /* patched later */";
  z[lc++]="  asyso_putbytes((unsigned char *) \"WAVEfmt \",8);";
  z[lc++]="  asyso_putlong(16,4);";
  z[lc++]="  asyso_putlong(1,2);                  /* PCM  */";
  z[lc++]="  asyso_putlong(ochannels,2);          /* number of channels */";
  z[lc++]="  asyso_putlong(srate,4);              /* srate */";
  z[lc++]="  asyso_putlong(srate*ochannels*2,4);  /* bytes/sec */";
  z[lc++]="  asyso_putlong(ochannels*2,2);        /* block align */";
  z[lc++]="  asyso_putlong(16,2);                 /* 2 bytes per sample */";
  z[lc++]="  asyso_putbytes((unsigned char *) \"data\",4);";
  z[lc++]="  asyso_putlong(0,4);                  /* patched later */";
  z[lc++]="";
  z[lc++]="  asyso_srate = srate;";
  z[lc++]="  asyso_channels = ochannels;";
  z[lc++]="  asyso_size = osize;";
  z[lc++]="  asyso_nsamp = 0;";
  z[lc++]="  asyso_buf = (short *)calloc(osize, sizeof(short));";
  z[lc++]="";
  z[lc++]="  if (asyso_buf == NULL)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"Can't allocate WAV output buffer (%s).\\n\",";
  z[lc++]="	      strerror(errno));";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/*********************************************************/";
  z[lc++]="/*            gets next block of WAV bytes               */";
  z[lc++]="/*********************************************************/";
  z[lc++]="";
  z[lc++]="int asysi_getbytes(unsigned char * c, int numbytes)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if ((int)rread(c, sizeof(char), numbytes, asysi_fd) != numbytes)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*********************************************************/";
  z[lc++]="/*        flushes next block of WAV bytes                */";
  z[lc++]="/*********************************************************/";
  z[lc++]="";
  z[lc++]="int asysi_flushbytes(int numbytes)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char c;";
  z[lc++]="";
  z[lc++]="  while (numbytes > 0)";
  z[lc++]="    {";
  z[lc++]="      if (rread(&c, sizeof(char), 1, asysi_fd) != 1)";
  z[lc++]="	return ASYS_ERROR;";
  z[lc++]="      numbytes--;";
  z[lc++]="    }";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/*********************************************************/";
  z[lc++]="/*     converts byte stream to an unsigned long          */";
  z[lc++]="/*********************************************************/";
  z[lc++]="";
  z[lc++]="long asysi_getlong(int numbytes, unsigned long * ret)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char c[4];";
  z[lc++]="";
  z[lc++]="  if (numbytes > 4)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if (ASYS_DONE != asysi_getbytes(&c[0],numbytes))";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  switch (numbytes) {";
  z[lc++]="  case 4:";
  z[lc++]="    *ret  =  (unsigned long)c[0];";
  z[lc++]="    *ret |=  (unsigned long)c[1] << 8;";
  z[lc++]="    *ret |=  (unsigned long)c[2] << 16;";
  z[lc++]="    *ret |=  (unsigned long)c[3] << 24;";
  z[lc++]="    return ASYS_DONE;";
  z[lc++]="  case 3:";
  z[lc++]="    *ret  =  (unsigned long)c[0];";
  z[lc++]="    *ret |=  (unsigned long)c[1] << 8;";
  z[lc++]="    *ret |=  (unsigned long)c[2] << 16;";
  z[lc++]="    return ASYS_DONE;";
  z[lc++]="  case 2:";
  z[lc++]="    *ret  =  (unsigned long)c[0];";
  z[lc++]="    *ret |=  (unsigned long)c[1] << 8;";
  z[lc++]="    return ASYS_DONE;";
  z[lc++]="  case 1:";
  z[lc++]="    *ret = (unsigned long)c[0];";
  z[lc++]="    return ASYS_DONE;";
  z[lc++]="  default:";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="  ";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*  checks byte stream for AIFF/WAV cookie --              */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="int asysi_soundtypecheck(char * d)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  char c[4];";
  z[lc++]="";
  z[lc++]="  if (rread(c, sizeof(char), 4, asysi_fd) != 4)";
  z[lc++]="    return ASYSI_EOF;";
  z[lc++]="  if (strncmp(c,d,4))";
  z[lc++]="    return ASYSI_NOMATCH;";
  z[lc++]="  return ASYSI_MATCH;";
  z[lc++]="}";
  z[lc++]="  ";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        core routine for audio input setup                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysi_setup(long srate, long ichannels, long isize, char * name)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  short swaptest = 0x0100;";
  z[lc++]="  unsigned long i, cookie;";
  z[lc++]="  long len;";
  z[lc++]="  char * val;";
  z[lc++]="";
  z[lc++]="  asysi_doswap = *((char *)&swaptest);";
  z[lc++]="";
  z[lc++]="  if (name == NULL)";
  z[lc++]="    val = ASYSI_DEFAULTNAME;";
  z[lc++]="  else";
  z[lc++]="    val = name;";
  z[lc++]="  asysi_name = strcpy((char *) calloc((strlen(val)+1),sizeof(char)), val);";
  z[lc++]="  asysi_fd = fopen(asysi_name,\"rb\");";
  z[lc++]="  if (asysi_fd == NULL)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (asysi_soundtypecheck(\"RIFF\")!= ASYSI_MATCH)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if (asysi_flushbytes(4)!= ASYS_DONE)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if (asysi_soundtypecheck(\"WAVE\")!= ASYSI_MATCH)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  while ((cookie = asysi_soundtypecheck(\"fmt \"))!=ASYSI_MATCH)";
  z[lc++]="    {";
  z[lc++]="      if (cookie == ASYSI_EOF)";
  z[lc++]="	return ASYS_ERROR;";
  z[lc++]="      if (asysi_getlong(4, &i) != ASYS_DONE)";
  z[lc++]="	return ASYS_ERROR;";
  z[lc++]="      if (asysi_flushbytes(i)!= ASYS_DONE)";
  z[lc++]="	return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="  if (asysi_getlong(4, &i) != ASYS_DONE)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  len = i;";
  z[lc++]="  if ((len -= 16) < 0)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if (asysi_getlong(2, &i) != ASYS_DONE)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if (i != 1)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr,\"Error: Can only handle PCM WAV files\\n\");";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="  if (asysi_getlong(2, &i) != ASYS_DONE)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if (i != ichannels)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr,\"Error: Inchannels doesn't match WAV file\\n\");";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="  if (asysi_getlong(4, &i) != ASYS_DONE)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if (srate != i)";
  z[lc++]="    fprintf(stderr,\"Warning: SAOL srate %i mismatches WAV file srate %i\\n\",";
  z[lc++]="	    srate,i);";
  z[lc++]="  asysi_flushbytes(6);";
  z[lc++]="  if (asysi_getlong(2, &i) != ASYS_DONE)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if ((i < 9) || (i > 16))";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr,\"Error: Can't handle %i bit data\\n\",i);";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="  asysi_flushbytes(len);";
  z[lc++]="  while ((cookie = asysi_soundtypecheck(\"data\"))!=ASYSI_MATCH)";
  z[lc++]="    {";
  z[lc++]="      if (cookie == ASYSI_EOF)";
  z[lc++]="	return ASYS_ERROR;";
  z[lc++]="      if (asysi_getlong(4, &i) != ASYS_DONE)";
  z[lc++]="	return ASYS_ERROR;";
  z[lc++]="      if (asysi_flushbytes(i)!= ASYS_DONE)";
  z[lc++]="	return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="  if (asysi_getlong(4, &i) != ASYS_DONE)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  asysi_nsamp = i/2;";
  z[lc++]="";
  z[lc++]="  asysi_srate = srate;";
  z[lc++]="  asysi_channels = ichannels;";
  z[lc++]="  asysi_size = isize;";
  z[lc++]="  asysi_buf = (short *)malloc(sizeof(short)*isize);";
  z[lc++]="  if (asysi_buf == NULL)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"Can't allocate WAV input buffer (%s).\\n\",";
  z[lc++]="	      strerror(errno));";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && !defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio output for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_osetup(long srate, long ochannels, long osample, ";
  z[lc++]="		char * oname, long toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  return asyso_setup(srate, ochannels, ASYS_OCHAN*ACYCLE, oname);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio input for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_isetup(long srate, long ichannels, long isample, ";
  z[lc++]="		char * iname, long toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  return asysi_setup(srate, ichannels, ASYS_ICHAN*ACYCLE, iname);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*   sets up audio input and output for a given srate/channels  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_iosetup(long srate, long ichannels, long ochannels,";
  z[lc++]="		 long isample, long osample, ";
  z[lc++]="		 char * iname, char * oname, long toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  if (asysi_setup(srate, ichannels, ASYS_ICHAN*ACYCLE, iname) != ASYS_DONE)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  return asyso_setup(srate, ochannels, ASYS_OCHAN*ACYCLE, oname);";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             shuts down audio output system                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asyso_shutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  fseek(asyso_fd, 4, SEEK_SET);";
  z[lc++]="  asyso_putlong(2*(unsigned long)asyso_nsamp+36,4);";
  z[lc++]="  fseek(asyso_fd, 32, SEEK_CUR);";
  z[lc++]="  asyso_putlong(2*(unsigned long)asyso_nsamp,4);";
  z[lc++]="  fclose(asyso_fd);";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               shuts down audio input system                  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asysi_shutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  fclose(asysi_fd);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(!defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                    shuts down audio output                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_oshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asyso_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input device                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ishutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysi_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input and output device        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ioshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysi_shutdown();";
  z[lc++]="  asyso_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        creates buffer, and generates starting silence        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_preamble(ASYS_OTYPE * asys_obuf[], long * osize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  *asys_obuf = asyso_buf;";
  z[lc++]="  *osize = asyso_size;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               sends one frame of audio to output             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_putbuf(ASYS_OTYPE * asys_obuf[], long * osize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char * buf;";
  z[lc++]="  unsigned char tmp;";
  z[lc++]="  long i = 0;";
  z[lc++]="";
  z[lc++]="  if (asyso_doswap)";
  z[lc++]="    {";
  z[lc++]="      buf = (unsigned char *)(*asys_obuf);";
  z[lc++]="      while (i < 2*(*osize))";
  z[lc++]="	{";
  z[lc++]="	  tmp = buf[i+1];";
  z[lc++]="	  buf[i+1] = buf[i];";
  z[lc++]="	  buf[i] = tmp;";
  z[lc++]="	  i += 2;";
  z[lc++]="	}";
  z[lc++]="      if (rwrite(buf, sizeof(char), 2*(*osize), asyso_fd) != 2*(*osize))";
  z[lc++]="	return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    if (rwrite(*asys_obuf, sizeof(short), *osize, asyso_fd) != *osize)";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="  asyso_nsamp += *osize;";
  z[lc++]="  *osize = asyso_size;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               sends one frame of audio to output             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_getbuf(ASYS_ITYPE * asys_ibuf[], long * isize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  unsigned char * buf;";
  z[lc++]="  unsigned char tmp;";
  z[lc++]="  long i = 0;";
  z[lc++]="";
  z[lc++]="  if (*asys_ibuf == NULL)";
  z[lc++]="    *asys_ibuf = asysi_buf;";
  z[lc++]="  ";
  z[lc++]="  if (asysi_nsamp <= 0)";
  z[lc++]="    {";
  z[lc++]="      *isize = 0;";
  z[lc++]="      return ASYS_DONE;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  *isize = (long)rread(*asys_ibuf, sizeof(short), asysi_size, asysi_fd);";
  z[lc++]="  if (asysi_doswap)";
  z[lc++]="    {";
  z[lc++]="      buf = (unsigned char *)(*asys_ibuf);";
  z[lc++]="      while (i < 2*(*isize))";
  z[lc++]="	{";
  z[lc++]="	  tmp = buf[i+1];";
  z[lc++]="	  buf[i+1] = buf[i];";
  z[lc++]="	  buf[i] = tmp;";
  z[lc++]="	  i += 2;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  asysi_nsamp -= *isize;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  printlib(lc);
}


void makedsound(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: Win32 DirectSound audio driver for sfront";
  z[lc++]="#    Copyright (C) 1999  Regents of the University of California";
  z[lc++]="#";
  z[lc++]="#    This program is free software; you can redistribute it and/or modify";
  z[lc++]="#    it under the terms of the GNU General Public License (Version 2) as";
  z[lc++]="#    published by the Free Software Foundation.";
  z[lc++]="#";
  z[lc++]="#    This program is distributed in the hope that it will be useful,";
  z[lc++]="#    but WITHOUT ANY WARRANTY; without even the implied warranty of";
  z[lc++]="#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the";
  z[lc++]="#    GNU General Public License for more details.";
  z[lc++]="#";
  z[lc++]="#    You should have received a copy of the GNU General Public License";
  z[lc++]="#    along with this program; if not, write to the Free Software";
  z[lc++]="#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA";
  z[lc++]="#";
  z[lc++]="#    Author: Professor John Wawrzynek, UCB CS Division";
  z[lc++]="#    Maintainance Email To: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]=" ";
  z[lc++]="//////////////////////////";
  z[lc++]="// dsound output";
  z[lc++]="// by Vincent Siliakus & Thomas Jongepier";
  z[lc++]="// november 1999";
  z[lc++]="//////////////////////////";
  z[lc++]="#include <windows.h>";
  z[lc++]="#include <windowsx.h>";
  z[lc++]="#include <mmsystem.h>";
  z[lc++]="#include <dsound.h>";
  z[lc++]="#include <objbase.h>";
  z[lc++]="#include <initguid.h> ";
  z[lc++]="";
  z[lc++]="#include <stdio.h>";
  z[lc++]="";
  z[lc++]="#define ASYS_SUCCESS ASYS_DONE";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/* Global variables for audio output.";
  z[lc++]=" */";
  z[lc++]=" ";
  z[lc++]="";
  z[lc++]="char asyso_playing = 0;";
  z[lc++]="int asyso_wrtCursor = 0;";
  z[lc++]="int asyso_bufsize;                                /* buffer size in";
  z[lc++]="bytes        */";
  z[lc++]="int asyso_blksize;                                /* size preferred by";
  z[lc++]="sfront    */";
  z[lc++]="";
  z[lc++]="double asyso_speriod;";
  z[lc++]="LPDIRECTSOUND 		lpDirectSound;";
  z[lc++]="LPDIRECTSOUNDBUFFER lpDsb;	";
  z[lc++]="LPDIRECTSOUNDBUFFER lpPrDsb;";
  z[lc++]="LPDIRECTSOUNDNOTIFY lpDsNotify;";
  z[lc++]="HANDLE				*hBuffPos;";
  z[lc++]="DSBPOSITIONNOTIFY   *PositionNotify;";
  z[lc++]="PCMWAVEFORMAT		pcmwfp;";
  z[lc++]="PCMWAVEFORMAT		pcmwf;";
  z[lc++]="DSBUFFERDESC		dsprbdescp;";
  z[lc++]="DSBUFFERDESC		dsbdesc;";
  z[lc++]="DSCAPS				dscaps;";
  z[lc++]="DSBCAPS				pr,sec;";
  z[lc++]="HRESULT       		hr;	";
  z[lc++]="unsigned long		ds_numofsubbuff;";
  z[lc++]="unsigned long		ds_subbuffercounter=0;";
  z[lc++]="unsigned long		ds_writeposition=0;";
  z[lc++]="unsigned long		ds_counter=0;";
  z[lc++]="unsigned long		ds_resetwritecrspoint=0;";
  z[lc++]="unsigned long		SECBUFFBYTESIZE;";
  z[lc++]="unsigned long		SUBBUFFBYTESIZE;";
  z[lc++]="unsigned long		SUBBUFFSAMPLESIZE;";
  z[lc++]="unsigned long		WRITEPOSITIONOFFSET;";
  z[lc++]="unsigned long		TIMES;";
  z[lc++]="unsigned long		EXCEPTIONTIMES;";
  z[lc++]=" ";
  z[lc++]="  ";
  z[lc++]="void DevCaps(DSCAPS *);";
  z[lc++]="void PrBuffCaps(DSBCAPS *);";
  z[lc++]="void SecBuffCaps(DSBCAPS *);";
  z[lc++]="void WaitForNotification();";
  z[lc++]="void Close();";
  z[lc++]="void Play();";
  z[lc++]="void Stop();";
  z[lc++]="int InitOutput(unsigned long);";
  z[lc++]=" ";
  z[lc++]="void DevCaps(DSCAPS *DSCaps)";
  z[lc++]="{	";
  z[lc++]="	DSCaps->dwSize = sizeof(DSCAPS);";
  z[lc++]="	IDirectSound_GetCaps(lpDirectSound,DSCaps);";
  z[lc++]="}";
  z[lc++]=" ";
  z[lc++]="void PrBuffCaps(DSBCAPS *PrBCaps)";
  z[lc++]="{	";
  z[lc++]="	PrBCaps->dwSize = sizeof(DSBCAPS); ";
  z[lc++]="	IDirectSoundBuffer_GetCaps(lpPrDsb,PrBCaps); ";
  z[lc++]="}";
  z[lc++]=" ";
  z[lc++]="void SecBuffCaps(DSBCAPS *SecBCaps)";
  z[lc++]="{	";
  z[lc++]="	SecBCaps->dwSize = sizeof(DSBCAPS);";
  z[lc++]="	IDirectSoundBuffer_GetCaps(lpDsb,SecBCaps);";
  z[lc++]="}";
  z[lc++]=" ";
  z[lc++]="void WaitForNotification()";
  z[lc++]="{";
  z[lc++]="	DWORD EventNumber = (WaitForMultipleObjects";
  z[lc++]="		(ds_numofsubbuff, hBuffPos, FALSE, INFINITE));";
  z[lc++]="	//ResetEvent(hBuffPos[EventNumber]); //for manual ResetEvent. ";
  z[lc++]="}";
  z[lc++]=" ";
  z[lc++]="void Close()";
  z[lc++]="{ ";
  z[lc++]="	for(ds_counter=0;ds_counter<ds_numofsubbuff;ds_counter++)";
  z[lc++]="		CloseHandle(hBuffPos[ds_counter]);";
  z[lc++]="	IDirectSoundBuffer_Release(lpDsb);";
  z[lc++]="	IDirectSound_Release(lpDirectSound);";
  z[lc++]="}";
  z[lc++]=" ";
  z[lc++]="void Play() ";
  z[lc++]="{ ";
  z[lc++]="	IDirectSoundBuffer_Play(lpDsb,0,0,DSBPLAY_LOOPING ); ";
  z[lc++]="} ";
  z[lc++]="  ";
  z[lc++]="void Stop()";
  z[lc++]="{";
  z[lc++]="	IDirectSoundBuffer_Stop(lpDsb);";
  z[lc++]="}";
  z[lc++]=" ";
  z[lc++]=" ";
  z[lc++]="int InitOutput(unsigned long sys_osize, ";
  z[lc++]="			   unsigned long samplerate, ";
  z[lc++]="			   unsigned long numchannels)";
  z[lc++]="{ ";
  z[lc++]="	HWND hwnd = GetForegroundWindow();";
  z[lc++]="	if(hwnd==NULL)hwnd = GetDesktopWindow();";
  z[lc++]="	SECBUFFBYTESIZE	 =	sys_osize*16;//use 16 or 32	";
  z[lc++]="	SUBBUFFBYTESIZE	 =	sys_osize;";
  z[lc++]="	SUBBUFFSAMPLESIZE=	sys_osize/2;";
  z[lc++]="  	WRITEPOSITIONOFFSET = SUBBUFFBYTESIZE;";
  z[lc++]="	TIMES=SECBUFFBYTESIZE/SUBBUFFBYTESIZE;";
  z[lc++]="	EXCEPTIONTIMES = (WRITEPOSITIONOFFSET/SUBBUFFBYTESIZE);";
  z[lc++]="	ds_resetwritecrspoint =  ";
  z[lc++]="		SECBUFFBYTESIZE-(EXCEPTIONTIMES*SUBBUFFBYTESIZE);";
  z[lc++]="	ds_numofsubbuff=SECBUFFBYTESIZE/SUBBUFFBYTESIZE;";
  z[lc++]="	////////////////////////////////";
  z[lc++]="	//dsound init";
  z[lc++]="	////////////////////////////////";
  z[lc++]="	//Create DirectSound Object";
  z[lc++]="	if FAILED(DirectSoundCreate(NULL, &lpDirectSound, NULL))";
  z[lc++]="		return ASYS_ERROR;";
  z[lc++]="	//";
  z[lc++]="	//Set Cooperative level of DirectSound Object";
  z[lc++]="	if FAILED(IDirectSound_SetCooperativeLevel(lpDirectSound,hwnd, ";
  z[lc++]="			DSSCL_PRIORITY))return ASYS_ERROR;";
  z[lc++]="	//    ";
  z[lc++]="	////////////////////////////////  ";
  z[lc++]="   // Set up wave format structure.";
  z[lc++]="   memset(&pcmwfp, 0, sizeof(PCMWAVEFORMAT));";
  z[lc++]="    pcmwfp.wf.wFormatTag = WAVE_FORMAT_PCM;";
  z[lc++]="    pcmwfp.wf.nChannels = numchannels;";
  z[lc++]="    pcmwfp.wf.nSamplesPerSec = samplerate;";
  z[lc++]="    pcmwfp.wf.nBlockAlign = 2*numchannels;";
  z[lc++]="    pcmwfp.wf.nAvgBytesPerSec =";
  z[lc++]="		pcmwfp.wf.nSamplesPerSec * pcmwfp.wf.nBlockAlign;";
  z[lc++]="    pcmwfp.wBitsPerSample = 16;";
  z[lc++]="	//";
  z[lc++]="	////////////////////////////////";
  z[lc++]="    // Set up DSBUFFERDESC structure.";
  z[lc++]="    memset(&dsprbdescp, 0, sizeof(DSBUFFERDESC)); // Zero it out.";
  z[lc++]="    dsprbdescp.dwSize = sizeof(DSBUFFERDESC);";
  z[lc++]="    dsprbdescp.dwFlags = DSBCAPS_PRIMARYBUFFER;";
  z[lc++]="    dsprbdescp.dwBufferBytes = 0;";
  z[lc++]="    dsprbdescp.lpwfxFormat = NULL;";
  z[lc++]="	//";
  z[lc++]="	////////////////////////////////";
  z[lc++]="	// Create Primary buffer.  ";
  z[lc++]="    if FAILED(IDirectSound_CreateSoundBuffer(lpDirectSound,&dsprbdescp, ";
  z[lc++]="	&lpPrDsb, NULL))return ASYS_ERROR;";
  z[lc++]="	// Set primary buffer to desired format.";
  z[lc++]="    if FAILED(IDirectSoundBuffer_SetFormat(lpPrDsb,";
  z[lc++]="		(LPWAVEFORMATEX)&pcmwfp))return ASYS_ERROR;";
  z[lc++]="	//start playing (no sound yet)";
  z[lc++]="    IDirectSoundBuffer_Play(lpPrDsb,0,0,DSBPLAY_LOOPING);";
  z[lc++]="	//";
  z[lc++]="    // Set up wave format structure.";
  z[lc++]="    memset(&pcmwf, 0, sizeof(PCMWAVEFORMAT));";
  z[lc++]="    pcmwf.wf.wFormatTag = WAVE_FORMAT_PCM;";
  z[lc++]="    pcmwf.wf.nChannels = numchannels;";
  z[lc++]="    pcmwf.wf.nSamplesPerSec = samplerate;";
  z[lc++]="    pcmwf.wf.nBlockAlign = 2*numchannels;";
  z[lc++]="    pcmwf.wf.nAvgBytesPerSec =";
  z[lc++]="		pcmwf.wf.nSamplesPerSec * pcmwf.wf.nBlockAlign;";
  z[lc++]="    pcmwf.wBitsPerSample = 16;	";
  z[lc++]="	//";
  z[lc++]="    // Set up DSBUFFERDESC structure.";
  z[lc++]="    memset(&dsbdesc, 0, sizeof(DSBUFFERDESC)); // Zero it out.";
  z[lc++]="    dsbdesc.dwSize = sizeof(DSBUFFERDESC);";
  z[lc++]="    // Need default controls (pan, volume, frequency).";
  z[lc++]="    dsbdesc.dwFlags = ";
  z[lc++]="					 DSBCAPS_GLOBALFOCUS ";
  z[lc++]="					|DSBCAPS_GETCURRENTPOSITION2";
  z[lc++]="					|DSBCAPS_CTRLPOSITIONNOTIFY ;";
  z[lc++]="    dsbdesc.dwBufferBytes = SECBUFFBYTESIZE;";
  z[lc++]="    dsbdesc.lpwfxFormat = (LPWAVEFORMATEX)&pcmwf;";
  z[lc++]="	//";
  z[lc++]="	////////////////////////////////";
  z[lc++]="	if FAILED(IDirectSound_CreateSoundBuffer(lpDirectSound,&dsbdesc, ";
  z[lc++]="		&lpDsb, NULL))return ASYS_ERROR;";
  z[lc++]="    //";
  z[lc++]="	PositionNotify=(DSBPOSITIONNOTIFY*)malloc(ds_numofsubbuff*";
  z[lc++]="		(sizeof(DSBPOSITIONNOTIFY)));";
  z[lc++]="	hBuffPos=(HANDLE*)malloc(ds_numofsubbuff*sizeof(HANDLE));";
  z[lc++]="	//";
  z[lc++]="	for(ds_counter=0;ds_counter<ds_numofsubbuff;ds_counter++){";
  z[lc++]="		hBuffPos[ds_counter]=CreateEvent(NULL,FALSE,FALSE,NULL);";
  z[lc++]="		PositionNotify[ds_counter].dwOffset = SUBBUFFBYTESIZE*ds_counter;";
  z[lc++]="		PositionNotify[ds_counter].hEventNotify=hBuffPos[ds_counter]; ";
  z[lc++]="	}";
  z[lc++]="	//";
  z[lc++]="	if FAILED(IDirectSoundBuffer_QueryInterface(lpDsb,";
  z[lc++]="		&IID_IDirectSoundNotify,(LPVOID *)&lpDsNotify))return ASYS_ERROR;  ";
  z[lc++]="	//";
  z[lc++]="	IDirectSoundNotify_SetNotificationPositions(lpDsNotify,ds_numofsubbuff,";
  z[lc++]="		PositionNotify); ";
  z[lc++]="	//\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\";
  z[lc++]="	//";
  z[lc++]="	Play();";
  z[lc++]="	return ASYS_SUCCESS;";
  z[lc++]="}";
  z[lc++]=" ";
  z[lc++]=" ";
  z[lc++]="#endif";
  z[lc++]=" ";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && !defined(ASYS_HASINPUT))";
  z[lc++]=" ";
  z[lc++]="/* Opens waveform output for a given srate/channels.";
  z[lc++]=" */";
  z[lc++]=" ";
  z[lc++]="int asys_osetup(long srate, long ochannels, long osample, ";
  z[lc++]="                char * oname, long toption)";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  long osize = ASYS_OCHAN*ACYCLE;";
  z[lc++]="";
  z[lc++]="  InitOutput(osize,srate,ochannels);";
  z[lc++]="  return ASYS_SUCCESS;";
  z[lc++]="}";
  z[lc++]=" ";
  z[lc++]="#endif";
  z[lc++]=" ";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="  ";
  z[lc++]="/*";
  z[lc++]=" * Shuts down audio system.";
  z[lc++]=" */";
  z[lc++]=" ";
  z[lc++]="void asys_oshutdown(void)";
  z[lc++]=" ";
  z[lc++]="{";
  z[lc++]="  Stop();";
  z[lc++]="  Close();";
  z[lc++]="}";
  z[lc++]=" ";
  z[lc++]="#endif";
  z[lc++]=" ";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]=" ";
  z[lc++]="int asys_putbuf(short **buffer, long * osize)";
  z[lc++]=" ";
  z[lc++]="{ 	";
  z[lc++]="	DWORD dwBytes;";
  z[lc++]="	*osize=SUBBUFFSAMPLESIZE; ";
  z[lc++]="	ds_writeposition=ds_subbuffercounter*SUBBUFFBYTESIZE;	";
  z[lc++]="	WaitForNotification();	";
  z[lc++]="	if(ds_writeposition>ds_resetwritecrspoint)";
  z[lc++]="	{";
  z[lc++]="		ds_subbuffercounter=0;";
  z[lc++]="		ds_writeposition=0;";
  z[lc++]="	}";
  z[lc++]="	hr = IDirectSoundBuffer_Unlock(lpDsb,*buffer, ";
  z[lc++]="		SUBBUFFBYTESIZE, NULL,NULL);  ";
  z[lc++]="    hr = IDirectSoundBuffer_Lock(lpDsb,ds_writeposition, ";
  z[lc++]="		SUBBUFFBYTESIZE, (LPVOID*)buffer,&dwBytes, NULL, 0, NULL);    ";
  z[lc++]="	ds_subbuffercounter++;";
  z[lc++]="	return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="   ";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        creates buffer, and generates starting silence        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_preamble(ASYS_OTYPE * asys_obuf[], long * osize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  /* emulates old interface, since I don't understand asys_putbuf */";
  z[lc++]="  /* well enough to make direct modifications  */";
  z[lc++]="";
  z[lc++]="  /* set up first call, which allocates buffer */";
  z[lc++]="";
  z[lc++]="  *asys_obuf = NULL;";
  z[lc++]="  *osize = 0;";
  z[lc++]="";
  z[lc++]="  if (asys_putbuf(asys_obuf, osize) == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  /* clear allocated buffer */";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < (*osize); i++)";
  z[lc++]="    (*asys_obuf)[i] = 0;";
  z[lc++]="";
  z[lc++]="  /* send the 4 silence putbuf's of old API */";
  z[lc++]="";
  z[lc++]="  for(i = 0; i < 4; i++)";
  z[lc++]="    if (asys_putbuf(asys_obuf, osize) == ASYS_ERROR)";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]=" ";
  z[lc++]="";
  z[lc++]="/* Currently not supported audio input.  All routines are dummies.";
  z[lc++]=" */";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/* Initializes audio input.";
  z[lc++]=" */";
  z[lc++]="int asys_isetup(long srate, long ichannels, long isample, ";
  z[lc++]="                char * iname, long toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  return ASYS_ERROR;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/* Initialized bidirectional audio flows. */";
  z[lc++]="int asys_iosetup(long srate, long ichannels, long ochannels,";
  z[lc++]="                 long isample, long osample, ";
  z[lc++]="                 char * iname, char * oname, long toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  return ASYS_ERROR;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/* Shuts down audio input device.";
  z[lc++]=" */";
  z[lc++]="";
  z[lc++]="void asys_ishutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/* Gets one frame of audio from input.";
  z[lc++]=" */";
  z[lc++]="";
  z[lc++]="int asys_getbuf(ASYS_ITYPE * asys_ibuf[], long * isize)";
  z[lc++]="{";
  z[lc++]="  return ASYS_ERROR;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*  ksync() and ksyncinit() for -playback and -timesync modes  */";
  z[lc++]="/*_____________________________________________________________*/";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_KSYNC)";
  z[lc++]="";
  z[lc++]="#if (ASYS_TIMEOPTION != ASYS_TIMESYNC)";
  z[lc++]="";
  z[lc++]="#include <windows.h>";
  z[lc++]="#include <windowsx.h>";
  z[lc++]="#include <winbase.h>";
  z[lc++]="#include <mmsystem.h>";
  z[lc++]="";
  z[lc++]="#define SYNC_MAXCOUNT 4294967296L";
  z[lc++]="#define SYNC_KMTIME KUTIME/1000";
  z[lc++]="";
  z[lc++]="DWORD sync_last, sync_this, sync_delay;";
  z[lc++]="TIMECAPS sync_tc;";
  z[lc++]="BOOL sync_waitFlag;";
  z[lc++]="";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*         support routines                                */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="void CALLBACK sync_callBack(UINT uID, UINT uMsg, ";
  z[lc++]="                            DWORD dwUser, DWORD dw1, DWORD dw2)";
  z[lc++]="{";
  z[lc++]="  sync_waitFlag = TRUE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="BOOL sync_sleep(UINT ms)";
  z[lc++]="{";
  z[lc++]="  sync_waitFlag = FALSE;";
  z[lc++]="  if FAILED(timeSetEvent(ms, (UINT) 1, &sync_callBack, 0L, TIME_ONESHOT))";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"timeSetEvent error.\\n\");";
  z[lc++]="      exit(-1);";
  z[lc++]="    }";
  z[lc++]="  // spin wait";
  z[lc++]="  while (!sync_waitFlag) {}";
  z[lc++]="  return TRUE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*         synchronizes on k-rate boundaries               */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="float ksync()";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  float ret;";
  z[lc++]="";
  z[lc++]="  sync_this = timeGetTime();";
  z[lc++]="  ";
  z[lc++]="  if (sync_this<sync_last)   // timer wrap around";
  z[lc++]="    sync_last = (DWORD) (sync_last - SYNC_MAXCOUNT) + SYNC_KMTIME;";
  z[lc++]="  else ";
  z[lc++]="    sync_last += SYNC_KMTIME;";
  z[lc++]="";
  z[lc++]="  sync_delay = sync_last - sync_this;";
  z[lc++]="  if (sync_delay>0)";
  z[lc++]="    {";
  z[lc++]="      /* sync_sleep(sync_delay); */   /* can this be safely commented out? */";
  z[lc++]="      ret = (SYNC_KMTIME - sync_delay)/SYNC_KMTIME;";
  z[lc++]="    }";
  z[lc++]="  else ";
  z[lc++]="    ret = 1.0F;";
  z[lc++]="";
  z[lc++]="  return ret;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*         initializes k-rate boundaries sync              */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="void ksyncinit()";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  // Set 1ms time resolution";
  z[lc++]="  if FAILED(timeGetDevCaps(&sync_tc, sizeof(TIMECAPS)))";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"TimeGetDevCaps error.\\n\");";
  z[lc++]="      exit(-1);";
  z[lc++]="    }";
  z[lc++]="  sync_last = timeGetTime();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (ASYS_TIMEOPTION == ASYS_TIMESYNC)";
  z[lc++]="";
  z[lc++]="#include <windows.h>";
  z[lc++]="#include <windowsx.h>";
  z[lc++]="#include <winbase.h>";
  z[lc++]="#include <mmsystem.h>";
  z[lc++]="";
  z[lc++]="#define SYNC_MAXCOUNT 4294967296L";
  z[lc++]="#define SYNC_KMTIME KUTIME/1000";
  z[lc++]="";
  z[lc++]="DWORD sync_last, sync_this, sync_delay;";
  z[lc++]="TIMECAPS sync_tc;";
  z[lc++]="BOOL sync_waitFlag;";
  z[lc++]="";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*         support routines                                */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="void CALLBACK sync_callBack(UINT uID, UINT uMsg, ";
  z[lc++]="                            DWORD dwUser, DWORD dw1, DWORD dw2)";
  z[lc++]="{";
  z[lc++]="  sync_waitFlag = TRUE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="BOOL sync_sleep(UINT ms)";
  z[lc++]="{";
  z[lc++]="  sync_waitFlag = FALSE;";
  z[lc++]="  if FAILED(timeSetEvent(ms, (UINT) 1, &sync_callBack, 0L, TIME_ONESHOT))";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"timeSetEvent error.\\n\");";
  z[lc++]="      exit(-1);";
  z[lc++]="    }";
  z[lc++]="  // spin wait";
  z[lc++]="  while (!sync_waitFlag) {}";
  z[lc++]="  return TRUE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*         synchronizes on k-rate boundaries               */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="float ksync()";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  float ret;";
  z[lc++]="";
  z[lc++]="  sync_this = timeGetTime();";
  z[lc++]="  ";
  z[lc++]="  if (sync_this<sync_last)   // timer wrap around";
  z[lc++]="    sync_last = (DWORD) (sync_last - SYNC_MAXCOUNT) + SYNC_KMTIME;";
  z[lc++]="  else ";
  z[lc++]="    sync_last += SYNC_KMTIME;";
  z[lc++]="";
  z[lc++]="  sync_delay = sync_last - sync_this;";
  z[lc++]="  if (sync_delay>0)";
  z[lc++]="    {";
  z[lc++]="      sync_sleep(sync_delay);";
  z[lc++]="      ret = (SYNC_KMTIME - sync_delay)/SYNC_KMTIME;";
  z[lc++]="    }";
  z[lc++]="  else ";
  z[lc++]="    ret = 1.0F;";
  z[lc++]="";
  z[lc++]="  return ret;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*         initializes k-rate boundaries sync              */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="void ksyncinit()";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  // Set 1ms time resolution";
  z[lc++]="  if FAILED(timeGetDevCaps(&sync_tc, sizeof(TIMECAPS)))";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"TimeGetDevCaps error.\\n\");";
  z[lc++]="      exit(-1);";
  z[lc++]="    }";
  z[lc++]="  sync_last = timeGetTime();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#endif  /* ASYS_KSYNC */";
  printlib(lc);
}


void makelinux(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: merged linux/freebsd audio driver for sfront";
  z[lc++]="#    Copyright (C) 1999  Regents of the University of California";
  z[lc++]="#    Copyright (C) 2000  Bertrand Petit";
  z[lc++]="#";
  z[lc++]="#    This program is free software; you can redistribute it and/or modify";
  z[lc++]="#    it under the terms of the GNU General Public License (Version 2) as";
  z[lc++]="#    published by the Free Software Foundation.";
  z[lc++]="#";
  z[lc++]="#    This program is distributed in the hope that it will be useful,";
  z[lc++]="#    but WITHOUT ANY WARRANTY; without even the implied warranty of";
  z[lc++]="#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the";
  z[lc++]="#    GNU General Public License for more details.";
  z[lc++]="#";
  z[lc++]="#    You should have received a copy of the GNU General Public License";
  z[lc++]="#    along with this program; if not, write to the Free Software";
  z[lc++]="#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="#define ASYSIO_LINUX   0";
  z[lc++]="#define ASYSIO_FREEBSD 1";
  z[lc++]="";
  z[lc++]="#define ASYSIO_OSTYPE  ASYSIO_LINUX";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                linux audio driver for sfront                 */ ";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="/**************************************************/";
  z[lc++]="/* define flags for fifo mode, and for a timer to */";
  z[lc++]="/* catch SAOL infinite loops                      */";
  z[lc++]="/**************************************************/";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && (ASYSIO_OSTYPE == ASYSIO_LINUX) && \\";
  z[lc++]="     defined(CSYS_CDRIVER_LINMIDI) && (ASYS_TIMEOPTION == ASYS_TIMESYNC) && \\";
  z[lc++]="     !defined(ASYS_HASINPUT))";
  z[lc++]="#define ASYSIO_USEFIFO 1";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && (ASYSIO_OSTYPE == ASYSIO_LINUX) && \\";
  z[lc++]="    (ASYS_TIMEOPTION != ASYS_TIMESYNC))";
  z[lc++]="#define ASYSIO_USEFIFO 1";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef ASYSIO_USEFIFO";
  z[lc++]="#define ASYSIO_USEFIFO 0";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/**************************************************/";
  z[lc++]="/* include headers, based on flags set above      */";
  z[lc++]="/**************************************************/";
  z[lc++]="";
  z[lc++]="#include <unistd.h>";
  z[lc++]="#include <sys/ioctl.h>";
  z[lc++]="#include <fcntl.h>";
  z[lc++]="";
  z[lc++]="#if (ASYSIO_OSTYPE == ASYSIO_LINUX)";
  z[lc++]="#include <sys/soundcard.h>";
  z[lc++]="#include <endian.h>";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (ASYSIO_OSTYPE == ASYSIO_FREEBSD)";
  z[lc++]="#include <machine/soundcard.h>";
  z[lc++]="#include <machine/endian.h>";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#include <signal.h>  ";
  z[lc++]="#include <sys/time.h>  ";
  z[lc++]="";
  z[lc++]="#if ASYSIO_USEFIFO";
  z[lc++]="#include <sched.h>  ";
  z[lc++]="#if (ASYS_TIMEOPTION == ASYS_TIMESYNC)";
  z[lc++]="#include <time.h>";
  z[lc++]="#endif";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/******************************/";
  z[lc++]="/* other constant definitions */";
  z[lc++]="/******************************/";
  z[lc++]="";
  z[lc++]="#ifndef ASYSIO_DSPDEV";
  z[lc++]="#define ASYSIO_DSPDEV \"/dev/dsp\"";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/* determines native audio format */";
  z[lc++]="";
  z[lc++]="#if (BYTE_ORDER == BIG_ENDIAN)";
  z[lc++]="# define ASYSIO_AFORMAT AFMT_S16_BE";
  z[lc++]="#else";
  z[lc++]="# if (BYTE_ORDER == LITTLE_ENDIAN)";
  z[lc++]="#  define ASYSIO_AFORMAT AFMT_S16_LE";
  z[lc++]="# else";
  z[lc++]="#  error \"BYTE_ORDER not defined?\"";
  z[lc++]="# endif";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/* codes for IO types */";
  z[lc++]="";
  z[lc++]="#define ASYSIO_I  0";
  z[lc++]="#define ASYSIO_O  1";
  z[lc++]="#define ASYSIO_IO 2";
  z[lc++]="";
  z[lc++]="/* minimum fragment size */";
  z[lc++]="";
  z[lc++]="#define ASYSIO_FRAGMIN    16";
  z[lc++]="#define ASYSIO_LOGFRAGMIN 4";
  z[lc++]="";
  z[lc++]="/* number of silence buffers */";
  z[lc++]="";
  z[lc++]="#define ASYSO_LNUMBUFF 4";
  z[lc++]="";
  z[lc++]="/* maximum number of I/O retries before termination */";
  z[lc++]="";
  z[lc++]="#define ASYSIO_MAXRETRY 256";
  z[lc++]="";
  z[lc++]="#if ASYSIO_USEFIFO                      /* SCHED_FIFO constants for ksync()  */";
  z[lc++]="";
  z[lc++]="#if (ASYS_TIMEOPTION == ASYS_TIMESYNC)";
  z[lc++]="#define ASYSIO_SYNC_TIMEOUT    5        /* idle time to leave SCHED_FIFO     */";
  z[lc++]="#define ASYSIO_SYNC_ACTIVE     0        /* machine states for noteon timeout */";
  z[lc++]="#define ASYSIO_SYNC_WAITING    1";
  z[lc++]="#define ASYSIO_SYNC_SCHEDOTHER 2";
  z[lc++]="#else";
  z[lc++]="#define ASYSIO_MAXBLOCK ((int)KRATE)*2  /* max wait tor let SCHED_OTHERs run */";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/************************/";
  z[lc++]="/* variable definitions */";
  z[lc++]="/************************/";
  z[lc++]="";
  z[lc++]="int  asysio_fd;                    /* device pointer */";
  z[lc++]="long asysio_srate;                 /* sampling rate */";
  z[lc++]="long asysio_channels;              /* number of channels */";
  z[lc++]="long asysio_size;                  /* # samples in a buffer */";
  z[lc++]="long asysio_bsize;                 /* actual # bytes in a buffer */            ";
  z[lc++]="long asysio_requested_bsize;       /* requested # bytes in a buffer */        ";
  z[lc++]="long asysio_input;                 /* 1 if ASYSIO */";
  z[lc++]="long asysio_blocktime;             /* time (in bytes) blocked in kcycle */";
  z[lc++]="";
  z[lc++]="struct count_info asysio_ptr;      /* for GET{I,O}*PTR  ioctl calls */";
  z[lc++]="struct audio_buf_info asysio_info; /* for GET{I,O}SPACE ioctl calls */";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="short * asyso_buf = NULL;          /* output buffer */";
  z[lc++]="int asysio_puts;                   /* total number of putbufs */";
  z[lc++]="int asysio_reset;                  /* flags an overrun */";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="short * asysi_buf = NULL;          /* input buffer */";
  z[lc++]="struct audio_buf_info asysi_info;  /* input dma status */";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="sigset_t asysio_iloop_mask;            /* for masking off iloop interrupt */";
  z[lc++]="struct sigaction asysio_iloop_action;  /* for setting up iloop interrupt  */";
  z[lc++]="struct itimerval asysio_iloop_timer;   /* for setting up iloop timer      */";
  z[lc++]="";
  z[lc++]="#if ASYSIO_USEFIFO ";
  z[lc++]="int asysio_fifo;                       /* can get into sched_fifo mode */";
  z[lc++]="struct sched_param asysio_fifoparam;   /* param block for fifo mode */";
  z[lc++]="struct sched_param asysio_otherparam;  /* param block for other mode */";
  z[lc++]="";
  z[lc++]="#if (ASYS_TIMEOPTION == ASYS_TIMESYNC)";
  z[lc++]="";
  z[lc++]="/* state machine variables for noteon timeout */";
  z[lc++]="int    asysio_sync_state;";
  z[lc++]="time_t asysio_sync_waitstart;";
  z[lc++]="extern int csysi_newnote;       /* from linmidi */";
  z[lc++]="";
  z[lc++]="#else";
  z[lc++]="";
  z[lc++]="/* state to detect long periods w/o blocking */";
  z[lc++]="int asysio_sync_noblock;                /* how many acycles since last block */";
  z[lc++]="struct timespec asysio_sync_sleeptime;  /* time to wait during forced block  */";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_KSYNC)                      /* ksync() state */";
  z[lc++]="struct count_info asysio_sync_ptr;           ";
  z[lc++]="int asysio_sync_target, asysio_sync_incr;    ";
  z[lc++]="float asysio_sync_cpuscale;                  ";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                      shutdown routines                       */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                    shuts down soundcard                      */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asysio_shutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (ioctl(asysio_fd, SNDCTL_DSP_SYNC, 0) == -1)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"\\nSoundcard Error: SNDCTL_DSP_SYNC Ioctl Problem\\n\");";
  z[lc++]="      fprintf(stderr, \"Errno Message: %s\\n\\n\", strerror(errno));";
  z[lc++]="    }";
  z[lc++]="  close(asysio_fd);";
  z[lc++]="";
  z[lc++]="  /* so that a slow exit doesn't trigger timer */";
  z[lc++]="";
  z[lc++]="  asysio_iloop_timer.it_value.tv_sec = 0;";
  z[lc++]="  asysio_iloop_timer.it_value.tv_usec = 0;";
  z[lc++]="  asysio_iloop_timer.it_interval.tv_sec = 0;";
  z[lc++]="  asysio_iloop_timer.it_interval.tv_usec = 0;";
  z[lc++]="  ";
  z[lc++]="  if (setitimer(ITIMER_PROF, &asysio_iloop_timer, NULL) < 0)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"\\nSoundcard Driver Error:\\n\\n\");";
  z[lc++]="      fprintf(stderr, \"  Couldn't set up ITIMER_PROF timer.\\n\");";
  z[lc++]="      fprintf(stderr, \"  Errno Message: %s\\n\\n\", strerror(errno));";
  z[lc++]="    }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(!defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                    shuts down audio output                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_oshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysio_shutdown();";
  z[lc++]="  if (asyso_buf != NULL)";
  z[lc++]="    free(asyso_buf);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                    shuts down audio input                    */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ishutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysio_shutdown();  ";
  z[lc++]="  if (asysi_buf != NULL)";
  z[lc++]="    free(asysi_buf);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input and output               */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ioshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysio_shutdown();";
  z[lc++]="  if (asyso_buf != NULL)";
  z[lc++]="    free(asyso_buf);";
  z[lc++]="  if (asysi_buf != NULL)";
  z[lc++]="    free(asysi_buf);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                 initialization routines                      */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*          generic error-checking ioctl wrapper                */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="#define ASYSIO_IOCTL_CALL(x,y,z)  do { if (ioctl(x,y,z) == -1){\\";
  z[lc++]="      fprintf(stderr, \"  Error: %s Ioctl Problem\\n\", #y ); \\";
  z[lc++]="      fprintf(stderr, \"  Errno Message: %s\\n\\n\", strerror(errno));\\";
  z[lc++]="      close(asysio_fd); return ASYS_ERROR;}} while (0)";
  z[lc++]="";
  z[lc++]="#define  ASYSIO_ERROR_RETURN(x) do {\\";
  z[lc++]="      fprintf(stderr, \"  Error: %s.\\n\", x);\\";
  z[lc++]="      fprintf(stderr, \"  Errno Message: %s\\n\\n\", strerror(errno));\\";
  z[lc++]="      close(asysio_fd);\\";
  z[lc++]="      return ASYS_ERROR; } while (0)";
  z[lc++]="";
  z[lc++]="#define  ASYSIO_ERROR_RETURN_NOERRNO(x) do {\\";
  z[lc++]="      fprintf(stderr, \"  Error: %s.\\n\", x);\\";
  z[lc++]="      close(asysio_fd);\\";
  z[lc++]="      return ASYS_ERROR; } while (0)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               opens the soudcard device                      */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysio_opendevice(int dir, int toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  switch(dir) {";
  z[lc++]="  case ASYSIO_I:";
  z[lc++]="    asysio_fd = open(ASYSIO_DSPDEV, O_RDONLY, 0);";
  z[lc++]="    asysio_input = 1;";
  z[lc++]="    break;";
  z[lc++]="  case ASYSIO_O:";
  z[lc++]="    asysio_fd = open(ASYSIO_DSPDEV, O_WRONLY, 0);";
  z[lc++]="    asysio_input = 0;";
  z[lc++]="    break;";
  z[lc++]="  case ASYSIO_IO:";
  z[lc++]="    asysio_fd = open(ASYSIO_DSPDEV, O_RDWR, 0);";
  z[lc++]="    asysio_input = 1;";
  z[lc++]="    break;";
  z[lc++]="  default:";
  z[lc++]="    fprintf(stderr, \"  Error: Unexpected dir parameter value in \\n\");";
  z[lc++]="    fprintf(stderr, \"         asysio_setup.\\n\\n\");";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="  if (asysio_fd == -1)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"  Error: Can't open device %s (%s)\\n\\n\", ASYSIO_DSPDEV,";
  z[lc++]="	      strerror(errno));";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*         signal handler for trapping SAOL infinite loops      */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asysio_iloop_handler(int signum) ";
  z[lc++]="{   ";
  z[lc++]="  fprintf(stderr, \"  Error: Either\\n\\n\");";
  z[lc++]="  fprintf(stderr, \"    [1] The SAOL program has an infinite loop in it, or\\n\");";
  z[lc++]="  fprintf(stderr, \"    [2] Content is too complex for real-time work.\\n\\n\");";
  z[lc++]="  fprintf(stderr, \"  Exiting program ...\\n\\n\");";
  z[lc++]="  exit(0);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*         initializes iloop (heartbeat) interrupt              */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysio_initiloop(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  /*********************************************************/";
  z[lc++]="  /* set up signal handler for infinite-loop (iloop) timer */";
  z[lc++]="  /*********************************************************/";
  z[lc++]="  ";
  z[lc++]="  if (sigemptyset(&asysio_iloop_action.sa_mask) < 0)";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Couldn't run sigemptyset(iloop) OS call\");";
  z[lc++]="";
  z[lc++]="  /* infinite-loop timer wins over midi overrun timer */";
  z[lc++]="";
  z[lc++]="  if (sigaddset(&asysio_iloop_action.sa_mask, SIGALRM) < 0)";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Couldn't run sigaddset(iloop) OS call\");";
  z[lc++]="";
  z[lc++]="  asysio_iloop_action.sa_flags = SA_RESTART;";
  z[lc++]="  asysio_iloop_action.sa_handler = asysio_iloop_handler;";
  z[lc++]="  ";
  z[lc++]="  if (sigaction(SIGPROF, &asysio_iloop_action, NULL) < 0)";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Couldn't set up SIGPROF signal handler\");";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="  /************************/";
  z[lc++]="  /* set up timer and arm */";
  z[lc++]="  /************************/";
  z[lc++]="";
  z[lc++]="  asysio_iloop_timer.it_value.tv_sec = 3;";
  z[lc++]="  asysio_iloop_timer.it_value.tv_usec = 0;";
  z[lc++]="  asysio_iloop_timer.it_interval.tv_sec = 0;";
  z[lc++]="  asysio_iloop_timer.it_interval.tv_usec = 0;";
  z[lc++]="";
  z[lc++]="  if (setitimer(ITIMER_PROF, &asysio_iloop_timer, NULL) < 0)";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Couldn't set up ITIMER_PROF timer\");";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 initializes sched_fifo                       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysio_initscheduler(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="#if ASYSIO_USEFIFO";
  z[lc++]="";
  z[lc++]="  /*******************************/";
  z[lc++]="  /* set up sched_fifo variables */";
  z[lc++]="  /*******************************/";
  z[lc++]="";
  z[lc++]="  memset(&asysio_otherparam, 0, sizeof(struct sched_param));";
  z[lc++]="  memset(&asysio_fifoparam, 0, sizeof(struct sched_param));";
  z[lc++]=" ";
  z[lc++]="  if ((asysio_fifoparam.sched_priority =";
  z[lc++]="       sched_get_priority_max(SCHED_FIFO)) < 0)";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Couldn't get scheduling priority\");";
  z[lc++]="";
  z[lc++]="  asysio_fifoparam.sched_priority--;";
  z[lc++]="";
  z[lc++]="  /********************************/";
  z[lc++]="  /* try to enter sched-fifo mode */";
  z[lc++]="  /********************************/";
  z[lc++]="";
  z[lc++]="  asysio_fifo = !sched_setscheduler(0, SCHED_FIFO, &asysio_fifoparam);";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 prints startup screen                        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysio_screenwriter(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i, found;";
  z[lc++]="  int haslinmidi = 0;";
  z[lc++]="  float actual_latency;";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="  fprintf(stderr, \"%s \",  (ASYS_LATENCYTYPE == ASYS_HIGHLATENCY)? ";
  z[lc++]="	  \"Streaming\" : \"Interactive\");";
  z[lc++]="";
  z[lc++]="  fprintf(stderr, \"%s Audio \", (asysio_channels == 2) ? \"Stereo\" : \"Mono\");";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="  fprintf(stderr, \"%s\", asysio_input ? \"Input/Output\" : \"Output\");";
  z[lc++]="#else";
  z[lc++]="  fprintf(stderr, \"Input\");";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  found = i = 0;";
  z[lc++]="  while (i < csys_sfront_argc)";
  z[lc++]="    {";
  z[lc++]="      if (!(strcmp(csys_sfront_argv[i],\"-bitc\") && ";
  z[lc++]="	    strcmp(csys_sfront_argv[i],\"-bit\") &&";
  z[lc++]="	    strcmp(csys_sfront_argv[i],\"-orc\")))";
  z[lc++]="	{";
  z[lc++]="	  i++;";
  z[lc++]="	  fprintf(stderr, \" for %s\", csys_sfront_argv[i]);";
  z[lc++]="	  found = 1;";
  z[lc++]="	  break;";
  z[lc++]="	}";
  z[lc++]="      i++;";
  z[lc++]="    }";
  z[lc++]="  if (!found)";
  z[lc++]="    fprintf(stderr, \" for UNKNOWN\");";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="  i = 0;";
  z[lc++]="  while (i < csys_sfront_argc)";
  z[lc++]="    {";
  z[lc++]="      if (!strcmp(csys_sfront_argv[i],\"-cin\"))";
  z[lc++]="	{";
  z[lc++]="	  i++;";
  z[lc++]="	  fprintf(stderr, \" (-cin %s)\", csys_sfront_argv[i]);";
  z[lc++]="	  break;";
  z[lc++]="	}";
  z[lc++]="      i++;";
  z[lc++]="    }";
  z[lc++]="  fprintf(stderr, \"\\n\\n\");";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(CSYS_CDRIVER_LINMIDI)";
  z[lc++]="";
  z[lc++]="  haslinmidi = 1;";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(CSYS_CDRIVER_LINMIDI) || defined(CSYS_CDRIVER_ALSAMIDI)\\";
  z[lc++]="      || defined(CSYS_CDRIVER_ALSASEQ) || defined(CSYS_CDRIVER_ASCII))";
  z[lc++]="";
  z[lc++]="  /* list midi presets available */";
  z[lc++]="";
  z[lc++]="  fprintf(stderr, ";
  z[lc++]="	  \"MIDI Preset Numbers (use MIDI controller to select):\\n\\n\");";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < CSYS_PRESETNUM; i++)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"%3i. %s\", ";
  z[lc++]="	      csys_presets[i].preset,";
  z[lc++]="	      csys_instr[csys_presets[i].index].name);";
  z[lc++]="      if ((i&1))";
  z[lc++]="	fprintf(stderr, \"\\n\");";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  fprintf(stderr, \"\\t\\t\");";
  z[lc++]="	  if (i == (CSYS_PRESETNUM-1))";
  z[lc++]="	    fprintf(stderr, \"\\n\");";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  fprintf(stderr, \"\\n\");";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(CSYS_CDRIVER_ASCII)";
  z[lc++]="";
  z[lc++]="  fprintf(stderr, ";
  z[lc++]="  \"To play tunes on ASCII keyboard: a-z for notes, 0-9 for MIDI presets,\\n\");";
  z[lc++]="  fprintf(stderr, ";
  z[lc++]="  \"cntrl-C exits. If autorepeat interferes, exit and run 'xset -r' (in X).\\n\\n\");";
  z[lc++]="  ";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  /* diagnose best flags to use, and if they are used */";
  z[lc++]="";
  z[lc++]="#ifdef ASYS_HASOUTPUT";
  z[lc++]="";
  z[lc++]="  if ((ASYS_LATENCYTYPE == ASYS_HIGHLATENCY) || asysio_input ||";
  z[lc++]="      (!haslinmidi))";
  z[lc++]="    {";
  z[lc++]="      if (geteuid() || (ASYS_TIMEOPTION == ASYS_TIMESYNC))";
  z[lc++]="	{";
  z[lc++]="	  fprintf(stderr, \"For best results, make these changes:\\n\"); ";
  z[lc++]="	  fprintf(stderr, \"\\n\");";
  z[lc++]="	  if (ASYS_TIMEOPTION == ASYS_TIMESYNC)";
  z[lc++]="	    fprintf(stderr, \"   * Remove sfront -timesync flag\\n\");";
  z[lc++]="	  if (geteuid())";
  z[lc++]="	    fprintf(stderr, \"   * Run sa.c executable as root.\\n\");";
  z[lc++]="	  fprintf(stderr, \"\\n\");";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"This application runs best as root (%s), with:\\n\",";
  z[lc++]="	      !geteuid() ? \"which you are\": \"which you aren't\"); ";
  z[lc++]="      fprintf(stderr, \"\\n\");";
  z[lc++]="      fprintf(stderr, \"  [1] Sfront -playback flag. Good audio quality, keeps\\n\");";
  z[lc++]="      fprintf(stderr, \"      the mouse/kbd alive\");";
  z[lc++]="      fprintf(stderr, \"%s.\\n\", (ASYS_TIMEOPTION == ASYS_PLAYBACK) ?";
  z[lc++]="	      \" (currently chosen)\":\"\");";
  z[lc++]="      fprintf(stderr, \"  [2] Sfront -timesync flag. Better quality, console\\n\");";
  z[lc++]="      fprintf(stderr, \"      freezes during MIDI input\");";
  z[lc++]="      fprintf(stderr, \"%s.\\n\", (ASYS_TIMEOPTION == ASYS_TIMESYNC) ?";
  z[lc++]="	      \" (currently chosen)\":\"\");";
  z[lc++]="      fprintf(stderr, \"\\n\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  /* latency information */";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT))";
  z[lc++]="";
  z[lc++]="  ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOSPACE, &asysio_info);";
  z[lc++]="";
  z[lc++]="  fprintf(stderr, \"If audio artifacts still occur, try\");";
  z[lc++]="  ";
  z[lc++]="  actual_latency = ATIME*ASYSO_LNUMBUFF*(asysio_size >> (asysio_channels - 1));";
  z[lc++]="  ";
  z[lc++]="  if (asysio_info.fragstotal < ASYSO_LNUMBUFF)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \" sfront -latency %f flag, and see\\n\", ";
  z[lc++]="	      0.5F*actual_latency);";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \" sfront -latency %f flag, and see\\n\", ";
  z[lc++]="	      2.0F*actual_latency);";
  z[lc++]="";
  z[lc++]="    }";
  z[lc++]="  if (ASYS_LATENCYTYPE == ASYS_LOWLATENCY)";
  z[lc++]="    fprintf(stderr, \"http://www.cs.berkeley.edu/\"";
  z[lc++]="	    \"~lazzaro/sa/sfman/user/use/index.html#interact\\n\") ;";
  z[lc++]="  else";
  z[lc++]="    fprintf(stderr, \"http://www.cs.berkeley.edu/\"";
  z[lc++]="	    \"~lazzaro/sa/sfman/user/use/index.html#stream\\n\") ;";
  z[lc++]="";
  z[lc++]="  fprintf(stderr, \"\\n\");";
  z[lc++]="";
  z[lc++]="  if ((asysio_bsize != ASYSIO_FRAGMIN) &&";
  z[lc++]="      (asysio_bsize == asysio_requested_bsize) && ";
  z[lc++]="      (ASYS_LATENCYTYPE == ASYS_LOWLATENCY))";
  z[lc++]="  {";
  z[lc++]="    fprintf(stderr, \"If interactive response is slow, try \");";
  z[lc++]="    fprintf(stderr, \"sfront -latency %f flag.\\n\", 0.5F*actual_latency);";
  z[lc++]="    fprintf(stderr, \"\\n\");";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  fprintf(stderr, ";
  z[lc++]="  \"USE AT YOUR OWN RISK. Running as root may damage your file system,\\n\");";
  z[lc++]="  fprintf(stderr, ";
  z[lc++]="  \"and network use may result in a malicious attack on your machine.\\n\\n\");";
  z[lc++]="";
  z[lc++]="#if (ASYSIO_USEFIFO && (ASYS_TIMEOPTION == ASYS_TIMESYNC))";
  z[lc++]="";
  z[lc++]="  if (!geteuid())";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, ";
  z[lc++]="      \"NOTE: Mouse and keyboard are frozen for %i seconds after a MIDI\\n\",";
  z[lc++]="	      ASYSIO_SYNC_TIMEOUT);";
  z[lc++]="      fprintf(stderr, ";
  z[lc++]="	      \"NoteOn or NoteOff is received. Do not be alarmed.\\n\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  if (NSYS_NET)";
  z[lc++]="    fprintf(stderr, \"Network status: Contacting SIP server\\n\");";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        setup operations common to input and output           */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysio_setup(long srate, long channels, int dir, int toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  long i, j, maxfrag;";
  z[lc++]="";
  z[lc++]="  /******************/";
  z[lc++]="  /* open soundcard */";
  z[lc++]="  /******************/";
  z[lc++]="";
  z[lc++]="  if (asysio_opendevice(dir, toption) == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  ";
  z[lc++]="  /**************************************/";
  z[lc++]="  /* set up bidirectional I/O if needed */";
  z[lc++]="  /**************************************/";
  z[lc++]="";
  z[lc++]="  if (dir == ASYSIO_IO)";
  z[lc++]="    {";
  z[lc++]="";
  z[lc++]="#if (ASYSIO_OSTYPE != ASYSIO_FREEBSD)";
  z[lc++]="";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_SETDUPLEX, 0);";
  z[lc++]="";
  z[lc++]="#endif ";
  z[lc++]="";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETCAPS, &j);";
  z[lc++]="";
  z[lc++]="      if (!(j & DSP_CAP_DUPLEX))";
  z[lc++]="	ASYSIO_ERROR_RETURN_NOERRNO(\"Sound card can't do bidirectional audio\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /************************/";
  z[lc++]="  /* range check channels */";
  z[lc++]="  /************************/";
  z[lc++]="";
  z[lc++]="  if (channels > 2)";
  z[lc++]="    ASYSIO_ERROR_RETURN_NOERRNO(\"Sound card can't handle > 2 channels\");";
  z[lc++]="";
  z[lc++]="  /*********************/";
  z[lc++]="  /* set fragment size */";
  z[lc++]="  /*********************/";
  z[lc++]="";
  z[lc++]="  j = ASYSIO_LOGFRAGMIN;";
  z[lc++]="  i = ASYSIO_FRAGMIN >> channels;   /* only works for channels = 1, 2 */";
  z[lc++]="";
  z[lc++]="  /* find closest power-of-two fragment size to latency request */";
  z[lc++]="";
  z[lc++]="  while (2*ATIME*i*ASYSO_LNUMBUFF < ASYS_LATENCY)";
  z[lc++]="    {";
  z[lc++]="      i <<= 1;";
  z[lc++]="      j++;";
  z[lc++]="    }";
  z[lc++]="  if ((ATIME*2*i*ASYSO_LNUMBUFF - ASYS_LATENCY) < ";
  z[lc++]="      (ASYS_LATENCY - ATIME*i*ASYSO_LNUMBUFF))";
  z[lc++]="    {";
  z[lc++]="      i <<= 1;";
  z[lc++]="      j++;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  asysio_requested_bsize = 2*i*channels;";
  z[lc++]="";
  z[lc++]="  maxfrag = (ASYS_TIMEOPTION != ASYS_TIMESYNC) ? ASYSO_LNUMBUFF :";
  z[lc++]="             ASYSO_LNUMBUFF + ((ACYCLE/i) + 1);";
  z[lc++]="";
  z[lc++]="  j |= (maxfrag << 16);";
  z[lc++]="  ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_SETFRAGMENT, &j);";
  z[lc++]="";
  z[lc++]="  /********************/";
  z[lc++]="  /* set audio format */";
  z[lc++]="  /********************/";
  z[lc++]="";
  z[lc++]="  j = ASYSIO_AFORMAT;";
  z[lc++]="  ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_SETFMT, &j);";
  z[lc++]="";
  z[lc++]="  if (j != ASYSIO_AFORMAT)";
  z[lc++]="    ASYSIO_ERROR_RETURN_NOERRNO(\"Soundcard can't handle native shorts\");";
  z[lc++]="";
  z[lc++]="  /****************************************************/";
  z[lc++]="  /* set number of channels -- later add channels > 2 */";
  z[lc++]="  /****************************************************/";
  z[lc++]="";
  z[lc++]="  asysio_channels = channels--;";
  z[lc++]="  ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_STEREO, &channels);";
  z[lc++]="";
  z[lc++]="  if (channels != (asysio_channels-1))";
  z[lc++]="    ASYSIO_ERROR_RETURN_NOERRNO(\"Soundcard can't handle number of channels\");";
  z[lc++]="";
  z[lc++]="  /*********************/";
  z[lc++]="  /* set sampling rate */";
  z[lc++]="  /*********************/";
  z[lc++]="";
  z[lc++]="  asysio_srate = srate;";
  z[lc++]="  ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_SPEED, &srate);";
  z[lc++]="";
  z[lc++]="  if (abs(asysio_srate - srate) > 1000)";
  z[lc++]="    ASYSIO_ERROR_RETURN_NOERRNO(\"Soundcard can't handle sampling rate\");";
  z[lc++]="";
  z[lc++]="  /******************************/";
  z[lc++]="  /* compute actual buffer size */";
  z[lc++]="  /******************************/";
  z[lc++]="";
  z[lc++]="  ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETBLKSIZE, &asysio_bsize);";
  z[lc++]="  asysio_size = asysio_bsize >> 1;";
  z[lc++]="";
  z[lc++]="  /*************************/";
  z[lc++]="  /* print out info screen */";
  z[lc++]="  /*************************/";
  z[lc++]="";
  z[lc++]="  if (asysio_screenwriter() == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  /*********************************/";
  z[lc++]="  /* set SCHED_FIFO if appropriate */";
  z[lc++]="  /*********************************/";
  z[lc++]="";
  z[lc++]="  if (asysio_initscheduler() == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  /**********************************/";
  z[lc++]="  /* set up iloop (heartbeat) timer */";
  z[lc++]="  /**********************************/";
  z[lc++]="";
  z[lc++]="  if (asysio_initiloop() == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && !defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio output for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_osetup(long srate, long ochannels, long osample, ";
  z[lc++]="                char * oname, long toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (asysio_setup(srate, ochannels, ASYSIO_O, toption) == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (!(asyso_buf = (short *)calloc(asysio_size, sizeof(short))))";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Can't allocate output buffer\");";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio input for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_isetup(long srate, long ichannels, long isample, ";
  z[lc++]="                char * iname, long toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (asysio_setup(srate, ichannels, ASYSIO_I, toption) == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if (!(asysi_buf = (short *)malloc(asysio_bsize)))";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Can't allocate input buffer\");";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*   sets up audio input and output for a given srate/channels  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_iosetup(long srate, long ichannels, long ochannels,";
  z[lc++]="                 long isample, long osample, ";
  z[lc++]="                 char * iname, char * oname, long toption)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  if (ichannels != ochannels)";
  z[lc++]="    ASYSIO_ERROR_RETURN_NOERRNO";
  z[lc++]="      (\"Soundcard needs SAOL inchannels == outchannels\");";
  z[lc++]="";
  z[lc++]="  if (asysio_setup(srate, ichannels, ASYSIO_IO, toption) == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (!(asysi_buf = (short *)malloc(asysio_bsize)))";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Can't allocate input buffer\");";
  z[lc++]="";
  z[lc++]="  if (!(asyso_buf = (short *)calloc(asysio_size, sizeof(short))))";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Can't allocate output buffer\");";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*            input, output, and recovery routines              */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               gets one frame of audio from input             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_getbuf(ASYS_ITYPE * asys_ibuf[], long * isize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  long diffcompute, starttime;";
  z[lc++]="  long size, recv, bptr, retry;";
  z[lc++]="";
  z[lc++]="  *isize = asysio_size;";
  z[lc++]="";
  z[lc++]="  if (*asys_ibuf == NULL)";
  z[lc++]="    *asys_ibuf = asysi_buf;";
  z[lc++]="";
  z[lc++]="  ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETISPACE, &asysio_info);";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="  if (diffcompute = (asysio_info.bytes < asysio_bsize))";
  z[lc++]="    {  ";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOPTR, &asysio_ptr);";
  z[lc++]="      starttime = asysio_ptr.bytes;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  retry = bptr = 0;";
  z[lc++]="  size = asysio_bsize;";
  z[lc++]="";
  z[lc++]="  while ((recv = read(asysio_fd, &((*asys_ibuf)[bptr]), size)) != size)";
  z[lc++]="    {      ";
  z[lc++]="      if (++retry > ASYSIO_MAXRETRY)";
  z[lc++]="	ASYSIO_ERROR_RETURN(\"Too many I/O retries -- asys_getbuf\");";
  z[lc++]="";
  z[lc++]="      if (recv < 0)  /* errors */";
  z[lc++]="	{";
  z[lc++]="	  if ((errno == EAGAIN) || (errno == EINTR))";
  z[lc++]="	    continue;   ";
  z[lc++]="	  else";
  z[lc++]="	    ASYSIO_ERROR_RETURN(\"Read error on output audio device\");";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  bptr += recv; /* partial read */";
  z[lc++]="	  size -= recv;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="  if (diffcompute)";
  z[lc++]="    {  ";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOPTR, &asysio_ptr);";
  z[lc++]="      asysio_blocktime += (asysio_ptr.bytes - starttime);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               sends one frame of audio to output             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_putbuf(ASYS_OTYPE * asys_obuf[], long * osize)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  long size, sent, bptr, retry;";
  z[lc++]="  long diffcompute, starttime;";
  z[lc++]="";
  z[lc++]="  size = (*osize)*2;";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="  if (asysio_reset)";
  z[lc++]="    return ASYS_DONE;";
  z[lc++]="";
  z[lc++]="  ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOSPACE, &asysio_info);";
  z[lc++]="";
  z[lc++]="  asysio_reset = (++asysio_puts > ASYSO_LNUMBUFF) && ";
  z[lc++]="    (asysio_info.fragments == asysio_info.fragstotal);";
  z[lc++]="  if (asysio_reset)";
  z[lc++]="    return ASYS_DONE;";
  z[lc++]="";
  z[lc++]="#if (ASYS_TIMEOPTION != ASYS_TIMESYNC)";
  z[lc++]="";
  z[lc++]="  if (diffcompute = (asysio_info.bytes < size))";
  z[lc++]="    {  ";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOPTR, &asysio_ptr);";
  z[lc++]="      starttime = asysio_ptr.bytes;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  retry = bptr = 0;";
  z[lc++]="  while ((sent = write(asysio_fd, &((*asys_obuf)[bptr]), size)) != size)";
  z[lc++]="    {";
  z[lc++]="      if (++retry > ASYSIO_MAXRETRY)";
  z[lc++]="	ASYSIO_ERROR_RETURN(\"Too many I/O retries -- asys_putbuf\");";
  z[lc++]="";
  z[lc++]="      if (sent < 0)  /* errors */";
  z[lc++]="	{";
  z[lc++]="	  if ((errno == EAGAIN) || (errno == EINTR))";
  z[lc++]="	    continue;   ";
  z[lc++]="	  else";
  z[lc++]="	    ASYSIO_ERROR_RETURN(\"Write error on output audio device\");";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  bptr += sent;  /* partial write */";
  z[lc++]="	  size -= sent;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#if (ASYS_TIMEOPTION != ASYS_TIMESYNC)";
  z[lc++]="";
  z[lc++]="  if (diffcompute)";
  z[lc++]="    {  ";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOPTR, &asysio_ptr);";
  z[lc++]="      asysio_blocktime += (asysio_ptr.bytes - starttime);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  *osize = asysio_size;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        creates buffer, and generates starting silence        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_preamble(ASYS_OTYPE * asys_obuf[], long * osize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  *asys_obuf = asyso_buf;";
  z[lc++]="  *osize = asysio_size;";
  z[lc++]="";
  z[lc++]="  for(i = 0; i < ASYSO_LNUMBUFF; i++)";
  z[lc++]="    if (asys_putbuf(asys_obuf, osize) == ASYS_ERROR)";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               recovers from an overrun                       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysio_recover(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  long size, recv, bptr, retry;";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  asysio_reset = 0;";
  z[lc++]="";
  z[lc++]="  memset(asyso_buf, 0, asysio_bsize);";
  z[lc++]="";
  z[lc++]="  /*************************/";
  z[lc++]="  /* flush input if needed */";
  z[lc++]="  /*************************/";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="  ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETISPACE, &asysi_info);";
  z[lc++]="  ";
  z[lc++]="  while (asysi_info.fragments > 0)";
  z[lc++]="    {";
  z[lc++]="      retry = bptr = 0;";
  z[lc++]="      size = asysio_bsize;";
  z[lc++]="";
  z[lc++]="      while ((recv = read(asysio_fd, &(asysi_buf[bptr]), size)) != size)";
  z[lc++]="	{      ";
  z[lc++]="	  if (++retry > ASYSIO_MAXRETRY)";
  z[lc++]="	    ASYSIO_ERROR_RETURN(\"Too many I/O retries -- asysio_recover\");";
  z[lc++]="";
  z[lc++]="	  if (recv < 0)  /* errors */";
  z[lc++]="	    {";
  z[lc++]="	      if ((errno == EAGAIN) || (errno == EINTR))";
  z[lc++]="		continue;   ";
  z[lc++]="	      else";
  z[lc++]="		ASYSIO_ERROR_RETURN(\"Read error on output audio device\");";
  z[lc++]="	    }";
  z[lc++]="	  else";
  z[lc++]="	    {";
  z[lc++]="	      bptr += recv; /* partial read */";
  z[lc++]="	      size -= recv;";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETISPACE, &asysi_info);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  ibusidx = 0;";
  z[lc++]="  if (asys_getbuf(&asys_ibuf, &asys_isize)==ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  /**************************************/";
  z[lc++]="  /* fill latency interval with silence */ ";
  z[lc++]="  /**************************************/";
  z[lc++]="";
  z[lc++]="  asysio_puts = 0;";
  z[lc++]="  for(i = 0; i < ASYSO_LNUMBUFF; i++)";
  z[lc++]="    if (asys_putbuf(&asyso_buf, &asysio_size) == ASYS_ERROR)";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*        ksync() system for time synchronization          */ ";
  z[lc++]="/*_________________________________________________________*/";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_KSYNC)";
  z[lc++]="";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*         initializes k-rate boundaries sync              */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="void ksyncinit()";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysio_sync_target = asysio_sync_incr = ACYCLE*asysio_channels*2;  ";
  z[lc++]="  asysio_sync_cpuscale = 1.0F/asysio_sync_incr;";
  z[lc++]="";
  z[lc++]="  /* for -timesync, set up SCHED_FIFO watchdog state machine */";
  z[lc++]="";
  z[lc++]="#if (ASYSIO_USEFIFO && (ASYS_TIMEOPTION == ASYS_TIMESYNC))";
  z[lc++]="";
  z[lc++]="  if (asysio_fifo)";
  z[lc++]="";
  z[lc++]="    {";
  z[lc++]="      asysio_sync_state = ASYSIO_SYNC_SCHEDOTHER;";
  z[lc++]="      if (sched_setscheduler(0, SCHED_OTHER, &asysio_otherparam))";
  z[lc++]="	epr(0,NULL,NULL,\"internal error -- sched_other unavailable\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  /* elsewise, set up SCHED_FIFO monitor to force blocking */";
  z[lc++]="";
  z[lc++]="#if (ASYSIO_USEFIFO && (ASYS_TIMEOPTION != ASYS_TIMESYNC))";
  z[lc++]="";
  z[lc++]="  asysio_sync_noblock = 0;";
  z[lc++]="  asysio_sync_sleeptime.tv_sec = 0;";
  z[lc++]="  asysio_sync_sleeptime.tv_nsec = 2000001;  /* 2ms + epsilon forces block */";
  z[lc++]=" ";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*     different ksync()s for -timesync and -playback       */ ";
  z[lc++]="/*__________________________________________________________*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (ASYS_TIMEOPTION != ASYS_TIMESYNC)";
  z[lc++]="";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*         synchronizes on k-rate boundaries               */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="float ksync()";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  float ret;";
  z[lc++]="  long comptime;";
  z[lc++]="";
  z[lc++]="  if (asysio_reset)";
  z[lc++]="    {";
  z[lc++]="      if (asysio_recover()==ASYS_ERROR)";
  z[lc++]="	epr(0,NULL,NULL, \"Soundcard error -- failed recovery.\");";
  z[lc++]="      asysio_sync_target = asysio_sync_incr;";
  z[lc++]="      ret = 1.0F;";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOPTR, &asysio_sync_ptr);";
  z[lc++]="";
  z[lc++]="      if (asysio_sync_target == asysio_sync_incr)";
  z[lc++]="	ret = 0.0F;";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  comptime = asysio_sync_ptr.bytes - asysio_blocktime;";
  z[lc++]="	  if (comptime > asysio_sync_target)";
  z[lc++]="	    ret = 1.0F;";
  z[lc++]="	  else";
  z[lc++]="	    ret = (asysio_sync_cpuscale*";
  z[lc++]="		   (asysio_sync_incr - (asysio_sync_target - comptime)));";
  z[lc++]="	}";
  z[lc++]="      ";
  z[lc++]="      if ((asysio_sync_target = asysio_sync_incr + asysio_sync_ptr.bytes) < 0)";
  z[lc++]="	epr(0,NULL,NULL,\"Soundcard error -- rollover.\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /* reset infinite-loop timer */";
  z[lc++]="";
  z[lc++]="  if (setitimer(ITIMER_PROF, &asysio_iloop_timer, NULL) < 0)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"  Runtime Errno Message: %s\\n\", strerror(errno));";
  z[lc++]="      epr(0,NULL,NULL, \"Soundcard error -- Couldn't reset ITIMER_PROF\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#if ASYSIO_USEFIFO";
  z[lc++]="";
  z[lc++]="  if (asysio_fifo)";
  z[lc++]="    {";
  z[lc++]="      /* let other processes run if pending too long */";
  z[lc++]="";
  z[lc++]="      if (asysio_blocktime)";
  z[lc++]="	asysio_sync_noblock = 0;";
  z[lc++]="      else";
  z[lc++]="	asysio_sync_noblock++;";
  z[lc++]="";
  z[lc++]="      if (asysio_sync_noblock > ASYSIO_MAXBLOCK)";
  z[lc++]="	{";
  z[lc++]="	  nanosleep(&asysio_sync_sleeptime, NULL); ";
  z[lc++]="	  asysio_sync_noblock = 0;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  asysio_blocktime = 0;";
  z[lc++]="  return ret;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (ASYS_TIMEOPTION == ASYS_TIMESYNC)";
  z[lc++]="";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*         synchronizes on k-rate boundaries               */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="float ksync()";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  float ret;";
  z[lc++]="  long comptime;";
  z[lc++]="";
  z[lc++]="  if (!asysio_reset)";
  z[lc++]="    {";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOPTR, &asysio_sync_ptr);";
  z[lc++]="      if (asysio_sync_ptr.bytes > asysio_sync_target)";
  z[lc++]="	{";
  z[lc++]="	  comptime = asysio_sync_ptr.bytes - asysio_blocktime;";
  z[lc++]="	  if (comptime < asysio_sync_target)";
  z[lc++]="	    ret = (asysio_sync_cpuscale*";
  z[lc++]="		   (asysio_sync_incr - (asysio_sync_target - comptime)));";
  z[lc++]="	  else";
  z[lc++]="	    ret = 1.0F;";
  z[lc++]="	  ret = (asysio_sync_target != asysio_sync_incr) ? ret : 0.0F;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{	  ";
  z[lc++]="	  comptime = asysio_sync_ptr.bytes - asysio_blocktime;";
  z[lc++]="	  ret = (asysio_sync_cpuscale*";
  z[lc++]="		 (asysio_sync_incr - (asysio_sync_target - comptime)));";
  z[lc++]="	  asysio_reset = asysio_input && ";
  z[lc++]="	    ((asysio_sync_target-asysio_sync_ptr.bytes) == asysio_sync_incr);";
  z[lc++]="	  while ((asysio_sync_ptr.bytes < asysio_sync_target) && !asysio_reset)";
  z[lc++]="	    {  ";
  z[lc++]="	      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOSPACE, &asysio_info);";
  z[lc++]="	      asysio_reset = (asysio_info.fragments == asysio_info.fragstotal);";
  z[lc++]="	      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOPTR,&asysio_sync_ptr);";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  if (asysio_reset)";
  z[lc++]="    {";
  z[lc++]="      if (asysio_recover()==ASYS_ERROR)";
  z[lc++]="	epr(0,NULL,NULL,\"Sound driver error -- failed recovery.\");";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOPTR, &asysio_sync_ptr);";
  z[lc++]="      asysio_sync_target = asysio_sync_ptr.bytes;";
  z[lc++]="      ret = 1.0F;";
  z[lc++]="    }";
  z[lc++]="  if ((asysio_sync_target += asysio_sync_incr) < 0)";
  z[lc++]="    epr(0,NULL,NULL,\"Sound driver error -- rollover.\");";
  z[lc++]="";
  z[lc++]="  /* reset infinite-loop timer */";
  z[lc++]="";
  z[lc++]="  if (setitimer(ITIMER_PROF, &asysio_iloop_timer, NULL) < 0)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"  Runtime Errno Message: %s\\n\", strerror(errno));";
  z[lc++]="      epr(0,NULL,NULL, \"Soundcard error -- Couldn't reset ITIMER_PROF\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#if ASYSIO_USEFIFO";
  z[lc++]="";
  z[lc++]="  if (asysio_fifo)";
  z[lc++]="    {";
  z[lc++]="      switch (asysio_sync_state) {";
  z[lc++]="      case ASYSIO_SYNC_ACTIVE:";
  z[lc++]="	if (!csysi_newnote)";
  z[lc++]="	  {";
  z[lc++]="	    asysio_sync_state = ASYSIO_SYNC_WAITING;";
  z[lc++]="	    asysio_sync_waitstart = time(NULL);";
  z[lc++]="	  }";
  z[lc++]="	break;";
  z[lc++]="      case ASYSIO_SYNC_WAITING:";
  z[lc++]="	if (csysi_newnote)";
  z[lc++]="	  asysio_sync_state = ASYSIO_SYNC_ACTIVE;";
  z[lc++]="	else";
  z[lc++]="	  if ((time(NULL) - asysio_sync_waitstart) >= ASYSIO_SYNC_TIMEOUT)";
  z[lc++]="	    {";
  z[lc++]="	      asysio_sync_state = ASYSIO_SYNC_SCHEDOTHER;";
  z[lc++]="	      if (sched_setscheduler(0, SCHED_OTHER, &asysio_otherparam))";
  z[lc++]="		epr(0,NULL,NULL,\"internal error -- sched_other unavailable\");";
  z[lc++]="	    }";
  z[lc++]="	break;";
  z[lc++]="      case ASYSIO_SYNC_SCHEDOTHER:";
  z[lc++]="	if (csysi_newnote)";
  z[lc++]="	  {";
  z[lc++]="	    asysio_sync_state = ASYSIO_SYNC_ACTIVE;";
  z[lc++]="	    if (sched_setscheduler(0, SCHED_FIFO, &asysio_fifoparam))";
  z[lc++]="	      fprintf(stderr, \"  Note: Process no longer root, \" ";
  z[lc++]="		      \"improved audio quality no longer possible.\\n\");";
  z[lc++]="	  }";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  asysio_blocktime = 0;";
  z[lc++]="  return ret;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#endif /* ASYS_KSYNC */";
  z[lc++]="";
  z[lc++]="#undef ASYSIO_IOCTL_CALL";
  z[lc++]="#undef ASYSIO_ERROR_RETURN";
  z[lc++]="#undef ASYSIO_ERROR_RETURN_NOERRNO";
  z[lc++]="#undef ASYSIO_LINUX";
  z[lc++]="#undef ASYSIO_FREEBSD";
  z[lc++]="#undef ASYSIO_OSTYPE";
  z[lc++]="#undef ASYSIO_DSPDEV";
  z[lc++]="#undef ASYSIO_AFORMAT";
  z[lc++]="#undef ASYSIO_I  ";
  z[lc++]="#undef ASYSIO_O  ";
  z[lc++]="#undef ASYSIO_IO ";
  z[lc++]="#undef ASYSIO_FRAGMIN";
  z[lc++]="#undef ASYSIO_LOGFRAGMIN ";
  z[lc++]="#undef ASYSO_LNUMBUFF";
  z[lc++]="#undef ASYSIO_MAXRETRY";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                    end of soundcard driver                   */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="";
  printlib(lc);
}


void makefreebsd(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: merged linux/freebsd audio driver for sfront";
  z[lc++]="#    Copyright (C) 1999  Regents of the University of California";
  z[lc++]="#    Copyright (C) 2000  Bertrand Petit";
  z[lc++]="#";
  z[lc++]="#    This program is free software; you can redistribute it and/or modify";
  z[lc++]="#    it under the terms of the GNU General Public License (Version 2) as";
  z[lc++]="#    published by the Free Software Foundation.";
  z[lc++]="#";
  z[lc++]="#    This program is distributed in the hope that it will be useful,";
  z[lc++]="#    but WITHOUT ANY WARRANTY; without even the implied warranty of";
  z[lc++]="#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the";
  z[lc++]="#    GNU General Public License for more details.";
  z[lc++]="#";
  z[lc++]="#    You should have received a copy of the GNU General Public License";
  z[lc++]="#    along with this program; if not, write to the Free Software";
  z[lc++]="#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="#define ASYSIO_LINUX   0";
  z[lc++]="#define ASYSIO_FREEBSD 1";
  z[lc++]="";
  z[lc++]="#define ASYSIO_OSTYPE  ASYSIO_FREEBSD";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                linux audio driver for sfront                 */ ";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="/**************************************************/";
  z[lc++]="/* define flags for fifo mode, and for a timer to */";
  z[lc++]="/* catch SAOL infinite loops                      */";
  z[lc++]="/**************************************************/";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && (ASYSIO_OSTYPE == ASYSIO_LINUX) && \\";
  z[lc++]="     defined(CSYS_CDRIVER_LINMIDI) && (ASYS_TIMEOPTION == ASYS_TIMESYNC) && \\";
  z[lc++]="     !defined(ASYS_HASINPUT))";
  z[lc++]="#define ASYSIO_USEFIFO 1";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && (ASYSIO_OSTYPE == ASYSIO_LINUX) && \\";
  z[lc++]="    (ASYS_TIMEOPTION != ASYS_TIMESYNC))";
  z[lc++]="#define ASYSIO_USEFIFO 1";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#ifndef ASYSIO_USEFIFO";
  z[lc++]="#define ASYSIO_USEFIFO 0";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/**************************************************/";
  z[lc++]="/* include headers, based on flags set above      */";
  z[lc++]="/**************************************************/";
  z[lc++]="";
  z[lc++]="#include <unistd.h>";
  z[lc++]="#include <sys/ioctl.h>";
  z[lc++]="#include <fcntl.h>";
  z[lc++]="";
  z[lc++]="#if (ASYSIO_OSTYPE == ASYSIO_LINUX)";
  z[lc++]="#include <sys/soundcard.h>";
  z[lc++]="#include <endian.h>";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (ASYSIO_OSTYPE == ASYSIO_FREEBSD)";
  z[lc++]="#include <machine/soundcard.h>";
  z[lc++]="#include <machine/endian.h>";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#include <signal.h>  ";
  z[lc++]="#include <sys/time.h>  ";
  z[lc++]="";
  z[lc++]="#if ASYSIO_USEFIFO";
  z[lc++]="#include <sched.h>  ";
  z[lc++]="#if (ASYS_TIMEOPTION == ASYS_TIMESYNC)";
  z[lc++]="#include <time.h>";
  z[lc++]="#endif";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/******************************/";
  z[lc++]="/* other constant definitions */";
  z[lc++]="/******************************/";
  z[lc++]="";
  z[lc++]="#ifndef ASYSIO_DSPDEV";
  z[lc++]="#define ASYSIO_DSPDEV \"/dev/dsp\"";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/* determines native audio format */";
  z[lc++]="";
  z[lc++]="#if (BYTE_ORDER == BIG_ENDIAN)";
  z[lc++]="# define ASYSIO_AFORMAT AFMT_S16_BE";
  z[lc++]="#else";
  z[lc++]="# if (BYTE_ORDER == LITTLE_ENDIAN)";
  z[lc++]="#  define ASYSIO_AFORMAT AFMT_S16_LE";
  z[lc++]="# else";
  z[lc++]="#  error \"BYTE_ORDER not defined?\"";
  z[lc++]="# endif";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/* codes for IO types */";
  z[lc++]="";
  z[lc++]="#define ASYSIO_I  0";
  z[lc++]="#define ASYSIO_O  1";
  z[lc++]="#define ASYSIO_IO 2";
  z[lc++]="";
  z[lc++]="/* minimum fragment size */";
  z[lc++]="";
  z[lc++]="#define ASYSIO_FRAGMIN    16";
  z[lc++]="#define ASYSIO_LOGFRAGMIN 4";
  z[lc++]="";
  z[lc++]="/* number of silence buffers */";
  z[lc++]="";
  z[lc++]="#define ASYSO_LNUMBUFF 4";
  z[lc++]="";
  z[lc++]="/* maximum number of I/O retries before termination */";
  z[lc++]="";
  z[lc++]="#define ASYSIO_MAXRETRY 256";
  z[lc++]="";
  z[lc++]="#if ASYSIO_USEFIFO                      /* SCHED_FIFO constants for ksync()  */";
  z[lc++]="";
  z[lc++]="#if (ASYS_TIMEOPTION == ASYS_TIMESYNC)";
  z[lc++]="#define ASYSIO_SYNC_TIMEOUT    5        /* idle time to leave SCHED_FIFO     */";
  z[lc++]="#define ASYSIO_SYNC_ACTIVE     0        /* machine states for noteon timeout */";
  z[lc++]="#define ASYSIO_SYNC_WAITING    1";
  z[lc++]="#define ASYSIO_SYNC_SCHEDOTHER 2";
  z[lc++]="#else";
  z[lc++]="#define ASYSIO_MAXBLOCK ((int)KRATE)*2  /* max wait tor let SCHED_OTHERs run */";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/************************/";
  z[lc++]="/* variable definitions */";
  z[lc++]="/************************/";
  z[lc++]="";
  z[lc++]="int  asysio_fd;                    /* device pointer */";
  z[lc++]="long asysio_srate;                 /* sampling rate */";
  z[lc++]="long asysio_channels;              /* number of channels */";
  z[lc++]="long asysio_size;                  /* # samples in a buffer */";
  z[lc++]="long asysio_bsize;                 /* actual # bytes in a buffer */            ";
  z[lc++]="long asysio_requested_bsize;       /* requested # bytes in a buffer */        ";
  z[lc++]="long asysio_input;                 /* 1 if ASYSIO */";
  z[lc++]="long asysio_blocktime;             /* time (in bytes) blocked in kcycle */";
  z[lc++]="";
  z[lc++]="struct count_info asysio_ptr;      /* for GET{I,O}*PTR  ioctl calls */";
  z[lc++]="struct audio_buf_info asysio_info; /* for GET{I,O}SPACE ioctl calls */";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="short * asyso_buf = NULL;          /* output buffer */";
  z[lc++]="int asysio_puts;                   /* total number of putbufs */";
  z[lc++]="int asysio_reset;                  /* flags an overrun */";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="short * asysi_buf = NULL;          /* input buffer */";
  z[lc++]="struct audio_buf_info asysi_info;  /* input dma status */";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="sigset_t asysio_iloop_mask;            /* for masking off iloop interrupt */";
  z[lc++]="struct sigaction asysio_iloop_action;  /* for setting up iloop interrupt  */";
  z[lc++]="struct itimerval asysio_iloop_timer;   /* for setting up iloop timer      */";
  z[lc++]="";
  z[lc++]="#if ASYSIO_USEFIFO ";
  z[lc++]="int asysio_fifo;                       /* can get into sched_fifo mode */";
  z[lc++]="struct sched_param asysio_fifoparam;   /* param block for fifo mode */";
  z[lc++]="struct sched_param asysio_otherparam;  /* param block for other mode */";
  z[lc++]="";
  z[lc++]="#if (ASYS_TIMEOPTION == ASYS_TIMESYNC)";
  z[lc++]="";
  z[lc++]="/* state machine variables for noteon timeout */";
  z[lc++]="int    asysio_sync_state;";
  z[lc++]="time_t asysio_sync_waitstart;";
  z[lc++]="extern int csysi_newnote;       /* from linmidi */";
  z[lc++]="";
  z[lc++]="#else";
  z[lc++]="";
  z[lc++]="/* state to detect long periods w/o blocking */";
  z[lc++]="int asysio_sync_noblock;                /* how many acycles since last block */";
  z[lc++]="struct timespec asysio_sync_sleeptime;  /* time to wait during forced block  */";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_KSYNC)                      /* ksync() state */";
  z[lc++]="struct count_info asysio_sync_ptr;           ";
  z[lc++]="int asysio_sync_target, asysio_sync_incr;    ";
  z[lc++]="float asysio_sync_cpuscale;                  ";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                      shutdown routines                       */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                    shuts down soundcard                      */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asysio_shutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (ioctl(asysio_fd, SNDCTL_DSP_SYNC, 0) == -1)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"\\nSoundcard Error: SNDCTL_DSP_SYNC Ioctl Problem\\n\");";
  z[lc++]="      fprintf(stderr, \"Errno Message: %s\\n\\n\", strerror(errno));";
  z[lc++]="    }";
  z[lc++]="  close(asysio_fd);";
  z[lc++]="";
  z[lc++]="  /* so that a slow exit doesn't trigger timer */";
  z[lc++]="";
  z[lc++]="  asysio_iloop_timer.it_value.tv_sec = 0;";
  z[lc++]="  asysio_iloop_timer.it_value.tv_usec = 0;";
  z[lc++]="  asysio_iloop_timer.it_interval.tv_sec = 0;";
  z[lc++]="  asysio_iloop_timer.it_interval.tv_usec = 0;";
  z[lc++]="  ";
  z[lc++]="  if (setitimer(ITIMER_PROF, &asysio_iloop_timer, NULL) < 0)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"\\nSoundcard Driver Error:\\n\\n\");";
  z[lc++]="      fprintf(stderr, \"  Couldn't set up ITIMER_PROF timer.\\n\");";
  z[lc++]="      fprintf(stderr, \"  Errno Message: %s\\n\\n\", strerror(errno));";
  z[lc++]="    }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(!defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                    shuts down audio output                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_oshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysio_shutdown();";
  z[lc++]="  if (asyso_buf != NULL)";
  z[lc++]="    free(asyso_buf);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                    shuts down audio input                    */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ishutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysio_shutdown();  ";
  z[lc++]="  if (asysi_buf != NULL)";
  z[lc++]="    free(asysi_buf);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input and output               */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ioshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysio_shutdown();";
  z[lc++]="  if (asyso_buf != NULL)";
  z[lc++]="    free(asyso_buf);";
  z[lc++]="  if (asysi_buf != NULL)";
  z[lc++]="    free(asysi_buf);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                 initialization routines                      */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*          generic error-checking ioctl wrapper                */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="#define ASYSIO_IOCTL_CALL(x,y,z)  do { if (ioctl(x,y,z) == -1){\\";
  z[lc++]="      fprintf(stderr, \"  Error: %s Ioctl Problem\\n\", #y ); \\";
  z[lc++]="      fprintf(stderr, \"  Errno Message: %s\\n\\n\", strerror(errno));\\";
  z[lc++]="      close(asysio_fd); return ASYS_ERROR;}} while (0)";
  z[lc++]="";
  z[lc++]="#define  ASYSIO_ERROR_RETURN(x) do {\\";
  z[lc++]="      fprintf(stderr, \"  Error: %s.\\n\", x);\\";
  z[lc++]="      fprintf(stderr, \"  Errno Message: %s\\n\\n\", strerror(errno));\\";
  z[lc++]="      close(asysio_fd);\\";
  z[lc++]="      return ASYS_ERROR; } while (0)";
  z[lc++]="";
  z[lc++]="#define  ASYSIO_ERROR_RETURN_NOERRNO(x) do {\\";
  z[lc++]="      fprintf(stderr, \"  Error: %s.\\n\", x);\\";
  z[lc++]="      close(asysio_fd);\\";
  z[lc++]="      return ASYS_ERROR; } while (0)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               opens the soudcard device                      */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysio_opendevice(int dir, int toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  switch(dir) {";
  z[lc++]="  case ASYSIO_I:";
  z[lc++]="    asysio_fd = open(ASYSIO_DSPDEV, O_RDONLY, 0);";
  z[lc++]="    asysio_input = 1;";
  z[lc++]="    break;";
  z[lc++]="  case ASYSIO_O:";
  z[lc++]="    asysio_fd = open(ASYSIO_DSPDEV, O_WRONLY, 0);";
  z[lc++]="    asysio_input = 0;";
  z[lc++]="    break;";
  z[lc++]="  case ASYSIO_IO:";
  z[lc++]="    asysio_fd = open(ASYSIO_DSPDEV, O_RDWR, 0);";
  z[lc++]="    asysio_input = 1;";
  z[lc++]="    break;";
  z[lc++]="  default:";
  z[lc++]="    fprintf(stderr, \"  Error: Unexpected dir parameter value in \\n\");";
  z[lc++]="    fprintf(stderr, \"         asysio_setup.\\n\\n\");";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="  if (asysio_fd == -1)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"  Error: Can't open device %s (%s)\\n\\n\", ASYSIO_DSPDEV,";
  z[lc++]="	      strerror(errno));";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*         signal handler for trapping SAOL infinite loops      */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asysio_iloop_handler(int signum) ";
  z[lc++]="{   ";
  z[lc++]="  fprintf(stderr, \"  Error: Either\\n\\n\");";
  z[lc++]="  fprintf(stderr, \"    [1] The SAOL program has an infinite loop in it, or\\n\");";
  z[lc++]="  fprintf(stderr, \"    [2] Content is too complex for real-time work.\\n\\n\");";
  z[lc++]="  fprintf(stderr, \"  Exiting program ...\\n\\n\");";
  z[lc++]="  exit(0);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*         initializes iloop (heartbeat) interrupt              */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysio_initiloop(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  /*********************************************************/";
  z[lc++]="  /* set up signal handler for infinite-loop (iloop) timer */";
  z[lc++]="  /*********************************************************/";
  z[lc++]="  ";
  z[lc++]="  if (sigemptyset(&asysio_iloop_action.sa_mask) < 0)";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Couldn't run sigemptyset(iloop) OS call\");";
  z[lc++]="";
  z[lc++]="  /* infinite-loop timer wins over midi overrun timer */";
  z[lc++]="";
  z[lc++]="  if (sigaddset(&asysio_iloop_action.sa_mask, SIGALRM) < 0)";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Couldn't run sigaddset(iloop) OS call\");";
  z[lc++]="";
  z[lc++]="  asysio_iloop_action.sa_flags = SA_RESTART;";
  z[lc++]="  asysio_iloop_action.sa_handler = asysio_iloop_handler;";
  z[lc++]="  ";
  z[lc++]="  if (sigaction(SIGPROF, &asysio_iloop_action, NULL) < 0)";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Couldn't set up SIGPROF signal handler\");";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="  /************************/";
  z[lc++]="  /* set up timer and arm */";
  z[lc++]="  /************************/";
  z[lc++]="";
  z[lc++]="  asysio_iloop_timer.it_value.tv_sec = 3;";
  z[lc++]="  asysio_iloop_timer.it_value.tv_usec = 0;";
  z[lc++]="  asysio_iloop_timer.it_interval.tv_sec = 0;";
  z[lc++]="  asysio_iloop_timer.it_interval.tv_usec = 0;";
  z[lc++]="";
  z[lc++]="  if (setitimer(ITIMER_PROF, &asysio_iloop_timer, NULL) < 0)";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Couldn't set up ITIMER_PROF timer\");";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 initializes sched_fifo                       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysio_initscheduler(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="#if ASYSIO_USEFIFO";
  z[lc++]="";
  z[lc++]="  /*******************************/";
  z[lc++]="  /* set up sched_fifo variables */";
  z[lc++]="  /*******************************/";
  z[lc++]="";
  z[lc++]="  memset(&asysio_otherparam, 0, sizeof(struct sched_param));";
  z[lc++]="  memset(&asysio_fifoparam, 0, sizeof(struct sched_param));";
  z[lc++]=" ";
  z[lc++]="  if ((asysio_fifoparam.sched_priority =";
  z[lc++]="       sched_get_priority_max(SCHED_FIFO)) < 0)";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Couldn't get scheduling priority\");";
  z[lc++]="";
  z[lc++]="  asysio_fifoparam.sched_priority--;";
  z[lc++]="";
  z[lc++]="  /********************************/";
  z[lc++]="  /* try to enter sched-fifo mode */";
  z[lc++]="  /********************************/";
  z[lc++]="";
  z[lc++]="  asysio_fifo = !sched_setscheduler(0, SCHED_FIFO, &asysio_fifoparam);";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                 prints startup screen                        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysio_screenwriter(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i, found;";
  z[lc++]="  int haslinmidi = 0;";
  z[lc++]="  float actual_latency;";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="  fprintf(stderr, \"%s \",  (ASYS_LATENCYTYPE == ASYS_HIGHLATENCY)? ";
  z[lc++]="	  \"Streaming\" : \"Interactive\");";
  z[lc++]="";
  z[lc++]="  fprintf(stderr, \"%s Audio \", (asysio_channels == 2) ? \"Stereo\" : \"Mono\");";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="  fprintf(stderr, \"%s\", asysio_input ? \"Input/Output\" : \"Output\");";
  z[lc++]="#else";
  z[lc++]="  fprintf(stderr, \"Input\");";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  found = i = 0;";
  z[lc++]="  while (i < csys_sfront_argc)";
  z[lc++]="    {";
  z[lc++]="      if (!(strcmp(csys_sfront_argv[i],\"-bitc\") && ";
  z[lc++]="	    strcmp(csys_sfront_argv[i],\"-bit\") &&";
  z[lc++]="	    strcmp(csys_sfront_argv[i],\"-orc\")))";
  z[lc++]="	{";
  z[lc++]="	  i++;";
  z[lc++]="	  fprintf(stderr, \" for %s\", csys_sfront_argv[i]);";
  z[lc++]="	  found = 1;";
  z[lc++]="	  break;";
  z[lc++]="	}";
  z[lc++]="      i++;";
  z[lc++]="    }";
  z[lc++]="  if (!found)";
  z[lc++]="    fprintf(stderr, \" for UNKNOWN\");";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="  i = 0;";
  z[lc++]="  while (i < csys_sfront_argc)";
  z[lc++]="    {";
  z[lc++]="      if (!strcmp(csys_sfront_argv[i],\"-cin\"))";
  z[lc++]="	{";
  z[lc++]="	  i++;";
  z[lc++]="	  fprintf(stderr, \" (-cin %s)\", csys_sfront_argv[i]);";
  z[lc++]="	  break;";
  z[lc++]="	}";
  z[lc++]="      i++;";
  z[lc++]="    }";
  z[lc++]="  fprintf(stderr, \"\\n\\n\");";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(CSYS_CDRIVER_LINMIDI)";
  z[lc++]="";
  z[lc++]="  haslinmidi = 1;";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(CSYS_CDRIVER_LINMIDI) || defined(CSYS_CDRIVER_ALSAMIDI)\\";
  z[lc++]="      || defined(CSYS_CDRIVER_ALSASEQ) || defined(CSYS_CDRIVER_ASCII))";
  z[lc++]="";
  z[lc++]="  /* list midi presets available */";
  z[lc++]="";
  z[lc++]="  fprintf(stderr, ";
  z[lc++]="	  \"MIDI Preset Numbers (use MIDI controller to select):\\n\\n\");";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < CSYS_PRESETNUM; i++)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"%3i. %s\", ";
  z[lc++]="	      csys_presets[i].preset,";
  z[lc++]="	      csys_instr[csys_presets[i].index].name);";
  z[lc++]="      if ((i&1))";
  z[lc++]="	fprintf(stderr, \"\\n\");";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  fprintf(stderr, \"\\t\\t\");";
  z[lc++]="	  if (i == (CSYS_PRESETNUM-1))";
  z[lc++]="	    fprintf(stderr, \"\\n\");";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  fprintf(stderr, \"\\n\");";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(CSYS_CDRIVER_ASCII)";
  z[lc++]="";
  z[lc++]="  fprintf(stderr, ";
  z[lc++]="  \"To play tunes on ASCII keyboard: a-z for notes, 0-9 for MIDI presets,\\n\");";
  z[lc++]="  fprintf(stderr, ";
  z[lc++]="  \"cntrl-C exits. If autorepeat interferes, exit and run 'xset -r' (in X).\\n\\n\");";
  z[lc++]="  ";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  /* diagnose best flags to use, and if they are used */";
  z[lc++]="";
  z[lc++]="#ifdef ASYS_HASOUTPUT";
  z[lc++]="";
  z[lc++]="  if ((ASYS_LATENCYTYPE == ASYS_HIGHLATENCY) || asysio_input ||";
  z[lc++]="      (!haslinmidi))";
  z[lc++]="    {";
  z[lc++]="      if (geteuid() || (ASYS_TIMEOPTION == ASYS_TIMESYNC))";
  z[lc++]="	{";
  z[lc++]="	  fprintf(stderr, \"For best results, make these changes:\\n\"); ";
  z[lc++]="	  fprintf(stderr, \"\\n\");";
  z[lc++]="	  if (ASYS_TIMEOPTION == ASYS_TIMESYNC)";
  z[lc++]="	    fprintf(stderr, \"   * Remove sfront -timesync flag\\n\");";
  z[lc++]="	  if (geteuid())";
  z[lc++]="	    fprintf(stderr, \"   * Run sa.c executable as root.\\n\");";
  z[lc++]="	  fprintf(stderr, \"\\n\");";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"This application runs best as root (%s), with:\\n\",";
  z[lc++]="	      !geteuid() ? \"which you are\": \"which you aren't\"); ";
  z[lc++]="      fprintf(stderr, \"\\n\");";
  z[lc++]="      fprintf(stderr, \"  [1] Sfront -playback flag. Good audio quality, keeps\\n\");";
  z[lc++]="      fprintf(stderr, \"      the mouse/kbd alive\");";
  z[lc++]="      fprintf(stderr, \"%s.\\n\", (ASYS_TIMEOPTION == ASYS_PLAYBACK) ?";
  z[lc++]="	      \" (currently chosen)\":\"\");";
  z[lc++]="      fprintf(stderr, \"  [2] Sfront -timesync flag. Better quality, console\\n\");";
  z[lc++]="      fprintf(stderr, \"      freezes during MIDI input\");";
  z[lc++]="      fprintf(stderr, \"%s.\\n\", (ASYS_TIMEOPTION == ASYS_TIMESYNC) ?";
  z[lc++]="	      \" (currently chosen)\":\"\");";
  z[lc++]="      fprintf(stderr, \"\\n\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  /* latency information */";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT))";
  z[lc++]="";
  z[lc++]="  ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOSPACE, &asysio_info);";
  z[lc++]="";
  z[lc++]="  fprintf(stderr, \"If audio artifacts still occur, try\");";
  z[lc++]="  ";
  z[lc++]="  actual_latency = ATIME*ASYSO_LNUMBUFF*(asysio_size >> (asysio_channels - 1));";
  z[lc++]="  ";
  z[lc++]="  if (asysio_info.fragstotal < ASYSO_LNUMBUFF)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \" sfront -latency %f flag, and see\\n\", ";
  z[lc++]="	      0.5F*actual_latency);";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \" sfront -latency %f flag, and see\\n\", ";
  z[lc++]="	      2.0F*actual_latency);";
  z[lc++]="";
  z[lc++]="    }";
  z[lc++]="  if (ASYS_LATENCYTYPE == ASYS_LOWLATENCY)";
  z[lc++]="    fprintf(stderr, \"http://www.cs.berkeley.edu/\"";
  z[lc++]="	    \"~lazzaro/sa/sfman/user/use/index.html#interact\\n\") ;";
  z[lc++]="  else";
  z[lc++]="    fprintf(stderr, \"http://www.cs.berkeley.edu/\"";
  z[lc++]="	    \"~lazzaro/sa/sfman/user/use/index.html#stream\\n\") ;";
  z[lc++]="";
  z[lc++]="  fprintf(stderr, \"\\n\");";
  z[lc++]="";
  z[lc++]="  if ((asysio_bsize != ASYSIO_FRAGMIN) &&";
  z[lc++]="      (asysio_bsize == asysio_requested_bsize) && ";
  z[lc++]="      (ASYS_LATENCYTYPE == ASYS_LOWLATENCY))";
  z[lc++]="  {";
  z[lc++]="    fprintf(stderr, \"If interactive response is slow, try \");";
  z[lc++]="    fprintf(stderr, \"sfront -latency %f flag.\\n\", 0.5F*actual_latency);";
  z[lc++]="    fprintf(stderr, \"\\n\");";
  z[lc++]="  }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  fprintf(stderr, ";
  z[lc++]="  \"USE AT YOUR OWN RISK. Running as root may damage your file system,\\n\");";
  z[lc++]="  fprintf(stderr, ";
  z[lc++]="  \"and network use may result in a malicious attack on your machine.\\n\\n\");";
  z[lc++]="";
  z[lc++]="#if (ASYSIO_USEFIFO && (ASYS_TIMEOPTION == ASYS_TIMESYNC))";
  z[lc++]="";
  z[lc++]="  if (!geteuid())";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, ";
  z[lc++]="      \"NOTE: Mouse and keyboard are frozen for %i seconds after a MIDI\\n\",";
  z[lc++]="	      ASYSIO_SYNC_TIMEOUT);";
  z[lc++]="      fprintf(stderr, ";
  z[lc++]="	      \"NoteOn or NoteOff is received. Do not be alarmed.\\n\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  if (NSYS_NET)";
  z[lc++]="    fprintf(stderr, \"Network status: Contacting SIP server\\n\");";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        setup operations common to input and output           */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysio_setup(long srate, long channels, int dir, int toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  long i, j, maxfrag;";
  z[lc++]="";
  z[lc++]="  /******************/";
  z[lc++]="  /* open soundcard */";
  z[lc++]="  /******************/";
  z[lc++]="";
  z[lc++]="  if (asysio_opendevice(dir, toption) == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  ";
  z[lc++]="  /**************************************/";
  z[lc++]="  /* set up bidirectional I/O if needed */";
  z[lc++]="  /**************************************/";
  z[lc++]="";
  z[lc++]="  if (dir == ASYSIO_IO)";
  z[lc++]="    {";
  z[lc++]="";
  z[lc++]="#if (ASYSIO_OSTYPE != ASYSIO_FREEBSD)";
  z[lc++]="";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_SETDUPLEX, 0);";
  z[lc++]="";
  z[lc++]="#endif ";
  z[lc++]="";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETCAPS, &j);";
  z[lc++]="";
  z[lc++]="      if (!(j & DSP_CAP_DUPLEX))";
  z[lc++]="	ASYSIO_ERROR_RETURN_NOERRNO(\"Sound card can't do bidirectional audio\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /************************/";
  z[lc++]="  /* range check channels */";
  z[lc++]="  /************************/";
  z[lc++]="";
  z[lc++]="  if (channels > 2)";
  z[lc++]="    ASYSIO_ERROR_RETURN_NOERRNO(\"Sound card can't handle > 2 channels\");";
  z[lc++]="";
  z[lc++]="  /*********************/";
  z[lc++]="  /* set fragment size */";
  z[lc++]="  /*********************/";
  z[lc++]="";
  z[lc++]="  j = ASYSIO_LOGFRAGMIN;";
  z[lc++]="  i = ASYSIO_FRAGMIN >> channels;   /* only works for channels = 1, 2 */";
  z[lc++]="";
  z[lc++]="  /* find closest power-of-two fragment size to latency request */";
  z[lc++]="";
  z[lc++]="  while (2*ATIME*i*ASYSO_LNUMBUFF < ASYS_LATENCY)";
  z[lc++]="    {";
  z[lc++]="      i <<= 1;";
  z[lc++]="      j++;";
  z[lc++]="    }";
  z[lc++]="  if ((ATIME*2*i*ASYSO_LNUMBUFF - ASYS_LATENCY) < ";
  z[lc++]="      (ASYS_LATENCY - ATIME*i*ASYSO_LNUMBUFF))";
  z[lc++]="    {";
  z[lc++]="      i <<= 1;";
  z[lc++]="      j++;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  asysio_requested_bsize = 2*i*channels;";
  z[lc++]="";
  z[lc++]="  maxfrag = (ASYS_TIMEOPTION != ASYS_TIMESYNC) ? ASYSO_LNUMBUFF :";
  z[lc++]="             ASYSO_LNUMBUFF + ((ACYCLE/i) + 1);";
  z[lc++]="";
  z[lc++]="  j |= (maxfrag << 16);";
  z[lc++]="  ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_SETFRAGMENT, &j);";
  z[lc++]="";
  z[lc++]="  /********************/";
  z[lc++]="  /* set audio format */";
  z[lc++]="  /********************/";
  z[lc++]="";
  z[lc++]="  j = ASYSIO_AFORMAT;";
  z[lc++]="  ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_SETFMT, &j);";
  z[lc++]="";
  z[lc++]="  if (j != ASYSIO_AFORMAT)";
  z[lc++]="    ASYSIO_ERROR_RETURN_NOERRNO(\"Soundcard can't handle native shorts\");";
  z[lc++]="";
  z[lc++]="  /****************************************************/";
  z[lc++]="  /* set number of channels -- later add channels > 2 */";
  z[lc++]="  /****************************************************/";
  z[lc++]="";
  z[lc++]="  asysio_channels = channels--;";
  z[lc++]="  ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_STEREO, &channels);";
  z[lc++]="";
  z[lc++]="  if (channels != (asysio_channels-1))";
  z[lc++]="    ASYSIO_ERROR_RETURN_NOERRNO(\"Soundcard can't handle number of channels\");";
  z[lc++]="";
  z[lc++]="  /*********************/";
  z[lc++]="  /* set sampling rate */";
  z[lc++]="  /*********************/";
  z[lc++]="";
  z[lc++]="  asysio_srate = srate;";
  z[lc++]="  ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_SPEED, &srate);";
  z[lc++]="";
  z[lc++]="  if (abs(asysio_srate - srate) > 1000)";
  z[lc++]="    ASYSIO_ERROR_RETURN_NOERRNO(\"Soundcard can't handle sampling rate\");";
  z[lc++]="";
  z[lc++]="  /******************************/";
  z[lc++]="  /* compute actual buffer size */";
  z[lc++]="  /******************************/";
  z[lc++]="";
  z[lc++]="  ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETBLKSIZE, &asysio_bsize);";
  z[lc++]="  asysio_size = asysio_bsize >> 1;";
  z[lc++]="";
  z[lc++]="  /*************************/";
  z[lc++]="  /* print out info screen */";
  z[lc++]="  /*************************/";
  z[lc++]="";
  z[lc++]="  if (asysio_screenwriter() == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  /*********************************/";
  z[lc++]="  /* set SCHED_FIFO if appropriate */";
  z[lc++]="  /*********************************/";
  z[lc++]="";
  z[lc++]="  if (asysio_initscheduler() == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  /**********************************/";
  z[lc++]="  /* set up iloop (heartbeat) timer */";
  z[lc++]="  /**********************************/";
  z[lc++]="";
  z[lc++]="  if (asysio_initiloop() == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && !defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio output for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_osetup(long srate, long ochannels, long osample, ";
  z[lc++]="                char * oname, long toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (asysio_setup(srate, ochannels, ASYSIO_O, toption) == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (!(asyso_buf = (short *)calloc(asysio_size, sizeof(short))))";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Can't allocate output buffer\");";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio input for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_isetup(long srate, long ichannels, long isample, ";
  z[lc++]="                char * iname, long toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (asysio_setup(srate, ichannels, ASYSIO_I, toption) == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if (!(asysi_buf = (short *)malloc(asysio_bsize)))";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Can't allocate input buffer\");";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*   sets up audio input and output for a given srate/channels  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_iosetup(long srate, long ichannels, long ochannels,";
  z[lc++]="                 long isample, long osample, ";
  z[lc++]="                 char * iname, char * oname, long toption)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  if (ichannels != ochannels)";
  z[lc++]="    ASYSIO_ERROR_RETURN_NOERRNO";
  z[lc++]="      (\"Soundcard needs SAOL inchannels == outchannels\");";
  z[lc++]="";
  z[lc++]="  if (asysio_setup(srate, ichannels, ASYSIO_IO, toption) == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (!(asysi_buf = (short *)malloc(asysio_bsize)))";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Can't allocate input buffer\");";
  z[lc++]="";
  z[lc++]="  if (!(asyso_buf = (short *)calloc(asysio_size, sizeof(short))))";
  z[lc++]="    ASYSIO_ERROR_RETURN(\"Can't allocate output buffer\");";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*            input, output, and recovery routines              */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               gets one frame of audio from input             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_getbuf(ASYS_ITYPE * asys_ibuf[], long * isize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  long diffcompute, starttime;";
  z[lc++]="  long size, recv, bptr, retry;";
  z[lc++]="";
  z[lc++]="  *isize = asysio_size;";
  z[lc++]="";
  z[lc++]="  if (*asys_ibuf == NULL)";
  z[lc++]="    *asys_ibuf = asysi_buf;";
  z[lc++]="";
  z[lc++]="  ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETISPACE, &asysio_info);";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="  if (diffcompute = (asysio_info.bytes < asysio_bsize))";
  z[lc++]="    {  ";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOPTR, &asysio_ptr);";
  z[lc++]="      starttime = asysio_ptr.bytes;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  retry = bptr = 0;";
  z[lc++]="  size = asysio_bsize;";
  z[lc++]="";
  z[lc++]="  while ((recv = read(asysio_fd, &((*asys_ibuf)[bptr]), size)) != size)";
  z[lc++]="    {      ";
  z[lc++]="      if (++retry > ASYSIO_MAXRETRY)";
  z[lc++]="	ASYSIO_ERROR_RETURN(\"Too many I/O retries -- asys_getbuf\");";
  z[lc++]="";
  z[lc++]="      if (recv < 0)  /* errors */";
  z[lc++]="	{";
  z[lc++]="	  if ((errno == EAGAIN) || (errno == EINTR))";
  z[lc++]="	    continue;   ";
  z[lc++]="	  else";
  z[lc++]="	    ASYSIO_ERROR_RETURN(\"Read error on output audio device\");";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  bptr += recv; /* partial read */";
  z[lc++]="	  size -= recv;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="  if (diffcompute)";
  z[lc++]="    {  ";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOPTR, &asysio_ptr);";
  z[lc++]="      asysio_blocktime += (asysio_ptr.bytes - starttime);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               sends one frame of audio to output             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_putbuf(ASYS_OTYPE * asys_obuf[], long * osize)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  long size, sent, bptr, retry;";
  z[lc++]="  long diffcompute, starttime;";
  z[lc++]="";
  z[lc++]="  size = (*osize)*2;";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="  if (asysio_reset)";
  z[lc++]="    return ASYS_DONE;";
  z[lc++]="";
  z[lc++]="  ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOSPACE, &asysio_info);";
  z[lc++]="";
  z[lc++]="  asysio_reset = (++asysio_puts > ASYSO_LNUMBUFF) && ";
  z[lc++]="    (asysio_info.fragments == asysio_info.fragstotal);";
  z[lc++]="  if (asysio_reset)";
  z[lc++]="    return ASYS_DONE;";
  z[lc++]="";
  z[lc++]="#if (ASYS_TIMEOPTION != ASYS_TIMESYNC)";
  z[lc++]="";
  z[lc++]="  if (diffcompute = (asysio_info.bytes < size))";
  z[lc++]="    {  ";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOPTR, &asysio_ptr);";
  z[lc++]="      starttime = asysio_ptr.bytes;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  retry = bptr = 0;";
  z[lc++]="  while ((sent = write(asysio_fd, &((*asys_obuf)[bptr]), size)) != size)";
  z[lc++]="    {";
  z[lc++]="      if (++retry > ASYSIO_MAXRETRY)";
  z[lc++]="	ASYSIO_ERROR_RETURN(\"Too many I/O retries -- asys_putbuf\");";
  z[lc++]="";
  z[lc++]="      if (sent < 0)  /* errors */";
  z[lc++]="	{";
  z[lc++]="	  if ((errno == EAGAIN) || (errno == EINTR))";
  z[lc++]="	    continue;   ";
  z[lc++]="	  else";
  z[lc++]="	    ASYSIO_ERROR_RETURN(\"Write error on output audio device\");";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  bptr += sent;  /* partial write */";
  z[lc++]="	  size -= sent;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#if (ASYS_TIMEOPTION != ASYS_TIMESYNC)";
  z[lc++]="";
  z[lc++]="  if (diffcompute)";
  z[lc++]="    {  ";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOPTR, &asysio_ptr);";
  z[lc++]="      asysio_blocktime += (asysio_ptr.bytes - starttime);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  *osize = asysio_size;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        creates buffer, and generates starting silence        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_preamble(ASYS_OTYPE * asys_obuf[], long * osize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  *asys_obuf = asyso_buf;";
  z[lc++]="  *osize = asysio_size;";
  z[lc++]="";
  z[lc++]="  for(i = 0; i < ASYSO_LNUMBUFF; i++)";
  z[lc++]="    if (asys_putbuf(asys_obuf, osize) == ASYS_ERROR)";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               recovers from an overrun                       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysio_recover(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  long size, recv, bptr, retry;";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  asysio_reset = 0;";
  z[lc++]="";
  z[lc++]="  memset(asyso_buf, 0, asysio_bsize);";
  z[lc++]="";
  z[lc++]="  /*************************/";
  z[lc++]="  /* flush input if needed */";
  z[lc++]="  /*************************/";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="  ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETISPACE, &asysi_info);";
  z[lc++]="  ";
  z[lc++]="  while (asysi_info.fragments > 0)";
  z[lc++]="    {";
  z[lc++]="      retry = bptr = 0;";
  z[lc++]="      size = asysio_bsize;";
  z[lc++]="";
  z[lc++]="      while ((recv = read(asysio_fd, &(asysi_buf[bptr]), size)) != size)";
  z[lc++]="	{      ";
  z[lc++]="	  if (++retry > ASYSIO_MAXRETRY)";
  z[lc++]="	    ASYSIO_ERROR_RETURN(\"Too many I/O retries -- asysio_recover\");";
  z[lc++]="";
  z[lc++]="	  if (recv < 0)  /* errors */";
  z[lc++]="	    {";
  z[lc++]="	      if ((errno == EAGAIN) || (errno == EINTR))";
  z[lc++]="		continue;   ";
  z[lc++]="	      else";
  z[lc++]="		ASYSIO_ERROR_RETURN(\"Read error on output audio device\");";
  z[lc++]="	    }";
  z[lc++]="	  else";
  z[lc++]="	    {";
  z[lc++]="	      bptr += recv; /* partial read */";
  z[lc++]="	      size -= recv;";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETISPACE, &asysi_info);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  ibusidx = 0;";
  z[lc++]="  if (asys_getbuf(&asys_ibuf, &asys_isize)==ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  /**************************************/";
  z[lc++]="  /* fill latency interval with silence */ ";
  z[lc++]="  /**************************************/";
  z[lc++]="";
  z[lc++]="  asysio_puts = 0;";
  z[lc++]="  for(i = 0; i < ASYSO_LNUMBUFF; i++)";
  z[lc++]="    if (asys_putbuf(&asyso_buf, &asysio_size) == ASYS_ERROR)";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*        ksync() system for time synchronization          */ ";
  z[lc++]="/*_________________________________________________________*/";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_KSYNC)";
  z[lc++]="";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*         initializes k-rate boundaries sync              */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="void ksyncinit()";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysio_sync_target = asysio_sync_incr = ACYCLE*asysio_channels*2;  ";
  z[lc++]="  asysio_sync_cpuscale = 1.0F/asysio_sync_incr;";
  z[lc++]="";
  z[lc++]="  /* for -timesync, set up SCHED_FIFO watchdog state machine */";
  z[lc++]="";
  z[lc++]="#if (ASYSIO_USEFIFO && (ASYS_TIMEOPTION == ASYS_TIMESYNC))";
  z[lc++]="";
  z[lc++]="  if (asysio_fifo)";
  z[lc++]="";
  z[lc++]="    {";
  z[lc++]="      asysio_sync_state = ASYSIO_SYNC_SCHEDOTHER;";
  z[lc++]="      if (sched_setscheduler(0, SCHED_OTHER, &asysio_otherparam))";
  z[lc++]="	epr(0,NULL,NULL,\"internal error -- sched_other unavailable\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  /* elsewise, set up SCHED_FIFO monitor to force blocking */";
  z[lc++]="";
  z[lc++]="#if (ASYSIO_USEFIFO && (ASYS_TIMEOPTION != ASYS_TIMESYNC))";
  z[lc++]="";
  z[lc++]="  asysio_sync_noblock = 0;";
  z[lc++]="  asysio_sync_sleeptime.tv_sec = 0;";
  z[lc++]="  asysio_sync_sleeptime.tv_nsec = 2000001;  /* 2ms + epsilon forces block */";
  z[lc++]=" ";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*     different ksync()s for -timesync and -playback       */ ";
  z[lc++]="/*__________________________________________________________*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (ASYS_TIMEOPTION != ASYS_TIMESYNC)";
  z[lc++]="";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*         synchronizes on k-rate boundaries               */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="float ksync()";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  float ret;";
  z[lc++]="  long comptime;";
  z[lc++]="";
  z[lc++]="  if (asysio_reset)";
  z[lc++]="    {";
  z[lc++]="      if (asysio_recover()==ASYS_ERROR)";
  z[lc++]="	epr(0,NULL,NULL, \"Soundcard error -- failed recovery.\");";
  z[lc++]="      asysio_sync_target = asysio_sync_incr;";
  z[lc++]="      ret = 1.0F;";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOPTR, &asysio_sync_ptr);";
  z[lc++]="";
  z[lc++]="      if (asysio_sync_target == asysio_sync_incr)";
  z[lc++]="	ret = 0.0F;";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  comptime = asysio_sync_ptr.bytes - asysio_blocktime;";
  z[lc++]="	  if (comptime > asysio_sync_target)";
  z[lc++]="	    ret = 1.0F;";
  z[lc++]="	  else";
  z[lc++]="	    ret = (asysio_sync_cpuscale*";
  z[lc++]="		   (asysio_sync_incr - (asysio_sync_target - comptime)));";
  z[lc++]="	}";
  z[lc++]="      ";
  z[lc++]="      if ((asysio_sync_target = asysio_sync_incr + asysio_sync_ptr.bytes) < 0)";
  z[lc++]="	epr(0,NULL,NULL,\"Soundcard error -- rollover.\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  /* reset infinite-loop timer */";
  z[lc++]="";
  z[lc++]="  if (setitimer(ITIMER_PROF, &asysio_iloop_timer, NULL) < 0)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"  Runtime Errno Message: %s\\n\", strerror(errno));";
  z[lc++]="      epr(0,NULL,NULL, \"Soundcard error -- Couldn't reset ITIMER_PROF\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#if ASYSIO_USEFIFO";
  z[lc++]="";
  z[lc++]="  if (asysio_fifo)";
  z[lc++]="    {";
  z[lc++]="      /* let other processes run if pending too long */";
  z[lc++]="";
  z[lc++]="      if (asysio_blocktime)";
  z[lc++]="	asysio_sync_noblock = 0;";
  z[lc++]="      else";
  z[lc++]="	asysio_sync_noblock++;";
  z[lc++]="";
  z[lc++]="      if (asysio_sync_noblock > ASYSIO_MAXBLOCK)";
  z[lc++]="	{";
  z[lc++]="	  nanosleep(&asysio_sync_sleeptime, NULL); ";
  z[lc++]="	  asysio_sync_noblock = 0;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  asysio_blocktime = 0;";
  z[lc++]="  return ret;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (ASYS_TIMEOPTION == ASYS_TIMESYNC)";
  z[lc++]="";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*         synchronizes on k-rate boundaries               */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="float ksync()";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  float ret;";
  z[lc++]="  long comptime;";
  z[lc++]="";
  z[lc++]="  if (!asysio_reset)";
  z[lc++]="    {";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOPTR, &asysio_sync_ptr);";
  z[lc++]="      if (asysio_sync_ptr.bytes > asysio_sync_target)";
  z[lc++]="	{";
  z[lc++]="	  comptime = asysio_sync_ptr.bytes - asysio_blocktime;";
  z[lc++]="	  if (comptime < asysio_sync_target)";
  z[lc++]="	    ret = (asysio_sync_cpuscale*";
  z[lc++]="		   (asysio_sync_incr - (asysio_sync_target - comptime)));";
  z[lc++]="	  else";
  z[lc++]="	    ret = 1.0F;";
  z[lc++]="	  ret = (asysio_sync_target != asysio_sync_incr) ? ret : 0.0F;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{	  ";
  z[lc++]="	  comptime = asysio_sync_ptr.bytes - asysio_blocktime;";
  z[lc++]="	  ret = (asysio_sync_cpuscale*";
  z[lc++]="		 (asysio_sync_incr - (asysio_sync_target - comptime)));";
  z[lc++]="	  asysio_reset = asysio_input && ";
  z[lc++]="	    ((asysio_sync_target-asysio_sync_ptr.bytes) == asysio_sync_incr);";
  z[lc++]="	  while ((asysio_sync_ptr.bytes < asysio_sync_target) && !asysio_reset)";
  z[lc++]="	    {  ";
  z[lc++]="	      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOSPACE, &asysio_info);";
  z[lc++]="	      asysio_reset = (asysio_info.fragments == asysio_info.fragstotal);";
  z[lc++]="	      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOPTR,&asysio_sync_ptr);";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  if (asysio_reset)";
  z[lc++]="    {";
  z[lc++]="      if (asysio_recover()==ASYS_ERROR)";
  z[lc++]="	epr(0,NULL,NULL,\"Sound driver error -- failed recovery.\");";
  z[lc++]="      ASYSIO_IOCTL_CALL(asysio_fd, SNDCTL_DSP_GETOPTR, &asysio_sync_ptr);";
  z[lc++]="      asysio_sync_target = asysio_sync_ptr.bytes;";
  z[lc++]="      ret = 1.0F;";
  z[lc++]="    }";
  z[lc++]="  if ((asysio_sync_target += asysio_sync_incr) < 0)";
  z[lc++]="    epr(0,NULL,NULL,\"Sound driver error -- rollover.\");";
  z[lc++]="";
  z[lc++]="  /* reset infinite-loop timer */";
  z[lc++]="";
  z[lc++]="  if (setitimer(ITIMER_PROF, &asysio_iloop_timer, NULL) < 0)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"  Runtime Errno Message: %s\\n\", strerror(errno));";
  z[lc++]="      epr(0,NULL,NULL, \"Soundcard error -- Couldn't reset ITIMER_PROF\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#if ASYSIO_USEFIFO";
  z[lc++]="";
  z[lc++]="  if (asysio_fifo)";
  z[lc++]="    {";
  z[lc++]="      switch (asysio_sync_state) {";
  z[lc++]="      case ASYSIO_SYNC_ACTIVE:";
  z[lc++]="	if (!csysi_newnote)";
  z[lc++]="	  {";
  z[lc++]="	    asysio_sync_state = ASYSIO_SYNC_WAITING;";
  z[lc++]="	    asysio_sync_waitstart = time(NULL);";
  z[lc++]="	  }";
  z[lc++]="	break;";
  z[lc++]="      case ASYSIO_SYNC_WAITING:";
  z[lc++]="	if (csysi_newnote)";
  z[lc++]="	  asysio_sync_state = ASYSIO_SYNC_ACTIVE;";
  z[lc++]="	else";
  z[lc++]="	  if ((time(NULL) - asysio_sync_waitstart) >= ASYSIO_SYNC_TIMEOUT)";
  z[lc++]="	    {";
  z[lc++]="	      asysio_sync_state = ASYSIO_SYNC_SCHEDOTHER;";
  z[lc++]="	      if (sched_setscheduler(0, SCHED_OTHER, &asysio_otherparam))";
  z[lc++]="		epr(0,NULL,NULL,\"internal error -- sched_other unavailable\");";
  z[lc++]="	    }";
  z[lc++]="	break;";
  z[lc++]="      case ASYSIO_SYNC_SCHEDOTHER:";
  z[lc++]="	if (csysi_newnote)";
  z[lc++]="	  {";
  z[lc++]="	    asysio_sync_state = ASYSIO_SYNC_ACTIVE;";
  z[lc++]="	    if (sched_setscheduler(0, SCHED_FIFO, &asysio_fifoparam))";
  z[lc++]="	      fprintf(stderr, \"  Note: Process no longer root, \" ";
  z[lc++]="		      \"improved audio quality no longer possible.\\n\");";
  z[lc++]="	  }";
  z[lc++]="	break;";
  z[lc++]="      }";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  asysio_blocktime = 0;";
  z[lc++]="  return ret;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#endif /* ASYS_KSYNC */";
  z[lc++]="";
  z[lc++]="#undef ASYSIO_IOCTL_CALL";
  z[lc++]="#undef ASYSIO_ERROR_RETURN";
  z[lc++]="#undef ASYSIO_ERROR_RETURN_NOERRNO";
  z[lc++]="#undef ASYSIO_LINUX";
  z[lc++]="#undef ASYSIO_FREEBSD";
  z[lc++]="#undef ASYSIO_OSTYPE";
  z[lc++]="#undef ASYSIO_DSPDEV";
  z[lc++]="#undef ASYSIO_AFORMAT";
  z[lc++]="#undef ASYSIO_I  ";
  z[lc++]="#undef ASYSIO_O  ";
  z[lc++]="#undef ASYSIO_IO ";
  z[lc++]="#undef ASYSIO_FRAGMIN";
  z[lc++]="#undef ASYSIO_LOGFRAGMIN ";
  z[lc++]="#undef ASYSO_LNUMBUFF";
  z[lc++]="#undef ASYSIO_MAXRETRY";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*                    end of soundcard driver                   */";
  z[lc++]="/*______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="";
  printlib(lc);
}


void makestd(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: std audio driver for sfront";
  z[lc++]="#    Copyright (C) 1999  Regents of the University of California";
  z[lc++]="#";
  z[lc++]="#    This program is free software; you can redistribute it and/or modify";
  z[lc++]="#    it under the terms of the GNU General Public License (Version 2) as";
  z[lc++]="#    published by the Free Software Foundation.";
  z[lc++]="#";
  z[lc++]="#    This program is distributed in the hope that it will be useful,";
  z[lc++]="#    but WITHOUT ANY WARRANTY; without even the implied warranty of";
  z[lc++]="#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the";
  z[lc++]="#    GNU General Public License for more details.";
  z[lc++]="#";
  z[lc++]="#    You should have received a copy of the GNU General Public License";
  z[lc++]="#    along with this program; if not, write to the Free Software";
  z[lc++]="#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*           stdin/stdout file audio driver for sfront          */ ";
  z[lc++]="/*      reads/write 16-bit signed shorts in native format       */";
  z[lc++]="/*                     to/from stdout/stdin                     */";
  z[lc++]="/****************************************************************/";
  z[lc++]="        ";
  z[lc++]="#include <stdio.h>";
  z[lc++]="#include <string.h>";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/* global variables, must start with asys_ */";
  z[lc++]="";
  z[lc++]="FILE * asyso_fd;     /* output file pointer */";
  z[lc++]="char * asyso_name;   /* name of file  */        ";
  z[lc++]="long asyso_srate;    /* sampling rate */";
  z[lc++]="long asyso_channels; /* number of channels */";
  z[lc++]="long asyso_size;    /* number of samples in a buffer */";
  z[lc++]="long asyso_nsamp;    /* total number of samples written */";
  z[lc++]="short * asyso_buf;   /* output buffer */";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/* global variables, must start with asys_ */";
  z[lc++]="";
  z[lc++]="FILE * asysi_fd;     /* input file pointer */";
  z[lc++]="char * asysi_name;   /* name of file  */        ";
  z[lc++]="long asysi_srate;    /* sampling rate */";
  z[lc++]="long asysi_channels; /* number of channels */";
  z[lc++]="long asysi_size;  /* number of samples in a buffer */";
  z[lc++]="long asysi_nsamp;    /* total number of samples written */";
  z[lc++]="short * asysi_buf;   /* output buffer */";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        core routine for audio output setup                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asyso_setup(long srate, long ochannels, long osize, char * oname)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asyso_name = strcpy((char *) calloc(7, sizeof(char)), \"stdout\");";
  z[lc++]="  asyso_fd = stdout;";
  z[lc++]="  asyso_srate = srate;";
  z[lc++]="  asyso_channels = ochannels;";
  z[lc++]="  asyso_size = osize;";
  z[lc++]="  asyso_nsamp = 0;";
  z[lc++]="  asyso_buf = (short *)calloc(osize, sizeof(short));";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        core routine for audio input setup                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysi_setup(long srate, long ichannels, long isize, char * iname)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysi_name = strcpy((char *) calloc(6, sizeof(char)), \"stdin\");";
  z[lc++]="  asysi_fd = stdin;";
  z[lc++]="  asysi_srate = srate;";
  z[lc++]="  asysi_channels = ichannels;";
  z[lc++]="  asysi_size = isize;";
  z[lc++]="  asysi_nsamp = 0;";
  z[lc++]="  asysi_buf = (short *)malloc(sizeof(short)*isize);";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && !defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio output for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_osetup(long srate, long ochannels, long osample, ";
  z[lc++]="                char * oname, long toption)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  return asyso_setup(srate, ochannels, ASYS_OCHAN*ACYCLE, oname);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio input for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_isetup(long srate, long ichannels, long isample, ";
  z[lc++]="                char * iname, long toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  return asysi_setup(srate, ichannels, ASYS_ICHAN*ACYCLE, iname);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*   sets up audio input and output for a given srate/channels  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_iosetup(long srate, long ichannels, long ochannels,";
  z[lc++]="                 long isample, long osample, ";
  z[lc++]="                 char * iname, char * oname, long toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  if (asysi_setup(srate, ichannels, ASYS_ICHAN*ACYCLE, iname) != ASYS_DONE)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  return asyso_setup(srate, ochannels, ASYS_OCHAN*ACYCLE, oname);";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             shuts down audio output system                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asyso_shutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  char name[1024];";
  z[lc++]="";
  z[lc++]="  fclose(asyso_fd);";
  z[lc++]="  strcpy(name,asyso_name);";
  z[lc++]="  strcat(name,\".info\");";
  z[lc++]="  asyso_fd = fopen(name,\"w\");";
  z[lc++]="  fprintf(asyso_fd,\"%i\\n\",asyso_srate);";
  z[lc++]="  fprintf(asyso_fd,\"%i\\n\",asyso_channels);";
  z[lc++]="  fprintf(asyso_fd,\"%i\\n\",asyso_nsamp);";
  z[lc++]="  fclose(asyso_fd);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               shuts down audio input system                  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asysi_shutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  char name[1024];";
  z[lc++]="";
  z[lc++]="  fclose(asysi_fd);";
  z[lc++]="  strcpy(name, asysi_name);";
  z[lc++]="  strcat(name,\".info\");";
  z[lc++]="  asysi_fd = fopen(name,\"w\");";
  z[lc++]="  fprintf(asysi_fd,\"%i\\n\", asysi_srate);";
  z[lc++]="  fprintf(asysi_fd,\"%i\\n\", asysi_channels);";
  z[lc++]="  fprintf(asysi_fd,\"%i\\n\", asysi_nsamp);";
  z[lc++]="  fclose(asysi_fd);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(!defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                    shuts down audio output                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_oshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asyso_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input device                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ishutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysi_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input and output device        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ioshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysi_shutdown();";
  z[lc++]="  asyso_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="  ";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        creates buffer, and generates starting silence        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_preamble(ASYS_OTYPE * asys_obuf[], long * osize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  *asys_obuf = asyso_buf;";
  z[lc++]="  *osize = asyso_size;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               sends one frame of audio to output             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_putbuf(ASYS_OTYPE * asys_obuf[], long * osize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (rwrite(*asys_obuf, sizeof(short), *osize, asyso_fd) != *osize)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  asyso_nsamp += *osize;";
  z[lc++]="  *osize = asyso_size;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               sends one frame of audio to output             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_getbuf(ASYS_ITYPE * asys_ibuf[], long * isize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (*asys_ibuf == NULL)";
  z[lc++]="    *asys_ibuf = asysi_buf;";
  z[lc++]="  *isize = (long)rread(*asys_ibuf, sizeof(short), asysi_size, asysi_fd);";
  z[lc++]="  asysi_nsamp += *isize;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  printlib(lc);
}


void makevcdat(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: raw audio driver for sfront";
  z[lc++]="#    Copyright (C) 1999  Regents of the University of California";
  z[lc++]="#";
  z[lc++]="#    This program is free software; you can redistribute it and/or modify";
  z[lc++]="#    it under the terms of the GNU General Public License (Version 2) as";
  z[lc++]="#    published by the Free Software Foundation.";
  z[lc++]="#";
  z[lc++]="#    This program is distributed in the hope that it will be useful,";
  z[lc++]="#    but WITHOUT ANY WARRANTY; without even the implied warranty of";
  z[lc++]="#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the";
  z[lc++]="#    GNU General Public License for more details.";
  z[lc++]="#";
  z[lc++]="#    You should have received a copy of the GNU General Public License";
  z[lc++]="#    along with this program; if not, write to the Free Software";
  z[lc++]="#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             raw file audio driver for sfront                 */ ";
  z[lc++]="/*       reads/writes 16-bit signed shorts in native format     */";
  z[lc++]="/****************************************************************/";
  z[lc++]="        ";
  z[lc++]="#include <stdio.h>";
  z[lc++]="#include <string.h>";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/* default name for output audio file */";
  z[lc++]="#define ASYSO_DEFAULTNAME \"output\"";
  z[lc++]="";
  z[lc++]="/* global variables, must start with asyso_ */";
  z[lc++]="";
  z[lc++]="FILE * asyso_fd[ASYS_OCHAN]; /* output file pointer */";
  z[lc++]="long asyso_srate;            /* sampling rate */";
  z[lc++]="float asyso_stime;           /* sample period */";
  z[lc++]="long asyso_channels;         /* number of channels */";
  z[lc++]="long asyso_size;             /* number of samples in a buffer */";
  z[lc++]="long asyso_nsamp;            /* total number of samples written */";
  z[lc++]="ASYS_OTYPE * asyso_buf;      /* location for output buffer */ ";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/* default name for output audio file */";
  z[lc++]="#define ASYSI_DEFAULTNAME \"input\"";
  z[lc++]="";
  z[lc++]="/* global variables, must start with asysi_ */";
  z[lc++]="";
  z[lc++]="FILE * asysi_fd;     /* input file pointer */";
  z[lc++]="char * asysi_name;   /* name of file  */        ";
  z[lc++]="long asysi_srate;    /* sampling rate */";
  z[lc++]="long asysi_channels; /* number of channels */";
  z[lc++]="long asysi_size;    /* number of samples in a buffer */";
  z[lc++]="long asysi_nsamp;    /* total number of samples written */";
  z[lc++]="ASYS_ITYPE * asysi_buf;   /* location for input buffer */ ";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        core routine for audio output setup                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asyso_setup(long srate, long ochannels, long osample, ";
  z[lc++]="		long osize, char * name)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i;";
  z[lc++]="  char * cname;";
  z[lc++]="  char * nname;";
  z[lc++]="";
  z[lc++]="  /* note: ASYS_OCHAN holds same value as ochannels */";
  z[lc++]="";
  z[lc++]="  if (name == NULL)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      if (ASYS_OCHAN == 1)";
  z[lc++]="	{";
  z[lc++]="	  asyso_fd[0] = fopen(name,\"w\");";
  z[lc++]="	  if (asyso_fd[0] == NULL)";
  z[lc++]="	    return ASYS_ERROR;";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  cname = strcpy((char *)calloc((strlen(name)+1),sizeof(char)), name);";
  z[lc++]="	  cname[((int)strlen(cname))-4]='\\0';";
  z[lc++]="	  nname = (char *) malloc((int)strlen(cname)+8);";
  z[lc++]="	  for(i=0;i < ASYS_OCHAN;i++)";
  z[lc++]="	    {";
  z[lc++]="	      sprintf(nname,\"%s%i.dat\",cname,i+1);";
  z[lc++]="	      asyso_fd[i] = fopen(nname,\"w\");";
  z[lc++]="	      if (asyso_fd[i] == NULL)";
  z[lc++]="		return ASYS_ERROR;";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  for(i=0;i<ASYS_OCHAN;i++)";
  z[lc++]="    {";
  z[lc++]="      fprintf(asyso_fd[i],\"1\\n\");";
  z[lc++]="      fprintf(asyso_fd[i],\"# Sa.c channel %i: sample rate %i\\n\\n\",i+1,srate);";
  z[lc++]="      fprintf(asyso_fd[i],\"pairs\\n\");";
  z[lc++]="      fprintf(asyso_fd[i],\"ch%i\\n\",i+1);";
  z[lc++]="      fprintf(asyso_fd[i],\"*\\n\");";
  z[lc++]="      fprintf(asyso_fd[i],\"*\\n\");";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  asyso_srate = srate;";
  z[lc++]="  asyso_stime = 1.0F/srate;";
  z[lc++]="  asyso_channels = ochannels;";
  z[lc++]="  asyso_size = osize;";
  z[lc++]="  asyso_nsamp = 0;";
  z[lc++]="  asyso_buf = (ASYS_OTYPE *)calloc(osize, sizeof(ASYS_OTYPE));";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        core routine for audio input setup                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysi_setup(long srate, long ichannels, long isample, ";
  z[lc++]="		long isize, char * name)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  char strbuf[128];";
  z[lc++]="  char * ret;";
  z[lc++]="  char * val;";
  z[lc++]="";
  z[lc++]="  if (name == NULL)";
  z[lc++]="    val = ASYSI_DEFAULTNAME;";
  z[lc++]="  else";
  z[lc++]="    val = name;";
  z[lc++]="  asysi_name = strcpy((char *) calloc((strlen(val)+1),sizeof(char)), val);";
  z[lc++]="  asysi_fd = fopen(asysi_name,\"r\");";
  z[lc++]="  if (asysi_fd == NULL)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  ret = fgets(strbuf, 128, asysi_fd);";
  z[lc++]="  while ((strstr(strbuf,\"pairs\") == NULL)||(strbuf[0]=='#'))";
  z[lc++]="    {";
  z[lc++]="      if (ret == NULL)";
  z[lc++]="	return ASYS_ERROR;";
  z[lc++]="      ret = fgets(strbuf, 128, asysi_fd);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (fgets(strbuf, 128, asysi_fd) == NULL)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if (fgets(strbuf, 128, asysi_fd) == NULL)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  if (fgets(strbuf, 128, asysi_fd) == NULL)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  ";
  z[lc++]="  asysi_srate = srate;";
  z[lc++]="  asysi_channels = ichannels;";
  z[lc++]="  asysi_size = isize;";
  z[lc++]="  asysi_nsamp = 0;";
  z[lc++]="  asysi_buf = (ASYS_ITYPE *)malloc(sizeof(ASYS_ITYPE)*isize);";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && !defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio output for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_osetup(long srate, long ochannels, long osample, ";
  z[lc++]="                char * oname, long toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  return asyso_setup(srate, ochannels, osample, ASYS_OCHAN*ACYCLE, oname);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio input for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_isetup(long srate, long ichannels, long isample, ";
  z[lc++]="                char * iname, long toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  return asysi_setup(srate, ichannels, isample, ASYS_ICHAN*ACYCLE, iname);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*   sets up audio input and output for a given srate/channels  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_iosetup(long srate, long ichannels, long ochannels,";
  z[lc++]="                 long isample, long osample, ";
  z[lc++]="                 char * iname, char * oname, long toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (asysi_setup(srate, ichannels, isample, ASYS_ICHAN*ACYCLE,";
  z[lc++]="		  iname) != ASYS_DONE)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  return asyso_setup(srate, ochannels, osample, ASYS_OCHAN*ACYCLE, oname);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             shuts down audio output system                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asyso_shutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  for (i=0;i<ASYS_OCHAN;i++)";
  z[lc++]="    {";
  z[lc++]="      fprintf(asyso_fd[i],\"\\n\");";
  z[lc++]="      fclose(asyso_fd[i]);";
  z[lc++]="    }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               shuts down audio input system                  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asysi_shutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  fclose(asysi_fd);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(!defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                    shuts down audio output                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_oshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asyso_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input device                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ishutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysi_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input and output device        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ioshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysi_shutdown();";
  z[lc++]="  asyso_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="  ";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        creates buffer, and generates starting silence        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_preamble(ASYS_OTYPE * asys_obuf[], long * osize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  *asys_obuf = asyso_buf;";
  z[lc++]="  *osize = asyso_size;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               sends one frame of audio to output             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_putbuf(ASYS_OTYPE * asys_obuf[], long * osize)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  long i;";
  z[lc++]="";
  z[lc++]="  for (i = 0; i < *osize; i++)";
  z[lc++]="    {";
  z[lc++]="      fprintf(asyso_fd[i % ASYS_OCHAN], \"%f %f\\n\", asyso_nsamp*asyso_stime, ";
  z[lc++]="	      (float)((*asys_obuf)[i]));";
  z[lc++]="      if (!(i%ASYS_OCHAN))";
  z[lc++]="	asyso_nsamp++;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               gets one frame of audio from input             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_getbuf(ASYS_ITYPE * asys_ibuf[], long * isize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  float x, y;";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  if (*asys_ibuf == NULL)";
  z[lc++]="    *asys_ibuf = asysi_buf;";
  z[lc++]="  *isize = 0;";
  z[lc++]="  while (*isize < asysi_size)";
  z[lc++]="    {";
  z[lc++]="      if (fscanf(asysi_fd,\"%f%f\",&x, &y) != 2)";
  z[lc++]="	break;";
  z[lc++]="      for (i = 0; i < asysi_channels; i++)";
  z[lc++]="	(*asys_ibuf)[(*isize)++] = (ASYS_ITYPE) y;";
  z[lc++]="    }";
  z[lc++]="  asysi_nsamp += *isize;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  printlib(lc);
}


void makenull(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: null audio driver for sfront (thanks to Michael McGonagle)";
  z[lc++]="#    Copyright (C) 1999  Regents of the University of California";
  z[lc++]="#";
  z[lc++]="#    This program is free software; you can redistribute it and/or modify";
  z[lc++]="#    it under the terms of the GNU General Public License (Version 2) as";
  z[lc++]="#    published by the Free Software Foundation.";
  z[lc++]="#";
  z[lc++]="#    This program is distributed in the hope that it will be useful,";
  z[lc++]="#    but WITHOUT ANY WARRANTY; without even the implied warranty of";
  z[lc++]="#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the";
  z[lc++]="#    GNU General Public License for more details.";
  z[lc++]="#";
  z[lc++]="#    You should have received a copy of the GNU General Public License";
  z[lc++]="#    along with this program; if not, write to the Free Software";
  z[lc++]="#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*           nullin/nullout file audio driver for sfront        */";
  z[lc++]="/*           for benchmarking and printf()-driven apps          */ ";
  z[lc++]="/****************************************************************/";
  z[lc++]="        ";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/* global variables, must start with asys_ */";
  z[lc++]="";
  z[lc++]="long asyso_size;    /* number of samples in a buffer */";
  z[lc++]="short * asyso_buf;  /* output buffer */";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/* global variables, must start with asys_ */";
  z[lc++]="";
  z[lc++]="long asysi_size;     /* number of samples in a buffer */";
  z[lc++]="short * asysi_buf;   /* input buffer */";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        core routine for audio output setup                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asyso_setup(long srate, long ochannels, long osize, char * oname)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asyso_size = osize;";
  z[lc++]="  asyso_buf = (short *)calloc(osize, sizeof(short));";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        core routine for audio input setup                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysi_setup(long srate, long ichannels, long isize, char * iname)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysi_size = isize;";
  z[lc++]="  asysi_buf = (short *)calloc(isize, sizeof(short));";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && !defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio output for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_osetup(long srate, long ochannels, long osample, ";
  z[lc++]="                char * oname, long toption)";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  return asyso_setup(srate, ochannels, ASYS_OCHAN*ACYCLE, oname);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio input for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_isetup(long srate, long ichannels, long isample, ";
  z[lc++]="                char * iname, long toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  return asysi_setup(srate, ichannels, ASYS_ICHAN*ACYCLE, iname);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*   sets up audio input and output for a given srate/channels  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_iosetup(long srate, long ichannels, long ochannels,";
  z[lc++]="                 long isample, long osample, ";
  z[lc++]="                 char * iname, char * oname, long toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="";
  z[lc++]="  if (asysi_setup(srate, ichannels, ASYS_ICHAN*ACYCLE, iname) != ASYS_DONE)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="  return asyso_setup(srate, ochannels, ASYS_OCHAN*ACYCLE, oname);";
  z[lc++]="";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(!defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                    shuts down audio output                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_oshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input device                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ishutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input and output device        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ioshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        creates buffer, and generates starting silence        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_preamble(ASYS_OTYPE * asys_obuf[], long * osize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  *asys_obuf = asyso_buf;";
  z[lc++]="  *osize = asyso_size;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               sends one frame of audio to output             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_putbuf(ASYS_OTYPE * asys_obuf[], long * osize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  *osize = asyso_size;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               gets one frame of audio from input             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_getbuf(ASYS_ITYPE * asys_ibuf[], long * isize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  if (*asys_ibuf == NULL)";
  z[lc++]="    *asys_ibuf = asysi_buf;";
  z[lc++]="  *isize = asysi_size;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  printlib(lc);
}


void makeirix(void)
{
  int lc = 0;

  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator";
  z[lc++]="#    This file: IRIX audio driver for sfront";
  z[lc++]="#    Copyright (C) 1999  Regents of the University of California";
  z[lc++]="#    Copyright (C) 2001  Michael Pruett";
  z[lc++]="#";
  z[lc++]="#    This program is free software; you can redistribute it and/or modify";
  z[lc++]="#    it under the terms of the GNU General Public License (Version 2) as";
  z[lc++]="#    published by the Free Software Foundation.";
  z[lc++]="#";
  z[lc++]="#    This program is distributed in the hope that it will be useful,";
  z[lc++]="#    but WITHOUT ANY WARRANTY; without even the implied warranty of";
  z[lc++]="#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the";
  z[lc++]="#    GNU General Public License for more details.";
  z[lc++]="#";
  z[lc++]="#    You should have received a copy of the GNU General Public License";
  z[lc++]="#    along with this program; if not, write to the Free Software";
  z[lc++]="#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="#include <dmedia/audio.h>";
  z[lc++]="#include <unistd.h>";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/* global variables, must start with asys_ */";
  z[lc++]="";
  z[lc++]="ALport asyso_port;	/* audio port */";
  z[lc++]="long asyso_size;	/* number of samples in a buffer */";
  z[lc++]="short *asyso_buf;	/* output buffer */";
  z[lc++]="int asyso_channels;	/* number of channels */";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/* global variables, must start with asys_ */";
  z[lc++]="";
  z[lc++]="ALport asysi_port;	/* audio port */";
  z[lc++]="long asysi_size;	/* number of samples in a buffer */";
  z[lc++]="short *asysi_buf;	/* input buffer */";
  z[lc++]="int asysi_channels;	/* number of channels */";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="static int setrate (ALport port, double rate)";
  z[lc++]="{";
  z[lc++]="	int	res;";
  z[lc++]="	ALpv	params;";
  z[lc++]="";
  z[lc++]="	res = alGetResource(port);";
  z[lc++]="";
  z[lc++]="	params.param = AL_RATE;";
  z[lc++]="	params.value.ll = alDoubleToFixed(rate);";
  z[lc++]="";
  z[lc++]="	if (alSetParams(res, &params, 1) < 0)";
  z[lc++]="	{";
  z[lc++]="		return ASYS_ERROR;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="	return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        core routine for audio output setup                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asyso_setup (long srate, long ochannels, long osize, char *oname)";
  z[lc++]="{";
  z[lc++]="	ALconfig	config;";
  z[lc++]="";
  z[lc++]="	config = alNewConfig();";
  z[lc++]="";
  z[lc++]="	alSetChannels(config, ochannels);";
  z[lc++]="	alSetWidth(config, AL_SAMPLE_16);";
  z[lc++]="";
  z[lc++]="	asyso_port = alOpenPort(\"sfront\", \"w\", config);";
  z[lc++]="";
  z[lc++]="	alFreeConfig(config);";
  z[lc++]="";
  z[lc++]="	if (asyso_port == NULL)";
  z[lc++]="		return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="	if (setrate(asyso_port, srate) != ASYS_DONE)";
  z[lc++]="		return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="	asyso_channels = ochannels;";
  z[lc++]="	asyso_size = osize;";
  z[lc++]="	asyso_buf = (short *) calloc(osize, sizeof (short));";
  z[lc++]="	return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        core routine for audio input setup                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysi_setup(long srate, long ichannels, long isize, char *iname)";
  z[lc++]="{";
  z[lc++]="	ALconfig	config;";
  z[lc++]="";
  z[lc++]="	config = alNewConfig();";
  z[lc++]="";
  z[lc++]="	alSetChannels(config, ichannels);";
  z[lc++]="	alSetWidth(config, AL_SAMPLE_16);";
  z[lc++]="";
  z[lc++]="	asysi_port = alOpenPort(\"sfront\", \"r\", config);";
  z[lc++]="";
  z[lc++]="	alFreeConfig(config);";
  z[lc++]="";
  z[lc++]="	if (asysi_port == NULL)";
  z[lc++]="		return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="	if (setrate(asysi_port, srate) != ASYS_DONE)";
  z[lc++]="		return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="	asysi_channels = ichannels;";
  z[lc++]="	asysi_size = isize;";
  z[lc++]="	asysi_buf = (short *) calloc(isize, sizeof (short));";
  z[lc++]="	return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && !defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio output for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_osetup (long srate, long ochannels, long osample,";
  z[lc++]="	char *oname, long toption)";
  z[lc++]="{";
  z[lc++]="	return asyso_setup(srate, ochannels, ASYS_OCHAN*ACYCLE, oname);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        sets up audio input for a given srate/channels       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_isetup(long srate, long ichannels, long isample,";
  z[lc++]="	char *iname, long toption)";
  z[lc++]="{";
  z[lc++]="	return asysi_setup(srate, ichannels, ASYS_ICHAN*ACYCLE, iname);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*   sets up audio input and output for a given srate/channels  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_iosetup (long srate, long ichannels, long ochannels,";
  z[lc++]="	long isample, long osample,";
  z[lc++]="	char *iname, char *oname, long toption)";
  z[lc++]="{";
  z[lc++]="	int	result;";
  z[lc++]="";
  z[lc++]="	result = asysi_setup(srate, ichannels, ASYS_ICHAN*ACYCLE, iname);";
  z[lc++]="";
  z[lc++]="	if (result != ASYS_DONE)";
  z[lc++]="		return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="	return asyso_setup(srate, ochannels, ASYS_OCHAN*ACYCLE, oname);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(!defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                    shuts down audio output                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_oshutdown(void)";
  z[lc++]="{";
  z[lc++]="	while (alGetFilled(asyso_port) > 0)";
  z[lc++]="		sginap(1);";
  z[lc++]="";
  z[lc++]="	alClosePort(asyso_port);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input device                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ishutdown(void)";
  z[lc++]="{";
  z[lc++]="	alClosePort(asysi_port);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input and output device        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ioshutdown(void)";
  z[lc++]="{";
  z[lc++]="	alClosePort(asysi_port);";
  z[lc++]="";
  z[lc++]="	while (alGetFilled(asyso_port) > 0)";
  z[lc++]="		sginap(1);";
  z[lc++]="";
  z[lc++]="	alClosePort(asyso_port);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASOUTPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*        creates buffer, and generates starting silence        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_preamble (ASYS_OTYPE *asys_obuf[], long *osize)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="	*asys_obuf = asyso_buf;";
  z[lc++]="	*osize = asyso_size;";
  z[lc++]="";
  z[lc++]="	alZeroFrames(asyso_port, *osize);";
  z[lc++]="";
  z[lc++]="	return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               sends one frame of audio to output             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_putbuf (ASYS_OTYPE *asys_obuf[], long *osize)";
  z[lc++]="{";
  z[lc++]="	*osize = asyso_size;";
  z[lc++]="";
  z[lc++]="	alWriteFrames(asyso_port, *asys_obuf, *osize / asyso_channels);";
  z[lc++]="";
  z[lc++]="	return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_HASINPUT)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               gets one frame of audio from input             */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_getbuf (ASYS_ITYPE *asys_ibuf[], long *isize)";
  z[lc++]="{";
  z[lc++]="	if (*asys_ibuf == NULL)";
  z[lc++]="		*asys_ibuf = asysi_buf;";
  z[lc++]="	*isize = asysi_size;";
  z[lc++]="";
  z[lc++]="	alReadFrames(asysi_port, *asys_ibuf, *isize / asysi_channels);";
  z[lc++]="";
  z[lc++]="	return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  printlib(lc);
}


void makeportaudio(void)
{
  int lc = 0;

  z[lc++]="";
  z[lc++]="/*";
  z[lc++]="#    Sfront, a SAOL to C translator    ";
  z[lc++]="#    This file: portaudio audio driver for sfront";
  z[lc++]="#    Copyright (C) 1999  Regents of the University of California";
  z[lc++]="#";
  z[lc++]="#    This program is free software; you can redistribute it and/or modify";
  z[lc++]="#    it under the terms of the GNU General Public License (Version 2) as";
  z[lc++]="#    published by the Free Software Foundation.";
  z[lc++]="#";
  z[lc++]="#    This program is distributed in the hope that it will be useful,";
  z[lc++]="#    but WITHOUT ANY WARRANTY; without even the implied warranty of";
  z[lc++]="#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the";
  z[lc++]="#    GNU General Public License for more details.";
  z[lc++]="#";
  z[lc++]="#    You should have received a copy of the GNU General Public License";
  z[lc++]="#    along with this program; if not, write to the Free Software";
  z[lc++]="#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA";
  z[lc++]="#";
  z[lc++]="#    Maintainer: John Lazzaro, lazzaro@cs.berkeley.edu";
  z[lc++]="*/";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*             wav file audio driver for sfront                 */ ";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="#define ASYSN_PORTAUDIO_DEBUG        0    /* 1 for debug printouts */";
  z[lc++]="        ";
  z[lc++]="#define ASYSN_PORTAUDIO_SLEEPMS    250    /* exit check interval */";
  z[lc++]="";
  z[lc++]="#define ASYSN_PORTAUDIO_BUFFMIN      2    /* at least double buffer   */";
  z[lc++]="#define ASYSN_PORTAUDIO_BUFFDEFAULT  4    /* known to work well       */";
  z[lc++]="#define ASYSN_PORTAUDIO_BUFFMAX      6    /* avoid huge buffer counts */";
  z[lc++]="#define ASYSN_PORTAUDIO_LATENCYMAX 0.5    /* 500ms maximum latency    */";
  z[lc++]="";
  z[lc++]="PaStream * asysn_portaudio_fd;";
  z[lc++]="int asysn_portaudio_silence;";
  z[lc++]="volatile int asysn_portaudio_done;";
  z[lc++]="";
  z[lc++]="/* state for passive input driver */";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_ACTIVE_IO) && !defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="ASYS_ITYPE * asysn_portaudio_ibuf;";
  z[lc++]="long asysn_portaudio_iptr;";
  z[lc++]="long asysn_portaudio_ilast;";
  z[lc++]="long asysn_portaudio_ileft;";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/* state for passive output driver */";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_ACTIVE_IO) && !defined(ASYS_HASOUTPUT))";
  z[lc++]="";
  z[lc++]="ASYS_OTYPE * asysn_portaudio_obuf;";
  z[lc++]="long asysn_portaudio_optr;";
  z[lc++]="long asysn_portaudio_olast;";
  z[lc++]="long asysn_portaudio_oleft;";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/";
  z[lc++]="/*       callback functions for different scenareos              */";
  z[lc++]="/*_______________________________________________________________*/";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_ACTIVE_O)";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*            output-only callback function                     */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysn_portaudio_callback(void * inputBuffer, void * outputBuffer,";
  z[lc++]="			     unsigned long framesPerBuffer, ";
  z[lc++]="			     PaTimestamp outTime, void *userData)";
  z[lc++]="{";
  z[lc++]="  long optr = 0;";
  z[lc++]="  long oleft = (long) (framesPerBuffer * ASYS_OCHAN);";
  z[lc++]="  float * obuf = (float *) outputBuffer;";
  z[lc++]="  long osize;";
  z[lc++]="";
  z[lc++]="  if ((asysn_portaudio_done == ASYS_DONE) && (asysn_portaudio_silence == 0))";
  z[lc++]="    {";
  z[lc++]="      do ";
  z[lc++]="	{";
  z[lc++]="	  osize = oleft;";
  z[lc++]="	  asysn_portaudio_done = asys_orun(&(obuf[optr]), &osize);";
  z[lc++]="	  optr += osize;";
  z[lc++]="	  oleft -= osize;";
  z[lc++]="	} ";
  z[lc++]="      while ((asysn_portaudio_done == ASYS_DONE) && (oleft > 0));";
  z[lc++]="";
  z[lc++]="      if (oleft > 0)";
  z[lc++]="	memset(&(obuf[optr]), 0, sizeof(float)*oleft);";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      memset(outputBuffer, 0, sizeof(float)*oleft);";
  z[lc++]="      if (asysn_portaudio_silence)";
  z[lc++]="	asysn_portaudio_silence--;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return 0;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_ACTIVE_IO)";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*       Portaudio input and output callback function           */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysn_portaudio_callback(void * inputBuffer, void * outputBuffer,";
  z[lc++]="			     unsigned long framesPerBuffer, ";
  z[lc++]="			     PaTimestamp outTime, void *userData)";
  z[lc++]="{";
  z[lc++]="  long ileft = (long) (framesPerBuffer * ASYS_ICHAN);";
  z[lc++]="  long oleft = (long) (framesPerBuffer * ASYS_OCHAN);";
  z[lc++]="  float * ibuf = (float *) inputBuffer;";
  z[lc++]="  float * obuf = (float *) outputBuffer;";
  z[lc++]="  long isize, osize;";
  z[lc++]="";
  z[lc++]="  isize = ileft;";
  z[lc++]="  osize = oleft;";
  z[lc++]="";
  z[lc++]="  if ((asysn_portaudio_done == ASYS_DONE) && (asysn_portaudio_silence == 0))";
  z[lc++]="    {";
  z[lc++]="      asysn_portaudio_done = asys_iorun(ibuf, &isize, obuf, &osize);";
  z[lc++]="";
  z[lc++]="      if (osize < oleft)";
  z[lc++]="	memset(&(obuf[osize]), 0, sizeof(float)*(oleft - osize));";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      memset(outputBuffer, 0, sizeof(float)*oleft);";
  z[lc++]="      if (asysn_portaudio_silence)";
  z[lc++]="	asysn_portaudio_silence--;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return 0;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && !defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*       Portaudio output, passive input callback function      */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysn_portaudio_callback(void * inputBuffer, void * outputBuffer,";
  z[lc++]="			     unsigned long framesPerBuffer, ";
  z[lc++]="			     PaTimestamp outTime, void *userData)";
  z[lc++]="{";
  z[lc++]="  long isize, osize;";
  z[lc++]="  long optr = 0;";
  z[lc++]="  long oleft = (long) (framesPerBuffer * ASYS_OCHAN);";
  z[lc++]="  float * obuf = (float *) outputBuffer;";
  z[lc++]="";
  z[lc++]="  if ((asysn_portaudio_done == ASYS_DONE) && (asysn_portaudio_silence == 0))";
  z[lc++]="    {";
  z[lc++]="      do ";
  z[lc++]="	{";
  z[lc++]="	  if (asysn_portaudio_ileft == 0)";
  z[lc++]="	    {  ";
  z[lc++]="	      if ((asys_getbuf(&asysn_portaudio_ibuf, &asysn_portaudio_ilast) ";
  z[lc++]="		   != ASYS_DONE) || (asysn_portaudio_ilast == 0))";
  z[lc++]="		{";
  z[lc++]="		  asysn_portaudio_done = ASYS_EXIT;";
  z[lc++]="		  break;";
  z[lc++]="		}";
  z[lc++]="	      asysn_portaudio_iptr  = 0;";
  z[lc++]="	      asysn_portaudio_ileft = asysn_portaudio_ilast;";
  z[lc++]="	    }";
  z[lc++]="";
  z[lc++]="	  isize = asysn_portaudio_ileft;";
  z[lc++]="	  osize = oleft;";
  z[lc++]="	  asysn_portaudio_done = asys_iorun(&(asysn_portaudio_ibuf";
  z[lc++]="					      [asysn_portaudio_iptr]),";
  z[lc++]="					    &isize, &(obuf[optr]), &osize);";
  z[lc++]="	  asysn_portaudio_iptr += isize;";
  z[lc++]="	  asysn_portaudio_ileft -= isize;";
  z[lc++]="	  optr += osize;";
  z[lc++]="	  oleft -= osize;";
  z[lc++]="	}";
  z[lc++]="      while ((asysn_portaudio_done == ASYS_DONE) && (oleft > 0));";
  z[lc++]="";
  z[lc++]="      if (oleft > 0)";
  z[lc++]="	memset(&(obuf[optr]), 0, sizeof(float)*oleft);";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      memset(outputBuffer, 0, sizeof(float)*oleft);";
  z[lc++]="      if (asysn_portaudio_silence)";
  z[lc++]="	asysn_portaudio_silence--;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return 0;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*       Portaudio input, passive output callback function      */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysn_portaudio_callback(void * inputBuffer, void * outputBuffer,";
  z[lc++]="			     unsigned long framesPerBuffer, ";
  z[lc++]="			     PaTimestamp outTime, void *userData)";
  z[lc++]="{";
  z[lc++]="  long isize, osize;";
  z[lc++]="  long iptr = 0;";
  z[lc++]="  long ileft = (long) (framesPerBuffer * ASYS_ICHAN);";
  z[lc++]="  float * ibuf = (float *) inputBuffer;";
  z[lc++]="";
  z[lc++]="  while ((asysn_portaudio_done == ASYS_DONE) && ileft)";
  z[lc++]="    {";
  z[lc++]="      isize = ileft;";
  z[lc++]="      osize = asysn_portaudio_oleft;";
  z[lc++]="";
  z[lc++]="      asysn_portaudio_done = asys_iorun(&(ibuf[iptr]), &isize,";
  z[lc++]="					&(asysn_portaudio_obuf";
  z[lc++]="					  [asysn_portaudio_optr]), &osize);";
  z[lc++]="";
  z[lc++]="      if (asysn_portaudio_done == ASYS_DONE)";
  z[lc++]="	{";
  z[lc++]="	  asysn_portaudio_optr  += osize;";
  z[lc++]="	  asysn_portaudio_oleft -= osize;";
  z[lc++]="	  iptr  += isize;";
  z[lc++]="	  ileft -= isize;";
  z[lc++]="";
  z[lc++]="	  if (asysn_portaudio_oleft == 0)";
  z[lc++]="	    {";
  z[lc++]="	      if (asys_putbuf(&asysn_portaudio_obuf, &asysn_portaudio_olast)";
  z[lc++]="		  == ASYS_DONE)";
  z[lc++]="		{";
  z[lc++]="		  asysn_portaudio_oleft = asysn_portaudio_olast;";
  z[lc++]="		  asysn_portaudio_optr  = 0;";
  z[lc++]="		}";
  z[lc++]="	      else";
  z[lc++]="		asysn_portaudio_done = ASYS_EXIT;";
  z[lc++]="	    }";
  z[lc++]="	}";
  z[lc++]="      else";
  z[lc++]="	{";
  z[lc++]="	  osize = asysn_portaudio_olast - asysn_portaudio_oleft;";
  z[lc++]="	  asys_putbuf(&asysn_portaudio_obuf, &osize);";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*               initialize Portaudio system                    */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysn_portaudio_init(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  PaError err;";
  z[lc++]="";
  z[lc++]="  if ((err = Pa_Initialize()) != paNoError)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"Error: PortAudio initialization failure (%s).\\n\", ";
  z[lc++]="	      Pa_GetErrorText(err));";
  z[lc++]="      if (err == paHostError)";
  z[lc++]="	fprintf(stderr, \"     : Native error (%s).\\n\", strerror(errno));";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              check default output suitability                */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysn_portaudio_outcheck(double * srate, long ochannels, PaDeviceID * pid)";
  z[lc++]="";
  z[lc++]="{  ";
  z[lc++]="  const PaDeviceInfo * pidinfo;";
  z[lc++]="  PaError err;";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  if ((*pid = Pa_GetDefaultOutputDeviceID()) == paNoDevice)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"Error: No PortAudio output device.\\n\");";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if ((pidinfo = Pa_GetDeviceInfo(*pid)) == NULL)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"Error: Bad PortAudio default output ID.\\n\");";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (pidinfo->maxOutputChannels < ochannels)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"Error: SAOL outchannels %i > soundcard limit %i.\\n\",";
  z[lc++]="	      ochannels, pidinfo->maxOutputChannels);";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (pidinfo->numSampleRates == -1)";
  z[lc++]="    {";
  z[lc++]="      if ((*srate < pidinfo->sampleRates[0]) ||";
  z[lc++]="	  (*srate > pidinfo->sampleRates[1]))";
  z[lc++]="	{";
  z[lc++]="	  fprintf(stderr, \"Error: SAOL srate %lf > outside PortAudio range \"";
  z[lc++]="		  \"[%lf, %lf].\\n\", *srate, pidinfo->sampleRates[0],";
  z[lc++]="		  pidinfo->sampleRates[1]);";
  z[lc++]="	  return ASYS_ERROR;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      err = paHostError;";
  z[lc++]="      for (i = 0; i < pidinfo->numSampleRates; i++)";
  z[lc++]="	if (*srate == pidinfo->sampleRates[i])";
  z[lc++]="	  {";
  z[lc++]="	    err = paNoError;";
  z[lc++]="	    break;";
  z[lc++]="	  }";
  z[lc++]="";
  z[lc++]="      /* later add approximate check */";
  z[lc++]="      ";
  z[lc++]="      if (err == paHostError)";
  z[lc++]="	{";
  z[lc++]="	  fprintf(stderr, \"Error: SAOL srate %lf not among PortAudio rates \",";
  z[lc++]="		  *srate);";
  z[lc++]="	  for (i = 0; i < pidinfo->numSampleRates; i++)";
  z[lc++]="	    fprintf(stderr, \"%lf \", pidinfo->sampleRates[i]);";
  z[lc++]="	  fprintf(stderr, \"\\n\");";
  z[lc++]="	  return ASYS_ERROR;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              check default input suitability                 */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysn_portaudio_incheck(double * srate, long ichannels, PaDeviceID * pid)";
  z[lc++]="";
  z[lc++]="{  ";
  z[lc++]="  const PaDeviceInfo * pidinfo;";
  z[lc++]="  PaError err;";
  z[lc++]="  int i;";
  z[lc++]="";
  z[lc++]="  if ((*pid = Pa_GetDefaultInputDeviceID()) == paNoDevice)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"Error: No PortAudio input device.\\n\");";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if ((pidinfo = Pa_GetDeviceInfo(*pid)) == NULL)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"Error: Bad PortAudio default input ID.\\n\");";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (pidinfo->maxInputChannels < ichannels)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"Error: SAOL inchannels %i > soundcard limit %i.\\n\",";
  z[lc++]="	      ichannels, pidinfo->maxInputChannels);";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (pidinfo->numSampleRates == -1)";
  z[lc++]="    {";
  z[lc++]="      if ((*srate < pidinfo->sampleRates[0]) ||";
  z[lc++]="	  (*srate > pidinfo->sampleRates[1]))";
  z[lc++]="	{";
  z[lc++]="	  fprintf(stderr, \"Error: SAOL srate %lf > outside PortAudio irange \"";
  z[lc++]="		  \"[%lf, %lf].\\n\", *srate, pidinfo->sampleRates[0],";
  z[lc++]="		  pidinfo->sampleRates[1]);";
  z[lc++]="	  return ASYS_ERROR;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="  else";
  z[lc++]="    {";
  z[lc++]="      err = paHostError;";
  z[lc++]="      for (i = 0; i < pidinfo->numSampleRates; i++)";
  z[lc++]="	if (*srate == pidinfo->sampleRates[i])";
  z[lc++]="	  {";
  z[lc++]="	    err = paNoError;";
  z[lc++]="	    break;";
  z[lc++]="	  }";
  z[lc++]="";
  z[lc++]="      /* later add approximate check */";
  z[lc++]="      ";
  z[lc++]="      if (err == paHostError)";
  z[lc++]="	{";
  z[lc++]="	  fprintf(stderr, \"Error: SAOL srate %lf not among PortAudio irates \",";
  z[lc++]="		  *srate);";
  z[lc++]="	  for (i = 0; i < pidinfo->numSampleRates; i++)";
  z[lc++]="	    fprintf(stderr, \"%lf \", pidinfo->sampleRates[i]);";
  z[lc++]="	  fprintf(stderr, \"\\n\");";
  z[lc++]="	  return ASYS_ERROR;";
  z[lc++]="	}";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                determine buffer parameters                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asysn_portaudio_buffparam(unsigned long * framesPerBuffer,";
  z[lc++]="			      unsigned long * numberOfBuffers,";
  z[lc++]="			      double samplerate)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  double totframes, maxframes;";
  z[lc++]="  unsigned long num;";
  z[lc++]="  int i, found;";
  z[lc++]="";
  z[lc++]="  /* high-latency mac_carbon needs special treatment */";
  z[lc++]="";
  z[lc++]="#ifdef ASYS_OUTDRIVER_MAC_CARBON";
  z[lc++]="";
  z[lc++]="  if (ASYS_LATENCYTYPE == ASYS_HIGHLATENCY)";
  z[lc++]="    {";
  z[lc++]="      *numberOfBuffers = 10;";
  z[lc++]="      *framesPerBuffer = (ASYS_LATENCY/ATIME)/(*numberOfBuffers);";
  z[lc++]="      return ASYS_DONE;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  /* used for windows and low-latency mac_carbon */";
  z[lc++]="";
  z[lc++]="  *numberOfBuffers = ASYSN_PORTAUDIO_BUFFDEFAULT;";
  z[lc++]="  totframes = ASYS_LATENCY/ATIME;";
  z[lc++]="  maxframes = ASYSN_PORTAUDIO_LATENCYMAX/ATIME;";
  z[lc++]="  found = 0;";
  z[lc++]="";
  z[lc++]="  do {";
  z[lc++]="";
  z[lc++]="    *framesPerBuffer = (unsigned long) (totframes/(*numberOfBuffers));";
  z[lc++]="  ";
  z[lc++]="    for (i = 1; i < *framesPerBuffer; i *= 2)";
  z[lc++]="      if ((*framesPerBuffer >= i) && (*framesPerBuffer <= i*2))";
  z[lc++]="	{";
  z[lc++]="	  *framesPerBuffer = (((*framesPerBuffer - i) ";
  z[lc++]="			       < (2*i - *framesPerBuffer)) ? i : 2*i);";
  z[lc++]="	  break;";
  z[lc++]="	}";
  z[lc++]="";
  z[lc++]="    num = Pa_GetMinNumBuffers(*framesPerBuffer, samplerate);";
  z[lc++]="";
  z[lc++]="    if (num <= *numberOfBuffers)";
  z[lc++]="      found = 1;";
  z[lc++]="    else";
  z[lc++]="      totframes *= 2;";
  z[lc++]="";
  z[lc++]="  } while ((found == 0) && (totframes < maxframes));";
  z[lc++]="";
  z[lc++]="  /* handle a driver with broken Pa_GetMinNumBuffers() */";
  z[lc++]="  ";
  z[lc++]="  if (found == 0)";
  z[lc++]="    {";
  z[lc++]="      *numberOfBuffers = ASYSN_PORTAUDIO_BUFFDEFAULT;";
  z[lc++]="      *framesPerBuffer = (ASYS_LATENCY/ATIME)/(*numberOfBuffers);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  asysn_portaudio_silence = *numberOfBuffers;";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && !defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*  portaudio output only: a ASYS_ACTIVE_IO, all ASYS_ACTIVE_O  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_osetup(long srate, long ochannels, long osample, ";
  z[lc++]="		char * oname, long toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  double samplerate = (double) srate;";
  z[lc++]="  unsigned long framesPerBuffer;";
  z[lc++]="  unsigned long numberOfBuffers;";
  z[lc++]="  PaDeviceID opid;";
  z[lc++]="  PaError err;";
  z[lc++]="";
  z[lc++]="  if (asysn_portaudio_init() == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (asysn_portaudio_outcheck(&samplerate, ochannels, &opid) == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (asysn_portaudio_buffparam(&framesPerBuffer, ";
  z[lc++]="				&numberOfBuffers, samplerate) == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  err = Pa_OpenStream(&asysn_portaudio_fd, ";
  z[lc++]="		      paNoDevice,   0, paFloat32, NULL, ";
  z[lc++]="		      opid, ochannels, paFloat32, NULL, ";
  z[lc++]="		      samplerate, framesPerBuffer, numberOfBuffers, ";
  z[lc++]="		      paClipOff | paDitherOff, asysn_portaudio_callback, NULL);";
  z[lc++]="		      ";
  z[lc++]="  if (err != paNoError)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"Error: Cannot open PortAudio stream (%s).\\n\", ";
  z[lc++]="	      Pa_GetErrorText(err));";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (ASYSN_PORTAUDIO_DEBUG)";
  z[lc++]="    {";
  z[lc++]="      printf(\"Opening output-only Portaudio stream, %i channels\\n\"";
  z[lc++]="	     \"sample rate %lf, %lu buffers of frame size %lu\\n\",";
  z[lc++]="	     ochannels, samplerate, numberOfBuffers, framesPerBuffer);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/* portaudio input only: a ASYS_ACTIVE_IO case                  */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_isetup(long srate, long ichannels, long isample, ";
  z[lc++]="		char * iname, long toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  double samplerate = (double) srate;";
  z[lc++]="  unsigned long framesPerBuffer;";
  z[lc++]="  unsigned long numberOfBuffers;";
  z[lc++]="  PaDeviceID ipid;";
  z[lc++]="  PaError err;";
  z[lc++]="";
  z[lc++]="  if (asysn_portaudio_init() == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (asysn_portaudio_incheck(&samplerate, ichannels, &ipid) == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (asysn_portaudio_buffparam(&framesPerBuffer, ";
  z[lc++]="				&numberOfBuffers, samplerate) == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  err = Pa_OpenStream(&asysn_portaudio_fd, ";
  z[lc++]="		      ipid, ichannels, paFloat32, NULL,";
  z[lc++]="		      paNoDevice,   0, paFloat32, NULL, ";
  z[lc++]="		      samplerate, framesPerBuffer, numberOfBuffers, ";
  z[lc++]="		      paClipOff | paDitherOff, asysn_portaudio_callback, NULL);";
  z[lc++]="		      ";
  z[lc++]="  if (err != paNoError)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"Error: Cannot open PortAudio stream (%s).\\n\", ";
  z[lc++]="	      Pa_GetErrorText(err));";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT) && defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*   portaudio input and output: a ASYS_ACTIVE_IO case          */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="int asys_iosetup(long srate, long ichannels, long ochannels,";
  z[lc++]="		 long isample, long osample, ";
  z[lc++]="		 char * iname, char * oname, long toption)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  double osamplerate = (double) srate;";
  z[lc++]="  unsigned long framesPerBuffer;";
  z[lc++]="  unsigned long numberOfBuffers;";
  z[lc++]="  PaDeviceID opid, ipid;";
  z[lc++]="  double isamplerate;";
  z[lc++]="  PaError err;";
  z[lc++]="";
  z[lc++]="  if (asysn_portaudio_init() == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (asysn_portaudio_outcheck(&osamplerate, ochannels, &opid) == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  isamplerate = osamplerate;";
  z[lc++]="";
  z[lc++]="  if (asysn_portaudio_incheck(&isamplerate, ichannels, &ipid) == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  if (asysn_portaudio_buffparam(&framesPerBuffer, ";
  z[lc++]="				&numberOfBuffers, isamplerate) == ASYS_ERROR)";
  z[lc++]="    return ASYS_ERROR;";
  z[lc++]="";
  z[lc++]="  err = Pa_OpenStream(&asysn_portaudio_fd, ";
  z[lc++]="		      ipid, ichannels, paFloat32, NULL, ";
  z[lc++]="		      opid, ochannels, paFloat32, NULL, ";
  z[lc++]="		      isamplerate, framesPerBuffer, numberOfBuffers,";
  z[lc++]="		      paClipOff | paDitherOff, asysn_portaudio_callback, NULL);";
  z[lc++]="		      ";
  z[lc++]="  if (err != paNoError)";
  z[lc++]="    {";
  z[lc++]="      fprintf(stderr, \"Error: Cannot open PortAudio stream (%s).\\n\", ";
  z[lc++]="	      Pa_GetErrorText(err));";
  z[lc++]="      return ASYS_ERROR;";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  return ASYS_DONE;";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*       common shutdown routine for all I/O combinations       */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asysn_portaudio_shutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  int status = Pa_StreamActive(asysn_portaudio_fd);";
  z[lc++]="";
  z[lc++]="  if (status == 1)";
  z[lc++]="    {";
  z[lc++]="      Pa_StopStream(asysn_portaudio_fd);";
  z[lc++]="      status = Pa_StreamActive(asysn_portaudio_fd);";
  z[lc++]="    }";
  z[lc++]="";
  z[lc++]="  if (status == 0)";
  z[lc++]="    Pa_CloseStream(asysn_portaudio_fd);";
  z[lc++]="";
  z[lc++]="  Pa_Terminate();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(!defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*                    shuts down audio output                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_oshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysn_portaudio_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (!defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input device                   */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ishutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysn_portaudio_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_HASOUTPUT)&&(defined(ASYS_HASINPUT)))";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*              shuts down audio input and output device        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_ioshutdown(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysn_portaudio_shutdown();";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="/****************************************************************/";
  z[lc++]="/*          active audio main -- works for all I/O types        */";
  z[lc++]="/****************************************************************/";
  z[lc++]="";
  z[lc++]="void asys_main(void)";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  asysn_portaudio_done = ASYS_DONE;";
  z[lc++]="";
  z[lc++]="  /* initialize passive audio input driver, if needed */";
  z[lc++]="  ";
  z[lc++]="#if (defined(ASYS_ACTIVE_IO) && !defined(ASYS_HASINPUT))";
  z[lc++]="";
  z[lc++]="  asysn_portaudio_ibuf = NULL;";
  z[lc++]="  asysn_portaudio_iptr  = 0;";
  z[lc++]="  asysn_portaudio_ilast = 0;";
  z[lc++]="";
  z[lc++]="  if ((asys_getbuf(&asysn_portaudio_ibuf, &asysn_portaudio_ilast) ";
  z[lc++]="       != ASYS_DONE) || (asysn_portaudio_ilast == 0))";
  z[lc++]="    return;";
  z[lc++]="  asysn_portaudio_ileft = asysn_portaudio_ilast;";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  /* initialize passive audio output driver, if needed */";
  z[lc++]="";
  z[lc++]="#if (defined(ASYS_ACTIVE_IO) && !defined(ASYS_HASOUTPUT))";
  z[lc++]="";
  z[lc++]="  asysn_portaudio_obuf = NULL;";
  z[lc++]="  asysn_portaudio_optr  = 0;";
  z[lc++]="  asysn_portaudio_olast = 0;";
  z[lc++]="";
  z[lc++]="  if (asys_preamble(&asysn_portaudio_obuf,&asysn_portaudio_olast) != ASYS_DONE)";
  z[lc++]="    return;";
  z[lc++]="";
  z[lc++]="  asysn_portaudio_oleft = asysn_portaudio_olast;";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  z[lc++]="  if (Pa_StartStream(asysn_portaudio_fd) != paNoError)";
  z[lc++]="    {";
  z[lc++]="      asysn_portaudio_done = ASYS_ERROR;";
  z[lc++]="      return;";
  z[lc++]="    }";
  z[lc++]="  ";
  z[lc++]="  while (asysn_portaudio_done == ASYS_DONE)";
  z[lc++]="    Pa_Sleep(ASYSN_PORTAUDIO_SLEEPMS);";
  z[lc++]="  ";
  z[lc++]="  if (asysn_portaudio_done == ASYS_ERROR)";
  z[lc++]="    Pa_AbortStream(asysn_portaudio_fd);";
  z[lc++]="  else";
  z[lc++]="    Pa_StopStream(asysn_portaudio_fd);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="";
  z[lc++]="#if defined(ASYS_KSYNC)";
  z[lc++]="";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*         initializes k-rate boundaries sync              */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="void ksyncinit()";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="/***********************************************************/";
  z[lc++]="/*         synchronizes on k-rate boundaries               */";
  z[lc++]="/***********************************************************/";
  z[lc++]="";
  z[lc++]="float ksync()";
  z[lc++]="";
  z[lc++]="{";
  z[lc++]="  return (float) Pa_GetCPULoad(asysn_portaudio_fd);";
  z[lc++]="}";
  z[lc++]="";
  z[lc++]="#endif";
  z[lc++]="";
  printlib(lc);
}


