#!/usr/bin/env cwl-runner

# This CWL file was automatically generated using CTDConverter.
# Visit https://github.com/WorkflowConversion/CTDConverter for more information.

baseCommand: mason_methylation
class: CommandLineTool
cwlVersion: v1.0
doc: "Simulate methylation levels for IN.fa and write them to OUT.fa.\n\n\n\nFor more\
  \ information, visit http://www.seqan.de"
inputs:
- default: 'false'
  doc: Low verbosity.
  id: param_quiet
  inputBinding:
    prefix: -quiet
  label: Low verbosity.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Higher verbosity.
  id: param_verbose
  inputBinding:
    prefix: -verbose
  label: Higher verbosity.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Highest verbosity.
  id: param_very-verbose
  inputBinding:
    prefix: -very-verbose
  label: Highest verbosity.
  type:
  - 'null'
  - string
- default: '0'
  doc: Seed for RNG.
  id: param_seed
  inputBinding:
    prefix: -seed
  label: Seed for RNG.
  type:
  - 'null'
  - int
- doc: Input FASTA file with genome.
  id: param_in
  inputBinding:
    prefix: -in
  label: Input FASTA file with genome.
  type: File
- doc: Input FASTA file with genome.
  id: param_out
  inputBinding:
    prefix: -out
  label: Input FASTA file with genome.
  type: File
- default: 'false'
  doc: Enable methylation level simulation.
  id: param_methylation-levels
  inputBinding:
    prefix: -methylation-levels
  label: Enable methylation level simulation.
  type:
  - 'null'
  - string
- default: '0.6'
  doc: Median of beta distribution for methylation level of CpG loci.
  id: param_meth-cg-mu
  inputBinding:
    prefix: -meth-cg-mu
  label: Median of beta distribution for methylation level of CpG loci.
  type:
  - 'null'
  - double
- default: '0.03'
  doc: Standard deviation of beta distribution for methylation level of CpG loci.
  id: param_meth-cg-sigma
  inputBinding:
    prefix: -meth-cg-sigma
  label: Standard deviation of beta distribution for methylation level of CpG loci.
  type:
  - 'null'
  - double
- default: '0.08'
  doc: Median of beta distribution for methylation level of CHG loci.
  id: param_meth-chg-mu
  inputBinding:
    prefix: -meth-chg-mu
  label: Median of beta distribution for methylation level of CHG loci.
  type:
  - 'null'
  - double
- default: '0.008'
  doc: Standard deviation of beta distribution for methylation level of CHG loci.
  id: param_meth-chg-sigma
  inputBinding:
    prefix: -meth-chg-sigma
  label: Standard deviation of beta distribution for methylation level of CHG loci.
  type:
  - 'null'
  - double
- default: '0.05'
  doc: Median of beta distribution for methylation level of CHH loci.
  id: param_meth-chh-mu
  inputBinding:
    prefix: -meth-chh-mu
  label: Median of beta distribution for methylation level of CHH loci.
  type:
  - 'null'
  - double
- default: '0.005'
  doc: Standard deviation of beta distribution for methylation level of CHH loci.
  id: param_meth-chh-sigma
  inputBinding:
    prefix: -meth-chh-sigma
  label: Standard deviation of beta distribution for methylation level of CHH loci.
  type:
  - 'null'
  - double
label: Methylation Level Simulation
