#!/usr/bin/perl

if ($ARGV[0]) {
	print "usage: gen_key.pl\n";
	print "  generates a 56 byte, random string, to be used as the site_key.\n";	print "  will use /dev/random if availible, otherwise uses perl's rand()\n";	print "  function.\n";
	exit;
}

if (-e '/dev/random') {
	open(RAND, '</dev/random') || die "couldn't open /dev/random: $!\n";
	binmode(RAND);
	my $raw;
	my $got = read(RAND, $raw, 28);
	warn "short read: wanted 28, only got $got\n" if $got != 28;
	close(RAND);
	my $key = unpack("H56", $raw);
	print $key, "\n";
} else {
	my $raw;
	foreach (1..28) {
		$raw .= chr(int(rand(255)));
	}
	my $key = unpack("H56", $raw);
	print $key, "\n";
}
