###
### windows/switcher.tcl: part of Scid
### Copyright (C) 2000-2004  Shane Hudson.


# 0: Unknown/empty
image create photo dbt0 -format gif -data \
 "R0lGODdhIAAgAIAAAAAAAP///ywAAAAAIAAgAAACHoyPqcvtD6OctNqLs968+w+G4kiW5omm
  6sq27gubBQA7"

# 1: Temporary database
image create photo dbt1 -format gif -data \
 "R0lGODdhIAAgAKEAAP///wAAAOHh4X9/fywAAAAAIAAgAAACXYSPqcvtD6OctNKAs9Y2iA+G
  X2AB20mWnhimHduWpjDQX127lYfftn6x1YQC4IRnIxolyGFvGWn6cjKpskq8qrJPbE/7+na3
  4p83OX7BRth1UWZCYeD0uv2Oz+sXBQA7"

# 2: Clipbase
image create photo dbt2 -format gif -data \
 "R0lGODdhIAAgAMIAAP///wAAqgAAAP//AOrq6gAAAAAAAAAAACwAAAAAIAAgAAADwAi63P4Q
  hKkCs9NKWvVd2KeFUmmCjVeOG3tWqIpxrHvR2Xp7XOT/wKBwISgaj8ik8SEYOJ/QqPTpaE6v
  2IZ1oOx2tU7BEGgVj39lUGbNbvcA6QphbpwT6vTinBGX2PF3enkCe0RhIH+CgYSDhQp9AYCS
  ikV8hxWTjIuJllwgmYmalYaeco2nmwSdZn6ooKqkrAGhtKern5S5oqxwlxKvqYG3mLq1wrGI
  rsWwj76zyruMw63Br9ORy9W8TbzY0cZFCQA7"

# 3: PGN file
image create photo dbt3 -format gif -data \
 "R0lGODdhIAAgAKEAAP////8AAAAA/wAAACwAAAAAIAAgAAACZISPqcvtD6MMlKIajAXbiP9p
  WMaNpfhsVoWyHQCG5/mKWGqqq3nEgq2z0WqKGmtYInliqMQoE3QQk7vmEiTJaiW+rvcr227B
  ZLBYXE77zmO1m611v+FceZpet5PxEX2ZDxiIVwAAOw=="

# 4: My games
image create photo dbt4 -format gif -data \
 "R0lGODdhIAAgANMAAAAAAAAAqgCqAACqqqoAAKoAqqpVAKqqqlVVVVVV/1X/VVX///9VVf9V
  ////Vf///ywAAAAAIAAgAAAEg9DISau9lOjNu//eI45kaZ7cqa5kyr6mC8+PTL/2veY6uo2B
  gCkIDBqNIxmxtHw0fZqiUFpkKZ9I0TP202aP1V3X+c2Sj8/rWdjcltTg9lSlJnvD9PFyP3e3
  9HN4fkmAQ31oZjw9b2OLUASOYlGRj5SVloyTmISamzWNmyCio6SlphsRADs="

# 5: Large database
image create photo dbt5 -format gif -data \
 "R0lGODdhIAAgAKEAAP8AAP///wAA/wAAACwAAAAAIAAgAAACiYSPqcvtH6KctFpks544iA9+
  WRhGHQmOqGAeUblR8AnH3uzeNxunYkB7/VS8X1DIq6SELQNTspxEdcCcZTqldIjIzZaYrXzB
  tvE1LLaChxmz9IeWuLtQtjbHDmN5xx33eRRHZ4THIlhnyFd4+LZEY9fjuEiyJum0Q3mG0gRg
  4ymn9un1QFpqeloAADs="

# 6: Correspondence chess
image create photo dbt6 -format gif -data \
 "R0lGODdhIAAgANMAAAAAAAAAqgCqAACqqqoAAKoAqqpVAKqqqlVVVVVV/1X/VVX///9VVf9V
  ////Vf///ywAAAAAIAAgAAAEuPDJ+YC1NOs97fkfxo0UcDxgKpIcgL5p6LLZPJ24atM7leu8
  1waHAo5MMM4PtKoliRniwTPdmFLJ4ZWpuVI/2U6sWgsxvk/UltrzMs5f6TpEFk/fF/RpLivf
  zzJUaipqbTKATBd0XFNta1uJi5E9EnFjTJd1XZCXnFwkliqZlJueU52kNQYGlpxNoKusX480
  JbEeuI21qqsmvhe7Xbe/wS23p6nBAMO6xcK9yM7Pss3SGdAuydKvNBEAOw=="

# 7: Computer chess
image create photo dbt7 -format gif -data \
 "R0lGODdhIAAgAKEAAP///wAAAOHh4QAA/ywAAAAAIAAgAAACdISPqcvtD6OctNrrgt680yCE
  4kgGEigM6squoQmBrRrMgwA/cmvWLR7ZrXI+Vy6T4gGKxmByeGDejg3hgMoExp7XRJbKsHY0
  LK0uZJu9TqT2CJwZy+HxuSdoz9Oj7v77rDdmFuZXuGcQaIexyNjo+AgZ6VAAADs="

# 8: Index of games
image create photo dbt8 -format gif -data \
 "R0lGODdhIAAgANMAAAAAAAAAqgCqAACqqqoAAKoAqqpVAKqqqlVVVVVV/1X/VVX///9VVf9V
  ////Vf///ywAAAAAIAAgAAAEovDJSau9OOvNu/9gKALkE5wPqa5A10pJHGtvxrImqkrAcWC1
  i2zGS/kut1wglUwZf5UgbIh09qCT0ml5w1mflNcwsWmZwbyuuvQ1H52hs/z9WkvbVvoIfy0y
  11F8enFtCQGDgBZyKYeDIHKGPo4fco1vW5iZmDVmkZI8Y6FjAEtWllh2ajqebxSir2OnGJq0
  mpJYF7e6u7scvL+3IsLDxMUUEQA7"

# 9: Player collection
image create photo dbt9 -format gif -data \
 "R0lGODdhIAAgAKEAAP///wAAANjGpuFCACwAAAAAIAAgAAACg4SPqcvtD6NMoYYJg9jiYqZx
  m/dR4liaJ5oa4Uq2LxfLcKuyOBLW++wrVWBByewmXCExR2VRYYlKp9FGYIDNarfcQfCadXkq
  YrHWB8aSAeu250zZltnj+jaWVtfn6/shj8W3R8c1VjjoZlDI1iUo2FUBiTgI2WV5iZmpKUnV
  6Tm141AAADs="

# 10: Tournament, all-play-all
image create photo dbt10 -format gif -data \
 "R0lGODdhIAAgAKEAAP///wAAAAAA//8AACwAAAAAIAAgAAACZoSPqcvtH6KMYM6HM7RVdq+F
  4kg2gnEC6YqW7usIsmwExnDnAL7rmA1rAF0zWq+i4yl9mmFQ4QwVU0vkscojRZ+HbayY1AGx
  QS/XnJiGr7X1E13+ztZka5ZrxSO8ara/CqcnOJhQAAA7"

# 11: Tournament, Swiss
image create photo dbt11 -format gif -data \
 "R0lGODdhIAAgAIAAAP8AAP///ywAAAAAIAAgAAACRYSPqcvtD6OctFoQss437d0hnxYeI1di
  Z6qO7BlU8Pw59B03OG3vcO9z6YJCBrG4ONYov1Sz9AxFO9NL1XJlabfcrldRAAA7"

# 12: GM games
image create photo dbt12 -format gif -data \
 "R0lGODdhIAAgANMAAAAAAAAAqgCqAACqqqoAAKoAqqpVAKqqqlVVVVVV/1X/VVX///9VVf9V
  ////Vf///ywAAAAAIAAgAAAEjNDISau9lOjNu//eI45kaZ7cqa5kyr6mC8+PTL/2veY6upWB
  YNA0BAZEMuFIuTwakT9RsUliSouuadX5sHaxUa1K6CRDNVeY+QtGf5vrt7lNSBO5w7kzy91S
  34BJfWx/RXRwcHiDgVGJR1NijG49O42UPpOXMZaaLZydZ3WgJTygpZ2nmiCrrK2urxsRADs="

# 13: IM games
image create photo dbt13 -format gif -data \
 "R0lGODdhIAAgANMAAAAAAAAAqgCqAACqqqoAAKoAqqpVAKqqqlVVVVVV/1X/VVX///9VVf9V
  ////Vf///ywAAAAAIAAgAAAEhNDISau9lOjNu//eI45kaZ7cqa5kyr6mC8+PTL/2veY6up2B
  wChoIpZ4D2NSWFKOkMogUySN/YrT6tApgma10unz2vwaw1YN8LskcmtkUlSIfnu3VKY9js/7
  l2kEa31yYl18f4BlgT04iI0tj5CHapM+lZZHkpNIlp2cm5Ago6SlpqcbEQA7"

# 14: Blitz games
image create photo dbt14 -format gif -data \
 "R0lGODdhIAAgANMAAAAAAAAAqgCqAACqqqoAAKoAqqpVAKqqqlVVVVVV/1X/VVX///9VVf9V
  ////Vf///ywAAAAAIAAgAAAEgvDJSau9OOvNu89AKI7AV4VOqqqlKaHrGroPHKfh4dp3rn+8
  mO/XCcoAhyQQcGMhlR6jM0nkSHGk2ebaxFm7XZGVBHYMo8zwsApKN9dsDHeNVj+hYzUV/33f
  +WM2Ins0NW5whYJ/cUVpg1SFhlh7jI2TkJEoj4A7ZouRE5uchZSgEhEAOw=="

# 15: Tactics
image create photo dbt15 -format gif -data \
 "R0lGODdhIAAgANMAAAAAAAAAqgCqAACqqqoAAKoAqqpVAKqqqlVVVVVV/1X/VVX///9VVf9V
  ////Vf///ywAAAAAIAAgAAAEdtDISau9lOjNu//eI45kaZ7cqa5kyr6mC8+PTL/2veY6uqmB
  wCkY9GmAwlLxsWz9hslRkxkV8URTKil71bK4T1NWWbWGyatx7bwtS93mIxSp6vZG9vtaLoZ7
  Y2x6TnyCJXl3hz2JOos3jTSPM5EwIJWWl5iZGxEAOw=="

# 16: Endings
image create photo dbt16 -format gif -data \
 "R0lGODdhIAAgAKEAAP///wAAAP/73wAAACwAAAAAIAAgAAAChYSPqcsZDWOYsa5ns5lYXwoE
  AsZ54TQ+orqCFToK6RynVsulONpBO6/L9Ro/Hkd4Kx6FQ2JLBpUZPbBltfmyWjeg0ql3jAY3
  wTJYuySLxec1tIs+OuJD0RpLRZsUdvbe4Yan0RclmEH49oeAKKV4wDjiyKUlCcNm6EPnMghZ
  iMmn6SXJUAAAOw=="

# 17: Openings for White
image create photo dbt17 -format gif -data \
 "R0lGODdhIAAgANMAAAAAAAAAqgCqAACqqqoAAKoAqqpVAKqqqlVVVVVV/1X/VVX///9VVf9V
  ////Vf///ywAAAAAIAAgAAAErvDJSau9F+jNu9cYMBxDaZ4oCoRj6rqgJZJvXQLHWs22jec6
  Ca/3+gWCjyExZUQqURLf4XCkPE2UWtPaSmWL0+rkWvrCws6u9yGlpmnQiRbNhWMrYHd9bVbR
  x2plF2d6gHYDGIRiQoGIg0x/jIdLN5FJjZQDW4aZfoWSnSeboKGVn5eTlKOopaaLSRqtmpY/
  H7YetD9Tu7y9vpawv8LCr0IbAcjJysvMSFa30BwSEQA7"

# 18: Openings for Black
image create photo dbt18 -format gif -data \
 "R0lGODdhIAAgANMAAAAAAAAAqgCqAACqqqoAAKoAqqpVAKqqqlVVVVVV/1X/VVX///9VVf9V
  ////Vf///ywAAAAAIAAgAAAErvDJSau9F+jNu9cYMBxDaZ4oCoRj6rqgJZJvXQLHWs22jec6
  Ca/3+gWCjyExZUQqVaJak/I0caSHw5HaYm6wWmcXqgFvJ1VrtJg9C8enKzvMpcU7c3cSfsPD
  2mJ2fR5/dGh8H2txgHVkfiqMh4JLVpFvk5QDU5KZkIaXnYufe5iUm6ChN5akqaqjX62nSVmJ
  tRyrGlm6u7y9u3pJP77DvcDBGgHJysvMzUhUttExEQA7"

# 19: Openings for either color
image create photo dbt19 -format gif -data \
 "R0lGODdhIAAgANMAAAAAAAAAqgCqAACqqqoAAKoAqqpVAKqqqlVVVVVV/1X/VVX///9VVf9V
  ////Vf///ywAAAAAIAAgAAAEuvDJSau9F+jNu9cYMBxDaZ4oCoRj6rqgJZKq+JrAsVZzrd2l
  nG4n6Z04wIEwQHwYcZvksvmEJpWHA5NSVUaBU24LiryFJ1UPOLtFj73q17n4/tgkKja1/hlQ
  jnpiNEB/OIFugzeFQYd0iYoPeVp7jy6LWJOCSRaGmYibFZ1tjoQXjJ6kkJyYo05vlqaslFdy
  ja6VtLJcP7mSrUJ2wRy2GlnGx8jJx61OQsrPyczNGgHV1tfY2U27wt07EQA7"

# 20: Theory: 1.c4
image create photo dbt20 -format gif -data \
 "R0lGODdhIAAgAKEAAP/739jGpgAAAP///ywAAAAAIAAgAAACfYRvoauIzNyBSyYaLMDZcv15
  GDiKFHmaELqqkVvBXCN3UniXebq3/fuLBWlDmwN31CV5S18T+BRqokSqTSCYKB8lwWCQ3Wy1
  PCzZyU15wRdmerX+ZpHvCPY+H7fRZ2h9VvUX2CclaGTI4kc4uKfYWLh4GJkI+cgo5jZZo1EA
  ADs="

# 21: Theory: 1.d4
image create photo dbt21 -format gif -data \
 "R0lGODdhIAAgAKEAAP/739jGpgAAAP///ywAAAAAIAAgAAACf4RvoauIzNyBSyYaLMDZcv15
  GDiKFHmaELqqkVvBXCN3UniXebq3/fuLBWlDmwN31CV5S18T+BRqokSq8aEQCKRYJlYwGGyv
  E2VXyy17y2Bxtet8tMNbFlSuzZMva35cPXMHKOhHuGE2mFaoeNjX+Lf4ligZufdoiASHiVip
  UQAAOw=="

# 22: Theory: 1.d4 d5
image create photo dbt22 -format gif -data \
 "R0lGODdhIAAgAKEAAP/739jGpgAAAP///ywAAAAAIAAgAAACh4RvoauIzNyBSyYaLMDZcv15
  GDiKFHmaELqqkVvBXCN3UggIwlTepa67pHzDoLBFbAF3m57jswzinqPobvpwZocaKneL9Opi
  yZdPMBgIaGWyeM32hrNodRxsftbTa1b+YWUj98fzVThDeJTYZKjohvd4uIglGel4V4l5KQip
  yTiXyRnqZwlQAAA7"

# 23: Theory: QGD
image create photo dbt23 -format gif -data \
 "R0lGODdhIAAgAKEAAP/739jGpgAAAP///ywAAAAAIAAgAAACmYRvoauIzNyB6wgxaZBJm3t1
  FAdo24eJEGmiYelxLQjCo+zRYYvfksn7xYS+l23VQ9JUkWQTYAw6eMvjc5rTWSvOig4jfQyx
  PhIZSURHFRduuikYDFJsuaDRxUNTtrb+DGfXETf3JzZCKBiQWMiStbSoc/LmBlh5CHSFqZlR
  tnnZiWZpGMrJBHpKmjo5yvqpugUbVooa63pQAAA7"

# 24: Theory: Slav
image create photo dbt24 -format gif -data \
 "R0lGODdhIAAgAKEAAP/739jGpgAAAP///ywAAAAAIAAgAAACmIRvoauIzI4QBy5XbTBzJo19
  lkSJUAhoG9CVKvq23hvGcgrWOUbz6u7oBXceU0Q3YnWMF+SJU8IlfckWs+GMyCjCB2grfVLF
  wymqTPZOi9JJc3wUDAaugJyOhb/ZC3ceHTdXdyfwp3ZyJ5iSiAfzdWMns6JnmGF2+PMGqInJ
  aZn2eUQ5uVl5RdppGiZaihrqeep4+aradVAAADs="

# 25: Theory: 1.d4 Nf6
image create photo dbt25 -format gif -data \
 "R0lGODdhIAAgAKEAAP/739jGpgAAAP///ywAAAAAIAAgAAACioRvoauIKqJoLrFVrYwhg4tl
  wcZ5IFWNZCeeJiexqdtCZX29q0lXZNxznGTC4MN4GPJAyxyO0YQ+QzPmFFW0Vp1baZfqyXLF
  3iwHe9QWBYPBhJgep8/wJFLTfkfBD3bbXWeh1rdzFfhxhzg0aMcoKNcI+VgWRxlpOcl3qZmJ
  tunZeahkuAeqKAlQAAA7"

# 26: Theory: 1.e4
image create photo dbt26 -format gif -data \
 "R0lGODdhIAAgAKEAAP/739jGpgAAAP///ywAAAAAIAAgAAACfYRvoauIzNyBSyYaLMDZcv15
  GDiKFHmaELqqkVvBXCN3UniXebq3/fuLBWlDmwN31CV5S18T+BRqokSq8aETCCZKbEowGGw3
  XS5Pa3Z6W2DxhbmOtMNbZLyizdfLb3V6JnVXJXj1F2g4iFjYB0XI0qj4eMg4SQYXWSOZaFAA
  ADs="

# 27: Theory: Sicilian
image create photo dbt27 -format gif -data \
 "R0lGODdhIAAgAKEAAP/739jGpgAAAP///ywAAAAAIAAgAAAChYRvoauIzNyBSyYaLMDZcv15
  GDiKFHmaELqqkVvBXCN30iII8V3yeU7jpYTAoCPk+xkfveNPyXrdnsDo7thkDjXYrbYlBOcm
  WXJKMBgILl6zeM0Gd1todVw6j9TTa2S+QtVXdnf1NVPohmeISLiUyLgxGNnWaPPnWGmFOSm3
  uOnnaRmqUQAAOw=="

# 28: Theory: Sicilian 1.e4 c5 2.Nd3 d6 3.d4
image create photo dbt28 -format gif -data \
 "R0lGODdhIAAgAKEAAP/739jGpgAAAP///ywAAAAAIAAgAAACo4RvoauIzNxZQiyZYMOq1i1p
  oENZ4yNiQOedU8p5rSoGtPzRcLiTdY/S6AIfV0bIIbZsSSRPeWlCdDLjCjjBWYbTGI757IYj
  UrJqHEVbS+nKy+kTDAYmg5x+FPugIHfeHDdXB3An8JdGcidoo4hXc/NFiHMFF6Rn+YOIGSVz
  uJbSaPhYRjFnKorlSURXSHn5BuFB6JjqatY6qsaoiFoJy6BVUQAAOw=="

# 29: Theory: Caro-Kann
image create photo dbt29 -format gif -data \
 "R0lGODdhIAAgAKEAAP/739jGpgAAAP///ywAAAAAIAAgAAACh4RvoauIzI4QBy5XbTBzJo19
  lkSJUAhoG9CVKvq23hvGcgrWOUbz6u7oBYEPYmakQ/qUQ2bReTwlpUtq0/rERiNTLqrqvYaz
  Xo9pvL2wBgOX8axmlXBQeGPdtq/AFwGbTSFE1ncjmHbH97MnFseI6Lg4+CgZeVipB/NGp4XZ
  1UiZWbeJ1olRAAA7"

# 30: Theory: French
image create photo dbt30 -format gif -data \
 "R0lGODdhIAAgAKEAAP/739jGpgAAAP///ywAAAAAIAAgAAACiIRvoauIzNyB6wgxaZBJm3t1
  FAdo24eJEGmiYelxLQjCo+zRYYvfksn7xYQ+R9A4RBYfSeYy81RFeivqlFjFXpVZ7pbk7Ia/
  0OzLJi5PBYNB6jiuoNRyrZztlta9FXwbA0fXoAPYJHhiB4TI12C1F9eYuAg5echiqBfJWJnJ
  iUbWeRn1+WjJUQAAOw=="

# 31: Theory: Open Games
image create photo dbt31 -format gif -data \
 "R0lGODdhIAAgAKEAAP/739jGpgAAAP///ywAAAAAIAAgAAACh4RvoauIzNyBSyYaLMDZcv15
  GDiKFHmaELqqkVvBXCN3UngrghDnab7b0Xwtn3DowCUDQZ5t+Us2hazXbcqr9qBFDdf63T5K
  gN2EHKYJBgPBJTr+md/deGvdpoPtETzbrcRXgbWBJoh0OKOFeAbXWPe4Fyk2yahHeWlZ6Jj5
  lLjoWRnaCapRAAA7"

variable ::windows::switcher::base_types { 
  Unknown
  {Temporary database}
  Clipbase
  {PGN format file}
  {My games}
  {Large database}
  {Correspondence chess}
  {Computer chess}
  {Sorted Index of games}
  {Player collection}
  {Tournament: All-play-all}
  {Tournament: Swiss}
  {Grandmaster games}
  {International Master games}
  {Blitz (fast) games}
  {Tactics}
  {Endgames}
  {Openings for White}
  {Openings for Black}
  {Openings for either color}
  {Theory: 1.c4}
  {Theory: 1.d4}
  {Theory: 1.d4 d5}
  {Theory: QGD: 1.d4 d5 2.c4 e6}
  {Theory: Slav: 1.d4 d5 2.c4 c6}
  {Theory: 1.d4 Nf6}
  {Theory: 1.e4}
  {Theory: Sicilian: 1.e4 c5}
  {Theory: Sicilian: 1.e4 c5 2.Nf3 d6 3.d4}
  {Theory: Caro-Kann: 1.e4 c6}
  {Theory: French: 1.e4 e6}
  {Theory: Open Games: 1.e4 e5}
}


set numBaseTypeIcons [llength $::windows::switcher::base_types]

set temp_dbtype 0

proc selectBaseType {type} {
  global temp_dbtype
  set w .btypeWin
  if {![winfo exists $w]} { return }
  $w.t configure -state normal
  set temp_dbtype $type
  set linenum [expr $type + 1]
  $w.t tag remove sel 1.0 end
  $w.t tag remove selected 1.0 end
  $w.t tag add selected "${linenum}.2 linestart" "$linenum.2 lineend"
  $w.t see $linenum.2
  $w.t configure -state disabled
}

proc clickBaseType {x y} {
  set type [.btypeWin.t index "@$x,$y linestart"]
  set type [expr int($type) - 1]
  selectBaseType $type
}

proc changeBaseType {baseNum} {
  global temp_dbtype ::windows::switcher::base_types numBaseTypeIcons
  if {$baseNum > [sc_base count total]} { return }
  set temp_dbtype [sc_base type $baseNum]
  if {$temp_dbtype >= $numBaseTypeIcons} { set temp_dbtype 0 }
  toplevel .btypeWin
  set w .btypeWin
  wm title $w "Scid: Choose database icon"

  text $w.t -yscrollcommand "$w.yscroll set" -font font_Regular \
    -height 25 -width 40 -background white -wrap none \
    -cursor top_left_arrow
  $w.t tag configure selected -background {#ffff80}

  scrollbar $w.yscroll -command "$w.t yview" -takefocus 0
  pack [frame $w.b] -side bottom -pady 5
  pack $w.yscroll -side right -fill y
  pack $w.t -side left -fill both -expand yes

  dialogbutton $w.b.set -text "OK" -command \
    "catch {sc_base type $baseNum \$temp_dbtype}; ::windows::switcher::Refresh; ::maint::Refresh;
     focus .; destroy $w"

  dialogbutton $w.b.cancel -text $::tr(Cancel) -command "focus .; destroy $w"
  pack $w.b.set $w.b.cancel -side left -padx 5

  set numtypes [llength $base_types]
  for {set i  0} {$i < $numtypes} {incr i} {
    if {$i > 0} { $w.t insert end "\n" }
    $w.t image create end -image dbt$i -pady 3 -padx 3
    $w.t insert end "   [lindex $base_types $i]  "
  } 

  bind $w.t <Double-ButtonRelease-1> "clickBaseType %x %y; $w.b.set invoke"
  bind $w.t <ButtonRelease-1> "clickBaseType %x %y"
  bind $w.t <Button1-Motion> "clickBaseType %x %y; break"

  bind $w <Up> {
    if {$temp_dbtype != 0} { selectBaseType [expr $temp_dbtype - 1] }
    break
  }

  bind $w <Down> {
    if {$temp_dbtype < [expr [llength $base_types] - 1]} {
      selectBaseType [expr $temp_dbtype + 1]
    }
    break
  }

  bind $w <Home> { selectBaseType 0 }
  bind $w <End> { selectBaseType [expr [llength $base_types] - 1] }
  bind $w <Escape> "$w.b.cancel invoke"
  bind $w <Return> "$w.b.set invoke"

  focus $w.t
  grab $w
  update
  selectBaseType $temp_dbtype
}



proc ::windows::switcher::pressMouseEvent {i} {
  if {! [winfo exists .baseWin]} {return}
  foreach win {"" .img .name .ngames} {
    .baseWin.c.f$i$win configure -cursor exchange
  }
}

proc ::windows::switcher::releaseMouseEvent {fromBase x y} {
  if {! [winfo exists .baseWin]} {return}
  foreach win {"" .img .name .ngames} {
    .baseWin.c.f$fromBase$win configure -cursor {}
  }
  set dropPoint [winfo containing $x $y]
  if {! [string match ".baseWin.c.f*" $dropPoint]} {return}
  set toBase [string range $dropPoint 12 12]
  if {$toBase == $fromBase} {::file::SwitchToBase $toBase} else {
    copyFilter $fromBase $toBase
  }
}

set baseWin 0

proc ::windows::switcher::Open {} {
  global baseWin
  if {[winfo exists .baseWin]} {
    focus .
    destroy .baseWin
    set baseWin 0
    return
  }
  set baseWin 1
  set w .baseWin
  ::createToplevel .baseWin
  
  bind $w <Configure> "+recordWinSize $w"
  bind $w <Configure> "+::windows::switcher::Refresh"
  setWinLocation $w

  ::setTitle $w "Scid: [tr WindowsSwitcher]"

  bind $w <Escape> ::windows::switcher::Open
  bind $w <Destroy> { set baseWin 0 }
  bind $w <F1> { helpWindow Switcher }
  standardShortcuts $w

  canvas $w.c -width 300 -height 100 -yscrollcommand [list $w.ybar set]
  scrollbar $w.ybar -takefocus 0 -command [list $w.c yview]
  label $w.status -width 1 -anchor w -relief sunken -borderwidth 1

  grid $w.c -row 0 -column 0 -sticky news
  grid $w.ybar -row 0 -column 1 -sticky ns
  grid $w.status -row 1 -column 0 -sticky we
  grid rowconfigure $w 0 -weight 1
  grid columnconfigure $w 0 -weight 1

  #set side left
  #if {$::windows::switcher::vertical} { set side top }
  set numBases [sc_base count total]

  for {set i 1} {$i <= $numBases} {incr i} {
    set f [frame $w.c.f$i -background white -borderwidth 2 -relief ridge]
    $w.c create window 0 0 -window $w.c.f$i -anchor nw -tag tag$i

    set f $w.c.f$i
    label $f.img -image dbt0 -relief solid -borderwidth 1
    label $f.name -width 11 -anchor w -font font_Small
    label $f.ngames -text "0" -width 11 -anchor e -font font_Tiny
    grid $f.img -row 0 -column 0 -rowspan 2 -padx 2 -pady 2
    grid $f.name -row 0 -column 1 -padx 2 -pady 0 -sticky we
    grid $f.ngames -row 1 -column 1 -padx 2 -pady 0 -sticky we

    foreach win {"" .img .name .ngames} {
      bind $f$win <ButtonPress-1> [list ::windows::switcher::pressMouseEvent $i]
      bind $f$win <ButtonRelease-1> [list ::windows::switcher::releaseMouseEvent $i %X %Y]
    }

    menu $f.menu -tearoff 0
    $f.menu add command -label [tr SearchReset] \
      -command "sc_filter reset $i; ::windows::stats::Refresh"
    $f.menu add command -label [tr ChangeIcon] -command "changeBaseType $i"
    $f.menu add separator
    $f.menu add command -label [tr FileOpen] -command ::file::Open
    set closeLabel [tr FileClose]
    if {$i == [sc_info clipbase]} { set closeLabel [tr EditReset] }
    $f.menu add command -label $closeLabel \
      -command [list ::file::Close $i]
    foreach win {"" .img .name .ngames} {
      bind $f$win <ButtonPress-$::MB3> "tk_popup $f.menu %X %Y"
    }
    $f.menu add separator
    $f.menu add checkbutton -label "Icons" -variable ::windows::switcher::icons \
      -command ::windows::switcher::Refresh
    #$f.menu add separator
    #$f.menu add command -label $::tr(ChangeOrient) -command ::windows::switcher::Orientate
  }
  setWinSize $w
  ::windows::switcher::Refresh
  ::createToplevelFinalize $w
}

proc ::windows::switcher::Orientate {} {
  #variable vertical
  #if {$vertical} {
  #  set vertical 0
  #  set side left
  #} else {
  #  set vertical 1
  #  set side top
  #}

  #set w .baseWin
  #set numBases [sc_base count total]

  #for {set i 1} {$i <= $numBases} {incr i} {
  #  pack forget $w.f$i
  #}
  #for {set i 1} {$i <= $numBases} {incr i} {
  #  pack $w.f$i -side $side
  #}
}

proc ::windows::switcher::Refresh {} {
  global numBaseTypeIcons
  variable icons
  set w .baseWin

  if {! [winfo exists $w]} { return }
  set numBases [sc_base count total]
  set current [sc_base current]
  set clipbase [sc_info clipbase]

  # Get the canvas width and icon dimensions, to compute the correct
  # scroll region.

  for {set i 1} {$i <= $numBases} {incr i} {
    if {$icons} {
      grid $w.c.f$i.img -row 0 -column 0 -rowspan 2 -padx 2 -pady 2
    } else {
      grid forget $w.c.f$i.img
    }
  }

  set canvasWidth [winfo width $w.c]
  set iconWidth [winfo width $w.c.f$clipbase]
  incr iconWidth 5
  set iconHeight [winfo height $w.c.f$clipbase]
  incr iconHeight 5

  # Compute the number of columns that can fit in the canvas
  set numColumns [expr {int($canvasWidth / $iconWidth)}]
  if {$numColumns < 1} { set numColumns 1 }
  set numDisplayed 0

  set row 0
  set column 0
  set x 0
  set y 0
  set status ""

  for {set i 1} {$i <= $numBases} {incr i} {
    if {[sc_base inUse $i]} {
      set color white
      set filename [file nativename [sc_base filename $i]]
      set n $i
      # Do we want to call the clipbase base number "C"?
      # Only if we do it everywhere else for consistency.
      # if {$i == $clipbase} { set n "C" }

      # Set a different color for the current database.
      if {$i == $current} {
        set color lightSteelBlue
        set status $filename
        if {[sc_base isReadOnly]} { append status " ($::tr(readonly))" }
      }

      $w.c.f$i configure -background $color
      set dbtype [sc_base type $i]
      if {$dbtype >= $numBaseTypeIcons} { set dbtype 0 }
      if {$icons} {
        $w.c.f$i.img configure -image dbt$dbtype -background $color
      } else {
        $w.c.f$i.img configure -image ""
      }
      if {$i == $clipbase} {
        set name [sc_base filename $i]
        $w.c.f$i.name configure -background $color \
      } else {
        set name "$n: [file tail [sc_base filename $i]]"
      }
      $w.c.f$i.name configure -background $color -text $name
      $w.c.f$i.ngames configure -background $color \
        -text "[filterText $i 100000]"
      $w.c itemconfigure tag$i -state normal
      $w.c coords tag$i [expr $x + 2] [expr $y + 2]
      incr column
      if {$column == $numColumns} {
        set column 0
        set x 0
        incr y $iconHeight
        incr row
      } else {
        incr x $iconWidth
      }
      incr numDisplayed
    } else {
      $w.c itemconfigure tag$i -state hidden
    }
  }

  set numRows [expr {int( ($numDisplayed + $numColumns - 1) / $numColumns)}]
  if {$numRows < 1} { set numRows 1 }
  set top 0
  set left 0
  set right [expr {$numColumns * $iconWidth}]
  set bottom [expr {$numRows * $iconHeight}]
  $w.c configure -scrollregion [list $left $top $right $bottom]
  if {[winfo height $w.c] >= $bottom} {
    grid forget $w.ybar
  } else {
    grid $w.ybar -row 0 -column 1 -sticky ns
  }
  $w.status configure -text $status
}
