# basewind.tcl: part of Scid
# Copyright (C) 2000   Shane Hudson.


# 0: Unknown/empty
image create photo dbt0 -format gif -data \
 "R0lGODdhIAAgAIAAAAAAAP///ywAAAAAIAAgAAACHoyPqcvtD6OctNqLs968+w+G4kiW5omm
  6sq27gubBQA7"

# 1: Temporary database
image create photo dbt1 -format gif -data \
 "R0lGODdhIAAgAKEAAP///wAAAOHh4X9/fywAAAAAIAAgAAACXYSPqcvtD6OctNKAs9Y2iA+G
  X2AB20mWnhimHduWpjDQX127lYfftn6x1YQC4IRnIxolyGFvGWn6cjKpskq8qrJPbE/7+na3
  4p83OX7BRth1UWZCYeD0uv2Oz+sXBQA7"

# 2: Clipbase
image create photo dbt2 -format gif -data \
 "R0lGODdhIAAgAMIAAP///wAAqgAAAP//AOrq6gAAAAAAAAAAACwAAAAAIAAgAAADwAi63P4Q
  hKkCs9NKWvVd2KeFUmmCjVeOG3tWqIpxrHvR2Xp7XOT/wKBwISgaj8ik8SEYOJ/QqPTpaE6v
  2IZ1oOx2tU7BEGgVj39lUGbNbvcA6QphbpwT6vTinBGX2PF3enkCe0RhIH+CgYSDhQp9AYCS
  ikV8hxWTjIuJllwgmYmalYaeco2nmwSdZn6ooKqkrAGhtKern5S5oqxwlxKvqYG3mLq1wrGI
  rsWwj76zyruMw63Br9ORy9W8TbzY0cZFCQA7"

# 3: PGN file
image create photo dbt3 -format gif -data \
 "R0lGODdhIAAgAKEAAP////8AAAAA/wAAACwAAAAAIAAgAAACZISPqcvtD6MMlKIajAXbiP9p
  WMaNpfhsVoWyHQCG5/mKWGqqq3nEgq2z0WqKGmtYInliqMQoE3QQk7vmEiTJaiW+rvcr227B
  ZLBYXE77zmO1m611v+FceZpet5PxEX2ZDxiIVwAAOw=="

# 4: My games
image create photo dbt4 -format gif -data \
 "R0lGODdhIAAgANMAAAAAAAAAqgCqAACqqqoAAKoAqqpVAKqqqlVVVVVV/1X/VVX///9VVf9V
  ////Vf///ywAAAAAIAAgAAAEg9DISau9lOjNu//eI45kaZ7cqa5kyr6mC8+PTL/2veY6uo2B
  gCkIDBqNIxmxtHw0fZqiUFpkKZ9I0TP202aP1V3X+c2Sj8/rWdjcltTg9lSlJnvD9PFyP3e3
  9HN4fkmAQ31oZjw9b2OLUASOYlGRj5SVloyTmISamzWNmyCio6SlphsRADs="

# 5: Large database
image create photo dbt5 -format gif -data \
 "R0lGODdhIAAgAKEAAP8AAP///wAA/wAAACwAAAAAIAAgAAACiYSPqcvtH6KctFpks544iA9+
  WRhGHQmOqGAeUblR8AnH3uzeNxunYkB7/VS8X1DIq6SELQNTspxEdcCcZTqldIjIzZaYrXzB
  tvE1LLaChxmz9IeWuLtQtjbHDmN5xx33eRRHZ4THIlhnyFd4+LZEY9fjuEiyJum0Q3mG0gRg
  4ymn9un1QFpqeloAADs="

# 6: Correspondence chess
image create photo dbt6 -format gif -data \
 "R0lGODdhIAAgANMAAAAAAAAAqgCqAACqqqoAAKoAqqpVAKqqqlVVVVVV/1X/VVX///9VVf9V
  ////Vf///ywAAAAAIAAgAAAEuPDJ+YC1NOs97fkfxo0UcDxgKpIcgL5p6LLZPJ24atM7leu8
  1waHAo5MMM4PtKoliRniwTPdmFLJ4ZWpuVI/2U6sWgsxvk/UltrzMs5f6TpEFk/fF/RpLivf
  zzJUaipqbTKATBd0XFNta1uJi5E9EnFjTJd1XZCXnFwkliqZlJueU52kNQYGlpxNoKusX480
  JbEeuI21qqsmvhe7Xbe/wS23p6nBAMO6xcK9yM7Pss3SGdAuydKvNBEAOw=="

# 7: Computer chess
image create photo dbt7 -format gif -data \
 "R0lGODdhIAAgAKEAAP///wAAAOHh4QAA/ywAAAAAIAAgAAACdISPqcvtD6OctNrrgt680yCE
  4kgGEigM6squoQmBrRrMgwA/cmvWLR7ZrXI+Vy6T4gGKxmByeGDejg3hgMoExp7XRJbKsHY0
  LK0uZJu9TqT2CJwZy+HxuSdoz9Oj7v77rDdmFuZXuGcQaIexyNjo+AgZ6VAAADs="

# 8: Index of games
image create photo dbt8 -format gif -data \
 "R0lGODdhIAAgANMAAAAAAAAAqgCqAACqqqoAAKoAqqpVAKqqqlVVVVVV/1X/VVX///9VVf9V
  ////Vf///ywAAAAAIAAgAAAEovDJSau9OOvNu/9gKALkE5wPqa5A10pJHGtvxrImqkrAcWC1
  i2zGS/kut1wglUwZf5UgbIh09qCT0ml5w1mflNcwsWmZwbyuuvQ1H52hs/z9WkvbVvoIfy0y
  11F8enFtCQGDgBZyKYeDIHKGPo4fco1vW5iZmDVmkZI8Y6FjAEtWllh2ajqebxSir2OnGJq0
  mpJYF7e6u7scvL+3IsLDxMUUEQA7"

# 9: Player collection
image create photo dbt9 -format gif -data \
 "R0lGODdhIAAgAKEAAP///wAAANjGpuFCACwAAAAAIAAgAAACg4SPqcvtD6NMoYYJg9jiYqZx
  m/dR4liaJ5oa4Uq2LxfLcKuyOBLW++wrVWBByewmXCExR2VRYYlKp9FGYIDNarfcQfCadXkq
  YrHWB8aSAeu250zZltnj+jaWVtfn6/shj8W3R8c1VjjoZlDI1iUo2FUBiTgI2WV5iZmpKUnV
  6Tm141AAADs="

# 10: Tournament, all-play-all
image create photo dbt10 -format gif -data \
 "R0lGODdhIAAgAKEAAP///wAAAAAA//8AACwAAAAAIAAgAAACZoSPqcvtH6KMYM6HM7RVdq+F
  4kg2gnEC6YqW7usIsmwExnDnAL7rmA1rAF0zWq+i4yl9mmFQ4QwVU0vkscojRZ+HbayY1AGx
  QS/XnJiGr7X1E13+ztZka5ZrxSO8ara/CqcnOJhQAAA7"

# 11: Tournament, Swiss
image create photo dbt11 -format gif -data \
 "R0lGODdhIAAgAIAAAP8AAP///ywAAAAAIAAgAAACRYSPqcvtD6OctFoQss437d0hnxYeI1di
  Z6qO7BlU8Pw59B03OG3vcO9z6YJCBrG4ONYov1Sz9AxFO9NL1XJlabfcrldRAAA7"

# 12: GM games
image create photo dbt12 -format gif -data \
 "R0lGODdhIAAgANMAAAAAAAAAqgCqAACqqqoAAKoAqqpVAKqqqlVVVVVV/1X/VVX///9VVf9V
  ////Vf///ywAAAAAIAAgAAAEjNDISau9lOjNu//eI45kaZ7cqa5kyr6mC8+PTL/2veY6upWB
  YNA0BAZEMuFIuTwakT9RsUliSouuadX5sHaxUa1K6CRDNVeY+QtGf5vrt7lNSBO5w7kzy91S
  34BJfWx/RXRwcHiDgVGJR1NijG49O42UPpOXMZaaLZydZ3WgJTygpZ2nmiCrrK2urxsRADs="

# 13: IM games
image create photo dbt13 -format gif -data \
 "R0lGODdhIAAgANMAAAAAAAAAqgCqAACqqqoAAKoAqqpVAKqqqlVVVVVV/1X/VVX///9VVf9V
  ////Vf///ywAAAAAIAAgAAAEhNDISau9lOjNu//eI45kaZ7cqa5kyr6mC8+PTL/2veY6up2B
  wChoIpZ4D2NSWFKOkMogUySN/YrT6tApgma10unz2vwaw1YN8LskcmtkUlSIfnu3VKY9js/7
  l2kEa31yYl18f4BlgT04iI0tj5CHapM+lZZHkpNIlp2cm5Ago6SlpqcbEQA7"

# 14: Blitz games
image create photo dbt14 -format gif -data \
 "R0lGODdhIAAgANMAAAAAAAAAqgCqAACqqqoAAKoAqqpVAKqqqlVVVVVV/1X/VVX///9VVf9V
  ////Vf///ywAAAAAIAAgAAAEgvDJSau9OOvNu89AKI7AV4VOqqqlKaHrGroPHKfh4dp3rn+8
  mO/XCcoAhyQQcGMhlR6jM0nkSHGk2ebaxFm7XZGVBHYMo8zwsApKN9dsDHeNVj+hYzUV/33f
  +WM2Ins0NW5whYJ/cUVpg1SFhlh7jI2TkJEoj4A7ZouRE5uchZSgEhEAOw=="

# 15: Tactics
image create photo dbt15 -format gif -data \
 "R0lGODdhIAAgANMAAAAAAAAAqgCqAACqqqoAAKoAqqpVAKqqqlVVVVVV/1X/VVX///9VVf9V
  ////Vf///ywAAAAAIAAgAAAEdtDISau9lOjNu//eI45kaZ7cqa5kyr6mC8+PTL/2veY6uqmB
  wCkY9GmAwlLxsWz9hslRkxkV8URTKil71bK4T1NWWbWGyatx7bwtS93mIxSp6vZG9vtaLoZ7
  Y2x6TnyCJXl3hz2JOos3jTSPM5EwIJWWl5iZGxEAOw=="

# 16: Endings
image create photo dbt16 -format gif -data \
 "R0lGODdhIAAgAKEAAP///wAAAP/73wAAACwAAAAAIAAgAAAChYSPqcsZDWOYsa5ns5lYXwoE
  AsZ54TQ+orqCFToK6RynVsulONpBO6/L9Ro/Hkd4Kx6FQ2JLBpUZPbBltfmyWjeg0ql3jAY3
  wTJYuySLxec1tIs+OuJD0RpLRZsUdvbe4Yan0RclmEH49oeAKKV4wDjiyKUlCcNm6EPnMghZ
  iMmn6SXJUAAAOw=="

# 17: Openings for White
image create photo dbt17 -format gif -data \
 "R0lGODdhIAAgANMAAAAAAAAAqgCqAACqqqoAAKoAqqpVAKqqqlVVVVVV/1X/VVX///9VVf9V
  ////Vf///ywAAAAAIAAgAAAErvDJSau9F+jNu9cYMBxDaZ4oCoRj6rqgJZJvXQLHWs22jec6
  Ca/3+gWCjyExZUQqURLf4XCkPE2UWtPaSmWL0+rkWvrCws6u9yGlpmnQiRbNhWMrYHd9bVbR
  x2plF2d6gHYDGIRiQoGIg0x/jIdLN5FJjZQDW4aZfoWSnSeboKGVn5eTlKOopaaLSRqtmpY/
  H7YetD9Tu7y9vpawv8LCr0IbAcjJysvMSFa30BwSEQA7"

# 18: Openings for Black
image create photo dbt18 -format gif -data \
 "R0lGODdhIAAgANMAAAAAAAAAqgCqAACqqqoAAKoAqqpVAKqqqlVVVVVV/1X/VVX///9VVf9V
  ////Vf///ywAAAAAIAAgAAAErvDJSau9F+jNu9cYMBxDaZ4oCoRj6rqgJZJvXQLHWs22jec6
  Ca/3+gWCjyExZUQqVaJak/I0caSHw5HaYm6wWmcXqgFvJ1VrtJg9C8enKzvMpcU7c3cSfsPD
  2mJ2fR5/dGh8H2txgHVkfiqMh4JLVpFvk5QDU5KZkIaXnYufe5iUm6ChN5akqaqjX62nSVmJ
  tRyrGlm6u7y9u3pJP77DvcDBGgHJysvMzUhUttExEQA7"

# 19: Openings for either color
image create photo dbt19 -format gif -data \
 "R0lGODdhIAAgANMAAAAAAAAAqgCqAACqqqoAAKoAqqpVAKqqqlVVVVVV/1X/VVX///9VVf9V
  ////Vf///ywAAAAAIAAgAAAEuvDJSau9F+jNu9cYMBxDaZ4oCoRj6rqgJZKq+JrAsVZzrd2l
  nG4n6Z04wIEwQHwYcZvksvmEJpWHA5NSVUaBU24LiryFJ1UPOLtFj73q17n4/tgkKja1/hlQ
  jnpiNEB/OIFugzeFQYd0iYoPeVp7jy6LWJOCSRaGmYibFZ1tjoQXjJ6kkJyYo05vlqaslFdy
  ja6VtLJcP7mSrUJ2wRy2GlnGx8jJx61OQsrPyczNGgHV1tfY2U27wt07EQA7"

# 20: Theory: 1.c4
image create photo dbt20 -format gif -data \
 "R0lGODdhIAAgAKEAAP/739jGpgAAAP///ywAAAAAIAAgAAACfYRvoauIzNyBSyYaLMDZcv15
  GDiKFHmaELqqkVvBXCN3UniXebq3/fuLBWlDmwN31CV5S18T+BRqokSqTSCYKB8lwWCQ3Wy1
  PCzZyU15wRdmerX+ZpHvCPY+H7fRZ2h9VvUX2CclaGTI4kc4uKfYWLh4GJkI+cgo5jZZo1EA
  ADs="

# 21: Theory: 1.d4
image create photo dbt21 -format gif -data \
 "R0lGODdhIAAgAKEAAP/739jGpgAAAP///ywAAAAAIAAgAAACf4RvoauIzNyBSyYaLMDZcv15
  GDiKFHmaELqqkVvBXCN3UniXebq3/fuLBWlDmwN31CV5S18T+BRqokSq8aEQCKRYJlYwGGyv
  E2VXyy17y2Bxtet8tMNbFlSuzZMva35cPXMHKOhHuGE2mFaoeNjX+Lf4ligZufdoiASHiVip
  UQAAOw=="

# 22: Theory: 1.d4 d5
image create photo dbt22 -format gif -data \
 "R0lGODdhIAAgAKEAAP/739jGpgAAAP///ywAAAAAIAAgAAACh4RvoauIzNyBSyYaLMDZcv15
  GDiKFHmaELqqkVvBXCN3UggIwlTepa67pHzDoLBFbAF3m57jswzinqPobvpwZocaKneL9Opi
  yZdPMBgIaGWyeM32hrNodRxsftbTa1b+YWUj98fzVThDeJTYZKjohvd4uIglGel4V4l5KQip
  yTiXyRnqZwlQAAA7"

# 23: Theory: QGD
image create photo dbt23 -format gif -data \
 "R0lGODdhIAAgAKEAAP/739jGpgAAAP///ywAAAAAIAAgAAACmYRvoauIzNyB6wgxaZBJm3t1
  FAdo24eJEGmiYelxLQjCo+zRYYvfksn7xYS+l23VQ9JUkWQTYAw6eMvjc5rTWSvOig4jfQyx
  PhIZSURHFRduuikYDFJsuaDRxUNTtrb+DGfXETf3JzZCKBiQWMiStbSoc/LmBlh5CHSFqZlR
  tnnZiWZpGMrJBHpKmjo5yvqpugUbVooa63pQAAA7"

# 24: Theory: Slav
image create photo dbt24 -format gif -data \
 "R0lGODdhIAAgAKEAAP/739jGpgAAAP///ywAAAAAIAAgAAACmIRvoauIzI4QBy5XbTBzJo19
  lkSJUAhoG9CVKvq23hvGcgrWOUbz6u7oBXceU0Q3YnWMF+SJU8IlfckWs+GMyCjCB2grfVLF
  wymqTPZOi9JJc3wUDAaugJyOhb/ZC3ceHTdXdyfwp3ZyJ5iSiAfzdWMns6JnmGF2+PMGqInJ
  aZn2eUQ5uVl5RdppGiZaihrqeep4+aradVAAADs="

# 25: Theory: 1.d4 Nf6
image create photo dbt25 -format gif -data \
 "R0lGODdhIAAgAKEAAP/739jGpgAAAP///ywAAAAAIAAgAAACioRvoauIKqJoLrFVrYwhg4tl
  wcZ5IFWNZCeeJiexqdtCZX29q0lXZNxznGTC4MN4GPJAyxyO0YQ+QzPmFFW0Vp1baZfqyXLF
  3iwHe9QWBYPBhJgep8/wJFLTfkfBD3bbXWeh1rdzFfhxhzg0aMcoKNcI+VgWRxlpOcl3qZmJ
  tunZeahkuAeqKAlQAAA7"

# 26: Theory: 1.e4
image create photo dbt26 -format gif -data \
 "R0lGODdhIAAgAKEAAP/739jGpgAAAP///ywAAAAAIAAgAAACfYRvoauIzNyBSyYaLMDZcv15
  GDiKFHmaELqqkVvBXCN3UniXebq3/fuLBWlDmwN31CV5S18T+BRqokSq8aETCCZKbEowGGw3
  XS5Pa3Z6W2DxhbmOtMNbZLyizdfLb3V6JnVXJXj1F2g4iFjYB0XI0qj4eMg4SQYXWSOZaFAA
  ADs="

# 27: Theory: Sicilian
image create photo dbt27 -format gif -data \
 "R0lGODdhIAAgAKEAAP/739jGpgAAAP///ywAAAAAIAAgAAAChYRvoauIzNyBSyYaLMDZcv15
  GDiKFHmaELqqkVvBXCN30iII8V3yeU7jpYTAoCPk+xkfveNPyXrdnsDo7thkDjXYrbYlBOcm
  WXJKMBgILl6zeM0Gd1todVw6j9TTa2S+QtVXdnf1NVPohmeISLiUyLgxGNnWaPPnWGmFOSm3
  uOnnaRmqUQAAOw=="

# 28: Theory: Sicilian 1.e4 c5 2.Nd3 d6 3.d4
image create photo dbt28 -format gif -data \
 "R0lGODdhIAAgAKEAAP/739jGpgAAAP///ywAAAAAIAAgAAACo4RvoauIzNxZQiyZYMOq1i1p
  oENZ4yNiQOedU8p5rSoGtPzRcLiTdY/S6AIfV0bIIbZsSSRPeWlCdDLjCjjBWYbTGI757IYj
  UrJqHEVbS+nKy+kTDAYmg5x+FPugIHfeHDdXB3An8JdGcidoo4hXc/NFiHMFF6Rn+YOIGSVz
  uJbSaPhYRjFnKorlSURXSHn5BuFB6JjqatY6qsaoiFoJy6BVUQAAOw=="

# 29: Theory: Caro-Kann
image create photo dbt29 -format gif -data \
 "R0lGODdhIAAgAKEAAP/739jGpgAAAP///ywAAAAAIAAgAAACh4RvoauIzI4QBy5XbTBzJo19
  lkSJUAhoG9CVKvq23hvGcgrWOUbz6u7oBYEPYmakQ/qUQ2bReTwlpUtq0/rERiNTLqrqvYaz
  Xo9pvL2wBgOX8axmlXBQeGPdtq/AFwGbTSFE1ncjmHbH97MnFseI6Lg4+CgZeVipB/NGp4XZ
  1UiZWbeJ1olRAAA7"

# 30: Theory: French
image create photo dbt30 -format gif -data \
 "R0lGODdhIAAgAKEAAP/739jGpgAAAP///ywAAAAAIAAgAAACiIRvoauIzNyB6wgxaZBJm3t1
  FAdo24eJEGmiYelxLQjCo+zRYYvfksn7xYQ+R9A4RBYfSeYy81RFeivqlFjFXpVZ7pbk7Ia/
  0OzLJi5PBYNB6jiuoNRyrZztlta9FXwbA0fXoAPYJHhiB4TI12C1F9eYuAg5echiqBfJWJnJ
  iUbWeRn1+WjJUQAAOw=="

# 31: Theory: Open Games
image create photo dbt31 -format gif -data \
 "R0lGODdhIAAgAKEAAP/739jGpgAAAP///ywAAAAAIAAgAAACh4RvoauIzNyBSyYaLMDZcv15
  GDiKFHmaELqqkVvBXCN3UngrghDnab7b0Xwtn3DowCUDQZ5t+Us2hazXbcqr9qBFDdf63T5K
  gN2EHKYJBgPBJTr+md/deGvdpoPtETzbrcRXgbWBJoh0OKOFeAbXWPe4Fyk2yahHeWlZ6Jj5
  lLjoWRnaCapRAAA7"


set base_types {
  Unknown
  {Temporary database}
  Clipbase
  {PGN format file}
  {My games}
  {Large database}
  {Correspondence chess}
  {Computer chess}
  {Sorted Index of games}
  {Player collection}
  {Tournament: All-play-all}
  {Tournament: Swiss}
  {Grandmaster games}
  {International Master games}
  {Blitz (fast) games}
  {Tactics}
  {Endgames}
  {Openings for White}
  {Openings for Black}
  {Openings for either color}
  {Theory: 1.c4}
  {Theory: 1.d4}
  {Theory: 1.d4 d5}
  {Theory: QGD: 1.d4 d5 2.c4 e6}
  {Theory: Slav: 1.d4 d5 2.c4 c6}
  {Theory: 1.d4 Nf6}
  {Theory: 1.e4}
  {Theory: Sicilian: 1.e4 c5}
  {Theory: Sicilian: 1.e4 c5 2.Nf3 d6 3.d4}
  {Theory: Caro-Kann: 1.e4 c6}
  {Theory: French: 1.e4 e6}
  {Theory: Open Games: 1.e4 e5}
}


set numBaseTypeIcons [llength $base_types]

set temp_dbtype 0

proc selectBaseType {type} {
  global temp_dbtype
  set w .btypeWin
  if {![winfo exists $w]} { return }
  $w.t configure -state normal
  set temp_dbtype $type
  set linenum [expr $type + 1]
  $w.t tag remove sel 1.0 end
  $w.t tag remove selected 1.0 end
  $w.t tag add selected "${linenum}.2 linestart" "$linenum.2 lineend"
  $w.t see $linenum.2
  $w.t configure -state disabled
}

proc clickBaseType {x y} {
  set type [.btypeWin.t index "@$x,$y linestart"]
  set type [expr int($type) - 1]
  selectBaseType $type
}

proc changeBaseType {baseNum} {
  global temp_dbtype base_types numBaseTypeIcons
  if {$baseNum > [sc_base count total]} { return }
  set temp_dbtype [sc_base type $baseNum]
  if {$temp_dbtype >= $numBaseTypeIcons} { set temp_dbtype 0 }
  toplevel .btypeWin
  set w .btypeWin
  wm title $w "Scid: Choose database icon"

  text $w.t -yscrollcommand "$w.yscroll set" -font font_Regular \
    -height 25 -width 40 -background white -wrap none \
    -cursor top_left_arrow
  $w.t tag configure selected -background {#ffff80}

  scrollbar $w.yscroll -command "$w.t yview" -takefocus 0
  pack [frame $w.b] -side bottom -pady 5
  pack $w.yscroll -side right -fill y
  pack $w.t -side left -fill both -expand yes

  button $w.b.set -text "OK" -command \
    "catch {sc_base type $baseNum \$temp_dbtype}; updateBaseWin;
     focus .; destroy $w"

  button $w.b.cancel -text "Cancel" -command "focus .; destroy $w; focus ."
  pack $w.b.set $w.b.cancel -side left -padx 5

  set numtypes [llength $base_types]
  for {set i  0} {$i < $numtypes} {incr i} {
    if {$i > 0} { $w.t insert end "\n" }
    $w.t image create end -image dbt$i -pady 3 -padx 3
    $w.t insert end "   [lindex $base_types $i]  "
  } 

  bind $w.t <Double-ButtonRelease-1> "clickBaseType %x %y; $w.b.set invoke"
  bind $w.t <ButtonRelease-1> "clickBaseType %x %y"
  bind $w.t <Button1-Motion> "clickBaseType %x %y; break"

  bind $w <Up> {
    if {$temp_dbtype != 0} { selectBaseType [expr $temp_dbtype - 1] }
    break
  }

  bind $w <Down> {
    if {$temp_dbtype < [expr [llength $base_types] - 1]} {
      selectBaseType [expr $temp_dbtype + 1]
    }
    break
  }

  bind $w <Home> { selectBaseType 0 }
  bind $w <End> { selectBaseType [expr [llength $base_types] - 1] }
  bind $w <Escape> "$w.b.cancel invoke"
  bind $w <Return> "$w.b.set invoke"

  focus $w.t
  grab $w
  update
  selectBaseType $temp_dbtype
}



proc baseWin_onCursor {i} {
  if {! [winfo exists .baseWin]} {return}
  foreach win {"" .img .name .ngames} {
    .baseWin.f$i$win configure -cursor exchange
  }
}

proc baseWin_offCursor {fromBase x y} {
  if {! [winfo exists .baseWin]} {return}
  foreach win {"" .img .name .ngames} {
    .baseWin.f$fromBase$win configure -cursor {}
  }
  set dropPoint [winfo containing $x $y]
  if {! [string match ".baseWin.f*" $dropPoint]} {return}
  set toBase [string range $dropPoint 10 10]
  if {$toBase == $fromBase} {switchBase $toBase} else {
    copyFilter $fromBase $toBase
  }
}

set baseWin 0

proc makeBaseWin {} {
  global baseWin
  if {[winfo exists .baseWin]} {
    focus .
    destroy .baseWin
    set baseWin 0
    return
  }
  set baseWin 1
  set w [toplevel .baseWin]
  bind $w <Configure> "recordWinSize $w"
  setWinLocation $w

  wm resizable $w false false
  wm title $w "Scid: [tr WindowsSwitcher]"
  bind $w <Escape> makeBaseWin
  bind $w <Destroy> { set baseWin 0 }
  bind $w <F1> { helpWindow Switcher }
  standardShortcuts $w

  set side left
  if {$::switcherVertical} { set side top }
  set numBases [sc_base count total]

  for {set i 1} {$i <= $numBases} {incr i} {
    set f [frame $w.f$i -background white -borderwidth 1 -relief ridge]
    pack $f -side $side
    label $f.img -image dbt0 -relief solid -borderwidth 1
    label $f.name -width 13 -anchor w -font font_Small
    label $f.ngames -text "0" -width 13 -anchor e -font font_Small
    pack $f.img -side top -padx 4 -pady 4
    pack $f.name -side top -padx 2 -fill x
    pack $f.ngames -side top -padx 2 -fill x
    foreach win {"" .img .name .ngames} {
      bind $f$win <ButtonPress-1> "baseWin_onCursor $i"
      bind $f$win <ButtonRelease-1> "baseWin_offCursor $i %X %Y"
    }
    menu $f.menu -tearoff 0
    $f.menu add command -label [tr SearchReset] -command "sc_filter reset $i"
    $f.menu add command -label "Change icon..." -command "changeBaseType $i"
    $f.menu add separator
    set closeLabel [tr FileClose]
    if {$i == [sc_info clipbase]} { set closeLabel [tr EditReset] }
    $f.menu add command -label $closeLabel \
      -command "catch {sc_base close $i}"
    foreach win {"" .img .name .ngames} {
      bind $f$win <ButtonPress-3> "tk_popup $f.menu %X %Y"
    }
    $f.menu add separator
    $f.menu add command -label $::tr(ChangeOrient) -command orientBaseWin
  }
  updateBaseWin
}

proc orientBaseWin {} {
  global switcherVertical
  if {$switcherVertical} {
    set switcherVertical 0
    set side left
  } else {
    set switcherVertical 1
    set side top
  }

  set w .baseWin
  set numBases [sc_base count total]

  for {set i 1} {$i <= $numBases} {incr i} {
    pack forget $w.f$i
  }
  for {set i 1} {$i <= $numBases} {incr i} {
    pack $w.f$i -side $side
  }
}

proc updateBaseWin {} {
  global numBaseTypeIcons
  if {! [winfo exists .baseWin]} { return }
  set numBases [sc_base count total]
  set current [sc_base current]
  for {set i 1} {$i <= $numBases} {incr i} {
    .baseWin.f$i configure -background white
    set dbtype [sc_base type $i]
    if {$dbtype >= $numBaseTypeIcons} { set dbtype 0 }
    .baseWin.f$i.img configure -image dbt$dbtype -background white
    .baseWin.f$i.name configure -background white \
      -text "$i: [file tail [sc_base filename $i]]"
    .baseWin.f$i.ngames configure -background white \
      -text "[filterText $i 100000]"
  }

  .baseWin.f$current configure -background {#ffff80}
  foreach i {.img .name .ngames} {
    .baseWin.f$current$i configure -background {#ffff80}
  }
}

