#if defined(__APPLE__)
#include <stdint.h>
#endif

#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>

#include <netinet/in.h>

#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include "scamper_addr.h"
#include "scamper_list.h"
#include "scamper_tlv.h"
#include "scamper_trace.h"
#include "scamper_file.h"

int main(int argc, char *argv[])
{
  scamper_file_t *in, *out;
  scamper_file_filter_t *filter;
  scamper_trace_t *trace;
  uint16_t type;

  if(argc != 2)
    {
      fprintf(stderr, "usage: warts2traceroute <file>\n");
      return -1;
    }

  if((in = scamper_file_open(argv[1], 'r', NULL)) == NULL)
    {
      fprintf(stderr, "could not open %s: %s\n", argv[1], strerror(errno));
      return -1;
    }

  if((out = scamper_file_openfd(STDOUT_FILENO,NULL,'w',"traceroute")) == NULL)
    {
      fprintf(stderr, "could not associate stdout\n");
      return -1;
    }

  type = SCAMPER_FILE_OBJ_TRACE;
  if((filter = scamper_file_filter_alloc(&type, 1)) == NULL)
    {
      fprintf(stderr, "could not allocate filter\n");
      return -1;
    }

  while(scamper_file_read(in, filter, &type, (void *)&trace) == 0)
    {
      if(trace == NULL) break; /* EOF */
      scamper_file_write_trace(out, trace);
      scamper_trace_free(trace);
    }

  scamper_file_close(out);
  scamper_file_close(in);

  return 0;
}
