
// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Malolan Chetlur     
//          Narayanan Thondugulam
//          Krishnan Subramani  

#include "IIRScram_PortList.hh"
#include "IIR_SignalInterfaceDeclaration.hh"
#include "IIR_ComponentDeclaration.hh"
#include "IIR_Identifier.hh"
#include "IIR_SignalDeclaration.hh"
#include "IIR_TypeDefinition.hh"
#include "set.hh"
#include "savant.hh"
#include "published_file.hh"

IIRScram_PortList::~IIRScram_PortList() {}

void 
IIRScram_PortList::_publish_vhdl(ostream &_vhdl_out) {
  IIR_InterfaceDeclaration* i;
  for (i = first(); i != NULL; ) {
    _vhdl_out << "  ";
    i->_publish_vhdl_decl(_vhdl_out);
    i = successor(i);
    if(i != NULL) {
      _vhdl_out << ";\n";
    }
  }
}

void
IIRScram_PortList::_publish_cc_elaborate( published_file &_cc_out ){
 IIR_InterfaceDeclaration* i;
 for (i = first(); i != NULL; ) {
   switch (i->get_kind()) {
   case IIR_TERMINAL_INTERFACE_DECLARATION: {
     _cc_out << "AMSType ";
     i->_publish_cc_lvalue(_cc_out);
     _cc_out.end_statement();
     break;
   }
   default:{
     i->_publish_cc_type_and_object_name( _cc_out );
     _cc_out.end_statement();
   
     if( i->_get_implicit_declarations() != NULL &&
	 i->_get_implicit_declarations()->num_elements() != 0) {
       IIR_Declaration* imp_decl = i->_get_implicit_declarations()->get_element();
       while(imp_decl != NULL) {
	 if(imp_decl->get_kind() == IIR_SIGNAL_DECLARATION) {
	   _cc_out << ((IIR_SignalDeclaration*)imp_decl)->get_subtype()->_get_cc_type_name();
	     _cc_out << " ";
	     imp_decl->_publish_cc_elaborate( _cc_out );
	     _cc_out << ";\n";
	 }
	 imp_decl = i->_get_implicit_declarations()->get_next_element();
       }   
     }
   }
     break;
   }
   i = successor(i);
 } 
}

void
IIRScram_PortList::_publish_cc_port_init( published_file &_cc_out ) {
  SCRAM_CC_REF( _cc_out, "IIRScram_PortList::_publish_cc_port_init" );
  IIR_InterfaceDeclaration* i = first();
  while( i != NULL ){
    switch(i->get_kind()){
    case IIR_SIGNAL_INTERFACE_DECLARATION:{
      i->_publish_cc_elaborate( _cc_out );
      _cc_out << OS("(ObjectBase::SIGNAL_NETINFO");
      if ((i->get_subtype()->_is_array_type() == TRUE) ||
	  (i->get_subtype()->_is_record_type() == TRUE)) {
	i->get_subtype()->_publish_cc_object_type_info( _cc_out );
	_cc_out << "," << NL();
	i->get_subtype()->_publish_cc_resolution_function_id( _cc_out );
	
	if (i->get_subtype()->_is_anonymous() == TRUE) {
	  _cc_out << "," << NL();
	  i->get_subtype()->_publish_cc_range( _cc_out );
	}
	else if ((i->get_subtype()->_is_unconstrained_array_type() == TRUE)
		 && (_get_currently_publishing_unit() != DUMMY_ENTITY_DECL)) {
	  _cc_out << "," << NL();
	  i->_publish_cc_elaborate( _cc_out );
	  _cc_out << "_port";
	}
      }
      _cc_out << CS(")");
      
      if( i->_get_implicit_declarations() != NULL &&
	  i->_get_implicit_declarations()->num_elements() != 0) {
	IIR_Declaration* imp_decl = i->_get_implicit_declarations()->get_element();
	while(imp_decl != NULL) {
	  if(imp_decl->get_kind() == IIR_SIGNAL_DECLARATION) {
	    _cc_out << "," << NL();
	    (imp_decl)->_publish_cc_elaborate( _cc_out );
	    _cc_out << OS("(ObjectBase::SIGNAL_NETINFO");
	    
	    if (((imp_decl->get_subtype()->_is_array_type() == TRUE) ||
		 (imp_decl->get_subtype()->_is_record_type() ==  TRUE)) &&
		(imp_decl->get_subtype()->_is_access_type() ==  FALSE)) {
	      imp_decl->get_subtype()->_publish_cc_object_type_info(_cc_out);
	      _cc_out << "," << NL();
	      imp_decl->get_subtype()->_publish_cc_resolution_function_id( _cc_out );
	      
	      if (imp_decl->get_subtype()->_is_anonymous() == TRUE) {
		_cc_out << "," << NL();
		imp_decl->get_subtype()->_publish_cc_range( _cc_out );
	      }
	    }
	    _cc_out << CS(")");
	  }
	  imp_decl = i->_get_implicit_declarations()->get_next_element();
	}     
      }
    }
      break;
    case IIR_TERMINAL_INTERFACE_DECLARATION:{
      i->_publish_cc_elaborate(_cc_out);
      _cc_out << "(ObjectBase::TERMINAL)";
    }
      break;
    default:{
      //do nothing
    }
      break;
    }
    i = successor(i);
    if(i != NULL) {
      _cc_out << "," << NL();
    }
  } 
}

int
IIRScram_PortList::_publish_cc_unconstrained_ports( published_file &_cc_out,
						    IIR_Boolean publishPortTypes, 
						    IIR_Boolean publishPortNames, 
						    IIR_Boolean commaFlag ){
  int noOfUnconstrainedPorts           = 0;
  IIR_InterfaceDeclaration *sig  = first();  
  while (sig != NULL) {
    SCRAM_CC_REF( _cc_out, "IIRScram_PortList::_publish_cc_unconstrained_ports" );
    ASSERT ( sig->get_subtype() != NULL );
    if (sig->get_subtype()->_is_unconstrained_array_type() == TRUE) {
      if (commaFlag == TRUE) {
	_cc_out << "," << NL();
      }
      if (publishPortTypes == TRUE) {
	_cc_out << "const ";
	_cc_out << sig->get_subtype()->_get_cc_type_name();
	_cc_out << "& ";
      }
      if (publishPortNames == TRUE) {
	sig->_publish_cc_elaborate( _cc_out );
	_cc_out << "_port";
      }
      commaFlag = TRUE;
      noOfUnconstrainedPorts++;
    }
    sig = successor(sig);
  }
  return noOfUnconstrainedPorts;
}
   
void
IIRScram_PortList::_publish_cc_port_map_aspect( published_file &_cc_out ) {
  ASSERT( _get_current_publish_node()->_is_component_decl() == TRUE );
  IIR_ComponentDeclaration *as_component_decl = 
    (IIR_ComponentDeclaration*)_get_current_publish_node();
  IIR_InterfaceDeclaration *local_clause = as_component_decl->local_port_clause.first();
  IIR_InterfaceDeclaration *actual_clause = first();
  for(; local_clause != NULL; ){
    _cc_out << "  Add(";
    _cc_out << _get_current_elab_name();
    local_clause->_publish_cc_elaborate( _cc_out );
    _cc_out << ",";
    
    // ### Temporary Fix
    if( actual_clause != NULL ){
      _cc_out << "\n    (("
	      << actual_clause->_get_declarative_region()->_get_cc_elaboration_class_name()
	      << " *)" << _get_current_elab_name() << "boundedEntity)->";
      actual_clause->_publish_cc_elaborate( _cc_out );
    }
    _cc_out << ");\n";
    
    if( local_clause->get_mode() == IIR_OUT_MODE || local_clause->get_mode() == IIR_INOUT_MODE ){
      SCRAM_CC_REF( _cc_out, "IIRScram_PortList::_publish_cc_port_map_aspect" );
      _cc_out << "  addChild(";
      _cc_out << _get_current_elab_name();
      local_clause->_publish_cc_elaborate( _cc_out );
      _cc_out << ", ";
      // ### Temporary Fix
      if( actual_clause != NULL ){
	_cc_out << "\n    (("
		<< actual_clause->_get_declarative_region()->_get_cc_elaboration_class_name()
		<< " *)" << _get_current_elab_name() << "boundedEntity)->";
	actual_clause->_publish_cc_elaborate( _cc_out );
      }
      _cc_out << ");\n";
    }
    local_clause = as_component_decl->local_port_clause.successor( local_clause );
    actual_clause = successor(actual_clause);
  }  
}

visitor_return_type *
IIRScram_PortList::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_PortList(this, arg);
}
