
// Copyright (c) 1996-2002 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Timothy J. McBrayer 
//          Malolan Chetlur     
//          Umesh Kumar V. Rajasekaran
//          Narayanan Thondugulam
//          Krishnan Subramani  
//	    Magnus Danielson	cfmd@swipnet.se

//---------------------------------------------------------------------------

#include "IIRScram.hh"
#include "IIR_CaseStatementAlternative.hh"
#include "IIR_SequentialStatement.hh"
#include "IIR_SequentialStatementList.hh"


IIRScram_CaseStatementAlternative::~IIRScram_CaseStatementAlternative() {}


void
IIRScram_CaseStatementAlternative::_publish_cc_decl_for_loop_iterator( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_CaseStatementAlternative::_publish_cc_decl_for_loop_iterator" );

  sequence_of_statements._publish_cc_decl_for_loop_iterator( _cc_out );
}


void 
IIRScram_CaseStatementAlternative::_build_wait_list(dl_list<IIRScram_WaitStatement>* list) {
  sequence_of_statements._build_wait_list(list);
}


void 
IIRScram_CaseStatementAlternative::_get_list_of_input_signals( set<IIR>* list ){
  sequence_of_statements._get_list_of_input_signals(list);
}


IIR_Boolean 
IIRScram_CaseStatementAlternative::_type_check_return_statements( set<IIR_TypeDefinition> *context_set, 
			       IIR_SubprogramDeclaration *subprogram_decl ){
  IIR_Boolean retval = FALSE;

  retval = IIR_SequentialStatement::
    _type_check_return_statements(context_set,
				  &sequence_of_statements,
				  subprogram_decl );
  return retval;
}


void 
IIRScram_CaseStatementAlternative::_get_signal_source_info( set<IIR> *siginfo ){
  sequence_of_statements._get_signal_source_info(siginfo);
}


void
IIRScram_CaseStatementAlternative::_clone(IIR* cl) {
  IIR_CaseStatementAlternative *clone = (IIR_CaseStatementAlternative*)cl;
  IIR::_clone(clone);

  IIR_SequentialStatement *seqclone, *stmt = sequence_of_statements.first();
  while (stmt != NULL) {
    seqclone = (IIR_SequentialStatement*)stmt->_clone();
    clone->sequence_of_statements.append(seqclone);
    stmt = sequence_of_statements.successor(stmt);
  }
}


IIR*
IIRScram_CaseStatementAlternative::_clone() {
  _report_undefined_scram_fn("_clone()");
  return NULL;
}


void
IIRScram_CaseStatementAlternative::_publish_vhdl_alternative(ostream &_vhdl_out, IIR *choice) {

  _vhdl_out << "when ";
  choice->_publish_vhdl(_vhdl_out);

  // In selected signal assignment statements, the
  // sequence_of_statements list is empty.  In case statements the
  // sequence_of_statements must be published.
  if (sequence_of_statements.first() != NULL) {
    _vhdl_out << " =>\n";
    sequence_of_statements._publish_vhdl(_vhdl_out);
  }
  
}
