
// Copyright (c) 2002-2003 The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Author: Sivakumar Gowrisankar             gowriss@ececs.uc.edu

//---------------------------------------------------------------------------

#include "IIRScram.hh"
#include "IIR_ArraySubnatureDefinition.hh"
#include "IIRScram_ArraySubnatureDefinition.hh"
#include "IIR_ArrayNatureDefinition.hh"
#include "IIR_ScalarNatureDefinition.hh"
#include "IIR_EnumerationLiteral.hh"
#include "IIR_Identifier.hh"
#include "IIR_NatureDeclaration.hh"
#include "IIR_Attribute.hh"
#include "IIR_IntegerLiteral.hh"
#include "IIR_FunctionDeclaration.hh"
#include "published_file.hh"

IIRScram_ArraySubnatureDefinition::~IIRScram_ArraySubnatureDefinition() {}

void
IIRScram_ArraySubnatureDefinition::_publish_vhdl( ostream &_vhdl_out ){
  if( _get_declaration() != NULL ){
    _get_declaration()->_publish_vhdl(_vhdl_out);
  }
  else {
    ASSERT( get_base_type() != NULL );
    get_base_type()->_publish_vhdl(_vhdl_out);
    if (_get_index_subtype() != NULL) {
      _vhdl_out << "(";
      _get_index_subtype()->_publish_vhdl_range(_vhdl_out);
      _vhdl_out << ")";
    }
  }
}

void
IIRScram_ArraySubnatureDefinition::_publish_vhdl_type_decl( ostream &_vhdl_out ){
  IIR_TypeDefinition *node ;
  int index, max_index ;

  ASSERT(_get_index_subtype() != NULL );
  ASSERT(get_element_subtype() != NULL );

  _vhdl_out << "array ";
  ASSERT ( get_base_type()->_get_index_subtype() != NULL );

  if(( get_base_type()->_is_unconstrained_array_type() == TRUE) ||
      (get_base_type()->_get_index_subtype()->_is_enumeration_type() == TRUE) ){

    _vhdl_out << " ( ";

    index = 1 ;
    max_index = _get_num_indexes();
    for (node = this; (index <= max_index); index++, node = node->_get_element_subtype())  {
      ASSERT(node->_is_array_type() == TRUE );
      ASSERT(node->_get_index_subtype() != NULL );
      ASSERT(node->_get_element_subtype() != NULL );
      if (index > 1) {
        _vhdl_out << ", ";
      }

      node->_get_index_subtype()->_publish_vhdl_index(_vhdl_out);
    }

    _vhdl_out << " ) ";

  }
  _vhdl_out << " of ";
  _get_final_subtype()->_publish_vhdl(_vhdl_out);
}


void
IIRScram_ArraySubnatureDefinition::_publish_vhdl_decl(ostream &_vhdl_out) {
  IIR_TypeDefinition *node ;
  int index, max_index ;

  ASSERT(_get_index_subtype() != NULL );
  ASSERT(get_element_subtype() != NULL );
  get_base_type()->_publish_vhdl(_vhdl_out);
  ASSERT ( get_base_type()->_get_index_subtype() != NULL );

  if( get_base_type()->_is_unconstrained_array_type() == TRUE &&
      _is_unconstrained_array_type() == FALSE ){

    _vhdl_out << " ( ";

    index = 1 ;
    max_index = _get_num_indexes();
    for (node = this; (index <= max_index); index++, node = node->_get_element_subtype())  {
      ASSERT(node->_is_array_type() == TRUE );
      ASSERT(node->_get_index_subtype() != NULL );
      ASSERT(node->_get_element_subtype() != NULL );
      if (index > 1) {
        _vhdl_out << ", ";
      }

      node->_get_index_subtype()->_publish_vhdl_index(_vhdl_out);
    }

    _vhdl_out << " ) ";

    if ( get_base_type()->_is_anonymous() == TRUE )  {
      _vhdl_out << " of ";
      node->_publish_vhdl(_vhdl_out);
    }
  }
}

void
IIRScram_ArraySubnatureDefinition::_publish_vhdl_subtype_decl(ostream &_vhdl_out){
  _publish_vhdl_decl(_vhdl_out);
}

const string
IIRScram_ArraySubnatureDefinition::_get_cc_type_name(){
  return "ArrayType";
}

IIR *
IIRScram_ArraySubnatureDefinition::_clone(){
  IIR_ArraySubnatureDefinition *my_clone = new IIR_ArraySubnatureDefinition();
  IIRScram::_clone( my_clone );

  IIR_ArrayNatureDefinition::_clone( my_clone );

  return my_clone;
}

IIR_Boolean
IIRScram_ArraySubnatureDefinition::_is_subtype() {
  return TRUE;
}

