#ifndef IIRSCRAM_VARIABLE_DECLARATION_HH
#define IIRSCRAM_VARIABLE_DECLARATION_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_VariableDeclaration.hh,v 1.3 1999/03/16 04:57:14 dmadhava Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_VariableDeclaration.hh"

class IIR_List;
class IIR_VariableDeclaration;

class IIRScram_VariableDeclaration : public IIRBase_VariableDeclaration {
// @BeginAutoDocExternalProseDescription
// @EndAutoDocExternalProseDescription
public:
  void _publish_vhdl_decl(ostream &);
  void _publish_cc();
  void _publish_cc_decl();
  void _publish_cc_init();
  void _publish_cc_data();
  void _publish_cc_wait_data();
  void _publish_cc_scalar_init();
  void _publish_cc_composite_init();
  void _publish_cc_access_init();
  void _publish_cc_value();
  void _publish_cc_universal_value();
  void _publish_cc_initialization_value() { _publish_cc(); }
  void _publish_cc_file_init();
  void _publish_cc_state_object_init();
  void _publish_cc_object_type();
  void _publish_cc_headers();
  void _publish_cc_kernel_type();

  IIR_Boolean _is_globally_static() { return FALSE; }
  
  IIR_Boolean _is_variable(){ return TRUE; }
  IIR_Boolean _is_readable(){ return TRUE; }
  IIR_Boolean _is_writable(){ return TRUE; }

  declaration_type _get_type();

  IIR *_clone();
  IIR_VariableDeclaration *_my_clone;

protected:
  IIRScram_VariableDeclaration();
  virtual ~IIRScram_VariableDeclaration();
    
private:
};
#endif
