#ifndef IIRSCRAM_SENSITIZED_PROCESS_STATEMENT_HH
#define IIRSCRAM_SENSITIZED_PROCESS_STATEMENT_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ececs.uc.edu
//          Malolan Chetlur     mal@ececs.uc.edu
//          Timothy J. McBrayer tmcbraye@ececs.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ececs.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_SensitizedProcessStatement.hh,v 1.3 1999/03/25 02:57:29 tmcbraye Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_SensitizedProcessStatement.hh"

class IIRScram_SensitizedProcessStatement : public IIRBase_SensitizedProcessStatement {

public:
  void _publish_vhdl(ostream &);
  void _publish_cc();
  IIR  *_transmute();
  void _type_check();
  IIR *_resolve_signal_name( IIR * );
  void _get_list_of_input_signals(set<IIR_Declaration>* list);  
#ifdef PROCESS_COMBINATION
  void _static_elaborate(IIR_ArchitectureDeclaration*, 
			 IIR_DeclarationList*, char*);
#endif
  IIR *_clone();

protected:
  IIRScram_SensitizedProcessStatement() {};
  virtual ~IIRScram_SensitizedProcessStatement() = 0;
    
private:
};
#endif
