
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_ConcurrentProcedureCallStatement.cc,v 1.3 1999/07/23 21:07:59 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include <strstream.h>
#include "IIRScram_ConcurrentProcedureCallStatement.hh"
#include "IIR_AssociationElement.hh"
#include "IIR_FunctionCall.hh"
#include "IIR_IndexedName.hh"
#include "IIR_InterfaceDeclaration.hh"
#include "IIR_Label.hh"
#include "IIR_ProcedureCallStatement.hh"
#include "IIR_ProcedureDeclaration.hh"
#include "IIR_ProcessStatement.hh"
#include "IIR_WaitStatement.hh"
#include "error_func.hh"
#include "resolution_func.hh"
#include "set.hh"


IIRScram_ConcurrentProcedureCallStatement::~IIRScram_ConcurrentProcedureCallStatement() {}


void 
IIRScram_ConcurrentProcedureCallStatement::_publish_vhdl(ostream &_vhdl_out) {
  if (get_label() != NULL) {
    get_label()->_publish_vhdl(_vhdl_out);
    _vhdl_out << ": ";
  }
  
  if (get_postponed() == true) {
    _vhdl_out << "postponed ";
  }
  
  get_procedure_name()->_publish_vhdl(_vhdl_out);
  
  if (actual_parameter_part.num_elements() != 0) {
    _vhdl_out << "(";
    
    if(actual_parameter_part.num_elements() != 0) {
      actual_parameter_part._publish_vhdl_without_formals(_vhdl_out);
    }
    
    _vhdl_out << ")";
  }
  
  _vhdl_out << ";\n";
}


void 
IIRScram_ConcurrentProcedureCallStatement::_type_check(){
  // Blatantly stolen from IIR_ProcedureCallStatement.  Changes need to be
  // propagate back to that file.
  set<IIR_TypeDefinition> proc_rval_set(IIR_ProcedureDeclaration::_get_procedure_return_type()); 
  set_procedure_name( get_procedure_name()->_semantic_transform( &proc_rval_set ));
  
  if( get_procedure_name()->get_kind() != IIR_FUNCTION_CALL ){
    set<IIR_Declaration> *my_decls;
    if( get_procedure_name()->get_kind() == IIR_INDEXED_NAME ){
      my_decls = ((IIR_IndexedName *)get_procedure_name())->get_prefix()->_symbol_lookup();
    }
    else{
      my_decls = get_procedure_name()->_symbol_lookup();
    }

    if( my_decls == NULL ){
      report_undefined_symbol( get_procedure_name() );
    }

    IIR_Declaration *current_decl = my_decls->get_element();
    while( current_decl != NULL ){
      if( current_decl->get_kind() != IIR_PROCEDURE_DECLARATION ){
	my_decls->remove( current_decl );
      }
      current_decl = my_decls->get_next_element();
    }
    
    resolve_subprogram_decls( my_decls, &actual_parameter_part, &proc_rval_set );
    
    switch( my_decls->num_elements() ){
    case 0:{
      ostrstream err;
      err << "No declaration of procedure with signature matching |"
	  << *get_procedure_name() << "|."   << ends;
      report_error( this, err );
      break;
    }
    case 1:{
      set_procedure_name( get_procedure_name()->_decl_to_decl( my_decls->get_element() ) );

      IIR *temp_name = get_procedure_name();
      ASSERT( temp_name->_is_iir_subprogram_declaration() == TRUE );
      IIR_SubprogramDeclaration *my_decl = (IIR_SubprogramDeclaration *)temp_name;

      actual_parameter_part._resolve_and_order( &my_decl->interface_declarations, NULL );

      break;
    }
    default:{
      report_ambiguous_error( get_procedure_name(), my_decls );
    }
    }
  
    delete my_decls;
  }
  else{
    
    IIR_FunctionCall *old_proc_name =  (IIR_FunctionCall *)get_procedure_name();
    set_procedure_name( old_proc_name->get_implementation() );
    IIR_List::_listcopy( actual_parameter_part,
			 old_proc_name->parameter_association_list );

    delete old_proc_name;
  }
  ASSERT( get_procedure_name()->_is_resolved() == TRUE );  
}


IIR * 
IIRScram_ConcurrentProcedureCallStatement::_transmute() {
  IIR_ProcessStatement* pstmt = new IIR_ProcessStatement;
  IIR_WaitStatement* wstmt = new IIR_WaitStatement;
  IIR_ProcedureCallStatement* pcstmt = new IIR_ProcedureCallStatement;

  copy_location( this, pstmt );
  copy_location( this, wstmt );
  copy_location( this, pcstmt );

  pstmt->set_label(get_label());
  pstmt->_set_enclosing_scope(_get_enclosing_scope());
  pstmt->set_postponed(get_postponed());
  pcstmt->set_procedure_name(get_procedure_name());
  // Copy the actual parameters.
  IIR_AssociationElement *elem = actual_parameter_part.first();
  while(elem != NULL) {
    pcstmt->actual_parameter_part.append(elem);
    elem = actual_parameter_part.successor(elem);
  }

  pstmt->process_statement_part.append(pcstmt);

  IIR_DesignatorList sensitivity_list;
  _build_sensitivity_list(&sensitivity_list);
  wstmt->sensitivity_list._add_signals_to_sensitivity_list(&sensitivity_list);

  pstmt->process_statement_part.append(wstmt);

  return pstmt;
}


void
IIRScram_ConcurrentProcedureCallStatement::_build_sensitivity_list(IIR_DesignatorList* sensitivity_list) {
  IIR_AssociationElement *elem = actual_parameter_part.first();

  while(elem != NULL) {
    ASSERT(elem->_is_resolved());
    if(elem->_get_actual()->_is_signal() == TRUE ||
       elem->_get_actual()->get_kind() == IIR_FUNCTION_CALL) {
      ASSERT(elem->get_formal()->_is_interface() == TRUE);
      IIR_InterfaceDeclaration *decl = (IIR_InterfaceDeclaration *) elem->get_formal();
      if(decl->get_mode() == IIR_IN_MODE ||
	 decl->get_mode() == IIR_INOUT_MODE) {
	elem->_get_actual()->_build_sensitivity_list(sensitivity_list);
      }
    }
    elem = actual_parameter_part.successor(elem);
  } // while
}

