// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_AccessTypeDefinition.cc,v 1.4 1999/05/20 00:29:19 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIR_AccessSubtypeDefinition.hh"
#include "set.hh"
#include "IIR_Declaration.hh"
#include "IIR_Identifier.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_ProcedureDeclaration.hh"
#include "IIR_ConstantInterfaceDeclaration.hh"
#include "symbol_table.hh"

IIRScram_AccessTypeDefinition::IIRScram_AccessTypeDefinition(){
}

IIRScram_AccessTypeDefinition::~IIRScram_AccessTypeDefinition(){
}

void 
IIRScram_AccessTypeDefinition::_publish_vhdl_decl(ostream &_vhdl_out) {
  _vhdl_out << "access ";
  if ( get_designated_type()->_is_anonymous() == FALSE ){
    get_designated_type()->_get_declaration()->get_declarator()->_publish_vhdl(_vhdl_out);
  } else {
    get_designated_type()->_publish_vhdl_type_decl(_vhdl_out);
  }
}

void 
IIRScram_AccessTypeDefinition::_publish_cc_kernel_type() {
  _cc_out << "AccessType";
}

void 
IIRScram_AccessTypeDefinition::_publish_cc_constructor_args() {
  //I have nothing to do here
}

void 
IIRScram_AccessTypeDefinition::_publish_cc_headers() {
  _cc_out <<  "#include \"AccessType.hh\"" << endl;
  _cc_out << "#include \"";
  get_designated_type()->_publish_cc_type_name();
  _cc_out << ".hh\"" << endl;
}

void 
IIRScram_AccessTypeDefinition::_publish_cc_decl_constructors() {
  if(_is_subtype_decl() == TRUE) {
    _publish_cc_subtype_constructors();
  }
  else {
    _publish_cc_type_constructors();
  }
}

void 
IIRScram_AccessTypeDefinition::_publish_cc_type_constructors() {

//   _cc_out << "  ";
//   _publish_cc_type_name();
//   _cc_out << "(ObjectBase::ObjectType) : ";
//   _publish_cc_parent_type_name();
//   _cc_out << "() {" << endl;
//   _cc_out << "val = NULL;\n";
//   _cc_out << "}" << endl;


  _cc_out << "  ";
  _publish_cc_type_name();
  _cc_out << "() : ";
  _publish_cc_parent_type_name();
  _cc_out << "() {" << endl;
  _cc_out << "val = NULL;\n";
  _cc_out << "}" << endl;

  _cc_out << "  ";
  _publish_cc_type_name();
  _cc_out << "(VHDLType& value) :";
  _publish_cc_parent_type_name();
  _cc_out << "() {" << endl;
  _cc_out << "val = NULL;\n";
  _cc_out << "this->setPointer((VHDLType*)&value);" << endl;
  _cc_out << "}" << endl;

  _cc_out << "  ";
  _publish_cc_type_name();
  _cc_out << "(ObjectBase::ObjectType, const VHDLType& value) :";
  _publish_cc_parent_type_name();
  _cc_out << "() {" << endl;
  _cc_out << "  val = NULL;\n";
  _cc_out << "  this->setPointer((VHDLType*)&value);" << endl;
  _cc_out << "}" << endl;

  _cc_out << " ";
  _publish_cc_type_name();
  _cc_out << "(bool alias, ";
  _publish_cc_type_name();
  _cc_out << "& actual): ";
  _publish_cc_parent_type_name();
  _cc_out << "(alias, actual) {}" << endl;

  // This constructor is needed when we have an array of access types.
  // This is because the vector attempts to new objects of this type. Ofcourse
  // that should never happen but the compiler does not know that and will
  // bitch while compiling the generated code that this constructor is needed
  // Well, so it is here.

  _publish_cc_type_name();
  _cc_out << "(ObjectBase::ObjectType) : ";
  _publish_cc_parent_type_name();
  _cc_out << "()  {" << endl;
  _cc_out << "  val = NULL;\n";
  _cc_out << "}\n" << endl;
}

void 
IIRScram_AccessTypeDefinition::_publish_cc_subtype_constructors() {

//   _cc_out << "  ";
//   _publish_cc_type_name();
//   _cc_out << "(ObjectBase::ObjectType) : ";
//   _publish_cc_parent_type_name();
//   _cc_out << "() {" << endl;
//   _cc_out << "val = NULL;\n";
//   _cc_out << "}" << endl;

  _cc_out << "  ";
  _publish_cc_type_name();
  _cc_out << "() : ";
  _publish_cc_parent_type_name();
  _cc_out << "() {" << endl;
  _cc_out << "}" << endl;

  // Constructor with just the value initialization
  _cc_out << "  ";
  _publish_cc_type_name();
  _cc_out << "(VHDLType& value) : ";
  _publish_cc_parent_type_name();
  _cc_out << "(value) {" << endl;
  _cc_out << "}" << endl;

  // Constructor taking the object type and initial value
//   _cc_out << "  ";
//   _publish_cc_type_name();
//   _cc_out << "(ObjectBase::ObjectType objType, const VHDLType& value) :";
//   _publish_cc_parent_type_name();
//   _cc_out << "(objType, value) {" << endl;
//   _cc_out << "}" << endl;
  

  // Constructor for alias initialization.
  _cc_out << " ";
  _publish_cc_type_name();
  _cc_out << "(bool alias, ";
  _publish_cc_type_name();
  _cc_out << "& actual) : ";
  _publish_cc_parent_type_name();
  _cc_out << "(alias, actual) {}" << endl;
}

void 
IIRScram_AccessTypeDefinition::_publish_cc_decl_destructors() {
  if(_is_subtype_decl() == TRUE) {
    _publish_cc_subtype_destructors();
  }
  else {
    _publish_cc_type_destructors();
  }
}


void 
IIRScram_AccessTypeDefinition::_publish_cc_type_destructors() {

  _cc_out << endl << endl;
  _cc_out << "  virtual ~";
  _publish_cc_type_name();
  _cc_out << "() {" << endl;
  _cc_out << "    addValueToListForDeletion();" << endl;
  _cc_out << "  }" << endl;
  _cc_out << endl;
}


void 
IIRScram_AccessTypeDefinition::_publish_cc_subtype_destructors() {

  _cc_out << endl << endl;
  _cc_out << "  virtual ~";
  _publish_cc_type_name();
  _cc_out << "() {" << endl;
  _cc_out << "  }" << endl;
  _cc_out << endl;
}

void 
IIRScram_AccessTypeDefinition::_publish_cc_decl_operator_equalto() {
  if(_is_subtype()) {
    _publish_cc_type_operator_equalto();
  }
  else {
    _publish_cc_subtype_operator_equalto();
  }
}

void
IIRScram_AccessTypeDefinition::_publish_cc_decl_operator_subscript() {
  // Subscript operator ([]) taking ScalarType as argument.
  //  get_element_subtype()->_publish_cc_type_name();
  if(_is_array_type()){
    get_designated_type()->_publish_cc_subelement_type();
    _cc_out << "& operator[](const ScalarType& indexSubscript) const {" 
	    << endl;
    _cc_out << "return ((*val)[indexSubscript]);" << endl;
    _cc_out  << "}" << endl;
    
    // Subscript operator ([]) taking int as argument.
    //    get_designated_type()->_publish_cc_subelement_type();
    _cc_out << "VHDLType";
    _cc_out << "& operator[](const int indexSubscript) const {" << endl
	    << "return ";
    //    get_designated_type()->_publish_cc_subelement_type();
    _cc_out << "(*val)[indexSubscript];" << endl;
    _cc_out << "}" << endl;
  }
}

void 
IIRScram_AccessTypeDefinition::_publish_cc_type_operator_equalto() {
  _cc_out << "  ";
  _publish_cc_type_name();
  _cc_out << "& operator = (";
  _publish_cc_type_name();
  _cc_out << "& value) {" << endl
	  << "    val = value.val;" << endl
	  << "    return *this;" << endl
	  << "  }" << endl
	  << endl << endl;

  _cc_out << "  VHDLType& operator = (const VHDLType& value) {" << endl
	  << "    val = ((";
  _publish_cc_type_name();
  _cc_out << "&) value).val;" << endl
	  << "    return *this;" << endl
	  << "  }" << endl
	  << endl 
	  << endl;
}

void 
IIRScram_AccessTypeDefinition::_publish_cc_subtype_operator_equalto() {
  _cc_out << "  ";
  _publish_cc_type_name();
  _cc_out << "& operator = (";
  _publish_cc_type_name();
  _cc_out << "& value) {" << endl
	  << "    val = value.val;" << endl
	  << "    return *this;" << endl
	  << "  }" << endl
	  << endl
	  << endl;

  _cc_out << "  VHDLType& operator = (const VHDLType& value) {" << endl
	  << "    val = ((";
  _publish_cc_type_name();
  _cc_out << "&) value).val;" << endl
	  << "    return *this;" << endl
	  << "  }" << endl
	  << endl 
	  << endl;
}

void 
IIRScram_AccessTypeDefinition::_publish_cc_decl_type_attributes() {
  //I have nothing to do here.
  //But I stop system from crying undefined function blah, blah, blah...
}

void 
IIRScram_AccessTypeDefinition::_publish_cc_data_members() {
  if(_is_subtype_decl() == FALSE) {
    get_designated_type()->_publish_cc_type_name();
    _cc_out << "* val;\n";
    _publish_cc_function_all();
    _publish_cc_function_setpointer();
    _publish_cc_function_print();
    _publish_cc_function_getpointer();
    _publish_cc_function_resetpointer();
  }
}


void 
IIRScram_AccessTypeDefinition::_publish_cc_function_getpointer() {
  _cc_out << "virtual VHDLType* getPointer() const {" << endl
	  << "  return val;" << endl
	  << " }" << endl;
}

void 
IIRScram_AccessTypeDefinition::_publish_cc_function_resetpointer() {
  _cc_out << "virtual void resetPointer() {" << endl
	  << "  val = NULL;" << endl
	  << " }" << endl;
}

void 
IIRScram_AccessTypeDefinition::_publish_cc_function_all() {
  //  get_designated_type()->_publish_cc_type_name();
  _cc_out << "VHDLType";
  _cc_out << "& all() {" << endl
	  << "  return *val;" << endl
	  << " }" << endl;
}

void 
IIRScram_AccessTypeDefinition::_publish_cc_function_print() {
  _cc_out << "virtual void print(ostream& os = cout) const {" << endl;
  _cc_out << "os << val" << "<< \" \" << endl;" << endl;
  _cc_out << "  val->print(os);" << endl;
  _cc_out << " }" << endl;
}

void 
IIRScram_AccessTypeDefinition::_add_decl_into_cgen_symbol_table(){
  ASSERT(get_designated_type() != NULL);
  if (get_designated_type() != this) {
    get_designated_type()->_add_decl_into_cgen_symbol_table();
  }
}


void 
IIRScram_AccessTypeDefinition::_publish_cc_function_setpointer() {
  _cc_out << "virtual void setPointer(VHDLType* src) {" << endl;
  _cc_out << "if(src != NULL){" << endl;
  _cc_out << "  if(src->get_kind() == ACCESS_TYPE) {" << endl;
  _cc_out <<"     val = ((";
  _publish_cc_type_name();
  _cc_out << "*)src)->val;" << endl;;
  _cc_out << "   }" << endl; 
  _cc_out << "   else {" << endl;
  _cc_out << "    val = (";
  get_designated_type()->_publish_cc_type_name();
  _cc_out <<" *)src;" << endl;
  _cc_out <<"   }" << endl;
  _cc_out << "  }" << endl;
  _cc_out << "  else {" << endl;
  _cc_out << "    val = NULL;" << endl;
  _cc_out <<"   }" << endl;
  _cc_out << " }" << endl;
  
}

void 
IIRScram_AccessTypeDefinition::_publish_cc() {
  _get_declaration()->_publish_cc_type_name();
}

void 
IIRScram_AccessTypeDefinition::_publish_cc_composite_init() {
  //For access types there is no need fr any initialization in the
  // initState() function as they are initialized in the constructor itself.
//   _cc_out << "(*(AccessType*)&this->" << _current_publish_name << ")"
// 	  << ".object = NULL;\n";
}

IIR_Boolean
IIRScram_AccessTypeDefinition::_is_scalar_type() {
  if((get_designated_type() != NULL) && (get_designated_type() != this)) {
    return get_designated_type()->_is_scalar_type();
  }
  else{
    return FALSE;
  }
}

IIR_Boolean
IIRScram_AccessTypeDefinition::_is_array_type() {
  if ((get_designated_type() != NULL) && (get_designated_type() != this)) {
    return get_designated_type()->_is_array_type();
  }
  else{
    return FALSE;
  }
}

IIR_Boolean
IIRScram_AccessTypeDefinition::_is_unconstrained_array_type() {
  if ((get_designated_type() != NULL) && (get_designated_type() != this)) {
    return get_designated_type()->_is_unconstrained_array_type();
  }
  else{
    return FALSE;
  }
}


IIR_Boolean
IIRScram_AccessTypeDefinition::_is_record_type() {
  if ((get_designated_type() != NULL) && (get_designated_type() != this)) {
    return get_designated_type()->_is_record_type();
  }
  else{
    return FALSE;
  }
}

IIR_Boolean 
IIRScram_AccessTypeDefinition::_designates_incomplete_type() {
  if(  get_designated_type() != NULL && 
       get_designated_type()->_is_incomplete_type_definition() == TRUE ){
    return TRUE;
  }
  else{
    return FALSE;
  }
}

set<IIR_Declaration> *
IIRScram_AccessTypeDefinition::_find_declarations( IIR_Name *to_find ){
  if( get_designated_type() == NULL ){
    return NULL;
  }
  else{
    return get_designated_type()->_find_declarations( to_find );
  }
}

IIR_TypeDefinition *
IIRScram_AccessTypeDefinition::_get_element_subtype(){
  return get_designated_type()->_get_element_subtype();
}


void 
IIRScram_AccessTypeDefinition::_set_element_subtype( IIR_TypeDefinition *new_element_type ){
  ASSERT( get_designated_type() != NULL && get_designated_type()->_is_array_type() == TRUE );
  get_designated_type()->_set_element_subtype( new_element_type );
}

IIR_ScalarTypeDefinition *
IIRScram_AccessTypeDefinition::_get_index_subtype(){
  return get_designated_type()->_get_index_subtype();
}

IIR_Int32
IIRScram_AccessTypeDefinition::_get_num_indexes(){
  ASSERT(get_designated_type() != NULL);
  return get_designated_type()->_get_num_indexes();
}


void
IIRScram_AccessTypeDefinition::_publish_cc_decl_cc() {
  _publish_cc_relational_operators();
}


void
IIRScram_AccessTypeDefinition::_publish_cc_relational_operators() {
  _publish_cc_equality_operator();
  _publish_cc_inequality_operator();
}

void
IIRScram_AccessTypeDefinition::_publish_cc_equality_operator() {
  _cc_out << "EnumerationType" << endl;
  _cc_out << "savantEqual(const ";
  _publish_cc_type_name();
  _cc_out << "& lhs, const ";
  _publish_cc_type_name();
  _cc_out << "& rhs)  {" << endl;
  _cc_out << "  if (lhs.val == rhs.val) {" << endl;
  _cc_out << " return SAVANT_BOOLEAN_TRUE;" << endl;
  _cc_out << "  } else { " << endl;
  _cc_out << " return SAVANT_BOOLEAN_FALSE;" << endl;
  _cc_out << "  }" << endl; 
  _cc_out << "}" << endl;
}

void
IIRScram_AccessTypeDefinition::_publish_cc_inequality_operator() {
  _cc_out << "EnumerationType" << endl;
  _cc_out << "savantNotEqual(const ";
  _publish_cc_type_name();
  _cc_out << "& lhs, const ";
  _publish_cc_type_name();
  _cc_out << "& rhs)  {" << endl;
  _cc_out << "  if (lhs.val != rhs.val) {" << endl;
  _cc_out << " return SAVANT_BOOLEAN_TRUE;" << endl;
  _cc_out << "  } else { " << endl;
  _cc_out << " return SAVANT_BOOLEAN_FALSE;" << endl;
  _cc_out << "  }" << endl; 
  _cc_out << "}" << endl;
}


void 
IIRScram_AccessTypeDefinition::_come_into_scope( symbol_table *sym_tab, 
						 IIR_TypeDeclaration *type_declaration ){
  
  sym_tab->get_in_scope_access_types()->add( (IIR_AccessTypeDefinition *)this );

  if( type_declaration->_get_implicit_declarations() == NULL ){
    IIR_TypeDefinition::_come_into_scope( sym_tab, type_declaration );
  
    char *name = "deallocate";
    IIR_ProcedureDeclaration *new_procedure_declaration = new IIR_ProcedureDeclaration();
    copy_location( this, new_procedure_declaration );
    new_procedure_declaration->set_declarator( IIR_Identifier::get( name, strlen(name ) ) );
    new_procedure_declaration->_set_is_implicit( TRUE );
    sym_tab->add_declaration( new_procedure_declaration );
    sym_tab->open_scope( new_procedure_declaration );
    
    
    IIR_ConstantInterfaceDeclaration *new_interface_declaration;
    new_interface_declaration  = new IIR_ConstantInterfaceDeclaration();
    new_interface_declaration->_set_is_implicit( TRUE );
    copy_location( this, new_interface_declaration );
    
    name = "p";
    new_procedure_declaration->interface_declarations.append( new_interface_declaration );
    
    new_interface_declaration->set_declarator(  IIR_Identifier::get( name, strlen(name ) ) );
    new_interface_declaration->set_subtype( (IIR_AccessTypeDefinition *)this );
    new_interface_declaration->set_mode( IIR_INOUT_MODE );
    
    sym_tab->close_scope( new_procedure_declaration );
    
    type_declaration->_get_implicit_declarations()->add( new_procedure_declaration );    
  }
  else{
    sym_tab->add_declaration( type_declaration->_get_implicit_declarations() );    
  }
}

IIR_Boolean 
IIRScram_AccessTypeDefinition::is_element(){
  return get_designated_type()->is_element();
}

void 
IIRScram_AccessTypeDefinition::set_is_element( IIR_Boolean new_is_element ){
  get_designated_type()->set_is_element( new_is_element );
}


IIR *
IIRScram_AccessTypeDefinition::_clone(){
  IIR_AccessTypeDefinition *retval = new IIR_AccessTypeDefinition();
  _clone( retval );

  return retval;
}


void 
IIRScram_AccessTypeDefinition::_clone( IIR_AccessTypeDefinition *copy_into ){
  copy_into->set_designated_type( get_designated_type() );

  IIR_TypeDefinition::_clone( copy_into );
}

void
IIRScram_AccessTypeDefinition::_publish_vhdl_subtype_decl(ostream &_vhdl_out){
  ASSERT(_get_type_mark() != NULL);
  ASSERT(_get_type_mark()->_get_declaration() != NULL);
  
  _get_type_mark()->_get_declaration()->_publish_vhdl(_vhdl_out);
}

void 
IIRScram_AccessTypeDefinition::_come_out_of_scope( symbol_table *sym_tab ){
  sym_tab->get_in_scope_access_types()->remove( (IIR_AccessTypeDefinition *)this );
}

IIR_TypeDefinition *
IIRScram_AccessTypeDefinition::_construct_new_subtype( IIR_Name *resolution_function,
						       IIR_ScalarTypeDefinition *new_constraint){
  ASSERT( get_designated_type() != NULL );
  IIR_AccessSubtypeDefinition *retval = new IIR_AccessSubtypeDefinition();
  IIR_TypeDefinition *new_designated_type;
  new_designated_type = get_designated_type()->_construct_new_subtype( 0, new_constraint );
  retval->set_designated_type( new_designated_type );
  retval->set_base_type( this );

  if( resolution_function != NULL ){
    retval->set_resolution_function( _resolve_resolution_function( resolution_function ) );
  }

  return retval;
}
