
#ifndef IIRBASE_WHILE_LOOP_STATEMENT_HH
#define IIRBASE_WHILE_LOOP_STATEMENT_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//---------------------------------------------------------------------------
// 
// $Id: IIRBase_WhileLoopStatement.hh,v 1.2 1999/03/09 20:52:31 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIR_SequentialStatement.hh"
#include "IIR_SequentialStatementList.hh"

class IIRBase_WhileLoopStatement : public IIR_SequentialStatement {

// @BeginAutoDocExternalProseDescription
// @EndAutoDocExternalProseDescription

public:

  IIR_Kind get_kind() {
    return IIR_WHILE_LOOP_STATEMENT;
  }
  IIR_Char *get_kind_text() {
    return "IIR_WhileLoopStatement";
  }

  void set_while_condition( IIR *while_condition);
  IIR *get_while_condition();

  IIR_SequentialStatementList sequence_of_statements;
protected:
  
  IIRBase_WhileLoopStatement();
  virtual ~IIRBase_WhileLoopStatement() = 0;
    
private:
  
  IIR *while_condition;

};

#endif
