
#ifndef IIRBASE_WAVEFORM_ELEMENT_HH
#define IIRBASE_WAVEFORM_ELEMENT_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRBase_WaveformElement.hh,v 1.2 1999/03/09 20:52:29 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIR_Tuple.hh"

class IIR_WaveformElement;

class IIRBase_WaveformElement : public IIR_Tuple {

// @BeginAutoDocExternalProseDescription
// @EndAutoDocExternalProseDescription

public:

  IIR_Kind get_kind() {
    return IIR_WAVEFORM_ELEMENT;
  }
  IIR_Char *get_kind_text() {
    return "IIR_WaveformElement";
  }

  void set_value( IIR* value);
  IIR* get_value();
  void set_time( IIR* time);
  IIR* get_time();
  void set_next( IIR_WaveformElement* next);
  IIR_WaveformElement* get_next();

protected:
  
  IIRBase_WaveformElement();
  virtual ~IIRBase_WaveformElement() = 0;
    
private:
  
  IIR* value;
  IIR* time;
  IIR_WaveformElement* next;

};

#endif
