AC_DEFUN(AC_PROG_PURIFY,[

AC_REQUIRE([AC_PROG_CXX])
AC_REQUIRE([AC_PROG_CXX])

AC_SUBST(PURIFY)
AC_SUBST(PURECLEAN)
AC_SUBST(PURECOV)
AC_SUBST(PCOLLECT)
AC_SUBST(QUANTIFY)

AC_PATH_PROG(PURIFY, purify, no)
AC_PATH_PROG(QUANTIFY, quantify, no)
AC_PATH_PROG(PURECLEAN, pure_remove_old_files, no)
AC_PATH_PROG(PURECOV, purecov, no)

if test "$ac_cv_prog_gxx" = yes ; then
  AC_MSG_CHECKING("locating gnu ld")
  $CXX -v > /dev/null 2> conftest.out
ac_collector=`egrep specs conftest.out | sed -e 's#[^/]*\(/.*/\).*#\1#'`ld
  PCOLLECT="-g++=yes -collector=$ac_collector"
  AC_MSG_RESULT($ac_collector)
else
  PCOLLECT=""
fi
])

AC_DEFUN(AC_PROG_PCCTS,
[
AC_SUBST(ANTLR)
AC_SUBST(DLG)

AC_PATH_PROG(ANTLR, antlr, no)
if test $ANTLR = no; then
AC_MSG_ERROR( Configure could not locate the program \"antlr\" in your
path.  This program is needed to build the savant system.  It should
be installed as part of the PCCTS system which is available for free
via anonymous ftp from ftp.parr-research.com in the directory
/pub/pccts.  If you have installed PCCTS please verify that \"antlr\"
is in your path which is currently:
$PATH)
fi

])

AC_DEFUN(AC_GNU_MAKE,
[
AC_MSG_CHECKING("for gnu make")
AC_CACHE_VAL(ac_cv_gnu_make,
[
if eval 'make -v | grep -i gnu 1>&5 2>&5'; then
ac_cv_gnu_make=yes
else
ac_cv_gnu_make=no
fi
])
AC_MSG_RESULT("$ac_cv_gnu_make")
if test $ac_cv_gnu_make = no; then
AC_MSG_ERROR( The version of the program \"make\" that is currently in
your path does not appear to be gnu make.  Gnu's version of \"make\"
is a hard requirement to build savant.  All gnu software is available
for free via anonymous ftp from prep.ai.mit.edu in the directory
/pub/gnu.  If you have installed gnu make please make sure it is the
first \"make\" in your current path:
$PATH)
fi
])


AC_DEFUN(AC_CXX_HAS_BOOL,
[
AC_MSG_CHECKING("for builtin bool type in c++ compiler")
AC_CACHE_VAL(ac_cv_cxx_has_bool,
[
AC_LANG_CPLUSPLUS
AC_TRY_COMPILE(,
bool x; return 0;,
ac_cv_prog_cxx_bool=yes,
ac_cv_prog_cxx_bool=no)
if test "$ac_cv_prog_cxx_bool" = yes; then
CPPFLAGS="$CPPFLAGS -DHAS_BOOLEAN"
fi
])
AC_MSG_RESULT($ac_cv_prog_cxx_bool)
])


AC_DEFUN(AC_ANSI_CC,
[ 
AC_REQUIRE([AC_PROG_CC])
AC_MSG_CHECKING("checking whether $CC is ansi")

AC_CACHE_VAL(ac_cv_prog_ansi_cc,
[ 
cat > conftest.$ac_ext <<EOF
dnl This sometimes fails to find confdefs.h, for some reason.
[#]line __oline__ "[$]0"
[#]line __oline__ "configure"
#include "confdefs.h"
int main() { return 0; }
int foo(int x) { return x; }
EOF
if eval $ac_compile; then
  ac_cv_prog_ansi_cc=yes
else
  AC_MSG_RESULT("no")
  AC_MSG_CHECKING(
	"checking whether $CC is ansi with -Aa -D_INCLUDE_POSIX_SOURCE")
  saveCFLAGS="$CFLAGS"
  CFLAGS="-Aa -D_INCLUDE_POSIX_SOURCE $CFLAGS"
  if eval $ac_compile; then
    ac_cv_prog_ansi_cc=yes
  else  
    ac_cv_prog_ansi_cc=no
    CFLAGS="$saveCFLAGS"
  fi
fi
AC_MSG_RESULT($ac_cv_prog_ansi_cc)
if test $ac_cv_prog_ansi_cc = no ; then
  AC_MSG_RESULT("PLEASE find an ansi c compiler")
fi
rm -f conftest.*
])
])

AC_DEFUN(AC_SAVANT_MAKEDEPEND,[
  AC_MSG_CHECKING(for some way to build dependencies)
  AC_CACHE_VAL(ac_cv_found_gpp,[
    AC_CHECK_PROG(ac_cv_found_gpp, g++, yes, no )
  ])

  if test $ac_cv_found_gpp = yes; then
    MAKEDEPEND="-rm -f .depend;g++ -MM -MG \$(MDFLAGS) \$(CPPFLAGS) \$(MAKEDEP_SRCS) > .depend"
  fi

  if test $ac_cv_found_gpp = no; then
    AC_CACHE_VAL(ac_cv_savant_makedepend,[
      if test -f ../bin/makedepend.$host_os; then
        ac_cv_savant_makedepend=yes
        MAKEDEPEND="-rm -f .depend;../bin/makedepend.$host_os -f- -- \$(MDFLAGS) \$(CPPFLAGS) -- \$(MAKEDEP_SRCS) > .depend"
      else
        ac_cv_savant_makedepend=no
      fi
    AC_MSG_RESULT( checking for ../bin/makedepend.$host_os installed by savant... $ac_cv_savant_makedepend )
    ])
  fi


  if test $ac_cv_found_gpp = no; then
    if test $ac_cv_savant_makedepend = no; then
        AC_MSG_WARN( 
The regular \"makedepend\" that ships with Xwindows 
has hard limits on the number of files that it can handle and 
SAVANT has more files than it can deal with.  The developers of 
SAVANT provide two easy solutions to this problem.  One is to use 
g++ to generate dependencies (even if you're compiling with some
other compiler) and the other is to ship a binaries of X makedepend 
with its static limits increased.  However configure could not 
locate any version of the program \"g++\" in your path nor can it 
find a binary version of \"makedepend\" installed by SAVANT for your 
OS. Since configure cannot find either one you'll need to build the 
dependencies some other way - perhaps using a compiler flag of the 
c++ compiler you're using or making a soft link to a compatible
binary installed by SAVANT.  Please see the notes in the README 
regarding makedepend.  If g++ _is_ installed on your system please make 
sure the directory it is in appears in your path - your path right now
is:
$PATH )
      exit -1;
    fi
  fi
])
