/*
 * AUTHOR: Pedro Lineu Orso                             orso@brturbo.com
 *                                                            1998, 2004
 * SARG Squid Analysis Report Generator            http://sarg-squid.org
 * ---------------------------------------------------------------------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 */

#include "include/conf.h"

void authfail_report()
{

   FILE *fp_in = NULL, *fp_ou = NULL;
      
   char url[MAXLEN];
   char html[MAXLEN];
   char html2[MAXLEN];
   char authfail_in[MAXLEN];
   char per[MAXLEN];
   char report[MAXLEN];
   char periodo[100];
   char ip[MAXLEN];
   char oip[MAXLEN];
   char user[MAXLEN];
   char ouser[MAXLEN];
   char ouser2[MAXLEN];
   char data[15];
   char hora[15];
   char ftime[128];
   char *str;
   int  z=0;
   int  count=0;

   if(strlen(DataFile) > 0) return;

   ouser[0]='\0';

   sprintf(tmp4,"%s/authfail.log.unsort",TempDir);
   
   if(!authfail_count) {
      unlink(tmp4);
      return;
   }

   sprintf(authfail_in,"%s/authfail.log",TempDir);
   sprintf(per,"%s/periodo",dirname);
   sprintf(report,"%s/authfail.html",dirname);

   sprintf(csort,"export LC_ALL=C;sort -b -T %s -k 3,3 -k 5,5 -o %s %s", TempDir, authfail_in, tmp4);
   system(csort);
   unlink(tmp4);

   if ((fp_in = fopen(per, "r")) == 0) {
      fprintf(stderr, "SARG: (authfail) %s: %s\n",text[45],per);
      exit(1);
   }

   fgets(periodo,sizeof(periodo),fp_in);
   fclose(fp_in);

   if((fp_in=fopen(authfail_in,"r"))==NULL) {
     fprintf(stderr, "SARG: (authfail) %s: %s\n",text[45],authfail_in);
     exit(1);
   }

   if((fp_ou=fopen(report,"w"))==NULL) {
     fprintf(stderr, "SARG: (authfail) %s: %s\n",text[45],report);
     exit(1);
   }

   fputs("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"",fp_ou);
   fputs(" \"http://www.w3.org/TR/html4/loose.dtd\">\n",fp_ou);
   fputs("<html>\n",fp_ou);
   fputs("<head>\n",fp_ou);
   sprintf(html,"  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=%s\">\n",CharSet);
   fputs(html,fp_ou);
   css(fp_ou);
   fputs("</head>\n",fp_ou);

   if(strlen(FontFace) > 0) {
      sprintf(url,"<font face=%s>\n",FontFace);
      fputs(url,fp_ou);
   }

   sprintf(url,"<body bgcolor=%s text=%s background='%s'>\n",BgColor,TxColor,BgImage);
   fputs(url,fp_ou);

   if(strlen(LogoImage) > 0) {
      fputs("<center><table cellpadding=0 cellspacing=0>\n",fp_ou);
      sprintf(url,"<tr><th align=\"center\"><img src='%s' border=0 align=absmiddle width=%s height=%s><font color=%s>%s</font>\n",LogoImage,Width,Height,LogoTextColor,LogoText);
      fputs(url,fp_ou);
      fputs("</table>\n",fp_ou);
   }

   show_sarg(fp_ou,"..");
   fputs("<center><table cellpadding=0 cellspacing=0>\n",fp_ou);
   sprintf(url,"<tr><th class=\"title\">%s</th></tr>\n",Title);
   fputs(url,fp_ou);

   sprintf(url,"<tr><td class=\"header\">%s: %s</td></tr>\n",text[89],periodo);
   fputs(url,fp_ou);
   sprintf(url,"<tr><th class=\"header\">%s %s</th></tr>\n",text[117],text[55]);
   fputs(url,fp_ou);
   fputs("</table></center>\n",fp_ou);

   fputs("<center><table cellpadding=0 cellspacing=2>\n",fp_ou);
   fputs("<tr><td></td></tr>\n",fp_ou);
   fputs("<tr><td></td></tr>\n",fp_ou);
   fputs("<tr><td></td></tr>\n",fp_ou);
   sprintf(url,"<tr><th class=\"header\">%s</th><th class=\"header\">%s</th><th class=\"header\">%s</th><th class=\"header\">%s</th></tr>\n",text[98],text[111],text[110],text[91]);
   fputs(url,fp_ou);

   while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
      getword(data,buf,' ');
      getword(hora,buf,' ');
      getword(user,buf,' ');
      getword(ip,buf,' ');
      getword(url,buf,' ');

      if((str=(char *) strstr(user, "_")) != (char *) NULL ) {
         if((str=(char *) strstr(str+1, "_")) != (char *) NULL )
            fixip(user);
      }

      if(strcmp(Ip2Name,"yes") == 0) 
         ip2name(ip);

      if(!z) {
         strcpy(ouser,user);
         strcpy(oip,ip);
         z++;
      } else {
         if(strcmp(ouser,user) == 0)
            user[0]='\0';
         if(user[0] != '\0')
            strcpy(ouser,user);
         if(strcmp(oip,ip) == 0) 
            ip[0]='\0';
         if(ip[0] != '\0')
            strcpy(oip,ip);
      }

      if(UserTabFile[0] != '\0') {
         sprintf(warea,":%s:",user);
         if((str=(char *) strstr(userfile,warea)) != (char *) NULL ) {
            z1=0;
            str2=(char *) strstr(str+1,":");
            str2++;
            bzero(name, MAXLEN);
            while(str2[z1] != ':') {
               name[z1]=str2[z1];
               z1++;
            }
         } else strcpy(name,user);
      } else strcpy(name,user);

     if(AuthfailReportLimit) {
        if(strcmp(ouser2,name) == 0) {
            count++;
         } else {
            count=1;
            strcpy(ouser2,name);
         }
         if(count >= AuthfailReportLimit)
            continue;
      }

      sprintf(html2,"<tr><td class=\"data2\">%s</td><td class=\"data2\">%s</td><td class=\"data2\">%s-%s</td><td class=\"data2\">%s<a href=\"%s\">%s</a></td></th>\n",name,ip,data,hora,BlockImage,url,url);
      fputs(html2,fp_ou);
   }

   fputs("</table>\n",fp_ou);

   show_info(fp_ou);

   fputs("</body>\n</html>\n",fp_ou);

   fclose(fp_in);
   fclose(fp_ou);

   unlink(authfail_in);

   return;
}
