#ifndef RUMBA_IOHANDLER_BASE_H
#define RUMBA_IOHANDLER_BASE_H

//#ifdef __GNUC__
//#define streampos ios::seek_dir
//#endif

#include <rumba_config.h>
#include <fstream>
#include <strstream>
#include <rumba/rumba_system.h>
#include <rumba/log.h>
#include <rumba/point.hpp>
#include <rumba/baseManifold.h>

#include <streambuf.h>

/**
*	The purpose of the reader class is to read data stored on a disk
*	as a certain type (for example, float) and give it to the user as
*	a type of their choice (for example, int). The idea is that the user
*	does not know in advance what file type they will be dealing with,
*	so the purpose of the IOHandlerBase is to polymorphically handle different
*	data types.
*
*	The rumba_cast conversion operator is used for the required data
*	conversions. It throws an exception RUMBA::BadCast if a conversion
*	cannot be performed (which is something we must allow for if we are 
*	to permit the user to request arbitrary conversions)
*	
*/



// abstract class.

namespace RUMBA 
{ 

class IOHandlerBase 
{
public:
	virtual ~IOHandlerBase(){ Stream.close(); };	

	/** is the stream writeable ? */
	virtual bool writeable() const = 0;

	/**
	*	The main purpose of this class: dispatching these guys.
	*	The derived class implements these as templates.
	*/
	virtual void cGet (char*   dest, int nelts, bool le)=0;
	virtual void cGet (short*  dest, int nelts, bool le )=0;
	virtual void cGet (int*    dest, int nelts, bool le )=0;
	virtual void cGet (float*  dest, int nelts, bool le )=0;
	virtual void cGet (double* dest, int nelts, bool le )=0;

	// These should be pure virtual.
	virtual void cPut (char*   src, int nelts, bool le)=0;
	virtual void cPut (short*  src, int nelts, bool le)=0;
	virtual void cPut (int*    src, int nelts, bool le)=0;
	virtual void cPut (float*  src, int nelts, bool le)=0;
	virtual void cPut (double* src, int nelts, bool le)=0;



	virtual void iGet ( BaseManifold*, int, int, bool ){}


	/*
	   * 	seekg and seekp position at Nth data element, NOT Nth position
	   *	in file !!!
	   */

	virtual void seekg(int x, std::ios::seekdir pos = std::ios::beg )
	{ 
		log.logName() << "Warning: Calling IOHandlerBase::seekg(" <<x << "\n"; 
		Stream.seekg (x, pos); 
	}
	virtual void seekp(int x, std::ios::seekdir pos = std::ios::beg )
	{ 
		log.logName() << "Warning: Calling IOHandlerBase::seekp(" <<x << "\n"; 
		Stream.seekp(x, pos); 
	}

	/** 
	 *   size() returns the number of data elements, in other words, the 
	 *   largest valid argument to seekg() or seekp()
	 */
	virtual int size();

	/**
	 *   streamsize() returns the number of data elements currently stored 
	 *   in the file.
	 */
	virtual int streamsize() = 0;


	virtual BaseManifold* createManifold(int,int,int,int){ return 0; }

	virtual BaseManifold* get( 
			const intPoint&,const intPoint&,const intPoint&, bool 
			) { return 0;}
	virtual void get ( 
			const intPoint&, 
			const intPoint&, 
			const intPoint&, 
			bool, 
			BaseManifold* 
			) 
	{ }
	virtual void put ( const BaseManifold*, 
			const intPoint&,
			const intPoint&,
			const intPoint&, bool  
			) 
	{
		log.logName() << "Warning: virtual function stub IOHandlerBase::put()"
			"called	" << "\n";
	}

	/**
	 *   Adust the limit on the number of elements a stream can store.
	 */
	virtual void resize(int s);

protected:

	IOHandlerBase();

	IOHandlerBase
	(
		const char* filename, 
		int Size,
		std::ios_base::openmode mode = std::ios::in 
	);

	/** 
	 * 	 Extend the file so that it's large enough to hold sz elements.
	 * 	 Note that this call may make the file larger than this. (ie currently
	 * 	 the call is the same as grow(size())
	 */
	virtual void grow ( int sz ) = 0;

	Log log;
	std::fstream Stream;
	std::string Filename;
	bool hostLE; // is the machine little-endian ?

	int Size;
	
};

int filesize ( std::fstream& Stream );

} // namespace RUMBA

#endif
