#ifndef RUMBA_SIEMENS_FILE_H
#define RUMBA_SIEMENS_FILE_H

#include <rumba/exemplar.h>
#include <rumba/header_request.h>
#include <rumba/manifoldFile.h>
#include <string>
#include <list>
#include <fstream>


namespace RUMBA
{



class SiemensFile : public ManifoldFile 
{

public:
	SiemensFile();
	SiemensFile(Exemplar);
	virtual bool isMine(std::string s);
	void saveHeader(const char* filename);
	void loadHeader(const char* filename);

	void initFile ( std::ios_base::openmode mode);

	ManifoldFile* getNew();
private:

	void endian_hack(const char* filename, std::ifstream& in);

	void loadCsv();
	void loadRc();
	Factory* getFactoryFromDataType(std::string );
	void fillRequiredHeaders();

	void processHeaderData();
	void processDimensions();
	void processPixelDimensions();
	void processOrientation();
	
	void processDimensionsForSave();

	void setfilesize(const char*);
	char find_orientation(char top, char back);

	int Filesize;
	int Tiles;


	std::list<RUMBA::header_request> HeaderRequests;

	std::string header_size;

};

	extern SiemensFile SiemensFileInstance;
	extern SiemensFile* SiemensFileExemplar;



}//namespace RUMBA


#endif
