#include <fstream>
#include <string>
using std::ostream;
#include <rumba/arghandler.h>
#include <rumba/manifoldFile.h>
#include <rumba/fileIO.h>

using std::cerr;
using std::endl;
using RUMBA::Argument;

void help_message() {
	std::cerr << "Usage: txt2bin [ -i infile ] [ -o outfile ] \
		[ --type char|short|int|float|double ]\n";
}
void putCharWrapper(ostream& o,double d,bool b){ RUMBA::putChar(o,(char)d); }
void putShortWrapper(ostream& o,double d,bool b){ RUMBA::putShort(o,(short)d,b); }
void putIntWrapper(ostream& o,double d,bool b){ RUMBA::putInt(o,(int)d,b); }
void putFloatWrapper(ostream& o,double d,bool b){ RUMBA::putFloat(o,(float)d,b); }
void putDoubleWrapper(ostream& o,double d,bool b){ RUMBA::putDouble(o,d,b); }

Argument myArgs [] = {
	Argument ( "type", RUMBA::ALPHA, 0, "" ),
	Argument ( "bigendian", RUMBA::FLAG, 'b' ),
	Argument()
};



int main(int argc, char** argv)
{
	std::string type, infile, outfile;
	RUMBA::ArgHandler argh ( argc, argv, myArgs );

	double x;
	bool b = 1;

	void (*doit) (ostream&,double,bool); 

	if (argh.arg("help"))
	{
		help_message();
		exit(0);
	}

	try 
	{
		argh.arg ( "type", type );
		argh.arg ( "outfile", outfile );
		argh.arg ( "infile", infile );
		b = ! argh.arg("bigendian");
	}
	catch(...)
	{}

	ifstream fin;
	ofstream fout;
	istream* in;
	ostream* out;

	if ( infile.empty() )
		in = &std::cin;
	else
	{
		fin.open(infile.c_str());
		if (!fin)
		{
			cerr  << "Couldn't open " << infile << endl;
			exit(1);
		}
		in = &fin;
	}

	if ( outfile.empty() )
		out= &std::cout;
	else
	{
		fout.open(outfile.c_str());
		if (!fout)
		{
			cerr  << "Couldn't open " << outfile << endl;
			exit(1);
		}
		out = &fout;
	}


	if ( type == "char" )
		doit=putCharWrapper;
	else if ( type == "short" || type.empty()  ) 
		doit=putShortWrapper;
	else if ( type == "int" )
		doit=putIntWrapper;
	else if ( type == "float" )
		doit=putFloatWrapper;
	else if ( type == "double" )
		doit=putDoubleWrapper;
	else
	{
		help_message();
		exit(1);
	}


	while ( *in >> x )
		doit(*out,x,b);

	return 0;

}


