#include <rumba/manifold.h>
#include <rumba/arghandler.h>
#include <iostream>

using RUMBA::Argument;

Argument myArgs[] = {
	Argument ( "width", RUMBA::NUMERIC, 'x', "1" ),
	Argument ( "height", RUMBA::NUMERIC, 'y', "1" ),
	Argument ( "depth", RUMBA::NUMERIC, 'z', "1" ),
	Argument ( "timepoints", RUMBA::NUMERIC, 't', "1" ),
	Argument()
};


int main (int argc, char** argv)
{
	/**
	*	Handle command line arguments
	*/
	int x,y,z,t;
	string infile;
	RUMBA::ArgHandler argh ( argc, argv, myArgs );
	argh.arg ( "infile",infile );
	argh.arg("width",x);
	argh.arg("height",y);
	argh.arg("depth",z);
	argh.arg("timepoints",t);
	if (infile == "") {
		std::cerr << "Must supply an input file. eg -i infile" << std::endl;
		exit (1);
	}

	/**
	*	Load manifold
	*/
	/*
	RUMBA::Manifold<short> M;
	try {
	M.loadAscii ( infile,x,y,z,t );
	}
	catch ( RUMBA::Exception& e ){
		cerr << "Caught RUMBA::Exception" << endl;
		cerr << e.error() << endl;
		exit (1);
	}
	*/
	/*
	catch ( RUMBA::BadFile& e ){
		cerr <<"caught RUMBA::BadFile" << endl;
		cerr << e.error() << endl;
		exit (1);
	}
	*/
	/*
	catch (...){
		cerr << "Uncaught" <<endl;
		exit (1);
	}
	cerr << "Infile is: \"" << infile << "\"" << endl;
	cerr << "M[0] is : " << M[0] << endl;
	*/

}
