#include <roy.h>

typedef struct _RNodeKV       RNodeKV;

struct _RNodeKV {
    RBHASH_HEADER;
    void *value;
};

void *
rnode_kv_get            (RNode *node, RBuf *key)
{
    RNodeKV *kv;

    if (!node->kvs) {
        return (NULL);
    }

    kv = rbhash_lookup (node->kvs, key);
    return (kv ? kv->value : NULL);
}


void
rnode_kv_set            (RNode *node, RBuf *key, void *value)
{
    RNodeKV *kv;
    RBuf *realkey;

    if (rbuf_owned (key)) {
        realkey = rbuf_new_with_rbuf (key);
    } else {
        realkey = key;
    }
    rbuf_own (realkey);

    kv = rchunk_alloc (sizeof (RNodeKV));
    kv->value = value;
   
    if (!node->kvs) {
        node->kvs = rbhash_new ();
    }

    rbhash_insert (node->kvs, kv, realkey);
}


