# Automatically generated....
raise 'Must be invoked by installation process' unless $opfile

# -----------------------------------------
aClass = ClassModule.new("Range", "Object", "class")
aClass.addFragment(Paragraph.new("A <code>Range</code> represents an interval---a set of values with a start and an end. Ranges may be constructed using the <em>s</em><code>..</code><em>e</em> and <em>s</em><code>...</code><em>e</em> literals, or with <code>Range::new</code>. Ranges constructed using <code>..</code> run from the start to the end inclusively. Those created using <code>...</code> exclude the end value. When used as an iterator, ranges return each value in the sequence.\n"))
aClass.addFragment(Verbatim.new("(-1..-5).to_a      \#=> []\n(-5..-1).to_a      \#=> [-5, -4, -3, -2, -1]\n('a'..'e').to_a    \#=> [\"a\", \"b\", \"c\", \"d\", \"e\"]\n('a'...'e').to_a   \#=> [\"a\", \"b\", \"c\", \"d\"]\n"))
aClass.addFragment(Paragraph.new("Ranges can be constructed using objects of any type, as long as the objects can be compared using their <code><=></code> operator and they support the <code>succ</code> method to return the next object in sequence.\n"))
aClass.addFragment(Verbatim.new("class Xs                \# represent a string of 'x's\n  include Comparable\n  attr :length\n  def initialize(n)\n    @length = n\n  end\n  def succ\n    Xs.new(@length + 1)\n  end\n  def <=>(other)\n    raise TypeError unless other.kind_of? Xs\n    @length <=> other.length\n  end\n  def inspect\n    'x' * @length\n  end\nend\n\nr = Xs.new(3)..Xs.new(6)   \#=> xxx..xxxxxx\nr.to_a                     \#=> [xxx, xxxx, xxxxx, xxxxxx]\nr.member?(Xs.new(5))       \#=> true\n"))
m0002 = MethodDesc.new("new", "class", "Range.new( <i>start</i>, <i>end</i>, <i>exclusive</i><code>=false</code> ) -> <i>aRange</i>")
m0002.addFragment(Paragraph.new("Constructs a range using the given <i>start</i> and <i>end</i>. If the third parameter is omitted or is <code>false</code>, the range will include the end object; otherwise, it will be excluded.\n"))
aClass.addMethod(m0002)
m0003 = MethodDesc.new("===", "instance", "<i>rng</i> === <i>anObject</i> -> <code>true</code> or <code>false</code>")
m0003.addFragment(Paragraph.new("Returns <code>true</code> if <i>anObject</i> is an element of <i>rng</i>, <code>false</code> otherwise. Conveniently, <code>===</code> is the comparison operator used by <code>case</code> statements.\n"))
m0003.addFragment(Verbatim.new("case 79\nwhen 1..50   then   print \"low\\n\"\nwhen 51..75  then   print \"medium\\n\"\nwhen 76..100 then   print \"high\\n\"\nend"))
m0003.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0003.addFragment(Verbatim.new("high"))
aClass.addMethod(m0003)
m0004 = MethodDesc.new("begin", "instance", "<i>rng</i>.begin -> <i>anObject</i>")
m0004.addFragment(Paragraph.new("Returns the first object of <i>rng</i>.\n"))
aClass.addMethod(m0004)
m0005 = MethodDesc.new("each", "instance", "<i>rng</i>.each {| i | block } -> <i>rng</i>")
m0005.addFragment(Paragraph.new("Iterates over the elements <i>rng</i>, passing each in turn to the block.\n"))
m0005.addFragment(Verbatim.new("(10..15).each do |n|\n   print n, ' '\nend"))
m0005.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0005.addFragment(Verbatim.new("10 11 12 13 14 15"))
aClass.addMethod(m0005)
m0006 = MethodDesc.new("end", "instance", "<i>rng</i>.end -> <i>anObject</i>")
m0006.addFragment(Paragraph.new("Returns the object that defines the end of <i>rng</i>. See also <code>Range\#length</code>.\n"))
m0006.addFragment(Verbatim.new("(1..10).end    \#=> 10\n(1...10).end   \#=> 10\n"))
aClass.addMethod(m0006)
m0007 = MethodDesc.new("exclude_end?", "instance", "<i>rng</i>.exclude_end? -> <code>true</code> or <code>false</code>")
m0007.addFragment(Paragraph.new("Returns <code>true</code> if <i>rng</i> excludes its end value.\n"))
aClass.addMethod(m0007)
m0008 = MethodDesc.new("first", "instance", "<i>rng</i>.first -> <i>anObject</i>")
m0008.addFragment(Paragraph.new("Returns the first object in <i>rng</i>.\n"))
aClass.addMethod(m0008)
m0009 = MethodDesc.new("last", "instance", "<i>rng</i>.last -> <i>anObject</i>")
m0009.addFragment(Paragraph.new("Synonym for <code>Range\#end</code>.\n"))
aClass.addMethod(m0009)
m0010 = MethodDesc.new("length", "instance", "<i>rng</i>.length -> <i>anInteger</i>")
m0010.addFragment(Paragraph.new("Returns the number of objects in <i>rng</i>.\n"))
m0010.addFragment(Verbatim.new("(1..10).length    \#=> 10\n(1...10).length   \#=> 9\n"))
aClass.addMethod(m0010)
m0011 = MethodDesc.new("size", "instance", "<i>rng</i>.size -> <i>anInteger</i>")
m0011.addFragment(Paragraph.new("Synonym for <code>Range\#length</code>.\n"))
aClass.addMethod(m0011)

File.open($opfile, "w") {|f| Marshal.dump(aClass, f) }
