/* Copyright (c) 2001-2010, David A. Clunie DBA Pixelmed Publishing. All rights reserved. */

package com.pixelmed.test;

import com.pixelmed.dose.*;

import junit.framework.*;

import com.pixelmed.dicom.CodedSequenceItem;

public class TestCTAcquisitionParameters extends TestCase {
	
	// constructor to support adding tests to suite ...
	
	public TestCTAcquisitionParameters(String name) {
		super(name);
	}
	
	// add tests to suite manually, rather than depending on default of all test...() methods
	// in order to allow adding TestCTAcquisitionParameters.suite() in AllTests.suite()
	// see Johannes Link. Unit Testing in Java pp36-47
	
	public static Test suite() {
		TestSuite suite = new TestSuite("TestCTAcquisitionParameters");
		
		suite.addTest(new TestCTAcquisitionParameters("TestCTAcquisitionParametersConstructor_WithAllParameters"));
		
		return suite;
	}
	
	protected void setUp() {
	}
	
	protected void tearDown() {
	}
	
	public void TestCTAcquisitionParametersConstructor_WithAllParameters() throws Exception {
		
		String irradiationEventUID = "1.2.3.4";
		String exposureTimeInSeconds = "1";
		String scanningLengthInMM = "750";
		String nominalSingleCollimationWidthInMM = "0.625";
		String nominalTotalCollimationWidthInMM = "40";
		String pitchFactor = "0.984";
		String kvp = "120";
		String tubeCurrent = "397";
		String exposureTimePerRotation = "0.6";
		String anatomyCodeMeaning = "Chest, Abdomen and Pelvis";
		CodedSequenceItem anatomy = new CodedSequenceItem("R-FAB56","SRT",anatomyCodeMeaning);
		
		CTAcquisitionParameters ctAcquisitionParameters = new CTAcquisitionParameters(irradiationEventUID,anatomy,exposureTimeInSeconds,scanningLengthInMM,nominalSingleCollimationWidthInMM,nominalTotalCollimationWidthInMM,pitchFactor,kvp,tubeCurrent,exposureTimePerRotation);
		
		String expectToString = "\tIrradiationEventUID="+irradiationEventUID+"\tAnatomy="+anatomy+"\tScanningLength="+scanningLengthInMM+" mm"
			+"\tCollimation single/total="+nominalSingleCollimationWidthInMM+"/"+nominalTotalCollimationWidthInMM+" mm"+"\tPitchFactor="+pitchFactor+":1"
			+"\tKVP="+kvp+" kVP"+"\tTubeCurrent="+tubeCurrent+" mA"+"\tExposure time/per rotation="+exposureTimeInSeconds+"/"+exposureTimePerRotation+" s\n";
		
		String expectToStringPretty = "\t"+anatomyCodeMeaning+"\t"+scanningLengthInMM+" mm"
			+"\t"+nominalSingleCollimationWidthInMM+"/"+nominalTotalCollimationWidthInMM+" mm"+"\t"+pitchFactor+":1"
			+"\t"+kvp+" kVP"+"\t"+tubeCurrent+" mA"+"\t"+exposureTimeInSeconds+"/"+exposureTimePerRotation+" s\n";
		
		assertEquals("Checking IrradiationEventUID equality",irradiationEventUID,ctAcquisitionParameters.getIrradiationEventUID());
		assertEquals("Checking Anatomy equality",anatomy,ctAcquisitionParameters.getAnatomy());
		assertEquals("Checking ExposureTimeInSeconds equality",exposureTimeInSeconds,ctAcquisitionParameters.getExposureTimeInSeconds());
		assertEquals("Checking ScanningLengthInMM equality",scanningLengthInMM,ctAcquisitionParameters.getScanningLengthInMM());
		assertEquals("Checking NominalSingleCollimationWidthInMM equality",nominalSingleCollimationWidthInMM,ctAcquisitionParameters.getNominalSingleCollimationWidthInMM());
		assertEquals("Checking NominalTotalCollimationWidthInMM equality",nominalTotalCollimationWidthInMM,ctAcquisitionParameters.getNominalTotalCollimationWidthInMM());
		assertEquals("Checking PitchFactor equality",pitchFactor,ctAcquisitionParameters.getPitchFactor());
		assertEquals("Checking KVP equality",kvp,ctAcquisitionParameters.getKVP());
		assertEquals("Checking TubeCurrent equality",tubeCurrent,ctAcquisitionParameters.getTubeCurrent());
		assertEquals("Checking ExposureTimePerRotation equality",exposureTimePerRotation,ctAcquisitionParameters.getExposureTimePerRotation());
		
		assertEquals("Checking toString",expectToString,ctAcquisitionParameters.toString());
		assertEquals("Checking toString pretty",expectToStringPretty,ctAcquisitionParameters.toString(true));
	}
	
}
