#include "npconfig.h"

void NP_Config::update_server_frames( int i )
{
   gtk_widget_destroy( server_frames[ i ] );

   int total = subscription.get_total();
   if ( total < 0 )
   {
      subscription.print_error();
      return;
   }

   if ( !total )
   {
      if ( server_frames != NULL )
         free( server_frames );

      server_frames = NULL;
      return;
   }

   GtkWidget **temp_frames;
   if (( temp_frames =
         ( GtkWidget **)calloc( total, sizeof *server_frames )) == NULL )
   {
      perror( "realloc" );
      exit( 1 );
   }
      
   GtkWidget **temp = temp_frames;
   GtkWidget **pointer = server_frames;

   int old_total = total + 1;
   for( int j = 0; j < old_total; ++j )
   {
      if ( j == i )
      {
         ++pointer;
         continue;
      }

      *temp++ = *pointer++;
   }

   free( server_frames );
   server_frames = temp_frames;

   return;
}
