#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <string.h>
#include <errno.h>

#include "npserver.h"

int NP_Server::write_timestamp( char *server )
{
   char buffer[ 1024 ], second_buffer[ 1024 ];

   FILE *file;

   time_t unix_time;
   struct tm *gmt;


   unix_time = time( NULL );
   gmt = gmtime( &unix_time );

   snprintf( buffer, sizeof buffer, "%2.2u%2.2u%2.2u %2.2u%2.2u%2.2u\n",
             gmt->tm_year, gmt->tm_mon + 1, gmt->tm_mday,
             gmt->tm_hour, gmt->tm_min, gmt->tm_sec );

   snprintf( second_buffer, sizeof buffer, "%s/.peruser_spool/%s-TIMESTAMP", 
             getenv( "HOME" ), server );
   if (( file = fopen( second_buffer, "w" )) == NULL )
   {
      snprintf( error_message, sizeof error_message,
                "NP_Server: write_timestamp(): fopen() returned error: %s.",
                strerror( errno ));
      return -1;
   }

   fputs( buffer, file );
   fclose( file );

   return 0;
}
