#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npgroup.h"
#include "npnode.h"
#include "nptree.h"

int NP_Tree::create_folders( char *name )
{
   char *line;
   if (( line = file.get_string() ) == NULL )
      return 0;

   if (( nodes = ( NP_Node **)realloc( nodes, ++total_nodes * sizeof *nodes ))
       == NULL )
   {
      perror( "realloc" );
      exit( 1 );
   }

   NP_Node **pointer = nodes;
   if (( pointer[ total_nodes - 1 ] = new NP_Node( name ))
       == NULL )
   {
      perror( "new" );
      exit( 1 );
   }

   if ( array.clear() )
   {
      snprintf( error_message, sizeof error_message, "NP_Tree: "
                "create_folders(): %s", array.get_error() );
      return 1;
   }
   
   do
   {
      if ( array.add_item( strtok( line + strspn( line, ":" ), "\t\n" )))
      {
         snprintf( error_message, sizeof error_message, "NP_Tree: "
                   "create_folders(): %s", array.get_error() );
         return 1;
      }
   }
   while(( line = file.get_string() ) != NULL );

   if (( pointer[ total_nodes - 1 ]->update_groups( array )))
   {
      snprintf( error_message, sizeof error_message, "NP_Tree: "
                "create_folders(): %s",
                pointer[ total_nodes - 1 ]->get_error());
      return 1;
   }

   int groups, messages, unseen, headers, requested;
   if ( pointer[ total_nodes - 1 ]->get_stats( &groups, &messages,
                                               &unseen, &requested,
                                               &headers ))
   {
      snprintf( error_message, sizeof error_message, "NP_Tree: "
                "create_folders(): %s",
                pointer[ total_nodes - 1 ]->get_error());
      return 1;
   }

   total_groups += groups;
   total_messages += messages;
   total_unseen += unseen;
   total_requested += requested;
   total_headers += headers;

   if ( array.clear() )
   {
      snprintf( error_message, sizeof error_message, "NP_Tree: "
                "create_folders(): %s", array.get_error());
      return 1;
   }
      
   return 0;
}
   
