/* $Id: paridecl.h,v 1.584 2006/05/09 16:03:11 kb Exp $

Copyright (C) 2000-2003  The PARI group.

This file is part of the PARI/GP package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

/*******************************************************************/
/*                                                                 */
/*                DECLARATIONS of PUBLIC FUNCTIONS                 */
/*                                                                 */
/*******************************************************************/
/* Flx.c */
GEN     Fl_to_Flx(ulong x, long sv);
GEN     Flc_to_ZC(GEN z);
GEN     Flm_to_FlxV(GEN x, long sv);
GEN     Flm_to_FlxX(GEN x, long v,long w);
GEN     Flm_to_ZM(GEN z);
GEN     Flv_to_Flx(GEN x, long vs);
GEN     Flv_to_ZV(GEN z);
GEN     Flv_polint(GEN xa, GEN ya, ulong p, long vs);
GEN     Flv_roots_to_pol(GEN a, ulong p, long vs);
GEN     Flx_Fl_mul(GEN y, ulong x, ulong p);
GEN     Flx_to_Flv(GEN x, long N);
GEN     Flx_to_ZX(GEN z);
GEN     Flx_to_ZX_inplace(GEN z);
GEN     Flx_add(GEN x, GEN y, ulong p);
GEN     Flx_deriv(GEN z, ulong p);
GEN     Flx_div_by_X_x(GEN a, ulong x, ulong p, ulong *rem);
GEN     Flx_divrem(GEN x, GEN y, ulong p, GEN *pr);
ulong   Flx_eval(GEN x, ulong y, ulong p);
GEN     Flx_extgcd(GEN a, GEN b, ulong p, GEN *ptu, GEN *ptv);
ulong   Flx_extresultant(GEN a, GEN b, ulong p, GEN *ptU, GEN *ptV);
GEN     Flx_gcd(GEN a, GEN b, ulong p);
GEN     Flx_gcd_i(GEN a, GEN b, ulong p);
GEN     Flx_invmontgomery(GEN T, ulong p);
int     Flx_is_squarefree(GEN z, ulong p);
GEN     Flx_mul(GEN x, GEN y, ulong p);
GEN     Flx_neg(GEN x, ulong p);
GEN     Flx_neg_inplace(GEN x, ulong p);
GEN     Flx_normalize(GEN z, ulong p);
GEN     Flx_pow(GEN x, long n, ulong p);
GEN     Flx_recip(GEN x);
GEN     Flx_red(GEN z, ulong p);
GEN     Flx_rem_montgomery(GEN x, GEN mg, GEN T, ulong p);
GEN     Flx_rem(GEN x, GEN y, ulong p);
GEN     Flx_renormalize(GEN x, long l);
ulong   Flx_resultant(GEN a, GEN b, ulong p);
GEN     Flx_shift(GEN a, long n);
GEN     Flx_sqr(GEN x, ulong p);
GEN     Flx_sub(GEN x, GEN y, ulong p);
long    Flx_valuation(GEN x);
GEN     FlxC_to_ZXC(GEN x);
GEN     FlxM_to_ZXM(GEN z);
GEN     FlxV_Flc_mul(GEN V, GEN W, ulong p);
GEN     FlxV_to_Flm(GEN v, long n);
GEN     FlxX_add(GEN P, GEN Q, ulong p);
GEN     FlxX_renormalize(GEN x, long lx);
GEN     FlxX_shift(GEN a, long n);
GEN     FlxX_to_Flm(GEN v, long n);
GEN     FlxX_to_ZXX(GEN B);
GEN     FlxYqQ_pow(GEN x, GEN n, GEN S, GEN T, ulong p);
GEN     Flxq_inv(GEN x,GEN T,ulong p);
GEN     Flxq_invsafe(GEN x, GEN T, ulong p);
GEN     Flxq_mul(GEN y,GEN x,GEN T,ulong p);
GEN     Flxq_pow(GEN x, GEN n, GEN T, ulong p);
GEN     Flxq_powers(GEN x, long l, GEN T, ulong p);
GEN     Flxq_sqr(GEN y,GEN T,ulong p);
GEN     FlxqV_roots_to_pol(GEN V, GEN T, ulong p, long v);
GEN     FlxqX_normalize(GEN z, GEN T, ulong p);
GEN     FlxqX_Flxq_mul(GEN P, GEN U, GEN T, ulong p);
GEN     FlxqX_red(GEN z, GEN T, ulong p);
GEN     FlxqX_mul(GEN x, GEN y, GEN T, ulong p);
GEN     FlxqX_safegcd(GEN P, GEN Q, GEN T, ulong p);
GEN     FlxqX_sqr(GEN x, GEN T, ulong p);
GEN     FlxqX_divrem(GEN x, GEN y, GEN T, ulong p, GEN *pr);
GEN     FlxqXQ_pow(GEN x, GEN n, GEN S, GEN T, ulong p);
GEN     FlxqXV_prod(GEN V, GEN T, ulong p);
GEN     Z_to_Flx(GEN x, ulong p, long v);
GEN     ZM_to_Flm(GEN x, ulong p);
GEN     ZV_to_Flv(GEN x, ulong p);
GEN     ZX_to_Flx(GEN x, ulong p);
GEN     ZXV_to_FlxV(GEN v, ulong p);
GEN     ZXX_to_FlxX(GEN B, ulong p, long v);
GEN     ZXXV_to_FlxXV(GEN V, ulong p, long v);
GEN     polx_Flx(long sv);
GEN     zero_Flx(long sv);

/* alglin1.c */

GEN     Flm_Flc_mul(GEN x, GEN y, ulong p);
GEN     Flm_deplin(GEN x, ulong p);
GEN     Flm_gauss(GEN a, GEN b, ulong p);
GEN     Flm_indexrank(GEN x, ulong p);
GEN     Flm_inv(GEN x, ulong p);
GEN     Flm_ker(GEN x, ulong p);
GEN     Flm_ker_sp(GEN x, ulong p, long deplin);
GEN     Flm_mul(GEN x, GEN y, ulong p);
GEN     FlxqM_ker(GEN x, GEN T, ulong p);
GEN     FpC_Fp_mul(GEN x, GEN y, GEN p);
GEN     FpC_FpV_mul(GEN x, GEN y, GEN p);
GEN     FpM_FpC_mul(GEN x, GEN y, GEN p);
GEN     FpM_deplin(GEN x, GEN p);
GEN     FpM_gauss(GEN a, GEN b, GEN p);
GEN     FpM_image(GEN x, GEN p);
GEN     FpM_intersect(GEN x, GEN y, GEN p);
GEN     FpM_inv(GEN x, GEN p);
GEN     FpM_invimage(GEN m, GEN v, GEN p);
GEN     FpM_ker(GEN x, GEN p);
GEN     FpM_mul(GEN x, GEN y, GEN p);
long    FpM_rank(GEN x, GEN p);
GEN     FpM_indexrank(GEN x, GEN p);
GEN     FpM_suppl(GEN x, GEN p);
GEN     FpV_FpC_mul(GEN x, GEN y, GEN p);
GEN     FqM_gauss(GEN a, GEN b, GEN T, GEN p);
GEN     FqM_ker(GEN x, GEN T, GEN p);
GEN     FqM_suppl(GEN x, GEN T, GEN p);
GEN     QM_inv(GEN M, GEN dM);
GEN     ZM_inv(GEN M, GEN dM);
void    appendL(GEN x, GEN t);
GEN     cget1(long l, long t);
GEN     concat(GEN x, GEN y);
GEN     shallowconcat(GEN x, GEN y);
GEN     concatsp3(GEN x, GEN y, GEN z);
GEN     deplin(GEN x);
GEN     det(GEN a);
GEN     det0(GEN a,long flag);
GEN     det2(GEN a);
GEN     detint(GEN x);
GEN     diagonal(GEN x);
GEN     eigen(GEN x, long prec);
GEN     extract(GEN x, GEN l);
GEN     extract0(GEN x, GEN l1, GEN l2);
GEN     gaddmat(GEN x, GEN y);
GEN     gaddmat_i(GEN x, GEN y);
GEN     gauss(GEN a, GEN b);
GEN     gaussmodulo(GEN M, GEN D, GEN Y);
GEN     gaussmodulo2(GEN M, GEN D, GEN Y);
GEN     gscalcol(GEN x, long n);
GEN     gscalcol_i(GEN x, long n);
GEN     gscalmat(GEN x, long n);
GEN     gscalsmat(long x, long n);
GEN     gtomat(GEN x);
GEN     gtrans(GEN x);
GEN     shallowtrans(GEN x);
int     hnfdivide(GEN A, GEN B);
GEN     matid(long n);
GEN     matid_Flm(long n);
GEN     image(GEN x);
GEN     image2(GEN x);
GEN     imagecompl(GEN x);
GEN     indexrank(GEN x);
GEN     inverseimage(GEN mat, GEN y);
long    isdiagonal(GEN x);
long    isscalarmat(GEN x, GEN s);
GEN     ker(GEN x);
GEN     keri(GEN x);
GEN     matextract(GEN x, GEN l1, GEN l2);
GEN     matimage0(GEN x,long flag);
GEN     matker0(GEN x, long flag);
GEN     matmuldiagonal(GEN x, GEN d);
GEN     matmultodiagonal(GEN x, GEN y);
GEN     matsolvemod0(GEN M, GEN D, GEN Y,long flag);
GEN     mattodiagonal(GEN m);
GEN     mattodiagonal_i(GEN m);
long    rank(GEN x);
GEN     row(GEN A, long x1);
GEN     row_i(GEN A, long x0, long x1, long x2);
GEN     rowcopy(GEN A, long x0);
GEN     rowslice(GEN A, long x1, long x2);
GEN     rowslicepermute(GEN A, GEN p, long x1, long x2);
GEN     rowpermute(GEN A, GEN p);
GEN     sindexrank(GEN x);
GEN     sum(GEN v, long a, long b);
GEN     suppl(GEN x);
GEN     vconcat(GEN A, GEN B);
GEN     vecslice(GEN A, long y1, long y2);
GEN     vecslicepermute(GEN A, GEN p, long y1, long y2);
GEN     vecpermute(GEN A, GEN p);

/* alglin2.c */

GEN     QuickNormL1(GEN x,long prec);
GEN     QuickNormL2(GEN x,long prec);
int     RgM_ishnf(GEN x);
GEN     RgXQ_norm(GEN x, GEN T);
GEN     ZM_to_zm(GEN z);
int     ZM_ishnf(GEN x);
GEN     ZV_add(GEN x, GEN y);
GEN     ZV_sub(GEN x, GEN y);
GEN     ZV_to_nv(GEN z);
GEN     adj(GEN x);
GEN     assmat(GEN x);
GEN     caract(GEN x, long v);
GEN     caract2(GEN p, GEN x, long v);
GEN     caradj(GEN x, long v, GEN *py);
GEN     caradj0(GEN x, long v);
GEN     carhess(GEN x, long v);
GEN     charpoly0(GEN x, long v,long flag);
GEN     conjvec(GEN x,long prec);
GEN     gconj(GEN x);
GEN     gnorm(GEN x);
GEN     gnorml1(GEN x,long prec);
GEN     gnorml2(GEN x);
GEN     gsmith(GEN x);
GEN     gsmith2(GEN x);
GEN     gtrace(GEN x);
GEN     hess(GEN x);
GEN     hnf(GEN x);
GEN     hnfall(GEN x);
GEN     hnfall_i(GEN A, GEN *ptB, long remove);
GEN     hnflll(GEN x);
GEN     hnflll_i(GEN A, GEN *ptB, int remove);
GEN     hnfmod(GEN x, GEN detmat);
GEN     hnfmodid(GEN x,GEN p);
GEN     hnfmodidpart(GEN x, GEN p);
GEN     hnfperm(GEN x);
GEN     intersect(GEN x, GEN y);
GEN     jacobi(GEN a, long prec);
GEN     matfrobenius(GEN M, long flag, long v);
GEN     mathnf0(GEN x, long flag);
GEN     matrixqz(GEN x, GEN pp);
GEN     matrixqz0(GEN x, GEN pp);
GEN     matrixqz2(GEN x);
GEN     matrixqz3(GEN x);
GEN     matsnf0(GEN x, long flag);
GEN     minpoly(GEN x, long v);
GEN     signat(GEN a);
GEN     smith(GEN x);
GEN     smith2(GEN x);
GEN     smithall(GEN x, GEN *ptU, GEN *ptV);
GEN     smithclean(GEN z);
GEN     smithrel(GEN H, GEN *newU, GEN *newUi);
GEN     sqred(GEN a);
GEN     sqred1(GEN a);
GEN     sqred3(GEN a);
GEN     zm_to_ZM(GEN z);
GEN     zx_to_ZX(GEN z);

/* anal.c */

void    addhelp(entree *ep, char *s);
void    delete_named_var(entree *ep);
long    delete_var(void);
entree* fetch_named_var(char *s);
long    fetch_user_var(char *s);
long    fetch_var(void);
void    freeep(entree *ep);
GEN     gp_read_str(char *t);
entree* gp_variable(char *s);
long    hashvalue(char **s);
entree* install(void *f, char *name, char *code);
entree* is_entry(char *s);
void    kill0(entree *ep);
GEN     readseq(char *t);
long    manage_var(long n, entree *ep);
void    name_var(long n, char *s);
GEN     strtoGENstr(const char *s);
GEN     strtoi(char *s);
GEN     strtor(char *s, long prec);
GEN     type0(GEN x);

/* aprcl.c */

long    isprimeAPRCL(GEN N);

/* Qfb.c */

void    check_quaddisc(GEN x, long *s, long *r, char *f);
void    check_quaddisc_real(GEN x, long *r, char *f);
void    check_quaddisc_imag(GEN x, long *r, char *f);
GEN     compimag(GEN x, GEN y);
GEN     compimagraw(GEN x, GEN y);
GEN     compraw(GEN x, GEN y);
GEN     compreal(GEN x, GEN y);
GEN     comprealraw(GEN x, GEN y);
GEN     nucomp(GEN x, GEN y, GEN l);
GEN     nudupl(GEN x, GEN l);
GEN     nupow(GEN x, GEN n);
GEN     powraw(GEN x, long n);
GEN     powrealraw(GEN x, long n);
GEN     primeform(GEN x, GEN p, long prec);
GEN     Qfb0(GEN x, GEN y, GEN z, GEN d, long prec);
GEN     qfbimagsolvep(GEN Q, GEN p);
GEN     qfbrealsolvep(GEN Q, GEN p);
GEN     qfbred0(GEN x, long flag, GEN D, GEN isqrtD, GEN sqrtD);
GEN     qfbsolve(GEN Q, GEN n);
GEN     qfi(GEN x, GEN y, GEN z);
GEN     qfr(GEN x, GEN y, GEN z, GEN d);
GEN     quadgen(GEN x);
GEN     quadpoly(GEN x);
GEN     quadpoly0(GEN x, long v);
GEN     redimag(GEN x);
GEN     redreal(GEN x);
GEN     redrealnod(GEN x, GEN isqrtD);
GEN     rhoreal(GEN x);
GEN     rhorealnod(GEN x, GEN isqrtD);
GEN     sqcompimag(GEN x);
GEN     sqcompreal(GEN x);

/* arith1.c */

ulong   Fl_pow(ulong x, ulong n, ulong p);
ulong   Fl_sqrt(ulong a, ulong p);
GEN     Fp_inv(GEN a, GEN m);
GEN     Fp_invsafe(GEN a, GEN m);
GEN     Fp_pow(GEN a, GEN n, GEN m);
GEN     Fp_pows(GEN A, long k, GEN N);
GEN     Fp_powu(GEN x, ulong k, GEN p);
GEN     Fp_sqrt(GEN a, GEN p);
GEN     Fp_sqrtn(GEN a, GEN n, GEN p, GEN *zetan);
long    Z_issquarerem(GEN x, GEN *pt);
GEN     bestappr0(GEN x, GEN a, GEN b);
GEN     bestappr(GEN x, GEN k);
long    cgcd(long a,long b);
GEN     chinese1(GEN x);
GEN     chinese(GEN x, GEN y);
GEN     classno2(GEN x);
GEN     classno(GEN x);
long    clcm(long a,long b);
GEN     contfrac0(GEN x, GEN b, long flag);
GEN     fibo(long n);
GEN     fundunit(GEN x);
GEN     gboundcf(GEN x, long k);
GEN     gcf2(GEN b, GEN x);
GEN     gcf(GEN x);
GEN     gener(GEN m);
ulong   gener_Fl_local(ulong p, GEN L);
ulong   gener_Fl(ulong p);
GEN     gener_Fp_local(GEN p, GEN L);
GEN     gener_Fp(GEN p);
GEN     gfundunit(GEN x);
GEN     ggener(GEN m);
long    gisanypower(GEN x, GEN *pty);
GEN     gisfundamental(GEN x);
GEN     gisprime(GEN x, long flag);
GEN     gispseudoprime(GEN x, long flag);
GEN     gispsp(GEN x);
GEN     gissquarerem(GEN x, GEN *pt);
GEN     gissquare(GEN x);
GEN     gkrogs(GEN x, long y);
GEN     gkronecker(GEN x, GEN y);
GEN     gmillerrabin(GEN n, long k);
GEN     gnextprime(GEN n);
GEN     gprecprime(GEN n);
GEN     gracine(GEN a);
GEN     gregula(GEN x, long prec);
GEN     hclassno(GEN x);
long    hil0(GEN x, GEN y, GEN p);
long    hil(GEN x, GEN y, GEN p);
long    isanypower(GEN x, GEN *y);
long    isfundamental(GEN x);
long    ispower(GEN x, GEN k, GEN *pty);
long    isprime(GEN x);
long    isprimeSelfridge(GEN x);
long    ispseudoprime(GEN x, long flag);
long    ispsp(GEN x);
long    krois(GEN x, long y);
long    kronecker(GEN x, GEN y);
long    krosi(long s, GEN x);
long    kross(long x, long y);
long    krouu(ulong x, ulong y);
GEN     lcmii(GEN a, GEN b);
GEN     mpfact(long n);
GEN     order(GEN x);
GEN     pnqn(GEN x);
GEN     qfbclassno0(GEN x,long flag);
GEN     quaddisc(GEN x);
GEN     racine(GEN a);
GEN     regula(GEN x, long prec);
GEN     seq_umul(ulong a, ulong b);
long    uissquarerem(ulong A, ulong *sqrtA);
GEN     znorder(GEN x, GEN o);
GEN     znstar(GEN x);

/* arith2.c */

long    Z_issquarefree(GEN x);
GEN     addprimes(GEN primes);
GEN     auxdecomp(GEN n, long all);
long    bigomega(GEN n);
GEN     binaire(GEN x);
long    bittest(GEN x, long n);
GEN     boundfact(GEN n, long lim);
GEN     core(GEN n);
GEN     corepartial(GEN n, long l);
GEN     core0(GEN n,long flag);
GEN     core2(GEN n);
GEN     core2partial(GEN n, long l);
GEN     coredisc(GEN n);
GEN     coredisc0(GEN n,long flag);
GEN     coredisc2(GEN n);
GEN     divisors(GEN n);
GEN     factorint(GEN n, long flag);
GEN     factoru(ulong n);
GEN     factoru_pow(ulong n);
GEN     gbigomega(GEN n);
GEN     gbitand(GEN x, GEN y);
GEN     gbitneg(GEN x, long n);
GEN     gbitnegimply(GEN x, GEN y);
GEN     gbitor(GEN x, GEN y);
GEN     gbittest(GEN x, GEN n);
GEN     gbitxor(GEN x, GEN y);
GEN     gboundfact(GEN n, long lim);
GEN     gissquarefree(GEN x);
GEN     gmu(GEN n);
GEN     gnumbdiv(GEN n);
GEN     gomega(GEN n);
GEN     gphi(GEN n);
GEN     gsumdiv(GEN n);
GEN     gsumdivk(GEN n,long k);
byteptr initprimes(ulong maxnum);
long    issquarefree(GEN x);
ulong   maxprime(void);
void    maxprime_check(ulong c);
long    mu(GEN n);
GEN     numbdiv(GEN n);
long    omega(GEN n);
GEN     phi(GEN n);
GEN     prime(long n);
GEN     primepi(GEN x);
GEN     primes(long n);
GEN     removeprimes(GEN primes);
GEN     smallfact(GEN n);
GEN     sumdiv(GEN n);
GEN     sumdivk(GEN n,long k);
GEN     Z_factor(GEN n);

/* base1.c */

GEN     T2_from_embed(GEN x, long r1);
void    check_ZX(GEN x, char *s);
void    check_ZXY(GEN x, char *s);
GEN     check_units(GEN x, char *f);
void    checkbid(GEN bid);
GEN     checkbnf(GEN bnf);
void    checkbnr(GEN bnr);
void    checkbnrgen(GEN bnr);
void    checkid(GEN x, long N);
GEN     checknf(GEN nf);
GEN     checknfelt_mod(GEN nf, GEN x, char *s);
void    checkprimeid(GEN bid);
void    checkrnf(GEN rnf);
GEN     dirzetak(GEN nf, GEN b);
GEN     factoredpolred(GEN x, GEN fa);
GEN     factoredpolred2(GEN x, GEN fa);
GEN     galois(GEN x, long prec);
GEN     galoisapply(GEN nf, GEN aut, GEN x);
GEN     get_bnf(GEN x, long *t);
GEN     get_bnfpol(GEN x, GEN *bnf, GEN *nf);
GEN     get_nf(GEN x, long *t);
GEN     get_nfpol(GEN x, GEN *nf);
GEN     get_primeid(GEN x);
GEN     glambdak(GEN nfz, GEN s, long prec);
int     gpolcomp(GEN p1, GEN p2);
GEN     gzetak(GEN nfz, GEN s, long prec);
GEN     gzetakall(GEN nfz, GEN s, long flag, long prec);
GEN     initalg(GEN x, long prec);
GEN     initalgred(GEN x, long prec);
GEN     initalgred2(GEN x, long prec);
GEN     initzeta(GEN pol, long prec);
long    nf_get_r1(GEN nf);
long    nf_get_r2(GEN nf);
void    nf_get_sign(GEN nf, long *r1, long *r2);
long    nfgetprec(GEN x);
GEN     nfinit0(GEN x, long flag, long prec);
GEN     nfisincl(GEN a, GEN b);
GEN     nfisisom(GEN a, GEN b);
GEN     nfnewprec(GEN nf, long prec);
GEN     nfnewprec_i(GEN nf, long prec);
GEN     ordred(GEN x);
GEN     polgalois(GEN x, long prec);
GEN     polred(GEN x);
GEN     polred0(GEN x, long flag, GEN p);
GEN     polred2(GEN x);
GEN     polredabs(GEN x);
GEN     polredabs0(GEN x, long flag);
GEN     polredabs2(GEN x);
GEN     polredabsall(GEN x, long flun);
GEN     rootsof1(GEN x);
GEN     smallpolred(GEN x);
GEN     smallpolred2(GEN x);
GEN     tschirnhaus(GEN x);

/* base2.c */

GEN     allbase(GEN f, long flag, GEN *dx, GEN *dK, GEN *index, GEN *ptw);
GEN     base(GEN x, GEN *y);
GEN     base2(GEN x, GEN *y);
void    checkmodpr(GEN modpr);
GEN     compositum(GEN pol1, GEN pol2);
GEN     compositum2(GEN pol1, GEN pol2);
GEN     discf(GEN x);
GEN     discf2(GEN x);
GEN     factoredbase(GEN x, GEN p, GEN *y);
GEN     factoreddiscf(GEN x, GEN p);
GEN     ff_to_nf(GEN x, GEN modpr);
GEN     fix_relative_pol(GEN nf, GEN x, int chk_lead);
GEN     gcdpm(GEN f1,GEN f2,GEN pm);
GEN     indexpartial(GEN P, GEN DP);
GEN     modprX(GEN x, GEN nf,GEN modpr);
GEN     modprX_lift(GEN x, GEN modpr);
GEN     modprM(GEN z, GEN nf,GEN modpr);
GEN     modprM_lift(GEN z, GEN modpr);
GEN     nf_to_ff_init(GEN nf, GEN *pr, GEN *T, GEN *p);
GEN     nf_to_ff(GEN nf, GEN x, GEN modpr);
GEN     nfbasis(GEN x, GEN *y,long flag,GEN p);
GEN     nfbasis0(GEN x,long flag,GEN p);
GEN     nfdiscf0(GEN x,long flag, GEN p);
GEN     nfmodprinit(GEN nf, GEN pr);
GEN     nfreducemodpr(GEN nf, GEN x, GEN modpr);
GEN     polcompositum0(GEN pol1, GEN pol2,long flag);
GEN     primedec(GEN nf,GEN p);
GEN     rnfbasis(GEN bnf, GEN order);
GEN     rnfdedekind(GEN nf, GEN T, GEN pr);
GEN     rnfdet(GEN nf, GEN order);
GEN     rnfdet2(GEN nf, GEN A, GEN I);
GEN     rnfdiscf(GEN nf, GEN pol);
GEN     rnfequation(GEN nf, GEN pol2);
GEN     rnfequation0(GEN nf, GEN pol2, long flall);
GEN     rnfequation2(GEN nf, GEN pol);
GEN     rnfhnfbasis(GEN bnf, GEN order);
long    rnfisfree(GEN bnf, GEN order);
GEN     rnflllgram(GEN nf, GEN pol, GEN order,long prec);
GEN     rnfpolred(GEN nf, GEN pol, long prec);
GEN     rnfpolredabs(GEN nf, GEN pol, long flag);
GEN     rnfpseudobasis(GEN nf, GEN pol);
GEN     rnfsimplifybasis(GEN bnf, GEN order);
GEN     rnfsteinitz(GEN nf, GEN order);
GEN     smallbase(GEN x, GEN *y);
GEN     smalldiscf(GEN x);
long    val_fact(ulong n, ulong p);
GEN     zk_to_ff_init(GEN nf, GEN *pr, GEN *T, GEN *p);
GEN     zk_to_ff(GEN x, GEN modpr);
GEN     zkmodprinit(GEN nf, GEN pr);

/* base3.c */

int     RgV_isscalar(GEN x);
GEN     algtobasis(GEN nf, GEN x);
GEN     arch_to_perm(GEN arch);
GEN     basistoalg(GEN nf, GEN x);
GEN     dethnf(GEN x);
GEN     dethnf_i(GEN mat);
GEN     element_div(GEN nf, GEN x, GEN y);
GEN     element_inv(GEN nf, GEN x);
GEN     element_invmodideal(GEN nf, GEN x, GEN ideal);
GEN     element_mul(GEN nf,GEN x,GEN y);
GEN     element_muli(GEN nf,GEN x,GEN y);
GEN     element_mulid(GEN nf, GEN x, long i);
GEN     element_pow(GEN nf,GEN x,GEN k);
GEN     element_powmodideal(GEN nf,GEN x,GEN k,GEN ideal);
GEN     element_powmodidele(GEN nf,GEN x,GEN k,GEN idele,GEN structarch);
GEN     element_sqr(GEN nf,GEN x);
GEN     element_sqri(GEN nf, GEN x);
long    element_val(GEN nf, GEN x, GEN vp);
GEN     eltmul_get_table(GEN nf, GEN x);
GEN     ideallist(GEN nf,long bound);
GEN     ideallist0(GEN nf,long bound, long flag);
GEN     ideallistarch(GEN nf, GEN list, GEN arch);
GEN     ideallistunit(GEN nf,long bound);
GEN     ideallistunitgen(GEN nf,long bound);
GEN     ideallistzstar(GEN nf,long bound);
GEN     ideallistzstargen(GEN nf,long bound);
GEN     idealstar0(GEN nf, GEN x,long flag);
int     isnfscalar(GEN x);
GEN     lift_to_pol(GEN x);
GEN     lllreducemodmatrix(GEN x,GEN y);
GEN     matalgtobasis(GEN nf, GEN x);
GEN     matbasistoalg(GEN nf, GEN x);
GEN     nfdiveuc(GEN nf, GEN a, GEN b);
GEN     nfdivrem(GEN nf, GEN a, GEN b);
GEN     nfmod(GEN nf, GEN a, GEN b);
GEN     nfreducemodideal(GEN nf,GEN x,GEN ideal);
GEN     nfreducemodidele(GEN nf,GEN g,GEN idele,GEN structarch);
GEN     reducemodinvertible(GEN x, GEN y);
GEN     reducemodmatrix(GEN x, GEN y);
GEN     reducemodHNF(GEN x, GEN y, GEN *Q);
GEN     rnfalgtobasis(GEN rnf, GEN x);
GEN     rnfbasistoalg(GEN rnf, GEN x);
GEN     set_sign_mod_idele(GEN nf, GEN x, GEN y, GEN idele, GEN sarch);
GEN     vecmodii(GEN a, GEN b);
GEN     zarchstar(GEN nf,GEN x,GEN arch);
GEN     zideallog(GEN nf,GEN x,GEN bigideal);
GEN     zidealstar(GEN nf, GEN x);
GEN     zidealstarinit(GEN nf, GEN x);
GEN     Idealstar(GEN nf, GEN x,long flun);
GEN     zidealstarinitgen(GEN nf, GEN x);
GEN     znlog(GEN x, GEN g);
GEN     zsigne(GEN nf,GEN alpha,GEN arch);
GEN     zsigns(GEN nf,GEN alpha);

/* base4.c */

GEN     element_divmodpr(GEN nf, GEN x, GEN y, GEN modpr);
GEN     element_invmodpr(GEN nf, GEN y, GEN modpr);
GEN     element_mulmodpr(GEN nf, GEN x, GEN y, GEN modpr);
GEN     element_mulvec(GEN nf, GEN x, GEN v);
GEN     element_powmodpr(GEN nf, GEN x, GEN k, GEN modpr);
GEN     element_reduce(GEN nf, GEN x, GEN ideal);
GEN     ideal_two_elt(GEN nf, GEN ix);
GEN     ideal_two_elt0(GEN nf, GEN ix, GEN a);
GEN     ideal_two_elt2(GEN nf, GEN x, GEN a);
GEN     idealadd(GEN nf, GEN x, GEN y);
GEN     idealaddmultoone(GEN nf, GEN list);
GEN     idealaddtoone(GEN nf, GEN x, GEN y);
GEN     idealaddtoone0(GEN nf, GEN x, GEN y);
GEN     idealappr(GEN nf, GEN x);
GEN     idealappr0(GEN nf, GEN x, long fl);
GEN     idealapprfact(GEN nf, GEN x);
GEN     idealchinese(GEN nf, GEN x, GEN y);
GEN     idealcoprime(GEN nf, GEN x, GEN y);
GEN     idealdiv(GEN nf, GEN x, GEN y);
GEN     idealdiv0(GEN nf, GEN x, GEN y,long flag);
GEN     idealdivexact(GEN nf, GEN x, GEN y);
GEN     idealdivpowprime(GEN nf, GEN x, GEN vp, GEN n);
GEN     idealmulpowprime(GEN nf, GEN x, GEN vp, GEN n);
GEN     idealfactor(GEN nf, GEN x);
GEN     idealhermite(GEN nf, GEN x);
GEN     idealhnf0(GEN nf, GEN a, GEN b);
GEN     idealintersect(GEN nf, GEN x, GEN y);
GEN     idealinv(GEN nf, GEN ix);
GEN     ideallllred(GEN nf,GEN ix,GEN vdir,long prec);
GEN     ideallllred_elt(GEN nf, GEN I, GEN vdir);
GEN     idealmul(GEN nf, GEN ix, GEN iy);
GEN     idealmul0(GEN nf, GEN ix, GEN iy, long flag, long prec);
GEN     idealmulh(GEN nf, GEN ix, GEN iy);
GEN     idealmulprime(GEN nf,GEN ix,GEN vp);
GEN     idealmulred(GEN nf, GEN ix, GEN iy, long prec);
GEN     idealnorm(GEN nf, GEN x);
GEN     idealpow(GEN nf, GEN ix, GEN n);
GEN     idealpow0(GEN nf, GEN ix, GEN n, long flag, long prec);
GEN     idealpowred(GEN nf, GEN ix, GEN n,long prec);
GEN     idealpows(GEN nf, GEN ideal, long iexp);
GEN     idealprodprime(GEN nf, GEN L);
GEN     idealred_elt(GEN nf, GEN I);
long    idealtyp(GEN *ideal, GEN *arch);
long    idealval(GEN nf,GEN ix,GEN vp);
GEN     ideleaddone(GEN nf, GEN x, GEN idele);
int     isidentity(GEN x);
long    isideal(GEN nf,GEN x);
GEN     minideal(GEN nf,GEN ix,GEN vdir,long prec);
GEN     mul_content(GEN cx, GEN cy);
GEN     nfdetint(GEN nf,GEN pseudo);
GEN     nfhermite(GEN nf, GEN x);
GEN     nfhermitemod(GEN nf, GEN x, GEN detmat);
GEN     nfkermodpr(GEN nf, GEN x, GEN modpr);
GEN     nfsmith(GEN nf, GEN x);
GEN     nfsolvemodpr(GEN nf, GEN a, GEN b, GEN modpr);
GEN     prime_to_ideal(GEN nf, GEN vp);
GEN     principalideal(GEN nf, GEN a);
GEN     principalidele(GEN nf, GEN a, long prec);
GEN     vecdiv(GEN x, GEN y);
GEN     vecinv(GEN x);
GEN     vecmul(GEN x, GEN y);
GEN     vecpow(GEN x, GEN n);

/* base5.c */

GEN     rnfelementabstorel(GEN rnf, GEN x);
GEN     rnfelementdown(GEN rnf, GEN x);
GEN     rnfelementreltoabs(GEN rnf, GEN x);
GEN     rnfelementup(GEN rnf, GEN x);
GEN     rnfidealabstorel(GEN rnf, GEN x);
GEN     rnfidealdown(GEN rnf, GEN x);
GEN     rnfidealhermite(GEN rnf, GEN x);
GEN     rnfidealmul(GEN rnf,GEN x,GEN y);
GEN     rnfidealnormabs(GEN rnf, GEN x);
GEN     rnfidealnormrel(GEN rnf, GEN x);
GEN     rnfidealreltoabs(GEN rnf, GEN x);
GEN     rnfidealtwoelement(GEN rnf,GEN x);
GEN     rnfidealup(GEN rnf, GEN x);
GEN     rnfinitalg(GEN nf,GEN pol,long prec);

/* bibli1.c */

GEN     ZM_zc_mul(GEN x, GEN y);
GEN     ZM_zm_mul(GEN x, GEN y);
GEN     algdep(GEN x, long n, long prec);
GEN     algdep0(GEN x, long n, long bit,long prec);
GEN     algdep2(GEN x, long n, long bit);
GEN     gram_matrix(GEN M);
GEN     kerint(GEN x);
GEN     kerint1(GEN x);
GEN     lindep(GEN x, long prec);
GEN     lindep0(GEN x, long flag,long prec);
GEN     lindep2(GEN x, long bit);
GEN     lll(GEN x, long prec);
GEN     lllgen(GEN x);
GEN     lllgram(GEN x, long prec);
GEN     lllgramgen(GEN x);
GEN     lllgramint(GEN x);
GEN     lllgramkerim(GEN x);
GEN     lllgramkerimgen(GEN x);
GEN     lllint(GEN x);
GEN     lllint_i(GEN x, long alpha, int gram, GEN *h, GEN *ptfl, GEN *ptB);
GEN     lllint_ip(GEN x, long alpha);
GEN     lllintpartial(GEN mat);
GEN     lllintpartial_ip(GEN mat);
GEN     lllkerim(GEN x);
GEN     lllkerimgen(GEN x);
GEN     matkerint0(GEN x,long flag);
GEN     minim(GEN a, GEN borne, GEN stockmax);
GEN     qfrep0(GEN a, GEN borne, long flag);
GEN     qfminim0(GEN a, GEN borne, GEN stockmax,long flag, long prec);
GEN     minim2(GEN a, GEN borne, GEN stockmax);
GEN     perf(GEN a);
GEN     qflll0(GEN x, long flag, long prec);
GEN     qflllgram0(GEN x, long flag, long prec);
char*   stackmalloc(size_t N);
GEN     zncoppersmith(GEN P0, GEN N, GEN X, GEN B) ;

/* bibli2.c */

GEN     binomial(GEN x, long k);
int     cmp_prime_ideal(GEN x, GEN y);
int     cmp_prime_over_p(GEN x, GEN y);
int     cmp_vecint(GEN x, GEN y);
GEN     convol(GEN x, GEN y);
GEN     cyclo(long n, long v);
GEN     dirdiv(GEN x, GEN y);
GEN     dirmul(GEN x, GEN y);
long    gen_search(GEN x, GEN y, long flag, int (*cmp)(GEN,GEN));
long    gen_search_aux(GEN x, GEN y, long flag, void *data, int (*cmp)(void*,GEN,GEN));
GEN     gen_setminus(GEN set1, GEN set2, int (*cmp)(GEN,GEN));
GEN     gen_sort(GEN x, long flag, int (*cmp)(GEN,GEN));
GEN     gen_sort_aux(GEN x, long flag, void *data, int (*cmp)(void *,GEN,GEN));
GEN     genrand(GEN N);
long    getrand(void);
long    getstack(void);
long    gettime(void);
GEN     gprec(GEN x, long l);
GEN     gprec_wtrunc(GEN x, long pr);
GEN     gprec_w(GEN x, long pr);
GEN     gtoset(GEN x);
GEN     indexlexsort(GEN x);
GEN     indexsort(GEN x);
GEN     laplace(GEN x);
GEN     legendre(long n, long v);
GEN     lexsort(GEN x);
GEN     mathilbert(long n);
GEN     matqpascal(long n, GEN q);
GEN     modreverse_i(GEN a, GEN T);
GEN     numtoperm(long n, GEN x);
int     pari_compare_lg(GEN a,GEN b);
int     pari_compare_long(long *a,long *b);
GEN     permtonum(GEN x);
GEN     polint(GEN xa, GEN ya, GEN x, GEN *dy);
GEN     polrecip(GEN x);
GEN     polymodrecip(GEN x);
GEN     roots_to_pol(GEN a, long v);
GEN     setintersect(GEN x, GEN y);
long    setisset(GEN x);
GEN     setminus(GEN x, GEN y);
long    setrand(long seed);
long    setsearch(GEN x, GEN y, long flag);
GEN     setunion(GEN x, GEN y);
GEN     sindexlexsort(GEN x);
GEN     sindexsort(GEN x);
GEN     sort(GEN x);
long    tablesearch(GEN T, GEN x, int (*cmp)(GEN,GEN));
GEN     tchebi(long n, long v);
GEN     vecbinome(long n);
GEN     vecsort(GEN x, GEN k);
GEN     vecsort0(GEN x, GEN k, long flag);

/* buch1.c */

GEN     buchimag(GEN D, GEN gcbach, GEN gcbach2, GEN gCO);
GEN     buchreal(GEN D, GEN gsens, GEN gcbach, GEN gcbach2, GEN gRELSUP, long prec);
GEN     quadclassunit0(GEN x, long flag,GEN data, long prec);
GEN     quadhilbert(GEN D, GEN flag, long prec);
GEN     quadray(GEN bnf, GEN f, GEN flag, long prec);


/* buch2.c */

GEN     bnfclassunit0(GEN P,long flag,GEN data,long prec);
GEN     bnfinit0(GEN P,long flag,GEN data,long prec);
GEN     bnfmake(GEN sbnf,long prec);
GEN     bnfnewprec(GEN nf, long prec);
GEN     bnrnewprec(GEN bnr, long prec);
GEN     buchall(GEN P, double bach, double bach2, long nbrelpid, long flun, long prec);
GEN     buchfu(GEN bignf);
GEN     check_and_build_obj(GEN S, long tag, GEN (*build)(GEN));
GEN     classgrouponly(GEN P,GEN data,long prec);
GEN     isprincipal(GEN bignf, GEN x);
GEN     isprincipalall(GEN bignf, GEN x,long flall);
GEN     isprincipalfact(GEN bnf,GEN P, GEN e, GEN C, long flag);
GEN     isprincipalforce(GEN bignf,GEN x);
GEN     isprincipalgen(GEN bignf, GEN x);
GEN     isprincipalgenforce(GEN bignf,GEN x);
GEN     isunit(GEN bignf, GEN x);
GEN     regulator(GEN P,GEN data,long prec);
GEN     signunits(GEN bignf);
GEN     smallbuchinit(GEN pol,double bach,double bach2,long nbrelpid,long prec);
GEN     zsignunits(GEN bnf, GEN archp, int add_zu);

/* buch3.c */

GEN     bnrclass0(GEN bignf, GEN ideal, long flag);
GEN     bnrclassno(GEN bignf,GEN ideal);
GEN     bnrclassnolist(GEN bnf,GEN listes);
GEN     bnrconductor(GEN arg0,GEN arg1,GEN arg2,GEN flag);
GEN     bnrconductorofchar(GEN bnr,GEN chi);
GEN     bnrdisc0(GEN arg0, GEN arg1, GEN arg2, long flag);
GEN     bnrdisclist0(GEN bnf,GEN borne, GEN arch);
GEN     bnrinit0(GEN bignf,GEN ideal,long flag);
long    bnrisconductor(GEN arg0,GEN arg1,GEN arg2);
GEN     bnrisprincipal(GEN bnf, GEN x,long flag);
GEN     buchnarrow(GEN bignf);
GEN     buchray(GEN bignf,GEN ideal);
GEN     buchrayinit(GEN bignf,GEN ideal);
GEN     buchrayinitgen(GEN bignf,GEN ideal);
long    certifybuchall(GEN bnf);
GEN     conductor(GEN bnr,GEN subgroup,long all);
GEN     decodemodule(GEN nf, GEN fa);
GEN     discrayabs(GEN bnr,GEN subgroup);
GEN     discrayabscond(GEN bnr,GEN subgroup);
GEN     discrayabslist(GEN bnf,GEN listes);
GEN     discrayabslistarch(GEN bnf, GEN arch, long bound);
GEN     discrayabslistlong(GEN bnf, long bound);
GEN     discrayrel(GEN bnr,GEN subgroup);
GEN     discrayrelcond(GEN bnr,GEN subgroup);
GEN     idealmodidele(GEN bnr, GEN x);
long    isinvector(GEN v, GEN x);
GEN     isprincipalray(GEN bnf, GEN x);
GEN     isprincipalraygen(GEN bnf, GEN x);
GEN     quick_isprincipalgen(GEN bnf, GEN x);
GEN     rnfconductor(GEN bnf, GEN polrel, long flag);
GEN     rnfnormgroup(GEN bnr, GEN polrel);
GEN     subgrouplist0(GEN bnr, GEN indexbound, long all);

/* buch4.c */

GEN     bnfisnorm(GEN bnf,GEN x,long flag,long PREC);
GEN     rnfisnorm(GEN S, GEN x, long flag);
GEN     rnfisnorminit(GEN bnf, GEN relpol, int galois);
GEN     bnfissunit(GEN bnf,GEN suni,GEN x);
GEN     bnfsunit(GEN bnf,GEN s,long PREC);
long    nfhilbert(GEN bnf,GEN a,GEN b);
long    nfhilbert0(GEN bnf,GEN a,GEN b,GEN p);
long    nfhilbertp(GEN bnf,GEN a,GEN b,GEN p);
long    qpsoluble(GEN pol,GEN p);
long    qpsolublenf(GEN bnf,GEN pol,GEN p);
long    zpsoluble(GEN pol,GEN p);
long    zpsolublenf(GEN bnf,GEN pol,GEN p);

/* default.c */

GEN default0(char *a, char *b, long flag);
GEN gp_default(char *a, char *b);
long setseriesprecision(long n);
long getrealprecision(void);
long setrealprecision(long n, long *prec);

/* elldata.c */

GEN     ellcondfile(long f);
GEN     ellcondlist(long f);
GEN     ellconvertname(GEN s);
GEN     ellgenerators(GEN E);
GEN     ellidentify(GEN E);
GEN     ellsearch(GEN A);
GEN     ellsearchcurve(GEN name);
void    forell(entree *ep, long a, long b, char *ch);

/* elliptic.c */

GEN     addell(GEN e, GEN z1, GEN z2);
GEN     akell(GEN e, GEN n);
GEN     anell(GEN e, long n);
GEN     apell(GEN e, GEN p);
GEN     apell2(GEN e, GEN p);
GEN     bilhell(GEN e, GEN z1, GEN z2, long prec);
void    checkbell(GEN e);
void    checkell(GEN e);
void    checksell(GEN e);
GEN     coordch(GEN e, GEN ch);
GEN     ellap0(GEN e, GEN p, long flag);
GEN     elleisnum(GEN om, long k, long flag, long prec);
GEN     elleta(GEN om, long prec);
GEN     ellglobalred(GEN e1);
GEN     ellheight0(GEN e, GEN a, long flag,long prec);
GEN     ellinit0(GEN x,long flag,long prec);
GEN     ellisoncurve(GEN e, GEN z);
GEN     elllseries(GEN e, GEN s, GEN A, long prec);
GEN     elllocalred(GEN e, GEN p1);
GEN     ellminimalmodel(GEN E, GEN *ptv);
long    ellrootno(GEN e, GEN p);
GEN     ellsigma(GEN om, GEN z, long flag, long prec);
GEN     elltaniyama(GEN e, long prec);
GEN     elltors0(GEN e, long flag);
GEN     ellwp0(GEN e, GEN z, long flag, long prec, long PREC);
GEN     ellzeta(GEN om, GEN z, long prec);
GEN     ghell(GEN e, GEN a, long prec);
GEN     ghell2(GEN e, GEN a, long prec);
GEN     initell(GEN x, long prec);
GEN     mathell(GEN e, GEN x, long prec);
int     oncurve(GEN e, GEN z);
GEN     ordell(GEN e, GEN x, long prec);
GEN     orderell(GEN e, GEN p);
GEN     pointch(GEN x, GEN ch);
GEN     pointchinv(GEN x, GEN ch);
GEN     pointell(GEN e, GEN z, long prec);
GEN     powell(GEN e, GEN z, GEN n);
GEN     smallinitell(GEN x);
GEN     subell(GEN e, GEN z1, GEN z2);
GEN     torsell(GEN e);
GEN     weipell(GEN e, long precdl);
GEN     zell(GEN e, GEN z, long prec);

/* es.c */

GEN     GENtocanonicalstr(GEN x);
GEN     GENtoGENstr(GEN x);
char*   GENtoTeXstr(GEN x);
char*   GENtostr(GEN x);
GEN     Str(GEN g);
GEN     Strchr(GEN g);
GEN     Strexpand(GEN g);
GEN     Strtex(GEN g);
void    brute(GEN g, char format, long dec);
void    bruteall(GEN g, char f, long d, long sp);
void    bruterr(GEN x,char format,long dec);
void    error0(GEN g);
void    etatpile(void);
char*   expand_tilde(const char *s);
int     file_is_binary(FILE *f);
void    flusherr(void);
void    fprintferr(const char* pat, ...);
GEN     gp_read_file(char *s);
GEN     gp_read_stream(FILE *f);
GEN     gp_readvec_file(char *s);
GEN     gp_readvec_stream(FILE *f);
void    killallfiles(int check);
int     killfile(pariFILE *f);
void    matbrute(GEN g, char format, long dec);
pariFILE* newfile(FILE *f, char *name, int type);
void    os_close(long fd);
char*   os_getenv(char *s);
long    os_open(char *s, int mode);
void    os_read(long fd, char ch[], long s);
void    (*os_signal(int sig, void (*f)(int)))(int);
void    outbeaut(GEN x);
void    outbeauterr(GEN x);
void    outbrute(GEN x);
void    outerr(GEN x);
void    outmat(GEN x);
void    output(GEN x);
void    outsor(GEN x);
void    outtex(GEN x);
char*   pGENtostr(GEN g, long flag);
void    pari_fclose(pariFILE *f);
pariFILE*   pari_fopen(char *s, char *mode);
pariFILE*   pari_safefopen(char *s, char *mode);
char*   pari_strdup(const char *s);
char*   pari_strndup(const char *s, long n);
char*   pari_unique_dir(char *s);
char*   pari_unique_filename(char *s);
void    pari_unlink(char *s);
void    pariflush(void);
void    pariputc(char c);
void    pariputs(const char *s);
void    pariprintf(const char *format, ...);
int     popinfile(void);
void    print(GEN g); 
void    print1(GEN g);
void    printp(GEN g);
void    printp1(GEN g);
void    printtex(GEN g);
GEN     readbin(const char *name, FILE *f);
void    sor(GEN g, char fo, long dd, long chmp);
void    switchin(const char *name);
void    switchout(char *name);
void    texe(GEN g, char format, long dec);
pariFILE* try_pipe(char *cmd, int flag);
const char* type_name(long t);
void    voir(GEN x, long nb);
void    vpariputs(const char* format, va_list args);
void    write0(const char *s, GEN g);
void    write1(const char *s, GEN g);
void    writebin(char *name, GEN x);
void    writetex(const char *s, GEN g);

/* galconj.c */

GEN     checkgal(GEN gal);
GEN     checkgroup(GEN g, GEN *S);
GEN     galois_group(GEN gal);
GEN     galoisconj(GEN nf);
GEN     galoisconj0(GEN nf, long flag, GEN d, long prec);
GEN     galoisconj2(GEN x, long nbmax, long prec);
GEN     galoisconj4(GEN T, GEN den, long flag);
GEN     galoisexport(GEN gal, long format);
GEN     galoisfixedfield(GEN gal, GEN v, long flag, long y);
GEN     galoisidentify(GEN gal);
GEN     galoisinit(GEN nf, GEN den);
GEN     galoisisabelian(GEN gal, long flag);
GEN     galoispermtopol(GEN gal, GEN perm);
GEN     galoissubgroups(GEN G);
GEN     galoissubfields(GEN G, long flag, long v);
long    numberofconjugates(GEN T, long pdepart);
GEN     vandermondeinverse(GEN L, GEN T, GEN den, GEN prep);
/* gen1.c */

GEN     gadd(GEN x, GEN y);
GEN     gaddsg(long x, GEN y);
GEN     gdiv(GEN x, GEN y);
GEN     gdivgs(GEN x, long s);
GEN     gmul(GEN x, GEN y);
GEN     gmul2n(GEN x, long n);
GEN     gmulsg(long s, GEN y);
GEN     gsqr(GEN x);
GEN     gsub(GEN x, GEN y);

/* gen2.c */
GEN     gopsg2(GEN (*f)(GEN, GEN), long s, GEN y);

long    ZX_valuation(GEN x, GEN *Z);
GEN     cgetimag(void);
GEN     cgetp(GEN x);
GEN     cvtop(GEN x, GEN p, long l);
GEN     cvtop2(GEN x, GEN y);
GEN     gabs(GEN x, long prec);
void    gaffect(GEN x, GEN y);
void    gaffsg(long s, GEN x);
int     gcmp(GEN x, GEN y);
int     gcmpsg(long x, GEN y);
int     gcmp0(GEN x);
int     gcmp1(GEN x);
int     gcmp_1(GEN x);
GEN     gcvtop(GEN x, GEN p, long r);
int     gequal(GEN x, GEN y);
int     gequalsg(long s, GEN x);
long    gexpo(GEN x);
long    ggval(GEN x, GEN p);
long    glength(GEN x);
GEN     gmax(GEN x, GEN y);
GEN     gmaxgs(GEN x, long y);
GEN     gmin(GEN x, GEN y);
GEN     gmings(GEN x, long y);
GEN     gneg(GEN x);
GEN     gneg_i(GEN x);
GEN     greffe(GEN x, long l, long use_stack);
int     gsigne(GEN x);
GEN     gtofp(GEN z, long prec);
GEN     gtolist(GEN x);
long    gtolong(GEN x);
int     lexcmp(GEN x, GEN y);
GEN     listconcat(GEN list1, GEN list2);
GEN     listcreate(long n);
GEN     listinsert(GEN list, GEN object, long index);
void    listkill(GEN list);
GEN     listput(GEN list, GEN object, long index);
GEN     listsort(GEN list, long flag);
GEN     matsize(GEN x);
GEN     normalize(GEN x);
GEN     normalizepol(GEN x);
GEN     normalizepol_approx(GEN x, long lx);
GEN     normalizepol_i(GEN x, long lx);
long    polvaluation(GEN x, GEN *z);
long    polvaluation_inexact(GEN x, GEN *Z);
GEN     pureimag(GEN x);
GEN     quadtoc(GEN x, long l);
long    sizedigit(GEN x);
long    u_lval(ulong x, ulong p);
long    u_lvalrem(ulong x, ulong p, ulong *py);
long    u_pvalrem(ulong x, GEN p, ulong *py);
GEN     vecmax(GEN x);
GEN     vecmin(GEN x);
long    Z_lval(GEN n, ulong p);
long    Z_lvalrem(GEN n, ulong p, GEN *py);
long    z_pval(long n, GEN p);
long    Z_pval(GEN n, GEN p);
long    Z_pvalrem(GEN x, GEN p, GEN *py);

/* gen3.c */

GEN     Mod0(GEN x, GEN y,long flag);
GEN     ceil_safe(GEN x);
GEN     ceilr(GEN x);
GEN     centerlift(GEN x);
GEN     centerlift0(GEN x,long v);
GEN     compo(GEN x, long n);
GEN     deg1pol(GEN x1, GEN x0,long v);
GEN     deg1pol_i(GEN x1, GEN x0,long v);
long    degree(GEN x);
GEN     denom(GEN x);
GEN     deriv(GEN x, long v);
GEN     derivpol(GEN x);
GEN     derivser(GEN x);
GEN     diviiround(GEN x, GEN y);
GEN     divrem(GEN x, GEN y, long v);
GEN     gand(GEN x, GEN y);
GEN     gceil(GEN x);
GEN     gcvtoi(GEN x, long *e);
GEN     gdivent(GEN x, GEN y);
GEN     gdiventgs(GEN x, long y);
GEN     gdiventres(GEN x, GEN y);
GEN     gdivmod(GEN x, GEN y, GEN *pr);
GEN     gdivround(GEN x, GEN y);
GEN     geq(GEN x, GEN y);
GEN     geval(GEN x);
GEN     gfloor(GEN x);
GEN     gfloor2n(GEN x, long s);
GEN     gfrac(GEN x);
GEN     gge(GEN x, GEN y);
GEN     ggprecision(GEN x);
GEN     ggrando(GEN x, long n);
GEN     ggt(GEN x, GEN y);
GEN     gimag(GEN x);
GEN     ginv(GEN x);
GEN     gle(GEN x, GEN y);
GEN     glt(GEN x, GEN y);
GEN     gmod(GEN x, GEN y);
GEN     gmodgs(GEN x, long y);
GEN     gmodulo(GEN x,GEN y);
GEN     gmodulo(GEN x,GEN y);
GEN     gmodulsg(long x, GEN y);
GEN     gmodulss(long x, long y);
GEN     gne(GEN x, GEN y);
GEN     gnot(GEN x);
GEN     gor(GEN x, GEN y);
GEN     gpolvar(GEN y);
long    gprecision(GEN x);
GEN     greal(GEN x);
GEN     grndtoi(GEN x, long *e);
GEN     ground(GEN x);
GEN     gshift(GEN x, long n);
GEN     gsubst(GEN x, long v, GEN y);
GEN     gsubstpol(GEN x, GEN v, GEN y);
GEN     gsubstvec(GEN x, GEN v, GEN y);
GEN     gtocol(GEN x);
GEN     gtopoly(GEN x, long v);
GEN     gtopolyrev(GEN x, long v);
GEN     gtoser(GEN x, long v);
GEN     gtovec(GEN x);
GEN     gtovecsmall(GEN x);
GEN     gtrunc(GEN x);
long    gvar(GEN x);
long    gvar2(GEN x);
GEN     hqfeval(GEN q, GEN x);
GEN     imag_i(GEN x);
GEN     integ(GEN x, long v);
int     iscomplex(GEN x);
int     isexactzero(GEN g);
int     isexactzeroscalar(GEN g);
int     isinexact(GEN x);
int     isinexactreal(GEN x);
int     isint(GEN n, GEN *ptk);
int     issmall(GEN n, long *ptk);
int     ismonome(GEN x);
GEN     lift(GEN x);
GEN     lift0(GEN x,long v);
GEN     mkcoln(long n, ...);
GEN     mkintn(long n, ...);
GEN     mkpoln(long n, ...);
GEN     mkvecn(long n, ...);
GEN     mulmat_real(GEN x, GEN y);
GEN     numer(GEN x);
long    padicprec(GEN x, GEN p);
GEN     polcoeff0(GEN x,long n,long v);
GEN     polcoeff_i(GEN x, long n, long v);
long    poldegree(GEN x,long v);
GEN     poleval(GEN x, GEN y);
GEN     pollead(GEN x,long v);
long    precision(GEN x);
GEN     precision0(GEN x,long n);
GEN     qf_base_change(GEN q, GEN M, int flag);
GEN     qfeval(GEN q, GEN x);
GEN     real_i(GEN x);
GEN     recip(GEN x);
GEN     round0(GEN x, GEN *pte);
GEN     roundr(GEN x);
GEN     scalarpol(GEN x, long v);
GEN     scalarser(GEN x, long v, long prec);
GEN     simplify(GEN x);
GEN     simplify_i(GEN x);
GEN     tayl(GEN x, long v, long precdl);
GEN     toser_i(GEN x);
GEN     truecoeff(GEN x, long n);
GEN     trunc0(GEN x, GEN *pte);
GEN     u2toi(ulong a, ulong b);

/* groupid.c */

long    group_ident(GEN G, GEN S);

/* ifactor1.c */

long    BSW_psp(GEN N);
int     uisprime(ulong n);
int     is_357_power(GEN x, GEN *pt, ulong *mask);
int     is_odd_power(GEN x, GEN *pt, ulong *curexp, ulong cutoffbits);
long    millerrabin(GEN n, long k);
GEN     nextprime(GEN n);
GEN     plisprime(GEN N, long flag);
GEN     precprime(GEN n);

/* init.c */

long    TIMER(pari_timer *T);
void    TIMERstart(pari_timer *T);
long    allocatemoremem(size_t newsize);
GEN     cgetalloc(long t, size_t l);
GEN     changevar(GEN x, GEN y);
void    disable_dbg(long val);
void*   err_catch(long errnum, jmp_buf *penv);
void    err_leave(void **v);
GEN     gclone(GEN x);
GEN     gcopy(GEN x);
GEN     gcopy_i(GEN x, long lx);
GEN     gerepile(pari_sp ltop, pari_sp lbot, GEN q);
void    gerepileall(pari_sp av, int n, ...);
void    gerepileallsp(pari_sp av, pari_sp tetpil, int n, ...);
void    gerepilecoeffs(pari_sp av, GEN x, int n);
void    gerepilecoeffssp(pari_sp av, pari_sp tetpil, long *g, int n);
GEN     gerepilecopy(pari_sp av, GEN x);
void    gerepilemany(pari_sp av, GEN* g[], int n);
void    gerepilemanysp(pari_sp av, pari_sp tetpil, GEN* g[], int n);
GEN     gerepileupto(pari_sp av, GEN q);
GEN     gerepileuptoint(pari_sp av, GEN q);
GEN     gerepileuptoleaf(pari_sp av, GEN q);
GEN     getheap(void);
char*   gpmalloc(size_t bytes);
char*   gprealloc(void *pointer,size_t size);
void    gunclone(GEN x);
void    killbloc(GEN x);
void    msgTIMER(pari_timer *T, char *format, ...);
void    msgtimer(char *format, ...);
GEN     newbloc(long n);
void    pari_add_function(entree *ep);
void    pari_add_module(entree *ep);
void    pari_close(void);
void    pari_close_opts(ulong init_opts);
void    pari_err(long numerr, ...);
void    pari_init_opts(size_t parisize, ulong maxprime, ulong init_opts);
void    pari_init(size_t parisize, ulong maxprime);
void    pari_sig_init(void (*f)(int));
void    pari_warn(long numerr, ...);
GEN     reorder(GEN x);
GEN     shallowcopy(GEN x);
stackzone* switch_stack(stackzone *z, long n);
long    taille(GEN x);
long    taille2(GEN x);
long    timer(void);
long    timer2(void);
void    traverseheap( void(*f)(GEN, void *), void *data );

/* intnum.c */

GEN     intcirc(void *E, GEN (*eval) (GEN, void *), GEN a, GEN R, GEN tab, long prec);
GEN     intcirc0(entree *ep, GEN a, GEN R, char *ch, GEN tab, long prec);
GEN     intfourcos0(entree *ep, GEN a, GEN b, GEN x, char *ch, GEN tab, long prec);
GEN     intfourexp0(entree *ep, GEN a, GEN b, GEN x, char *ch, GEN tab, long prec);
GEN     intfouriercos(void *E, GEN (*eval) (GEN, void *), GEN a, GEN b, GEN x, GEN tab, long prec);
GEN     intfouriersin(void *E, GEN (*eval) (GEN, void *), GEN a, GEN b, GEN x, GEN tab, long prec);
GEN     intfoursin0(entree *ep, GEN a, GEN b, GEN x, char *ch, GEN tab, long prec);
GEN     intfuncinit(void *E, GEN (*eval) (GEN, void *), GEN a, GEN b, long m, long flag, long prec);
GEN     intfuncinit0(entree *ep, GEN a, GEN b, char *ch, long flag, long m, long prec);
GEN     intlaplaceinv(void *E, GEN (*eval) (GEN, void *), GEN sig, GEN x, GEN tab, long prec);
GEN     intlaplaceinv0(entree *ep, GEN sig, GEN x, char *ch, GEN tab, long prec);
GEN     intmellininv(void *E, GEN (*eval) (GEN, void *), GEN sig, GEN x, GEN tab, long prec);
GEN     intmellininv0(entree *ep, GEN sig, GEN x, char *ch, GEN tab, long prec);
GEN     intmellininvshort(GEN sig, GEN x, GEN tab, long prec);
GEN     intnum(void *E, GEN (*eval) (GEN, void *), GEN a, GEN b, GEN tab, long prec);
GEN     intnum0(entree *ep, GEN a, GEN b, char *ch, GEN tab, long prec);
GEN     intnuminit(GEN a, GEN b, long m, long prec);
GEN     intnuminit0(GEN a, GEN b, GEN tab, long prec);
GEN     intnuminitgen(void *E, GEN (*eval) (GEN, void *), GEN a, GEN b, long m, long flext, long prec);
GEN     intnuminitgen0(entree *ep, GEN a, GEN b, char *ch, long m, long flag, long prec);
GEN     intnumromb(void *E, GEN (*eval) (GEN, void *), GEN a, GEN b, long flag, long prec);
GEN     intnumromb0(entree *ep, GEN a, GEN b, char *ch, long flag, long prec);
long    intnumstep(long prec);
GEN     sumnum(void *E, GEN (*f) (GEN, void *), GEN a, GEN sig, GEN tab, long flag, long prec);
GEN     sumnum0(entree *ep, GEN a, GEN sig, char *ch, GEN tab, long flag, long prec);
GEN     sumnumalt(void *E, GEN (*f) (GEN, void *), GEN a, GEN s, GEN tab, long flag, long prec);
GEN     sumnumalt0(entree *ep, GEN a, GEN sig, char *ch, GEN tab, long flag, long prec);
GEN     sumnuminit(GEN sig, long m, long sgn, long prec);
GEN     sumnuminit0(GEN a, GEN tab, long sgn, long prec);

/* kummer.c */

GEN     rnfkummer(GEN bnr, GEN subgroup, long all, long prec);

/* members.c */

GEN     member_a1(GEN x);
GEN     member_a2(GEN x);
GEN     member_a3(GEN x);
GEN     member_a4(GEN x);
GEN     member_a6(GEN x);
GEN     member_area(GEN x);
GEN     member_b2(GEN x);
GEN     member_b4(GEN x);
GEN     member_b6(GEN x);
GEN     member_b8(GEN x);
GEN     member_bid(GEN x);
GEN     member_bnf(GEN x);
GEN     member_c4(GEN x);
GEN     member_c6(GEN x);
GEN     member_clgp(GEN x);
GEN     member_codiff(GEN x);
GEN     member_cyc(GEN clg);
GEN     member_diff(GEN x);
GEN     member_disc(GEN x);
GEN     member_e(GEN x);
GEN     member_eta(GEN x);
GEN     member_f(GEN x);
GEN     member_fu(GEN x);
GEN     member_futu(GEN x);
GEN     member_gen(GEN x);
GEN     member_group(GEN x);
GEN     member_index(GEN x);
GEN     member_j(GEN x);
GEN     member_mod(GEN x);
GEN     member_nf(GEN x);
GEN     member_no(GEN clg);
GEN     member_omega(GEN x);
GEN     member_orders(GEN x);
GEN     member_p(GEN x);
GEN     member_pol(GEN x);
GEN     member_reg(GEN x);
GEN     member_r1(GEN x);
GEN     member_r2(GEN x);
GEN     member_roots(GEN x);
GEN     member_sign(GEN x);
GEN     member_t2(GEN x);
GEN     member_tate(GEN x);
GEN     member_tufu(GEN x);
GEN     member_tu(GEN x);
GEN     member_w(GEN x);
GEN     member_zk(GEN x);
GEN     member_zkst(GEN bid);

/* mp.c */

int     absi_cmp(GEN x, GEN y);
int     absi_equal(GEN x, GEN y);
int     absr_cmp(GEN x, GEN y);
GEN     addii_sign(GEN x, long sx, GEN y, long sy);
GEN     addir_sign(GEN x, long sx, GEN y, long sy);
GEN     addrr_sign(GEN x, long sx, GEN y, long sy);
GEN     addsi_sign(long x, GEN y, long sy);
GEN     addsr(long x, GEN y);
GEN     addss(long x, long y);
void    affir(GEN x, GEN y);
void    affrr(GEN x, GEN y);
GEN     bezout(GEN a, GEN b, GEN *u, GEN *v);
long    cbezout(long a,long b,long *uu,long *vv);
void    cgiv(GEN x);
int     cmpii(GEN x, GEN y);
int     cmprr(GEN x, GEN y);
int     cmpsi(long x, GEN y);
int     cmpui(ulong x, GEN y);
GEN     dbltor(double x);
GEN     diviiexact(GEN x, GEN y);
GEN     diviuexact(GEN x, ulong y);
GEN     divir(GEN x, GEN y);
GEN     divis(GEN y, long x);
GEN     divis_rem(GEN x, long y, long *rem);
GEN     diviu_rem(GEN y, ulong x, ulong *rem);
GEN     divri(GEN x, GEN y);
GEN     divrr(GEN x, GEN y);
GEN     divrs(GEN x, long y);
GEN     divsi(long x, GEN y);
GEN     divsr(long x, GEN y);
GEN     dvmdii(GEN x, GEN y, GEN *z);
int     equalii(GEN x, GEN y);
int     equalsi(long x, GEN y);
int     equalui(ulong x, GEN y);
GEN     floorr(GEN x);
GEN     gcdii(GEN x, GEN y);
GEN     int_normalize(GEN x, long known_zero_words);
GEN     int2n(long n);
GEN     int2u(ulong n);
int     invmod(GEN a, GEN b, GEN *res);
ulong   invrev(ulong b);
ulong   Fl_inv(ulong x, ulong p);
GEN     ishiftr(GEN x, long n);
GEN     modii(GEN x, GEN y);
void    modiiz(GEN x, GEN y, GEN z);
void    mpdivz(GEN x, GEN y, GEN z);
GEN     mulii(GEN x, GEN y);
GEN     mulir(GEN x, GEN y);
GEN     mulrr(GEN x, GEN y);
GEN     mulsi(long x, GEN y);
GEN     mulsr(long x, GEN y);
GEN     mulss(long x, long y);
GEN     mului(ulong x, GEN y);
GEN     mulur(ulong x, GEN y);
GEN     muluu(ulong x, ulong y);
long    pari_rand31(void);
GEN     randomi(GEN x);
int     ratlift(GEN x, GEN m, GEN *a, GEN *b, GEN amax, GEN bmax);
GEN     resmod2n(GEN x, long n);
double  rtodbl(GEN x);
GEN     shifti(GEN x, long n);
GEN     sqri(GEN x);
#define sqrti(x) sqrtremi((x),NULL)
GEN     sqrtremi(GEN S, GEN *R);
GEN     subsr(long x, GEN y);
GEN     truedvmdii(GEN x, GEN y, GEN *z);
GEN     truedvmdis(GEN x, long y, GEN *z);
GEN     truncr(GEN x);
ulong   umodiu(GEN y, ulong x);
long    vals(ulong x);

/* nffactor.c */

GEN     nffactor(GEN nf,GEN x);
GEN     nffactormod(GEN nf,GEN pol,GEN pr);
int     nfisgalois(GEN nf, GEN x);
GEN     nfroots(GEN nf,GEN pol);
GEN     rnfcharpoly(GEN nf, GEN T, GEN alpha, long v);
GEN     unifpol(GEN nf,GEN pol,long flag);

/* part.c */

GEN     numbpart(GEN x);

/* perm.c */

GEN     abelian_group(GEN G);
GEN     bitvec_alloc(long n);
void    bitvec_clear(GEN bitvec, long b);
void    bitvec_set(GEN bitvec, long b);
GEN     bitvec_shorten(GEN bitvec, long n);
long    bitvec_test(GEN bitvec, long b);
GEN     const_col(long n, GEN x);
GEN     const_vec(long n, GEN x);
GEN     const_vecsmall(long n, long c);
GEN     cyclicgroup(GEN g, long s);
GEN     cyclicperm(long l, long d);
GEN     cyc_pow(GEN cyc, long exp);
GEN     cyc_pow_perm(GEN cyc, long exp);
GEN     dicyclicgroup(GEN g1, GEN g2, long s1, long s2);
GEN     group_abelianHNF(GEN G, GEN L);
GEN     group_abelianSNF(GEN G, GEN L);
long    group_domain(GEN G);
GEN     group_elts(GEN G, long n);
GEN     group_export(GEN G, long format);
long    group_isA4S4(GEN G);
long    group_isabelian(GEN G);
GEN     group_leftcoset(GEN G, GEN g);
long    group_order(GEN G);
long    group_perm_normalize(GEN N, GEN g);
GEN     group_quotient(GEN G, GEN H);
GEN     group_rightcoset(GEN G, GEN g);
GEN     group_subgroups(GEN G);
GEN     groupelts_center(GEN S);
GEN     groupelts_abelian_group(GEN S);
int     perm_commute(GEN p, GEN q);
GEN     perm_cycles(GEN v);
GEN     perm_identity(long l);
GEN     perm_inv(GEN x);
GEN     perm_mul(GEN s, GEN t);
long    perm_order(GEN perm);
GEN     perm_pow(GEN perm, long exp);
GEN     quotient_group(GEN C, GEN G);
GEN     quotient_perm(GEN C, GEN p);
GEN     vec_to_vecsmall(GEN z);
GEN     vecperm_orbits(GEN v, long n);
int     vec_is1to1(GEN v);
int     vec_isconst(GEN v);
GEN     vec_lengthen(GEN v, long n);
GEN     vec_shorten(GEN v, long n);
GEN     vecsmall_append(GEN V, long s);
long    vecsmall_coincidence(GEN u, GEN v);
GEN     vecsmall_concat(GEN u, GEN v);
GEN     vecsmall_copy(GEN x);
GEN     vecsmall_indexsort(GEN V);
long    vecsmall_isin(GEN v, long x);
GEN     vecsmall_lengthen(GEN v, long n);
int     vecsmall_lexcmp(GEN x, GEN y);
long    vecsmall_pack(GEN V, long base, long mod);
int     vecsmall_prefixcmp(GEN x, GEN y);
GEN     vecsmall_prepend(GEN V, long s);
GEN     vecsmall_shorten(GEN v, long n);
void    vecsmall_sort(GEN V);
GEN     vecsmall_to_col(GEN z);
GEN     vecsmall_to_vec(GEN z);
GEN     vecsmall_uniq(GEN V);
GEN     vecvecsmall_indexsort(GEN x);
GEN     vecvecsmall_sort(GEN x);
long    vecvecsmall_search(GEN x, GEN y, long flag);

/* polarit1.c */

long    Flx_nbfact(GEN z, ulong p);
long    Flx_nbroots(GEN f, ulong p);
GEN     FpX_degfact(GEN f, GEN p);
long    FpX_is_irred(GEN f, GEN p);
long    FpX_is_squarefree(GEN f, GEN p);
long    FpX_is_totally_split(GEN f, GEN p);
GEN     FpX_factor(GEN f, GEN p);
long    FpX_nbfact(GEN f, GEN p);
long    FpX_nbroots(GEN f, GEN p);
GEN     FqX_factor(GEN x, GEN T, GEN p);
GEN     FqX_gcd(GEN P, GEN Q, GEN T, GEN p);
long    FqX_is_squarefree(GEN P, GEN T, GEN p);
long    FqX_nbfact(GEN u, GEN T, GEN p);
long    FqX_nbroots(GEN f, GEN T, GEN p);
GEN     FpX_rand(long d, long v, GEN p);
GEN     FpX_roots(GEN f, GEN p);
int     cmp_pol(GEN x, GEN y);
GEN     factcantor(GEN x, GEN p);
GEN     factmod(GEN f, GEN p);
GEN     factorff(GEN f, GEN p, GEN a);
GEN     factormod0(GEN f, GEN p,long flag);
GEN     factorpadic0(GEN f,GEN p,long r,long flag);
GEN     factorpadic2(GEN x, GEN p, long r);
GEN     factorpadic4(GEN x, GEN p, long r);
int     gdvd(GEN x, GEN y);
long    hensel_lift_accel(long n, long *pmask);
GEN     padicappr(GEN f, GEN a);
GEN     padicsqrtnlift(GEN a, GEN n, GEN S, GEN p, long e);
int     poldvd(GEN x, GEN y, GEN *z);
GEN     poldivrem(GEN x, GEN y, GEN *pr);
GEN     polfnf(GEN a, GEN t);
GEN     rootmod(GEN f, GEN p);
GEN     rootmod0(GEN f, GEN p,long flag);
GEN     rootmod2(GEN f, GEN p);
GEN     rootpadic(GEN f, GEN p, long r);
GEN     rootpadicfast(GEN f, GEN p, long e);
GEN     ZX_deriv(GEN x);
GEN     FpX_deriv(GEN f, GEN p);
GEN     FqX_deriv(GEN f, GEN T, GEN p);
GEN     ZpX_liftroot(GEN f, GEN a, GEN p, long e);
GEN     ZpXQX_liftroot(GEN f, GEN a, GEN T, GEN p, long e);
GEN     ZpX_liftroots(GEN f, GEN S, GEN q, long e);
GEN     roots2(GEN pol,long PREC);
GEN     rootsold(GEN x, long l);
GEN     simplefactmod(GEN f, GEN p);

/* polarit2.c */

GEN     Newton_exponents(long e);
GEN     Q_content(GEN x);
GEN     Q_denom(GEN x);
GEN     Q_div_to_int(GEN x, GEN c);
GEN     Q_muli_to_int(GEN x, GEN d);
GEN     Q_primitive_part(GEN x, GEN *ptc);
GEN     Q_primpart(GEN x);
GEN     Q_remove_denom(GEN x, GEN *ptd);
GEN     RgX_extgcd(GEN x, GEN y, GEN *U, GEN *V);
GEN     ZX_squff(GEN f, GEN *ex);
GEN     centermod(GEN x, GEN p);
GEN     centermod_i(GEN x, GEN p, GEN ps2);
GEN     centermodii(GEN x, GEN p, GEN po2);
GEN     combine_factors(GEN target, GEN famod, GEN p, long klim, long hint);
GEN     concat_factor(GEN f, GEN g);
GEN     content(GEN x);
GEN     deg1_from_roots(GEN L, long v);
GEN     discsr(GEN x);
GEN     divide_conquer_prod(GEN x, GEN (*mul)(GEN,GEN));
GEN     divide_conquer_assoc(GEN x, GEN (*mul)(void*,GEN,GEN), void *data);
GEN     factor(GEN x);
GEN     factor0(GEN x,long flag);
GEN     factorback(GEN fa,GEN nf);
GEN     factorback0(GEN fa,GEN e, GEN nf);
GEN     factorbackelt(GEN fa, GEN e, GEN nf);
GEN     factpol(GEN x, long hint);
GEN     gbezout(GEN x, GEN y, GEN *u, GEN *v);
GEN     gcd0(GEN x, GEN y,long flag);
GEN     gdeflate(GEN x, long v, long d);
GEN     gdivexact(GEN x, GEN y);
GEN     ggcd(GEN x, GEN y);
GEN     ginvmod(GEN x, GEN y);
GEN     gisirreducible(GEN x);
GEN     glcm(GEN x, GEN y);
GEN     glcm0(GEN x, GEN y);
GEN     hensel_lift_fact(GEN pol, GEN Q, GEN T, GEN p, GEN pe, long e);
GEN     leftright_pow(GEN,GEN,void*,GEN (*sqr)(void*,GEN),GEN (*mul)(void*,GEN,GEN));
GEN     leftright_pow_u(GEN x, ulong n, void *data, GEN (*sqr)(void*,GEN), GEN (*mul)(void*,GEN,GEN));
GEN     leftright_pow_fold(GEN x, GEN n, void *data, GEN (*sqr)(void*,GEN), GEN (*msqr)(void*,GEN));
GEN     leftright_pow_u_fold(GEN x, ulong n, void *data, GEN (*sqr)(void*,GEN), GEN (*msqr)(void*,GEN));
long    logint(GEN B, GEN y, GEN *ptq);
GEN     newtonpoly(GEN x, GEN p);
GEN     nfgcd(GEN P, GEN Q, GEN nf, GEN den);
GEN     nfrootsQ(GEN x);
GEN     poldeflate(GEN x0, long *m);
GEN     poldeflate_i(GEN x0, long d);
GEN     poldisc0(GEN x, long v);
GEN     polhensellift(GEN pol, GEN fct, GEN p, long exp);
GEN     polinflate(GEN x0, long d);
GEN     polresultant0(GEN x, GEN y,long v,long flag);
GEN     polsym(GEN x, long n);
GEN     primitive_part(GEN x, GEN *c);
GEN     primpart(GEN x);
GEN     pseudorem(GEN x, GEN y);
GEN     reduceddiscsmith(GEN pol);
GEN     resultant2(GEN x, GEN y);
GEN     resultantducos(GEN x, GEN y);
GEN     roots_from_deg1(GEN x);
GEN     srgcd(GEN x, GEN y);
long    sturmpart(GEN x, GEN a, GEN b);
GEN     subresall(GEN u, GEN v, GEN *sol);
GEN     subresext(GEN x, GEN y, GEN *U, GEN *V);
GEN     sylvestermatrix(GEN x,GEN y);
GEN     vecbezout(GEN x, GEN y);
GEN     vecbezoutres(GEN x, GEN y);

/* polarit3.c */

GEN     FpC_red(GEN z, GEN p);
GEN     FpC_to_mod(GEN z, GEN p);
GEN     FpM_red(GEN z, GEN p);
GEN     FpM_to_mod(GEN z, GEN p);
GEN     FpV_polint(GEN xa, GEN ya, GEN p);
GEN     FpV_red(GEN z, GEN p);
GEN     FpV_roots_to_pol(GEN V, GEN p, long v);
GEN     FpV_to_mod(GEN z, GEN p);
GEN     FpX_FpXQ_compo(GEN f,GEN x,GEN T,GEN p);
GEN     FpX_FpXQV_compo(GEN f,GEN x,GEN T,GEN p);
GEN     FpX_Fp_add(GEN y,GEN x,GEN p);
GEN     FpX_Fp_mul(GEN y,GEN x,GEN p);
GEN     FpX_add(GEN x,GEN y,GEN p);
GEN     FpX_center(GEN T,GEN mod);
GEN     FpX_chinese_coprime(GEN x,GEN y,GEN Tx,GEN Ty,GEN Tz,GEN p);
GEN     FpX_divrem(GEN x, GEN y, GEN p, GEN *pr);
GEN     FpX_eval(GEN x,GEN y,GEN p);
GEN     FpX_extgcd(GEN x, GEN y, GEN p, GEN *ptu, GEN *ptv);
GEN     FpX_factorff_irred(GEN P, GEN Q, GEN l);
void    FpX_ffintersect(GEN P,GEN Q,long n,GEN l,GEN *SP,GEN *SQ,GEN MA,GEN MB);
GEN     FpX_ffisom(GEN P,GEN Q,GEN l);
GEN     FpX_gcd(GEN x, GEN y, GEN p);
GEN     FpX_mul(GEN x,GEN y,GEN p);
GEN     FpX_neg(GEN x,GEN p);
GEN     FpX_normalize(GEN z, GEN p);
GEN     FpX_red(GEN z, GEN p);
GEN     FpX_resultant(GEN a, GEN b, GEN p);
GEN     FpX_sqr(GEN x,GEN p);
GEN     FpX_sub(GEN x,GEN y,GEN p);
GEN     FpX_to_mod(GEN z, GEN p);
GEN     FpXQ_charpoly(GEN x, GEN T, GEN p);
GEN     FpXQ_div(GEN x,GEN y,GEN T,GEN p);
GEN     FpXQ_ffisom_inv(GEN S,GEN Tp, GEN p);
GEN     FpXQ_inv(GEN x,GEN T,GEN p);
GEN     FpXQ_invsafe(GEN x, GEN T, GEN p);
GEN     FpXQ_matrix_pow(GEN y, long n, long m, GEN P, GEN l);
GEN     FpXQ_minpoly(GEN x, GEN T, GEN p);
GEN     FpXQ_mul(GEN y,GEN x,GEN T,GEN p);
GEN     FpXQ_pow(GEN x, GEN n, GEN T, GEN p);
GEN     FpXQ_powers(GEN x, long l, GEN T, GEN p);
GEN     FpXQ_sqr(GEN y, GEN T, GEN p);
GEN     FpXQ_sqrtn(GEN a, GEN n, GEN T, GEN p, GEN *zetan);
GEN     FpXQX_gcd(GEN P, GEN Q, GEN T, GEN p);
GEN     FpXQX_mul(GEN x, GEN y, GEN T, GEN p);
GEN     FpXQX_red(GEN z, GEN T, GEN p);
GEN     FpXQX_sqr(GEN x, GEN T, GEN p);
GEN     FpXQX_extgcd(GEN x, GEN y, GEN T, GEN p, GEN *ptu, GEN *ptv);
GEN     FpXQX_divrem(GEN x, GEN y, GEN T, GEN p, GEN *pr);
GEN     FpXQXV_prod(GEN V, GEN Tp, GEN p);
GEN     FpXQYQ_pow(GEN x, GEN n, GEN S, GEN T, GEN p);
GEN     FpXV_FpC_mul(GEN V, GEN W, GEN p);
GEN     FpXV_prod(GEN V, GEN p);
GEN     FpXV_red(GEN z, GEN p);
GEN     FpXX_add(GEN x, GEN y, GEN p);
GEN     FpXX_red(GEN z, GEN p);
GEN     FpX_rescale(GEN P, GEN h, GEN p);
GEN     FpY_FpXY_resultant(GEN a, GEN b0, GEN p);
GEN     Fq_inv(GEN x, GEN T, GEN p);
GEN     Fq_invsafe(GEN x, GEN T, GEN p);
GEN     Fq_add(GEN x, GEN y, GEN T/*unused*/, GEN p);
GEN     Fq_mul(GEN x, GEN y, GEN T, GEN p);
GEN     Fq_neg(GEN x, GEN T, GEN p);
GEN     Fq_neg_inv(GEN x, GEN T, GEN p);
GEN     Fq_pow(GEN x, GEN n, GEN T, GEN p);
GEN     Fq_red(GEN x, GEN T, GEN p);
GEN     Fq_sub(GEN x, GEN y, GEN T/*unused*/, GEN p);
GEN     FqC_to_FlxC(GEN v, GEN T, GEN pp);
GEN     FqM_to_FlxM(GEN x, GEN T, GEN pp);
GEN     FqV_roots_to_pol(GEN V, GEN T, GEN p, long v);
GEN     FqV_red(GEN z, GEN T, GEN p);
GEN     FqV_to_FlxV(GEN v, GEN T, GEN pp);
GEN     FqX_Fq_mul(GEN P, GEN U, GEN T, GEN p);
GEN     FqX_div(GEN x, GEN y, GEN T, GEN p);
GEN     FqX_divrem(GEN x, GEN y, GEN T, GEN p, GEN *z);
GEN     FqX_eval(GEN x, GEN y, GEN T, GEN p);
GEN     FqX_normalize(GEN z, GEN T, GEN p);
GEN     FqX_red(GEN z, GEN T, GEN p);
GEN     FqX_rem(GEN x, GEN y, GEN T, GEN p);
GEN     FqX_mul(GEN x, GEN y, GEN T, GEN p);
GEN     FqX_sqr(GEN x, GEN T, GEN p);
GEN     QXQ_inv(GEN A, GEN B);
ulong   Rg_to_Fl(GEN x, ulong p);
GEN     Rg_to_Fp(GEN x, GEN p);
GEN     RgC_to_FpC(GEN x, GEN p);
GEN     RgV_to_FpV(GEN x, GEN p);
GEN     RgX_to_FpX(GEN x, GEN p);
GEN     RgX_to_FqX(GEN x, GEN T, GEN p);
GEN     ZX_QX_resultant(GEN A, GEN B);
GEN     ZX_Z_add(GEN y,GEN x);
GEN     ZX_Z_mul(GEN y,GEN x);
GEN     ZX_add(GEN x, GEN y);
GEN     ZX_caract(GEN A, GEN B, long v);
GEN     ZX_disc(GEN x);
int     ZX_is_squarefree(GEN x);
GEN     ZX_neg(GEN x);
GEN     ZX_renormalize(GEN x, long lx);
GEN     ZX_resultant(GEN A, GEN B);
GEN     ZX_sub(GEN x, GEN y);
long    brent_kung_optpow(long d, long n);
GEN     ffinit(GEN p, long n, long v);
GEN     from_Kronecker(GEN z, GEN pol);
GEN     init_Fq(GEN p, long n, long v);
GEN     modulargcd(GEN a,GEN b);
GEN     stopoly(ulong m, ulong p, long v);
GEN     stopoly_gen(GEN m, GEN p, long v);
GEN     to_Kronecker(GEN P, GEN Q);

/* RgX.c */

int     is_rational(GEN x);
GEN     RgM_to_RgXV(GEN x, long v);
GEN     RgM_to_RgXX(GEN x, long v,long w);
GEN     RgM_zc_mul(GEN x, GEN y);
GEN     RgM_zm_mul(GEN x, GEN y);
GEN     RgV_to_RgX(GEN x, long v);
GEN     RgV_zc_mul(GEN x, GEN y);
GEN     RgV_zm_mul(GEN x, GEN y);
GEN     RgX_div_by_X_x(GEN a, GEN x, GEN *r);
GEN     RgX_divrem(GEN x,GEN y,GEN *r);
int     RgX_is_rational(GEN x);
GEN     RgX_mul(GEN x,GEN y);
GEN     RgX_mulspec(GEN a, GEN b, long na, long nb);
GEN     RgX_powers(GEN a, GEN T, long l);
GEN     RgX_renormalize(GEN x);
GEN     RgX_rescale(GEN P, GEN h);
GEN     RgX_unscale(GEN P, GEN h);
GEN     RgXQ_mul(GEN x,GEN y,GEN T);
GEN     RgXQ_powers(GEN x, long l, GEN T);
GEN     RgXQ_sqr(GEN x,GEN T);
GEN     RgXQC_red(GEN P, GEN T);
GEN     RgXQV_red(GEN P, GEN T);
GEN     RgXQX_RgXQ_mul(GEN x, GEN y, GEN T);
GEN     RgXQX_divrem(GEN x,GEN y,GEN T,GEN *r);
GEN     RgXQX_mul(GEN x,GEN y,GEN T);
GEN     RgXQX_red(GEN P, GEN T);
GEN     RgXQX_sqr(GEN x, GEN T);
GEN     RgXV_unscale(GEN v, GEN h);
GEN     RgX_Rg_div(GEN y, GEN x);
GEN     RgX_Rg_mul(GEN y, GEN x);
GEN     RgX_RgXQ_compo(GEN f, GEN x, GEN T);
GEN     RgX_mulXn(GEN x, long d);
GEN     RgX_shift_shallow(GEN x, long n);
GEN     RgX_shift(GEN a, long n);
GEN     RgX_sqr(GEN x);
GEN     RgX_sqrspec(GEN a, long na);
GEN     RgX_to_RgV(GEN x, long N);
GEN     RgXV_to_RgM(GEN v, long n);
GEN     RgXX_to_RgM(GEN v, long n);
GEN     RgXY_swap(GEN x, long n, long w);

/* rootpol.c */

GEN     cleanroots(GEN x,long l);
int     isrealappr(GEN x, long l);
GEN     roots(GEN x,long l);
GEN     roots0(GEN x,long flag,long l);

/* subcyclo.c */

GEN     galoissubcyclo(GEN N, GEN sg, long flag, long v);
GEN     polsubcyclo(long n, long d, long v);
GEN     subcyclo(long n, long d, long v);
GEN     znstar_small(GEN zn);

/* subfield.c */

GEN     subfields(GEN nf,GEN d);
GEN     subfields0(GEN nf,GEN d);

/* subgroup.c */

void    forsubgroup(entree *oep, GEN cyc, GEN bound, char *och);
GEN     subgrouplist(GEN cyc, GEN bound);

/* stark.c */

GEN     bnrL1(GEN bnr, GEN sbgrp, long flag, long prec);
GEN     bnrrootnumber(GEN bnr, GEN chi, long flag, long prec);
GEN     bnrstark(GEN bnr, GEN subgroup, long prec);

/* sumiter.c */

GEN     direuler(void *E, GEN (*eval)(GEN,void*), GEN ga, GEN gb, GEN c);
GEN     direuler0(entree *ep, GEN a, GEN b, char *ch, GEN c);
GEN     divsum(GEN num,entree *ep, char *ch);
void    fordiv(GEN a, entree *ep, char *ch);
void    forpari(entree *ep, GEN a, GEN b, char *ch);
void    forprime(entree *ep, GEN a, GEN b, char *ch);
void    forstep(entree *ep, GEN a, GEN b, GEN s, char *ch);
void    forvec(entree *ep, GEN x, char *ch, long flag);
GEN     forvec_start(GEN x, long flag, GEN *d, GEN (**next)(GEN,GEN));
GEN     matrice(GEN nlig, GEN ncol,entree *ep1, entree *ep2, char *ch);
GEN     polzag(long n, long m);
GEN     polzagreel(long n, long m, long prec);
GEN     prodeuler(void *E, GEN (*eval)(GEN,void*), GEN ga, GEN gb, long prec);
GEN     prodeuler0(entree *ep, GEN a, GEN b, char *ch, long prec);
GEN     prodinf(void *E, GEN (*eval)(GEN,void*), GEN a, long prec);
GEN     prodinf0(entree *ep, GEN a, char *ch, long flag, long prec);
GEN     prodinf1(void *E, GEN (*eval)(GEN,void*), GEN a, long prec);
GEN     produit(entree *ep, GEN a, GEN b, char *ch, GEN x);
GEN     somme(entree *ep, GEN a, GEN b, char *ch, GEN x);
GEN     sumalt(void *E, GEN (*eval)(GEN,void*), GEN a, long prec);
GEN     sumalt0(entree *ep, GEN a, char *ch,long flag, long prec);
GEN     sumalt2(void *E, GEN (*eval)(GEN,void*), GEN a, long prec);
GEN     sumpos(void *E, GEN (*eval)(GEN,void*), GEN a, long prec);
GEN     sumpos2(void *E, GEN (*eval)(GEN,void*), GEN a, long prec);
GEN     sumpos0(entree *ep, GEN a, char *ch, long flag,long prec);
GEN     suminf(void *E, GEN (*eval)(GEN,void*), GEN a, long prec);
GEN     suminf0(entree *ep, GEN a, char *ch, long prec);
GEN     vecteur(GEN nmax, entree *ep, char *ch);
GEN     vecteursmall(GEN nmax, entree *ep, char *ch);
GEN     vvecteur(GEN nmax, entree *ep, char *ch);
GEN     zbrent0(entree *ep, GEN a, GEN b, char *ch, long prec);
GEN     zbrent(void *E, GEN (*eval)(GEN,void*), GEN a, GEN b, long prec);

/* thue.c */

GEN     bnfisintnorm(GEN x, GEN y);
GEN     thue(GEN thueres, GEN rhs, GEN ne);
GEN     thueinit(GEN pol, long flag, long prec);

/* trans1.c */

GEN     Pi2n(long n, long prec);
GEN     PiI2(long prec);
GEN     PiI2n(long n, long prec);
GEN     agm(GEN x, GEN y, long prec);
void    consteuler(long prec);
void    constpi(long prec);
GEN     exp_Ir(GEN x);
GEN     gcos(GEN x, long prec);
GEN     gcotan(GEN x, long prec);
GEN     gexp(GEN x, long prec);
GEN     glog(GEN x, long prec);
GEN     gpow(GEN x, GEN n, long prec);
GEN     gpowgs(GEN x, long n);
GEN     gsin(GEN x, long prec);
void    gsincos(GEN x, GEN *s, GEN *c, long prec);
GEN     gsqrt(GEN x, long prec);
GEN     gsqrtn(GEN x, GEN n, GEN *zetan, long prec);
GEN     gtan(GEN x, long prec);
GEN     log0(GEN x,long flag, long prec);
GEN     mpcos(GEN x);
GEN     mpeuler(long prec);
GEN     mpexp(GEN x);
GEN     mpexp1(GEN x);
GEN     mplog(GEN x);
GEN     mplog2(long prec);
GEN     mppi(long prec);
GEN     mpsin(GEN x);
void    mpsincos(GEN x, GEN *s, GEN *c);
GEN     powiu(GEN p, ulong k);
GEN     powuu(ulong p, ulong k);
GEN     sqrtr(GEN x);
GEN     sqrtnr(GEN x, long n);
GEN     palog(GEN x);
GEN     powgi(GEN x, GEN n);
GEN     teich(GEN x);
ulong   upowuu(ulong p, ulong k);

/* trans2.c */

GEN     bernfrac(long n);
GEN     bernreal(long n, long prec);
GEN     bernvec(long nomb);
GEN     gach(GEN x, long prec);
GEN     gacos(GEN x, long prec);
GEN     garg(GEN x, long prec);
GEN     gash(GEN x, long prec);
GEN     gasin(GEN x, long prec);
GEN     gatan(GEN x, long prec);
GEN     gath(GEN x, long prec);
GEN     gch(GEN x, long prec);
GEN     ggamd(GEN x, long prec);
GEN     ggamma(GEN x, long prec);
GEN     glngamma(GEN x, long prec);
GEN     gpsi(GEN x, long prec);
GEN     gsh(GEN x, long prec);
GEN     gth(GEN x, long prec);
void    mpbern(long nomb, long prec);
GEN     mpfactr(long n, long prec);

/* trans3.c */

GEN     dilog(GEN x, long prec);
GEN     eint1(GEN x, long prec);
GEN     eta(GEN x, long prec);
GEN     eta0(GEN x, long flag,long prec);
GEN     gerfc(GEN x, long prec);
GEN     gpolylog(long m, GEN x, long prec);
void    gpolylogz(long m, GEN x, GEN y);
GEN     gzeta(GEN x, long prec);
GEN     hyperu(GEN a, GEN b, GEN gx, long prec);
GEN     incgam(GEN a, GEN x, long prec);
GEN     incgam0(GEN a, GEN x, GEN z,long prec);
GEN     incgam2(GEN a, GEN x, long prec);
GEN     incgamc(GEN a, GEN x, long prec);
GEN     hbessel1(GEN n, GEN z, long prec);
GEN     hbessel2(GEN n, GEN z, long prec);
GEN     ibessel(GEN n, GEN z, long prec);
GEN     jbessel(GEN n, GEN z, long prec);
GEN     jbesselh(GEN n, GEN z, long prec);
GEN     nbessel(GEN n, GEN z, long prec);
GEN     jell(GEN x, long prec);
GEN     kbessel(GEN nu, GEN gx, long prec);
GEN     kbessel0(GEN nu, GEN gx, long flag,long prec);
GEN     kbessel2(GEN nu, GEN x, long prec);
GEN     polylog(long m, GEN x, long prec);
GEN     polylog0(long m, GEN x, long flag, long prec);
GEN     polylogd(long m, GEN x, long prec);
GEN     polylogdold(long m, GEN x, long prec);
GEN     polylogp(long m, GEN x, long prec);
GEN     szeta(long x, long prec);
GEN     theta(GEN q, GEN z, long prec);
GEN     thetanullk(GEN q, long k, long prec);
GEN     trueeta(GEN x, long prec);
GEN     veceint1(GEN nmax, GEN C, long prec);
GEN     vecthetanullk(GEN q, long k, long prec);
GEN     weber0(GEN x, long flag,long prec);
GEN     weberf(GEN x, long prec);
GEN     weberf1(GEN x, long prec);
GEN     weberf2(GEN x, long prec);
