/* 
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) Hewlett-Packard (Paul Bame) paul_bame@hp.com
 */
#undef __KERNEL__
#include "common.h"
#include <linux/types.h>
#include <stddef.h>

#define MAX_FD 20

struct bootfs {
	int	fs_type;
	int	blocksize;
	
	int	(*mount)(long dev, long partition_start, long quiet);

	int	(*open)(const char *filename);
	int	(*bread)(int fd, long blkno, long nblks, char *buf);
	void	(*close)(int fd);
};


/* pdc_misc.c */
void die(const char *);
void firmware_init(int started_wide);
void pdc_default_width(int wide);
int pdc_cons_duplex();
int pdc_iodc_cin(char *buf, int size);
void pdc_iodc_cout(const char *c, int size);
int pdc_os_bits();
#define OS_32 0x2
#define OS_64 0x1
int pdc_iodc_bootin(unsigned devaddr, char *memaddr, unsigned size);
int pdc_read_conspath(unsigned char *memaddr);

typedef void (*describe_t)(int fd, int *bufalign, int *blocksize);
typedef int (*read_t)(int fd, char *buf, unsigned nbytes, unsigned devaddr);

extern int Debug;

extern char *bld_info;

/* pdc_bootio.c */
int pdc_bootdev_open(void);

/* byteio.c */
int byteio_open(int otherfd);

/* fileio.c */
int fileio_open(describe_t describef, read_t readf);
int seekread(int fd, char *buf, unsigned nbytes, unsigned devaddr);
void describe(int fd, int *bufalign, int *blocksize);

/* ext2.c */
int ext2_mount(long cons_dev, long p_offset, long quiet);
int ext2_open(const char *filename);
int ext2_filesize(int fd);

/* lib.c */
void blockprint(int zero_offset, char *buf, int nbytes);
char *malloc_aligned(int nbytes, int align);
char *malloc(int nbytes);
void malloc_init(char *first);
char *strpbrk(const char *cs, const char *ct);
size_t strspn(const char *s, const char *accept);
char *strtok(char *s, const char *ct);
int strncmp(const char *cs, const char *ct, size_t count);
void *memset(void *s, int c, size_t count);
int streq(const char *a, const char *b);
char *strcpy(char *dest, const char *src);
char *strcat(char *dest, const char *src);
void bzero(char *p, size_t len);
void *memcpy(void *d, const void *s, size_t len);
size_t strlen(const char *s);
size_t strnlen(const char *s, size_t count);
extern char *enter_text(char *txt, int maxchars);
extern char * strstr(const char * s1,const char * s2);
extern char * strchr(const char * s, int c);
extern char * strncpy(char * dest,const char *src,size_t count);
extern char * strrchr(const char * s, int c);

/* vsprintf.c */
int vsprintf(char *buf, const char *fmt, va_list args);
int sprintf(char *buf, const char *fmt, ...);

/* pdc_cons.c */
int getchar(void);
void puts(const char *s);
void putchar(char c);
int printf(const char *fmt, ...);

/* offset.c */
int offset_open(int otherfd, int offset, int length);

/* $Id: bootloader.h,v 1.6.2.2 2001/06/13 03:13:15 bame Exp $ */
