#include "mycrypt.h"

#ifdef PACKET

void packet_store_header(unsigned char *dst, int section, int subsection, unsigned long length)
{
   /* store version number */
   dst[0] = CRYPT&255;
   dst[1] = (CRYPT>>8)&255;

   /* store section and subsection */
   dst[2] = section & 255;
   dst[3] = subsection & 255;

   /* store length */
   STORE32L(length, &dst[4]);
}

int packet_valid_header(unsigned char *src, int section, int subsection)
{
   unsigned long ver;

   /* check version */
   ver = ((unsigned long)src[0]) | ((unsigned long)src[1] << 8);
   if (CRYPT < ver) {
      crypt_error = "Invalid version of libtomcrypt for packet given.";
      return CRYPT_ERROR;
   }

   /* check section and subsection */
   if (section != src[2] || subsection != src[3]) {
      crypt_error = "Invalid packet for operation requested.";
      return CRYPT_ERROR;
   }

   return CRYPT_OK;
}

#endif

static const char *ID_TAG = "packet.c";
 
