/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Header;
import org.javagroups.Message;
import org.javagroups.TimeoutException;
import org.javagroups.log.Trace;
import org.javagroups.stack.Protocol;
import org.javagroups.util.Queue;
import org.javagroups.util.QueueClosedException;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PIGGYBACK
extends Protocol {
    long max_wait_time;
    long max_size;
    Queue msg_queue;
    Packer packer;
    boolean packing;
    Address local_addr;

    public String getName() {
        return "PIGGYBACK";
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("max_wait_time");
        if (str != null) {
            this.max_wait_time = new Long(str);
            props.remove("max_wait_time");
        }
        if ((str = props.getProperty("max_size")) != null) {
            this.max_size = new Long(str);
            props.remove("max_size");
        }
        if (props.size() > 0) {
            System.err.println("PIGGYBACK.setProperties(): these properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void start() throws Exception {
        this.startPacker();
    }

    public void stop() {
        this.packing = false;
        this.msg_queue.close(true);
        this.stopPacker();
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                Header obj = msg.getHeader(this.getName());
                if (obj == null || !(obj instanceof PiggybackHeader)) break;
                msg.removeHeader(this.getName());
                try {
                    Vector messages = (Vector)Util.objectFromByteBuffer(msg.getBuffer());
                    if (Trace.trace) {
                        Trace.info("PIGGYBACK.up()", "unpacking " + messages.size() + " messages");
                    }
                    int i = 0;
                    while (i < messages.size()) {
                        this.passUp(new Event(1, messages.elementAt(i)));
                        ++i;
                    }
                }
                catch (Exception e) {
                    Trace.warn("PIGGYBACK.up()", "piggyback message does not contain a vector of piggybacked messages, discarding message ! Exception is " + e);
                    return;
                }
                return;
            }
        }
        this.passUp(evt);
    }

    public void down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                if (msg.getDest() != null && !msg.getDest().isMulticastAddress() || !this.packing) break;
                try {
                    this.msg_queue.add(msg);
                }
                catch (QueueClosedException closed) {
                    break;
                }
                return;
            }
        }
        this.passDown(evt);
    }

    void startPacker() {
        if (this.packer == null) {
            this.packing = true;
            this.packer = new Packer();
            this.packer.start();
        }
    }

    void stopPacker() {
        if (this.packer != null) {
            this.packer.stop();
            this.packing = false;
            this.msg_queue.close(false);
            this.packer = null;
        }
    }

    private final /* synthetic */ void this() {
        this.max_wait_time = 20L;
        this.max_size = 8192L;
        this.msg_queue = new Queue();
        this.packer = null;
        this.packing = false;
        this.local_addr = null;
    }

    public PIGGYBACK() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Packer
    implements Runnable {
        Thread t;

        public void start() {
            if (this.t == null) {
                this.t = new Thread((Runnable)this, "Packer thread");
                this.t.setDaemon(true);
                this.t.start();
            }
        }

        public void stop() {
            this.t = null;
        }

        public void run() {
            long current_size = 0L;
            long time_to_wait = PIGGYBACK.this.max_wait_time;
            while (PIGGYBACK.this.packer != null) {
                try {
                    Message m = (Message)PIGGYBACK.this.msg_queue.remove();
                    m.setSrc(PIGGYBACK.this.local_addr);
                    long start_time = System.currentTimeMillis();
                    current_size = 0L;
                    Message new_msg = new Message();
                    Vector<Message> msgs = new Vector<Message>();
                    msgs.addElement(m);
                    current_size += m.size();
                    while (System.currentTimeMillis() - start_time <= PIGGYBACK.this.max_wait_time && current_size <= PIGGYBACK.this.max_size) {
                        time_to_wait = PIGGYBACK.this.max_wait_time - (System.currentTimeMillis() - start_time);
                        if (time_to_wait <= 0L) break;
                        try {
                            m = (Message)PIGGYBACK.this.msg_queue.peek(time_to_wait);
                            m.setSrc(PIGGYBACK.this.local_addr);
                        }
                        catch (TimeoutException timeout) {
                            break;
                        }
                        if (m == null || m.size() + current_size > PIGGYBACK.this.max_size) break;
                        m = (Message)PIGGYBACK.this.msg_queue.remove();
                        current_size += m.size();
                        msgs.addElement(m);
                    }
                    try {
                        new_msg.putHeader(PIGGYBACK.this.getName(), new PiggybackHeader());
                        new_msg.setBuffer(Util.objectToByteBuffer(msgs));
                        PIGGYBACK.this.passDown(new Event(1, new_msg));
                        if (!Trace.trace) continue;
                        Trace.info("PIGGYBACK.run()", "combined " + msgs.size() + " messages of a total size of " + current_size + " bytes");
                    }
                    catch (Exception e) {
                        Trace.warn("PIGGYBACK.run()", "exception is " + e);
                    }
                }
                catch (QueueClosedException closed) {
                    if (!Trace.trace) break;
                    Trace.info("PIGGYBACK.run()", "packer stopped as queue is closed");
                    break;
                }
            }
        }

        private final /* synthetic */ void this() {
            this.t = null;
        }

        Packer() {
            this.this();
        }
    }

    public static class PiggybackHeader
    extends Header {
        public String toString() {
            return "[PIGGYBACK: <variables> ]";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }
    }
}

