//
// OpenVRML
//
// Copyright (C) 2001  Braden McDaniel
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 

/**
 * @class VrmlNodeVisitor
 *
 * @brief An interface to be implemented by visitors for nodes in a
 *        scene graph.
 */

# include "VrmlNodeVisitor.h"

/**
 * @brief Destructor.
 */
VrmlNodeVisitor::~VrmlNodeVisitor() {}

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeAnchor & node)
 *
 * @brief Visit an Anchor node.
 *
 * @param node an Anchor node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeAppearance & node)
 *
 * @brief Visit an Appearance node.
 *
 * @param node an Appearance node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeAudioClip & node)
 *
 * @brief Visit an AudioClip node.
 *
 * @param node an AudioClip node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeBackground & node)
 *
 * @brief Visit a Background node.
 *
 * @param node a Background node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeBillboard & node)
 *
 * @brief Visit a Billboard node.
 *
 * @param node a Billboard node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeBox & node)
 *
 * @brief Visit a Box node.
 *
 * @param node a Box node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeCollision & node)
 *
 * @brief Visit a Collision node.
 *
 * @param node a Collision node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeColor & node)
 *
 * @brief Visit a Color node.
 *
 * @param node a Color node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeColorInt & node)
 *
 * @brief Visit a ColorInterpolator node.
 *
 * @param node a ColorInterpolator node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeCone & node)
 *
 * @brief Visit a Cone node.
 *
 * @param node a Cone node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeCoordinate & node)
 *
 * @brief Visit a Coordinate node.
 *
 * @param node a Coordinate node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeCoordinateInt & node)
 *
 * @brief Visit a CoordinateInterpolator node.
 *
 * @param node a CoordinateInterpolator node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeCylinder & node)
 *
 * @brief Visit a Cylinder node.
 *
 * @param node a Cylinder node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeCylinderSensor & node)
 *
 * @brief Visit a CylinderSensor node.
 *
 * @param node a CylinderSensor node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeDirLight & node)
 *
 * @brief Visit a DirectionalLight node.
 *
 * @param node a DirectionalLight node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeElevationGrid & node)
 *
 * @brief Visit an ElevationGrid node.
 *
 * @param node an ElevationGrid node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeExtrusion & node)
 *
 * @brief Visit an Extrusion node.
 *
 * @param node an Extrusion node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeFog & node)
 *
 * @brief Visit a Fog node.
 *
 * @param node a Fog node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeFontStyle & node)
 *
 * @brief Visit a FontStyle node.
 *
 * @param node a FontStyle node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeGroup & node)
 *
 * @brief Visit a Group node.
 *
 * @param node a Group node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeIFaceSet & node)
 *
 * @brief Visit an IndexedFaceSet node.
 *
 * @param node an IndexedFaceSet node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeILineSet & node)
 *
 * @brief Visit an IndexedLineSet node.
 *
 * @param node an IndexedLineSet node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeImageTexture & node)
 *
 * @brief Visit an ImageTexture node.
 *
 * @param node an ImageTexture node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeInline & node)
 *
 * @brief Visit an Inline node.
 *
 * @param node an Inline node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeLOD & node)
 *
 * @brief Visit a LOD node.
 *
 * @param node a LOD node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeMaterial & node)
 *
 * @brief Visit a Material node.
 *
 * @param node a Material node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeMovieTexture & node)
 *
 * @brief Visit a MovieTexture node.
 *
 * @param node a MovieTexture node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeNavigationInfo & node)
 *
 * @brief Visit a NavigationInfo node.
 *
 * @param node a NavigationInfo node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeNormal & node)
 *
 * @brief Visit a Normal node.
 *
 * @param node a Normal node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeNormalInt & node)
 *
 * @brief Visit a NormalInterpolator node.
 *
 * @param node a NormalInterpolator node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeOrientationInt & node)
 *
 * @brief Visit an OrientationInterpolator node.
 *
 * @param node an OrientationInterpolator node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodePixelTexture & node)
 *
 * @brief Visit a PixelTexture node.
 *
 * @param node a PixelTexture node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodePlaneSensor & node)
 *
 * @brief Visit a PlaneSensor node.
 *
 * @param node a PlaneSensor node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodePointLight & node)
 *
 * @brief Visit a PointLight node.
 *
 * @param node a PointLight node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodePointSet & node)
 *
 * @brief Visit a PointSet node.
 *
 * @param node a PointSet node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodePositionInt & node)
 *
 * @brief Visit a PositionInterpolator node.
 *
 * @param node a PositionInterpolator node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeProto & node)
 *
 * @brief Visit a PROTO instantiation node.
 *
 * @param node a PROTO instantiation node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeProximitySensor & node)
 *
 * @brief Visit a ProximitySensor node.
 *
 * @param node a ProximitySensor node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeScalarInt & node)
 *
 * @brief Visit a ScalarInterpolator node.
 *
 * @param node a ScalarInterpolator node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeScript & node)
 *
 * @brief Visit a Script node.
 *
 * @param node a Script node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeShape & node)
 *
 * @brief Visit a Shape node.
 *
 * @param node a Shape node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeSound & node)
 *
 * @brief Visit a Sound node.
 *
 * @param node a Sound node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeSphere & node)
 *
 * @brief Visit a Sphere node.
 *
 * @param node a Sphere node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeSphereSensor & node)
 *
 * @brief Visit a SphereSensor node.
 *
 * @param node a SphereSensor node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeSpotLight & node)
 *
 * @brief Visit a SpotLight node.
 *
 * @param node a SpotLight node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeSwitch & node)
 *
 * @brief Visit a Switch node.
 *
 * @param node a Switch node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeText & node)
 *
 * @brief Visit a Text node.
 *
 * @param node a Text node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeTextureCoordinate & node)
 *
 * @brief Visit a TextureCoordinate node.
 *
 * @param node a TextureCoordinate node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeTextureTransform & node)
 *
 * @brief Visit a TextureTransform node.
 *
 * @param node a TextureTransform node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeTimeSensor & node)
 *
 * @brief Visit a TimeSensor node.
 *
 * @param node a TimeSensor node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeTouchSensor & node)
 *
 * @brief Visit a TouchSensor node.
 *
 * @param node a TouchSensor node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeTransform & node)
 *
 * @brief Visit a Transform node.
 *
 * @param node a Transform node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeViewpoint & node)
 *
 * @brief Visit a Viewpoint node.
 *
 * @param node a Viewpoint node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeVisibilitySensor & node)
 *
 * @brief Visit a VisibilitySensor node.
 *
 * @param node a VisibilitySensor node.
 */

/**
 * @fn void VrmlNodeVisitor::visit(VrmlNodeWorldInfo & node)
 *
 * @brief Visit a WorldInfo node.
 *
 * @param node a WorldInfo node.
 */
