#!/usr/bin/wish
#
# OpenVerse Main Module 
# 
# this file initalizes the program and does any
# platform specific things/setup. It will then source 
# supporting modules.
#
# Module Name		- Main Module
# Current Maintainter 	- Cruise <cruise@openverse.org>
# Sourced By		- Command Line
#
# Copyright (C) 1999-2001 David Gale <cruise@openverse.org>
# For more information visit http://OpenVerse.org/
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
# USA.

# NOTE
# Performance enhancements using string compare


global MV MVS
#Performance Enhancement DRG
if {[string compar $argv0 ""]} {
	set app "$argv0"
} else {
	set app [pwd]
}

catch { set app [file readlink "$app"] }


switch [array get tcl_platform platform] {
	"platform macintosh" {
		#
		# This seems to work if you put the wish
		# binary in the dir you are starting from.
		#
		set MV(homedir) "."
		set MV(libdir) "$MV(homedir)/lib"
		set MV(libbase) "$MV(homedir)"
		set MV(helpdir) "$MV(homedir)/help"
		source [file nativename "$MV(libdir)/Globals.tcl"]
		proc List_Avatars {} {
			global MV
			set avatars [lsort -ascii [glob -nocomplain [file nativename "$MV(anims)/*"]]]
			return $avatars
		}
		proc List_Plugins {} {
			global MV
			set plugins [lsort -ascii [glob -nocomplain [file nativename "$MV(plugindir)/*"]]]
			return $plugins
		}
		proc List_Images {} {
			global MV
			set images [lsort -ascii [glob -nocomplain [file nativename "$MV(images)/*"]]]
			return $images
		}
		proc List_Rimages {} {
			global MV
			set images [lsort -ascii [glob -nocomplain [file nativename "$MV(rem_images)/*"]]]
			return $images
		}
		proc List_Panels {} {
			global MV
			set panels [lsort -ascii [glob -nocomplain [file nativename "$MV(paneldir)/*"]]]
			return $panels
		}
		proc List_Languages {} {
			global MV
			set languages [lsort -ascii [glob -nocomplain [file nativename "$MV(languagedir)/*"]]]
			return $languages
		}
	} 
	"platform unix" {
		global env

		# check environment variable OVRUNDIR
		if {[info exists env(OVRUNDIR)] == 0} {
			# not set, use standard
			set OvRunDir /usr/lib/OpenVerse
		} else {
			# it's set, run from there
			set OvRunDir $env(OVRUNDIR)
			puts "Running from $OvRunDir"
		}

		#
		# UNIX just rules, this should take care of all
		# startup problems for this platform including user
		# errors.
		set MV(homedir) "~/.OpenVerse"
		set MV(libdir) "$OvRunDir/lib"
		set MV(libbase) "$OvRunDir"
		set MV(helpdir) "$MV(libbase)/help"
		source [file nativename "$MV(libdir)/Globals.tcl"]
		#
		# FORCE UPGRADE!
		#
		#Performance Enhancement DRG
		if {[file exists "$MV(homedir)/plugins/Query"]} {
			catch {file delete -force "$MV(homedir)/plugins/Query"}
		}
		#Performance Enhancement DRG
		if {![file exists "$MV(homedir)"]} {
			file mkdir $MV(homedir)
			file mkdir $MV(homedir)/images
			file mkdir $MV(homedir)/rimages
			file mkdir $MV(homedir)/simages
			file mkdir $MV(homedir)/anims
			file mkdir $MV(homedir)/rooms
			file mkdir $MV(homedir)/plugins
			file mkdir $MV(homedir)/plugins/Query
			file mkdir $MV(homedir)/objects
			file mkdir $MV(homedir)/icons
			file mkdir $MV(homedir)/download
			file copy "$MV(libbase)/images/default.gif" "$MV(homedir)/images"
			file copy "$MV(libbase)/images/bob.gif" "$MV(homedir)/images"
			file copy "$MV(libbase)/images/devil.gif" "$MV(homedir)/images"
			file copy "$MV(libbase)/anims/default.av" "$MV(homedir)/anims"
			file copy "$MV(libbase)/anims/Bob.av" "$MV(homedir)/anims"
			file copy "$MV(libbase)/anims/BSDdevil.av" "$MV(homedir)/anims"
			file copy "$MV(libbase)/plugins/Query/PlugInit.tcl" "$MV(homedir)/plugins/Query"
			file copy "$MV(libbase)/icons/room.gif" "$MV(homedir)/icons"
			file copy "$MV(libbase)/icons/unknown.gif" "$MV(homedir)/icons/"
			file copy "$MV(libbase)/icons/smile.gif" "$MV(homedir)/icons/"
			file copy "$MV(libbase)/icons/vhandle.mask" "$MV(homedir)/icons/"
			file copy "$MV(libbase)/icons/vhandle.xbm" "$MV(homedir)/icons/"
			file copy "$MV(libbase)/icons/hhandle.mask" "$MV(homedir)/icons/"
			file copy "$MV(libbase)/icons/hhandle.xbm" "$MV(homedir)/icons/"
			file copy "$MV(libbase)/icons/wink.gif" "$MV(homedir)/icons/"
			file copy "$MV(libbase)/icons/frown.gif" "$MV(homedir)/icons/"
			file copy "$MV(libbase)/icons/loading.gif" "$MV(homedir)/icons/"
			file copy "$MV(libbase)/icons/notes.gif" "$MV(homedir)/icons"
			file copy "$MV(libbase)/icons/bulb.gif" "$MV(homedir)/icons"
			file copy "$MV(libbase)/icons/steam.gif" "$MV(homedir)/icons"
			file copy "$MV(libbase)/icons/hearts.gif" "$MV(homedir)/icons"
			file copy "$MV(libbase)/icons/wwwurl.gif" "$MV(homedir)/icons/wwwurl.gif"
			file copy "$MV(libbase)/icons/ftpurl.gif" "$MV(homedir)/icons/ftpurl.gif"
			file copy "$MV(libbase)/icons/emailurl.gif" "$MV(homedir)/icons/emailurl.gif"
			file copy "$MV(libbase)/icons/dccfile.gif" "$MV(homedir)/icons/dccfile.gif"
			file copy "$MV(libbase)/icons/mv2.xbm" "$MV(homedir)/icons/mv2.xbm"
			file copy "$MV(libbase)/icons/mv2.xpm" "$MV(homedir)/icons/mv2.xpm"
			file copy "$MV(libbase)/icons/mv2.gif" "$MV(homedir)/icons/mv2.gif"
			file copy "$MV(libbase)/icons/log.gif" "$MV(homedir)/icons/"
			file copy "$MV(libbase)/icons/rubber.gif" "$MV(homedir)/icons/"
			file copy "$MV(libbase)/icons/jump.gif" "$MV(homedir)/icons/"
			file copy "$MV(libbase)/icons/shiver.gif" "$MV(homedir)/icons/"
			file copy "$MV(libbase)/icons/shutdown.gif" "$MV(homedir)/icons/"
			file copy "$MV(libbase)/icons/pinfo.gif" "$MV(homedir)/icons/"
			file copy "$MV(libbase)/icons/unlocked.gif" "$MV(homedir)/icons/unlocked.gif"
			file copy "$MV(libbase)/icons/locked.gif" "$MV(homedir)/icons/locked.gif"
			file copy "$MV(libbase)/icons/default.gif" "$MV(homedir)/icons/default.gif"
		}
		if {![file exists $MV(homedir)/simages]} {
			file mkdir $MV(homedir)/simages
		}
		if {![file exists $MV(homedir)/images]} {
			file mkdir $MV(homedir)/images
			file copy "$MV(libbase)/images/default.gif" "$MV(homedir)/images"
			file copy "$MV(libbase)/images/bob.gif" "$MV(homedir)/images"
			file copy "$MV(libbase)/images/devil.gif" "$MV(homedir)/images"
			file copy "$MV(libbase)/images/ov_tram_logo.gif" "$MV(homedir)/images"
		}
		if {![file exists $MV(homedir)/icons]} {
			file mkdir $MV(homedir)/icons
			file copy "$MV(libbase)/icons/smile.gif" "$MV(homedir)/icons/"
			file copy "$MV(libbase)/icons/vhandle.mask" "$MV(homedir)/icons/"
			file copy "$MV(libbase)/icons/vhandle.xbm" "$MV(homedir)/icons/"
			file copy "$MV(libbase)/icons/hhandle.mask" "$MV(homedir)/icons/"
			file copy "$MV(libbase)/icons/hhandle.xbm" "$MV(homedir)/icons/"
			file copy "$MV(libbase)/icons/wink.gif" "$MV(homedir)/icons/"
			file copy "$MV(libbase)/icons/frown.gif" "$MV(homedir)/icons/"
			file copy "$MV(libbase)/icons/hearts.gif" "$MV(homedir)/icons"
			file copy "$MV(libbase)/icons/loading.gif" "$MV(homedir)/icons/"
			file copy "$MV(libbase)/icons/notes.gif" "$MV(homedir)/icons"
			file copy "$MV(libbase)/icons/bulb.gif" "$MV(homedir)/icons"
			file copy "$MV(libbase)/icons/steam.gif" "$MV(homedir)/icons"
			file copy "$MV(libbase)/icons/unknown.gif" "$MV(homedir)/icons/unknown.gif"
			file copy "$MV(libbase)/icons/dccfile.gif" "$MV(homedir)/icons/dccfile.gif"
			file copy "$MV(libbase)/icons/mv2.xpm" "$MV(homedir)/icons/mv2.xpm"
			file copy "$MV(libbase)/icons/mv2.xbm" "$MV(homedir)/icons/mv2.xbm"
			file copy "$MV(libbase)/icons/mv2.gif" "$MV(homedir)/icons/mv2.gif"
			file copy "$MV(libbase)/icons/log.gif" "$MV(homedir)/icons/"
			file copy "$MV(libbase)/icons/rubber.gif" "$MV(homedir)/icons/"
			file copy "$MV(libbase)/icons/jump.gif" "$MV(homedir)/icons/"
			file copy "$MV(libbase)/icons/shiver.gif" "$MV(homedir)/icons/"
			file copy "$MV(libbase)/icons/shutdown.gif" "$MV(homedir)/icons/"
			file copy "$MV(libbase)/icons/pinfo.gif" "$MV(homedir)/icons/"
			file copy "$MV(libbase)/icons/unlocked.gif" "$MV(homedir)/icons/unlocked.gif"
			file copy "$MV(libbase)/icons/locked.gif" "$MV(homedir)/icons/locked.gif"
			file copy "$MV(libbase)/icons/wwwurl.gif" "$MV(homedir)/icons/wwwurl.gif"
			file copy "$MV(libbase)/icons/ftpurl.gif" "$MV(homedir)/icons/ftpurl.gif"
			file copy "$MV(libbase)/icons/emailurl.gif" "$MV(homedir)/icons/emailurl.gif"
			file copy "$MV(libbase)/icons/default.gif" "$MV(homedir)/icons/default.gif"
		}
		if {![file exists $MV(homedir)/icons/dccfile.gif]} {
			file copy "$MV(libbase)/icons/dccfile.gif" "$MV(homedir)/icons/dccfile.gif"
		}
		if {![file exists $MV(homedir)/icons/room.gif]} {
			file copy "$MV(libbase)/icons/room.gif" "$MV(homedir)/icons/room.gif"
		}
		if {![file exists $MV(homedir)/icons/notes.gif]} {
			file copy "$MV(libbase)/icons/notes.gif" "$MV(homedir)/icons"
		}
		if {![file exists $MV(homedir)/icons/loading.gif]} {
			file copy "$MV(libbase)/icons/loading.gif" "$MV(homedir)/icons"
		}
		if {![file exists $MV(homedir)/icons/bulb.gif]} {
			file copy "$MV(libbase)/icons/bulb.gif" "$MV(homedir)/icons"
		}
		if {![file exists $MV(homedir)/icons/steam.gif]} {
			file copy "$MV(libbase)/icons/steam.gif" "$MV(homedir)/icons"
		}
		if {![file exists $MV(homedir)/icons/smile.gif]} {
			file copy "$MV(libbase)/icons/smile.gif" "$MV(homedir)/icons"
		}
		if {![file exists $MV(homedir)/icons/vhandle.mask]} {
			file copy "$MV(libbase)/icons/vhandle.mask" "$MV(homedir)/icons"
		}
		if {![file exists $MV(homedir)/icons/vhandle.xbm]} {
			file copy "$MV(libbase)/icons/vhandle.xbm" "$MV(homedir)/icons"
		}
		if {![file exists $MV(homedir)/icons/hhandle.mask]} {
			file copy "$MV(libbase)/icons/hhandle.mask" "$MV(homedir)/icons"
		}
		if {![file exists $MV(homedir)/icons/hhandle.xbm]} {
			file copy "$MV(libbase)/icons/hhandle.xbm" "$MV(homedir)/icons"
		}
		if {![file exists $MV(homedir)/icons/wink.gif]} {
			file copy "$MV(libbase)/icons/wink.gif" "$MV(homedir)/icons"
		}
		if {![file exists $MV(homedir)/icons/frown.gif]} {
			file copy "$MV(libbase)/icons/frown.gif" "$MV(homedir)/icons"
		}
		if {![file exists $MV(homedir)/icons/hearts.gif]} {
			file copy "$MV(libbase)/icons/hearts.gif" "$MV(homedir)/icons"
		}
		if {![file exists $MV(homedir)/icons/default.gif]} {
			file copy "$MV(libbase)/icons/default.gif" "$MV(homedir)/icons/default.gif"
		}
		if {![file exists $MV(homedir)/icons/unlocked.gif]} {
			file copy "$MV(libbase)/icons/unlocked.gif" "$MV(homedir)/icons/unlocked.gif"
		}
		if {![file exists $MV(homedir)/icons/log.gif]} {
			file copy "$MV(libbase)/icons/log.gif" "$MV(homedir)/icons/"
		}
		if {![file exists $MV(homedir)/icons/rubber.gif]} {
			file copy "$MV(libbase)/icons/rubber.gif" "$MV(homedir)/icons/"
		}
		if {![file exists $MV(homedir)/icons/pinfo.gif]} {
			file copy "$MV(libbase)/icons/pinfo.gif" "$MV(homedir)/icons/"
		}
		if {![file exists $MV(homedir)/icons/locked.gif]} {
			file copy "$MV(libbase)/icons/locked.gif" "$MV(homedir)/icons/locked.gif"
		}
		if {![file exists $MV(homedir)/icons/unknown.gif]} {
			file copy "$MV(libbase)/icons/unknown.gif" "$MV(homedir)/icons/unknown.gif"
		}
		if {![file exists $MV(homedir)/icons/wwwurl.gif]} {
			file copy "$MV(libbase)/icons/wwwurl.gif" "$MV(homedir)/icons/wwwurl.gif"
		}
		if {![file exists $MV(homedir)/icons/ftpurl.gif]} {
			file copy "$MV(libbase)/icons/ftpurl.gif" "$MV(homedir)/icons/ftpurl.gif"
		}
		if {![file exists $MV(homedir)/icons/emailurl.gif]} {
			file copy "$MV(libbase)/icons/emailurl.gif" "$MV(homedir)/icons/emailurl.gif"
		}
		if {![file exists $MV(homedir)/icons/mv2.gif]} {
			file copy "$MV(libbase)/icons/mv2.gif" "$MV(homedir)/icons/mv2.gif"
		}
		if {![file exists $MV(homedir)/icons/mv2.xpm]} {
			file copy "$MV(libbase)/icons/mv2.xpm" "$MV(homedir)/icons/mv2.xpm"
		}
		if {![file exists $MV(homedir)/icons/mv2.xbm]} {
			file copy "$MV(libbase)/icons/mv2.xbm" "$MV(homedir)/icons/mv2.xbm"
		}
		if {![file exists $MV(homedir)/icons/jump.gif]} {
			file copy "$MV(libbase)/icons/jump.gif" "$MV(homedir)/icons/jump.gif"
		}
		if {![file exists $MV(homedir)/icons/shiver.gif]} {
			file copy "$MV(libbase)/icons/shiver.gif" "$MV(homedir)/icons/shiver.gif"
		}
		if {![file exists $MV(homedir)/icons/shutdown.gif]} {
			file copy "$MV(libbase)/icons/shutdown.gif" "$MV(homedir)/icons/shutdown.gif"
		}
		if {![file exists $MV(homedir)/panels]} {
			file mkdir $MV(homedir)/panels
		}
		if {![file exists "$MV(homedir)/panels/Fun"]} {
			file copy "$MV(libbase)/panels/Fun" "$MV(homedir)/panels"
		}
		if {![file exists "$MV(homedir)/panels/NotFun"]} {
			file copy "$MV(libbase)/panels/NotFun" "$MV(homedir)/panels"
		}
		if {![file exists "$MV(homedir)/panels/Pro"]} {
			file copy "$MV(libbase)/panels/Pro" "$MV(homedir)/panels"
		}
		if {![file exists $MV(homedir)/plugins]} {
			file mkdir $MV(homedir)/plugins
			file mkdir $MV(homedir)/plugins/Query
			file copy "$MV(libbase)/plugins/Query/PlugInit.tcl" "$MV(homedir)/plugins/Query"
		}
		if {![file exists $MV(homedir)/plugins/Query]} {
			file mkdir $MV(homedir)/plugins/Query
			file copy "$MV(libbase)/plugins/Query/PlugInit.tcl" "$MV(homedir)/plugins/Query"
		}
		if {![file exists $MV(homedir)/plugins/Query/PlugInit.tcl]} {
			file copy "$MV(libbase)/plugins/Query/PlugInit.tcl" "$MV(homedir)/plugins/Query"
		}
		if {![file exists $MV(homedir)/anims]} {
			file mkdir $MV(homedir)/anims
			file copy "$MV(libbase)/anims/default.av" "$MV(homedir)/anims"
			file copy "$MV(libbase)/anims/Bob.av" "$MV(homedir)/anims"
			file copy "$MV(libbase)/anims/BSDdevil.av" "$MV(homedir)/anims"
		}
		if {![file exists $MV(homedir)/rooms]} {
			file mkdir $MV(homedir)/rooms
		}
		if {![file exists $MV(homedir)/images/default.gif]} {
			file copy "$MV(libbase)/images/default.gif" "$MV(homedir)/images"
		}
		if {![file exists $MV(homedir)/images/ov_tram_logo.gif]} {
			file copy "$MV(libbase)/images/ov_tram_logo.gif" "$MV(homedir)/images"
		}
		if {![file exists $MV(homedir)/images/bob.gif]} {
			file copy "$MV(libbase)/images/bob.gif" "$MV(homedir)/images"
		}
		if {![file exists $MV(homedir)/images/devil.gif]} {
			file copy "$MV(libbase)/images/devil.gif" "$MV(homedir)/images"
		}
		if {![file exists $MV(homedir)/anims/default.av]} {
			file copy "$MV(libbase)/anims/default.av" "$MV(homedir)/anims"
		}
		if {![file exists $MV(homedir)/anims/Bob.av]} {
			file copy "$MV(libbase)/anims/Bob.av" "$MV(homedir)/anims"
		}
		if {![file exists $MV(homedir)/anims/BSDdevil.av]} {
			file copy "$MV(libbase)/anims/BSDdevil.av" "$MV(homedir)/anims"
		}
		wm iconbitmap . @$MV(homedir)/icons/mv2.xbm
		proc List_Avatars {} {
			global MV
			set avatars [lsort -ascii [glob -nocomplain "$MV(anims)/*"]]
			return $avatars
		}
		proc List_Rimages {} {
			global MV
			set images [lsort -ascii [glob -nocomplain "$MV(rem_images)/*"]]
			return $images
		}
		proc List_Plugins {} {
			global MV
			set plugins [lsort -ascii [glob -nocomplain "$MV(plugindir)/*"]]
			return $plugins
		}
		proc List_Panels {} {
			global MV
			set panels [lsort -ascii [glob -nocomplain "$MV(paneldir)/*"]]
			return $panels
		}
		proc List_Languages {} {
			global MV
			set languages [lsort -ascii [glob -nocomplain "$MV(languagedir)/*"]]
			return $languages
		}
	}
	default {
		#
		# Windows! This section needs some more work
		# since windows does not really support a safe
		# central location for OpenVerse, there is really
		# no way to protect against users who delete things.
		#
		set MV(homedir) "[file dirname "$app"]"
		set MV(libdir) "$MV(homedir)/lib"
		set MV(libbase) "$MV(homedir)"
		set MV(helpdir) "$MV(homedir)/help"
		source [file nativename "$MV(libdir)/Globals.tcl"]
		#wm iconbitmap . @$MV(homedir)/icons/mv2.ico
		proc List_Avatars {} {
			global MV
			set avatars [lsort -ascii [glob -nocomplain "$MV(anims)/*"]]
			return $avatars
		}
		proc List_Plugins {} {
			global MV
			set plugins [lsort -ascii [glob -nocomplain "$MV(plugindir)/*"]]
			return $plugins
		}
		proc List_Images {} {
			global MV
			set images [lsort -ascii [glob -nocomplain "$MV(images)/*"]]
			return $images
		}
		proc List_Rimages {} {
			global MV
			set images [lsort -ascii [glob -nocomplain "$MV(rem_images)/*"]]
			return $images
		}
		proc List_Panels {} {
			global MV
			set panels [lsort -ascii [glob -nocomplain "$MV(paneldir)/*"]]
			return $panels
		}
		proc List_Languages {} {
			global MV
			set languages [lsort -ascii [glob -nocomplain "$MV(languagedir)/*"]]
			return $languages
		}
	}
} 

if {![file exists "$MV(homedir)/rimages"]} {file mkdir "$MV(homedir)/rimages"}
if {![file exists "$MV(homedir)/download"]} {file mkdir "$MV(homedir)/download"}
if {![file exists "$MV(homedir)/objects"]} {file mkdir "$MV(homedir)/objects"}
if {![file exists "$MV(homedir)/simages"]} {file mkdir "$MV(homedir)/simages"}

source [file nativename "$MV(libdir)/IOFuncs.tcl"]
source [file nativename "$MV(libdir)/BaseFunc.tcl"]
source [file nativename "$MV(libdir)/InitMain.tcl"]

update

#
# A filename can be passed on the command line. If we were
# given one, read it in and connect to the host listed in it.
#
# CRUISE - 10/25/2001 - bug fix for windows arguments which may include spaces
#	and / or backslashes in the argument. This seems to make it work now.
#
if {[string compare $argv ""] != 0} {
	if {[string first "\}" $argv] != -1} {
		set narg [join $argv " "]
	} else {
		set narg $argv
	}
	set infile [open [file nativename $narg] r]
	gets $infile input
	close $infile
	set parms [split $input ":"]
	ConnectToRoom [lindex $parms 0] [lindex $parms 1]
}
