//                                               -*- C++ -*-
/**
 *  @file  t_NearestPointChecker_std.cxx
 *  @brief The test file of class NearestPointChecker for standard methods
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: t_NearestPointChecker_std.cxx 2392 2012-02-17 18:35:43Z schueller $
 */
#include <iostream>
#include <sstream>
#include <exception>
#include <cmath>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "NumericalMathFunction.hxx"
#include "Exception.hxx"
#include "NumericalSample.hxx"
#include "LessOrEqual.hxx"
#include "NearestPointChecker.hxx"

using namespace OT;
using namespace OT::Test;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {

    try {
      // Function
      UnsignedLong sampleSize(20);
      NumericalMathFunction levelFunction("TestOptimLinear");
      LessOrEqual myOperator;
      NumericalScalar threshold(2.0);
      NumericalSample mySample(0, levelFunction.getInputDimension());
      NumericalScalar random(0.1);
      for(UnsignedLong index = 0; index < sampleSize; index++)
        {
          NumericalPoint point(levelFunction.getInputDimension());
          NumericalScalar norm(0.0);
          for(UnsignedLong coordinate = 0; coordinate < levelFunction.getInputDimension(); coordinate++)
            {
              point[coordinate] = sqrt(-2.0*log(random));
              random = fmod(random+sqrt(2.0), 1.0);
              point[coordinate] *= cos(2.0*atan(1.0)*random);
              norm += point[coordinate] * point[coordinate];
            }
          for(UnsignedLong coordinate = 0; coordinate < levelFunction.getInputDimension(); coordinate++)
            {
              point[coordinate] /= sqrt(norm);
            }
          mySample.add(point);
        }
      NearestPointChecker myNearestPointChecker(levelFunction, myOperator, threshold, mySample);
      for(UnsignedLong index = 0; index < sampleSize; index++)
        {
          fullprint << mySample[index] << std::endl;
        }
      myNearestPointChecker.run();
      fullprint << "myNearestPointChecker = " << myNearestPointChecker << std::endl;
    }
    catch (NoWrapperFileFoundException & ex) {
      throw TestFailed(ex.__repr__());
    }


  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }

  return ExitCode::Success;
}
