//                                               -*- C++ -*-
/**
 *  @file  t_NatafIndependentCopulaGradient_std.cxx
 *  @brief The test file of class NatafIndependentCopulaGradient for standard methods
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: t_NatafIndependentCopulaGradient_IndependentCopula.cxx 1262 2009-05-28 12:47:53Z dutka $
 */
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "Matrix.hxx"
#include "NumericalPoint.hxx"
#include "NatafIndependentCopulaGradient.hxx"

using namespace OT;
using namespace OT::Test;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);
  setRandomGenerator();

  try {
    UnsignedLong dim(2);
    NatafIndependentCopulaGradient transformation(dim);
    fullprint << "transformation=" << transformation << std::endl;
    NumericalPoint point(dim, 0.75);
    fullprint << "transformation(" << point << ")=" << transformation.gradient(point) << std::endl;
    fullprint << "input dimension=" << transformation.getInputDimension() << std::endl;
    fullprint << "output dimension=" << transformation.getOutputDimension() << std::endl;
  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
