//                                               -*- C++ -*-
/**
 *  @file  GammaFactory.hxx
 *  @brief Factory for Gamma distribution
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: GammaFactory.hxx 2392 2012-02-17 18:35:43Z schueller $
 */
#ifndef OPENTURNS_GAMMAFACTORY_HXX
#define OPENTURNS_GAMMAFACTORY_HXX

#include "OTprivate.hxx"
#include "DistributionImplementationFactory.hxx"
#include "Gamma.hxx"

BEGIN_NAMESPACE_OPENTURNS



/**
 * @class GammaFactory
 */
class GammaFactory
  : public DistributionImplementationFactory
{
public:

  /** Default constructor */
  GammaFactory();

  /** Virtual constructor */
  virtual GammaFactory * clone() const;

  /* Here is the interface that all derived class must implement */
  using DistributionImplementationFactory::build;

  Gamma * build(const NumericalSample & sample) const;
  Gamma * build(const NumericalPointCollection & parameters) const;
  Gamma * build() const;


}; /* class GammaFactory */


END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_GAMMAFACTORY_HXX */
