// SWIG file base_all.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2010-02-09 12:30:08 +0100 (mar. 09 févr. 2010) $
// Id : $Id: base_all.i 1477 2010-02-09 11:30:08Z dutka $

%module(docstring="Base is the determnistic part of Open TURNS.") base
#pragma SWIG nowarn=314
%feature("autodoc","1");

%pythoncode %{
#from openturns.viewer import ViewImage,StopViewer,WaitForViewer

def TESTPREAMBLE():
  """
  TESTPREAMBLE() catches the --version argument on the command line,
  prints a identification string and then exits softly.
  """
  import sys
  if "--version" in sys.argv:
    print sys.argv[0] + " : $Id: base_all.i 1477 2010-02-09 11:30:08Z dutka $"
    sys.exit(0)
%}

// Use rpy version 2
// Win32 rpy 2 cannot be installed on Linux build machine (Wine)
#if (defined(HAVE_PYTHON_PACKAGE_RPY2) && HAVE_PYTHON_PACKAGE_RPY2) || (defined(HAVE_WIN32) && HAVE_WIN32)
%pythoncode %{
def Show(graph):
  from openturns import Graph, GraphImplementation, Drawable, DrawableImplementation
  try :
    if (Graph(graph).getClassName()=="Graph"):
      import rpy2.robjects as robjects
      tmp=robjects.r(graph.getRCommand())
      graph.clean()
  except :
    try :
      if (Drawable(graph).getClassName()=="Drawable"):
        import rpy2.robjects as robjects
        tmp=robjects.r(graph.draw())
        graph.clean()
    except :
      import sys
      print "Error in Show", sys.exc_type, sys.exc_value
%}
#else /* HAVE_PYTHON_PACKAGE_RPY2 */
%pythoncode %{
def Show(graph):
  raise NotImplementedError, "Show() is not available. You need to install rpy2 python module and rebuild Open TURNS to have this work"
%}
#endif /* HAVE_PYTHON_PACKAGE_RPY2 */

%{
#include "OT.hxx"
%}

%include typemaps.i
%include OTtypes.i
%include OTexceptions.i
%include std_vector.i

/* Base/Common */
%import base_common.i

/* Wrapper */
%import base_wrapper.i
%import BaseWrapperTemplateDefs.i

/* Base/Type */
%import base_type.i
%import BaseTypeTemplateDefs.i

/* Base/Stat */
%import base_stat.i
%import BaseStatTemplateDefs.i

/* Base/Graph */
%import base_graph.i
%import BaseGraphTemplateDefs.i

/* Base/Func */
%import base_func.i
%import BaseFuncTemplateDefs.i

/* Base/Diff */
%import base_diff.i
%import BaseDiffTemplateDefs.i

/* Base/Optim */
%import base_optim.i
%import BaseOptimTemplateDefs.i

/* Base/Solver */
%import base_solver.i
%import BaseSolverTemplateDefs.i

/* At last we include template definitions */
%include BaseTemplateDefs.i
