//                                               -*- C++ -*-
/**
 *  @file  NormalityTest.hxx
 *  @brief StatTest implements statistical tests
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: NormalityTest.hxx 1473 2010-02-04 15:44:49Z dutka $
 */
#ifndef OPENTURNS_NORMALITYTEST_HXX
#define OPENTURNS_NORMALITYTEST_HXX

#include "OTprivate.hxx"
#include "Exception.hxx"
#include "TestResult.hxx"
#include "NumericalSample.hxx"

namespace OpenTURNS
{
  namespace Uncertainty
  {
    namespace StatTest
    {

      /**
       * @class NormalityTest
       *
       */

      class NormalityTest
      {
      public:
        typedef Base::Common::InternalException         InternalException;
	typedef Base::Stat::TestResult                  TestResult;
	typedef Base::Stat::NumericalSample             NumericalSample;

	/** Default constructor */
	NormalityTest();

	/** Anderson Darling normality test for normal distributions. */
	static TestResult AndersonDarlingNormal(const NumericalSample & sample,
						const NumericalScalar level=0.95);

	/** Cramer Von Mises normality test for normal distributions. */
	static TestResult CramerVonMisesNormal(const NumericalSample & sample,
					       const NumericalScalar level=0.95);

      }; /* class NormalityTest */

    } /* namespace StatTest */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
#endif /* OPENTURNS_NORMALITYTEST_HXX */
