//                                               -*- C++ -*-
/**
 *  @file  DirectionalSampling.hxx
 *  @brief DirectionalSampling is an implementation of the directional sampling Montex Carlo simulation method
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: DirectionalSampling.hxx 1473 2010-02-04 15:44:49Z dutka $
 */
#ifndef OPENTURNS_DIRECTIONALSAMPLING_HXX
#define OPENTURNS_DIRECTIONALSAMPLING_HXX

#include "Simulation.hxx"
#include "Distribution.hxx"
#include "StandardEvent.hxx"
#include "RootStrategy.hxx"
#include "SamplingStrategy.hxx"

namespace OpenTURNS
{

  namespace Uncertainty 
  {

    namespace Algorithm
    {

      /**
       * @class DirectionalSampling
       */

      class DirectionalSampling :
	public Simulation
      {
	CLASSNAME;
      public:

	typedef Simulation::NumericalSample             NumericalSample;
	typedef Simulation::InvalidArgumentException    InvalidArgumentException;
	typedef Simulation::Event                       Event;
	typedef RootStrategy::NumericalScalarCollection NumericalScalarCollection;
	typedef Base::Func::NumericalMathFunction       NumericalMathFunction;
	typedef Model::Distribution                     Distribution;
	typedef Model::StandardEvent                    StandardEvent;
	typedef Distribution::Implementation            Implementation;

	/** Constructor with parameters */
	DirectionalSampling(const Simulation::Event & event)
	  throw(InvalidArgumentException);

	/** Constructor with parameters */
	DirectionalSampling(const Simulation::Event & event,
			    const RootStrategy & rootStrategy,
			    const SamplingStrategy & samplingStrategy)
          throw(InvalidArgumentException);


	/** Virtual constructor */
	virtual DirectionalSampling * clone() const;

	/** Root strategy accessor */
	void setRootStrategy(const RootStrategy & rootStrategy);
	RootStrategy getRootStrategy() const;

	/** Sampling strategy */
	void setSamplingStrategy(const SamplingStrategy & samplingStrategy);
	SamplingStrategy getSamplingStrategy() const;

	/** String converter */
	String __repr__() const;

      private:
	
	/** Compute the block sample */
	NumericalSample computeBlockSample();

        /** Compute the contribution of a direction to the probability given the roots of the performance function along the direction */
        NumericalScalar computeContribution(const NumericalScalarCollection & roots);

        /** Compute the contribution of a set of direction to the probability given the contributions of each direction in the set */
        NumericalScalar computeTotalContribution(const NumericalSample & directionSample);

	StandardEvent standardEvent_;
	NumericalMathFunction standardFunction_;
	Implementation inputDistribution_;
	RootStrategy rootStrategy_;
	SamplingStrategy samplingStrategy_;

      } ; /* class DirectionalSampling */

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_DIRECTIONALSAMPLING_HXX */
