/*
 * $Id: hash.h,v 1.4 2006/03/20 00:28:56 juhe Exp $
 *
 * Header file for allow_trusted hash table functions
 *
 * Copyright (C) 2003 Juha Heinanen
 *
 * This file is part of openser, a free SIP server.
 *
 * openser is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version
 *
 * openser is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _PERM_HASH_H_
#define _PERM_HASH_H_

#include <stdio.h>
#include "../../parser/msg_parser.h"
#include "../../str.h"
#include "../../usr_avp.h"

#define PERM_HASH_SIZE 128

/*
 * Structure stored in the hash table
 */
struct trusted_list {
	str src_ip;                 /* Source IP of SIP message */
	int proto;                  /* Protocol -- UDP, TCP, TLS, or SCTP */
	char *pattern;              /* Pattern matching From header field */
	str tag;                    /* Tag to be assigned to AVP */
	struct trusted_list *next;  /* Next element in the list */
};


/*
 * Parse and init tag avp specification
 */
int init_tag_avp(char *tag_avp_param);


/*
 * Gets tag avp specs
 */
void get_tag_avp(int_str *tag_avp_p, int *tag_avp_type_p);


/*
 * Create and initialize a hash table
 */
struct trusted_list** new_hash_table(void);


/*
 * Release all memory allocated for a hash table
 */
void free_hash_table(struct trusted_list** table);


/*
 * Destroy a hash table
 */
void destroy_hash_table(struct trusted_list** table);


/* 
 * Add <src_ip, proto, pattern> into hash table, where proto is integer
 * representation of string argument proto.
 */
int hash_table_insert(struct trusted_list** hash_table, char* src_ip,
		      char* proto, char* pattern, char* tag);


/* 
 * Check if an entry exists in hash table that has given src_ip and protocol
 * value and pattern that matches to From URI.
 */
int match_hash_table(struct trusted_list** table, struct sip_msg* msg);


/* 
 * Print domains stored in hash table 
 */
void hash_table_print(struct trusted_list** hash_table, FILE* reply_file);


/* 
 * Empty hash table
 */
void empty_hash_table(struct trusted_list** hash_table);


#endif /* _PERM_HASH_H_ */
