/**********************************************************************
  FT_ProExpn_VNA.c:

     FT_ProExpn_VNA.c is a subroutine to Fourier transform
     VNA separable projectors.

  Log of FT_ProExpn_VNA.c:

     7/Apr/2004  Released by T.Ozaki

***********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include "openmx_common.h"

#ifdef nompi
#include "mimic_mpi.h"
#else
#include "mpi.h"
#endif



void FT_ProExpn_VNA()
{
  int numprocs,myid,ID,tag=999;
  int count,NumSpe;
  int L,i,kj,num_k;
  int Lspe,spe,GL,Mul;
  double Sr,Dr;
  double dk,norm_k,h,dum0;
  double rmin,rmax,r,sum;
  double kmin,kmax,Sk,Dk;
  double sj,sy,sjp,syp;
  double RGL[GL_Mesh + 2];
  double *SumTmp;
  double tmp0,tmp1;
  double **SphB,**SphBp;
  double *tmp_SphB,*tmp_SphBp;
  double TStime, TEtime;
  MPI_Status stat;
  MPI_Request request;

  dtime(&TStime);

  /* MPI */
  MPI_Comm_size(mpi_comm_level1,&numprocs);
  MPI_Comm_rank(mpi_comm_level1,&myid);

  if (myid==Host_ID) printf("<FT_ProExpn_VNA>  Fourier transform of VNA separable projectors\n");

  for (Lspe=0; Lspe<MSpeciesNum; Lspe++){

    spe = Species_Top[myid] + Lspe;

    /* initalize */

    rmin = Spe_VPS_RV[spe][0];
    rmax = Spe_Atom_Cut1[spe] + 0.5;
    Sr = rmax + rmin;
    Dr = rmax - rmin;
    for (i=0; i<GL_Mesh; i++){
      RGL[i] = 0.50*(Dr*GL_Abscissae[i] + Sr);
    }

    num_k = Ngrid_NormK;
    dk = PAO_Nkmax/(double)num_k;

    /* allocate SphB and SphBp */

    SumTmp = (double*)malloc(sizeof(double)*List_YOUSO[34]);

    SphB = (double**)malloc(sizeof(double*)*(List_YOUSO[35]+3));
    for(L=0; L<(List_YOUSO[35]+3); L++){ 
      SphB[L] = (double*)malloc(sizeof(double)*GL_Mesh);
    }

    SphBp = (double**)malloc(sizeof(double*)*(List_YOUSO[35]+3));
    for(L=0; L<(List_YOUSO[35]+3); L++){ 
      SphBp[L] = (double*)malloc(sizeof(double)*GL_Mesh);
    }

    tmp_SphB  = (double*)malloc(sizeof(double)*(List_YOUSO[35]+3));
    tmp_SphBp = (double*)malloc(sizeof(double)*(List_YOUSO[35]+3));

    /* tabulation on Gauss-Legendre radial grid */

    kmin = Radial_kmin;
    kmax = PAO_Nkmax;
    Sk = kmax + kmin;
    Dk = kmax - kmin;
   
    /* loop for kj */
    
    for (kj=0; kj<GL_Mesh; kj++){

      norm_k = 0.50*(Dk*GL_Abscissae[kj] + Sk);

      /* calculate SphB */

      for (i=0; i<GL_Mesh; i++){

        r = RGL[i];
	Spherical_Bessel(norm_k*r,List_YOUSO[35],tmp_SphB,tmp_SphBp);

	for(L=0; L<=List_YOUSO[35]; L++){ 
	  SphB[L][i]  =  tmp_SphB[L]; 
	  SphBp[L][i] = tmp_SphBp[L]; 
	}
      }

      /* loop for L */
 
      for (L=0; L<=List_YOUSO[35]; L++){

	/****************************************************
                      \int jL(k*r)RL r^2 dr 
	****************************************************/

	for (Mul=0; Mul<List_YOUSO[34]; Mul++) SumTmp[Mul] = 0.0;

        /* Gauss-Legendre quadrature */

	for (i=0; i<GL_Mesh; i++){

	  r = RGL[i];
          sj = SphB[L][i];

	  tmp0 = r*r*GL_Weight[i]*sj;
	  for (Mul=0; Mul<List_YOUSO[34]; Mul++){
	    dum0 = PhiF(r, Projector_VNA[spe][L][Mul], Spe_VPS_RV[spe], Spe_Num_Mesh_VPS[spe]);   
	    SumTmp[Mul] += dum0*tmp0;
	  }
	}

	for (Mul=0; Mul<List_YOUSO[34]; Mul++){
	  Spe_VNA_Bessel[spe][L][Mul][kj] = 0.5*Dr*SumTmp[Mul];
	}

        GL_NormK[kj] = norm_k;

      } /* L */
    } /* kj */

    /* free SphB and SphBp */

    free(SumTmp);

    for(L=0; L<(List_YOUSO[35]+3); L++){ 
      free(SphB[L]);
    }
    free(SphB);

    for(L=0; L<(List_YOUSO[35]+3); L++){ 
      free(SphBp[L]);
    }
    free(SphBp);

    free(tmp_SphB);
    free(tmp_SphBp);

  } /* Lspe */

  /****************************************************
         regenerate radial grids in the k-space
         for the MPI calculation
  ****************************************************/

  for (kj=0; kj<GL_Mesh; kj++){
    kmin = Radial_kmin;
    kmax = PAO_Nkmax;
    Sk = kmax + kmin;
    Dk = kmax - kmin;
    norm_k = 0.50*(Dk*GL_Abscissae[kj] + Sk);
    GL_NormK[kj] = norm_k;
  }

  /***********************************************************
        sending and receiving of Spe_VNA_Bessel by MPI
  ***********************************************************/

  for (ID=0; ID<Num_Procs2; ID++){
    NumSpe = Species_End[ID] - Species_Top[ID] + 1;
    for (Lspe=0; Lspe<NumSpe; Lspe++){
      spe = Species_Top[ID] + Lspe;
      for (L=0; L<=List_YOUSO[35]; L++){
	for (Mul=0; Mul<List_YOUSO[34]; Mul++){
	  MPI_Bcast(&Spe_VNA_Bessel[spe][L][Mul][0],
		    GL_Mesh,MPI_DOUBLE,ID,mpi_comm_level1);
	}
      }
    }
  }

  /***********************************************************
                         elapsed time
  ***********************************************************/

  dtime(&TEtime);
}




