#ifndef VORBISENCODER_H_
#define VORBISENCODER_H_

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_LIBVORBIS

#include <list>
#include <vector>
#include <vorbis/codec.h>
#include <vorbis/vorbisenc.h>

#include "mediaInputEncoder.h"
#include "oggPacket.h"
#include "audioPacket.h"
#include "oggComment.h"
#include "vorbisStreamParameter.h"
#include "streamConfig.h"

class VorbisEncoder : public MediaInputEncoder {
protected:
  uint32 streamNo;

  vorbis_info vorbisInfo;
  vorbis_comment vorbisComment;
  vorbis_dsp_state vorbisState;
  vorbis_block vorbisBlock;

  OggPacketInternal packet;

  std::list<OggPacket> packetList;

  uint32 pktCnt;

public:
  VorbisEncoder(uint32 streamNo);
  virtual ~VorbisEncoder();

  virtual MediaInputEncoder& operator>>(OggPacket& packet);
  MediaInputEncoder& operator<<(AudioPacket& aPacket);

  void configureEncoder(VorbisStreamParameter& config,
                        StreamConfig& streamConf, std::vector<OggComment>& oggComments);
  void flush();

};

#endif /* HAVE_LIBVORBIS */
#endif /* VORBISENCODER_H_*/

