#ifndef THEORAENCODER_H_
#define THEORAENCODER_H_

#ifdef HAVE_CONFIG_H
#include "config.h"
#else
#warning only use with autotools
#endif

#ifdef HAVE_LIBTHEORAENC

#include <list>
#include <vector>
#include <theora/codec.h>
#include <theora/theoraenc.h>

#include "oggPacket.h"
#include "oggComment.h"
#include "mediaInputEncoder.h"
#include "theoraStreamParameter.h"
#include "streamConfig.h"

class TheoraEncoder : public MediaInputEncoder {

protected:

//  bool                 configured;
  uint32               streamNo;

  th_enc_ctx*          theoraState;
  th_comment           theoraComment;
  th_info              theoraInfo;

  OggPacketInternal    packet;

  std::list<OggPacket> packetList;

  void createHeader(std::vector<OggPacket>& headerList, std::vector<OggComment>& oggComments);

public:

  TheoraEncoder(uint32 streamNo);
  virtual ~TheoraEncoder();

  virtual MediaInputEncoder& operator>>(OggPacket& packet);
  MediaInputEncoder& operator<<(th_ycbcr_buffer buffer);

  void configureEncoder(TheoraStreamParameter& config, StreamConfig& streamConf, std::vector<OggComment>& oggComments);

};

#endif /* HAVE_LIBTHEORAENC */

#endif /*THEORAENCODER_H_*/
