#include <iostream>

#include "SDLvideoOutput.h"

SDLvideoOutput::SDLvideoOutput()
    : MediaUnit(write, "SDLvideoOutput")
{
}

SDLvideoOutput::SDLvideoOutput(VideoInfo& info)
    : MediaUnit(write, "SDLvideoOutput")
{
  init(info);
}

void SDLvideoOutput::init(VideoInfo& info)
{
  videoInfo = info;

  if ( SDL_Init(SDL_INIT_VIDEO) < 0 ) {
    std::cerr << "Unable to init SDL: "<< SDL_GetError() << std::endl;
    return;
  }

  screen = SDL_SetVideoMode(info.frame_width, info.frame_height, 0, SDL_SWSURFACE);
  if ( screen == NULL ) {
    std::cerr << "Unable to set " << info.frame_width <<" " << info.frame_height
              << " video: " << SDL_GetError() << std::endl;
    return;
  }

  yuv_overlay = SDL_CreateYUVOverlay(info.frame_width, info.frame_height,
                                     SDL_YV12_OVERLAY,
                                     screen);
  if ( yuv_overlay == NULL ) {
    std::cerr << "SDLvideoOutput::init: Couldn't create SDL_yuv_overlay:" << SDL_GetError();
    return;
  }
  rect.x = 0;
  rect.y = 0;
  rect.w = info.frame_width;
  rect.h = info.frame_height;

  SDL_DisplayYUVOverlay(yuv_overlay, &rect);

}

SDLvideoOutput::~SDLvideoOutput()
{
  SDL_Quit();
  std::cerr << std::endl;
}

//SDLvideoOutput& SDLvideoOutput::operator<<(TheoraVideoPacket packet)
SDLvideoOutput& SDLvideoOutput::operator<<(th_ycbcr_buffer packet)
{
  int i;
//  yuv_buffer yuv = packet.getYuvBuffer();
  int crop_offset;

  /* Lock SDL_yuv_overlay */
  if ( SDL_MUSTLOCK(screen) ) {
    if ( SDL_LockSurface(screen) < 0 ) {
      std::cerr << "SDLvideoOutput::operator<<: ERROR SDL_LockSurface\n";
      return(*this);
    }
  }
  if (SDL_LockYUVOverlay(yuv_overlay) < 0) {
    std::cerr << "SDLvideoOutput::operator<<: ERROR SDL_YUVOverlay\n";
    return(*this);
  }

  /* let's draw the data (*yuv[3]) on a SDL screen (*screen) */
  /* deal with border stride */
  /* reverse u and v for SDL */
  /* and crop input properly, respecting the encoded frame rect */
  crop_offset=videoInfo.offset_x+packet[0].stride*videoInfo.offset_y;
  for (i=0; i<yuv_overlay->h; i++)
    memcpy(yuv_overlay->pixels[0]+yuv_overlay->pitches[0]*i,
           packet[0].data+crop_offset+packet[0].stride*i,
           yuv_overlay->w);
  crop_offset=(videoInfo.offset_x/2)+(packet[1].stride)*(videoInfo.offset_y/2);
  for (i=0; i<yuv_overlay->h/2; i++) {
    memcpy(yuv_overlay->pixels[2]+yuv_overlay->pitches[2]*i,
           packet[1].data+crop_offset+packet[1].stride*i,
           yuv_overlay->w/2);
    memcpy(yuv_overlay->pixels[1]+yuv_overlay->pitches[1]*i,
           packet[2].data+crop_offset+packet[2].stride*i,
           yuv_overlay->w/2);
  }

  std::cerr << ".";

  /* Unlock SDL_yuv_overlay */
  if ( SDL_MUSTLOCK(screen) ) {
    SDL_UnlockSurface(screen);
  }
  SDL_UnlockYUVOverlay(yuv_overlay);

  /* Show, baby, show! */
  SDL_DisplayYUVOverlay(yuv_overlay, &rect);

  return(*this);

}
