/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ltfat;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ContFrame {
    private volatile boolean showLoadInd = false;
    private JFrame jf = null;
    private Map paramMap = null;
    private Map sliderParamMap = null;
    private Map paramComponentsMap = null;
    private Map sliderBoundsMap = null;
    public double flag = 1.0;
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    JLabel loadLabel;
    JProgressBar loadBar;
    JLabel loadTxt;
    private int defXPad = 3;
    private int defYPad = 10;
    private int namePrefferedSize = 70;
    private int sliderPrefferedSize = 170;
    private int valuePrefferedSize = 30;

    public void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            super.finalize();
        }
    }

    public void setVisibleParam(String string, boolean bl) throws NoSuchFieldException {
        if (this.paramComponentsMap == null) {
            return;
        }
        List list = (List)this.paramComponentsMap.get(string);
        if (list == null) {
            throw new NoSuchFieldException("Parameter " + string + " not found.");
        }
        for (JComponent jComponent : list) {
            jComponent.setVisible(bl);
        }
    }

    public double getParam(String string) throws NoSuchFieldException {
        if (this.paramMap == null) {
            return 0.0;
        }
        Double d = (Double)this.paramMap.get(string);
        if (d == null) {
            throw new NoSuchFieldException("Parameter " + string + " not found.");
        }
        return (Double)this.paramMap.get(string);
    }

    public double[] getParams(String ... stringArray) throws NoSuchFieldException {
        int n = stringArray.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.getParam(stringArray[i]);
            continue;
        }
        return dArray;
    }

    public double[] getParams() {
        int n = this.paramMap.size();
        if (n == 0) {
            throw new NullPointerException("Parameter map is empty");
        }
        Iterator iterator = this.paramMap.entrySet().iterator();
        double[] dArray = new double[n];
        int n2 = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            dArray[n2++] = (Double)entry.getValue();
        }
        return dArray;
    }

    public void addControlElements(final List list) {
        this.runInEDT(new Runnable(){

            @Override
            public void run() {
                ContFrame.this.paramMap = new LinkedHashMap();
                ContFrame.this.sliderParamMap = new HashMap();
                ContFrame.this.paramComponentsMap = new HashMap();
                ContFrame.this.sliderBoundsMap = new HashMap();
                ContFrame.this.initFrameComponents(list);
                ContFrame.this.jf.pack();
                ContFrame.this.jf.validate();
                ContFrame.this.jf.setVisible(true);
            }
        });
    }

    public void close() {
        if (this.jf != null) {
            this.jf.setVisible(false);
            this.jf.dispose();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void runInEDT(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            try {
                runnable.run();
                return;
            }
            catch (Exception exception) {}
            finally {
                return;
            }
        }
        try {
            SwingUtilities.invokeLater(runnable);
            return;
        }
        catch (Exception exception) {
            return;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void runInPool(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            System.out.println("Warning! We are on on EDT. Strange....");
        }
        try {
            this.executor.execute(runnable);
        }
        catch (Exception exception) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void updateBar(final double d) {
        this.runInPool(new Runnable(){

            @Override
            public void run() {
                if (ContFrame.this.loadLabel == null || ContFrame.this.loadBar == null || ContFrame.this.loadTxt == null) {
                    return;
                }
                if (!ContFrame.this.showLoadInd) {
                    ContFrame.this.loadLabel.setVisible(true);
                    ContFrame.this.loadBar.setVisible(true);
                    ContFrame.this.loadTxt.setVisible(true);
                }
                ContFrame.this.loadBar.setValue((int)d);
                ContFrame.this.loadTxt.setText(String.format(" %d%%", (int)d));
                if ((int)d > 80) {
                    ContFrame.this.loadTxt.setForeground(Color.red);
                } else {
                    ContFrame.this.loadTxt.setForeground(Color.black);
                }
                ContFrame.this.showLoadInd = true;
                ContFrame.this.loadBar.repaint();
                ContFrame.this.loadTxt.repaint();
            }
        });
    }

    public ContFrame() {
        this.runInEDT(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                ContFrame.this.jf = ContFrame.this.initFrame();
            }
        });
    }

    public void setLocation(final double d, final double d2) {
        this.runInEDT(new Runnable(){

            @Override
            public void run() {
                ContFrame.this.jf.setLocation((int)d, (int)d2);
            }
        });
    }

    private JFrame initFrame() {
        JFrame jFrame = new JFrame("LTFAT Control Panel");
        jFrame.setDefaultCloseOperation(0);
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ContFrame.this.flag = 0.0;
                ContFrame.this.close();
            }
        });
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 67 && keyEvent.getID() == 401) {
                    ContFrame.this.flag = 0.0;
                }
                return false;
            }
        });
        return jFrame;
    }

    private void initFrameComponents(List<List> list) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.jf.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = this.defXPad;
        gridBagConstraints.ipady = this.defYPad;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0 / (double)list.size();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.ipadx = this.defXPad;
        gridBagConstraints2.ipady = this.defYPad;
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.weightx = 0.7;
        gridBagConstraints2.weighty = 1.0 / (double)list.size();
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.ipadx = this.defXPad;
        gridBagConstraints3.ipady = this.defYPad;
        gridBagConstraints3.anchor = 21;
        gridBagConstraints3.weightx = 0.1;
        gridBagConstraints3.weighty = 1.0 / (double)list.size();
        gridBagConstraints3.insets = new Insets(10, 0, 0, 0);
        for (List list2 : list) {
            String string = new String("noname");
            String string2 = new String("nolabel");
            Object e = list2.get(1);
            if (e instanceof Character) {
                string2 = ((Character)e).toString();
            } else if (e instanceof String) {
                string2 = (String)e;
            }
            Object e2 = list2.get(0);
            if (e2 instanceof Character) {
                string = ((Character)e2).toString();
            } else if (e2 instanceof String) {
                string = (String)e2;
            }
            Double d = (Double)list2.get(2);
            Double d2 = (Double)list2.get(3);
            Double d3 = (Double)list2.get(4);
            int n = ((Double)list2.get(5)).intValue();
            int n2 = this.val2slider(d3, d, d2, n);
            JLabel jLabel = new JLabel(string2);
            JSlider jSlider = new JSlider(0, n - 1, n2);
            final JLabel jLabel2 = new JLabel(String.format("%.3g    ", this.slider2val(jSlider.getValue(), d, d2, n)));
            jLabel2.setPreferredSize(new Dimension(50, 15));
            jSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    JSlider jSlider = (JSlider)changeEvent.getSource();
                    int n = jSlider.getValue();
                    double d = ((SliderBounds)ContFrame.this.sliderBoundsMap.get(jSlider)).getMinVal();
                    double d2 = ((SliderBounds)ContFrame.this.sliderBoundsMap.get(jSlider)).getMaxVal();
                    double d3 = ContFrame.this.slider2val(n, d, d2, jSlider.getMaximum() + 1);
                    Dimension dimension = jLabel2.getPreferredSize();
                    jLabel2.setMinimumSize(dimension);
                    jLabel2.setMaximumSize(dimension);
                    jLabel2.setText(String.format("%.3g", d3));
                    ContFrame.this.paramMap.put(ContFrame.this.sliderParamMap.get(jSlider), d3);
                }
            });
            this.jf.add((Component)jLabel, gridBagConstraints);
            ++gridBagConstraints.gridy;
            this.jf.add((Component)jSlider, gridBagConstraints2);
            ++gridBagConstraints2.gridy;
            this.jf.add((Component)jLabel2, gridBagConstraints3);
            ++gridBagConstraints3.gridy;
            this.paramMap.put(string, d3);
            this.sliderParamMap.put(jSlider, string);
            ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
            arrayList.add(jLabel);
            arrayList.add(jSlider);
            arrayList.add(jLabel2);
            this.paramComponentsMap.put(string, arrayList);
            this.sliderBoundsMap.put(jSlider, new SliderBounds(d, d2));
        }
        this.loadTxt = new JLabel("0%");
        this.loadTxt.setPreferredSize(new Dimension(50, 15));
        this.loadLabel = new JLabel("Load:");
        this.loadBar = new JProgressBar();
        this.jf.add((Component)this.loadLabel, gridBagConstraints);
        this.jf.add((Component)this.loadBar, gridBagConstraints2);
        this.jf.add((Component)this.loadTxt, gridBagConstraints3);
        this.loadLabel.setVisible(false);
        this.loadBar.setVisible(false);
        this.loadTxt.setVisible(false);
    }

    private int val2slider(double d, double d2, double d3, int n) {
        int n2 = (int)Math.round((d - d2) / (d3 - d2) * (double)(n - 1));
        return Math.min(Math.max(n2, 0), n);
    }

    private double slider2val(int n, double d, double d2, int n2) {
        double d3 = (double)n / (double)(n2 - 1) * (d2 - d) + d;
        return Math.min(Math.max(d3, d), d2);
    }

    private class SliderBounds {
        private double minVal = 0.0;
        private double maxVal = 0.0;

        SliderBounds(double d, double d2) {
            this.minVal = d;
            this.maxVal = d2;
        }

        double getMaxVal() {
            return this.maxVal;
        }

        double getMinVal() {
            return this.minVal;
        }
    }
}

